<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemFulfillment StructType
 * Meta information extracted from the WSDL
 * - type: tranSales:ItemFulfillment
 * @subpackage Structs
 */
class ItemFulfillment extends Record
{
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The postingPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $postingPeriod;
    /**
     * The entity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entity;
    /**
     * The createdFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $createdFrom;
    /**
     * The requestedBy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $requestedBy;
    /**
     * The createdFromShipGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $createdFromShipGroup;
    /**
     * The partner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $partner;
    /**
     * The shippingAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $shippingAddress;
    /**
     * The pickedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pickedDate;
    /**
     * The packedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $packedDate;
    /**
     * The shippedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shippedDate;
    /**
     * The shipIsResidential
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $shipIsResidential;
    /**
     * The shipAddressList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $shipAddressList;
    /**
     * The shipStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shipStatus;
    /**
     * The saturdayDeliveryUps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $saturdayDeliveryUps;
    /**
     * The sendShipNotifyEmailUps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $sendShipNotifyEmailUps;
    /**
     * The sendBackupEmailUps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $sendBackupEmailUps;
    /**
     * The shipNotifyEmailAddressUps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shipNotifyEmailAddressUps;
    /**
     * The shipNotifyEmailAddress2Ups
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shipNotifyEmailAddress2Ups;
    /**
     * The backupEmailAddressUps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $backupEmailAddressUps;
    /**
     * The shipNotifyEmailMessageUps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shipNotifyEmailMessageUps;
    /**
     * The thirdPartyAcctUps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $thirdPartyAcctUps;
    /**
     * The thirdPartyZipcodeUps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $thirdPartyZipcodeUps;
    /**
     * The thirdPartyCountryUps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $thirdPartyCountryUps;
    /**
     * The thirdPartyTypeUps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $thirdPartyTypeUps;
    /**
     * The partiesToTransactionUps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $partiesToTransactionUps;
    /**
     * The exportTypeUps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $exportTypeUps;
    /**
     * The methodOfTransportUps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $methodOfTransportUps;
    /**
     * The carrierIdUps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $carrierIdUps;
    /**
     * The entryNumberUps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $entryNumberUps;
    /**
     * The inbondCodeUps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $inbondCodeUps;
    /**
     * The isRoutedExportTransactionUps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isRoutedExportTransactionUps;
    /**
     * The licenseNumberUps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $licenseNumberUps;
    /**
     * The licenseDateUps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $licenseDateUps;
    /**
     * The licenseExceptionUps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $licenseExceptionUps;
    /**
     * The eccNumberUps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $eccNumberUps;
    /**
     * The recipientTaxIdUps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $recipientTaxIdUps;
    /**
     * The blanketStartDateUps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $blanketStartDateUps;
    /**
     * The blanketEndDateUps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $blanketEndDateUps;
    /**
     * The shipmentWeightUps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $shipmentWeightUps;
    /**
     * The saturdayDeliveryFedEx
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $saturdayDeliveryFedEx;
    /**
     * The saturdayPickupFedex
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $saturdayPickupFedex;
    /**
     * The sendShipNotifyEmailFedEx
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $sendShipNotifyEmailFedEx;
    /**
     * The sendBackupEmailFedEx
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $sendBackupEmailFedEx;
    /**
     * The signatureHomeDeliveryFedEx
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $signatureHomeDeliveryFedEx;
    /**
     * The shipNotifyEmailAddressFedEx
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shipNotifyEmailAddressFedEx;
    /**
     * The backupEmailAddressFedEx
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $backupEmailAddressFedEx;
    /**
     * The shipDateFedEx
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shipDateFedEx;
    /**
     * The homeDeliveryTypeFedEx
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $homeDeliveryTypeFedEx;
    /**
     * The homeDeliveryDateFedEx
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $homeDeliveryDateFedEx;
    /**
     * The bookingConfirmationNumFedEx
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bookingConfirmationNumFedEx;
    /**
     * The intlExemptionNumFedEx
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $intlExemptionNumFedEx;
    /**
     * The b13aFilingOptionFedEx
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $b13aFilingOptionFedEx;
    /**
     * The b13aStatementDataFedEx
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $b13aStatementDataFedEx;
    /**
     * The thirdPartyAcctFedEx
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $thirdPartyAcctFedEx;
    /**
     * The thirdPartyCountryFedEx
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $thirdPartyCountryFedEx;
    /**
     * The thirdPartyTypeFedEx
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $thirdPartyTypeFedEx;
    /**
     * The shipmentWeightFedEx
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $shipmentWeightFedEx;
    /**
     * The termsOfSaleFedEx
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $termsOfSaleFedEx;
    /**
     * The termsFreightChargeFedEx
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $termsFreightChargeFedEx;
    /**
     * The termsInsuranceChargeFedEx
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $termsInsuranceChargeFedEx;
    /**
     * The insideDeliveryFedEx
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $insideDeliveryFedEx;
    /**
     * The insidePickupFedEx
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $insidePickupFedEx;
    /**
     * The ancillaryEndorsementFedEx
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ancillaryEndorsementFedEx;
    /**
     * The holdAtLocationFedEx
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $holdAtLocationFedEx;
    /**
     * The halPhoneFedEx
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $halPhoneFedEx;
    /**
     * The halAddr1FedEx
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $halAddr1FedEx;
    /**
     * The halAddr2FedEx
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $halAddr2FedEx;
    /**
     * The halAddr3FedEx
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $halAddr3FedEx;
    /**
     * The halCityFedEx
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $halCityFedEx;
    /**
     * The halZipFedEx
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $halZipFedEx;
    /**
     * The halStateFedEx
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $halStateFedEx;
    /**
     * The halCountryFedEx
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $halCountryFedEx;
    /**
     * The hazmatTypeFedEx
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $hazmatTypeFedEx;
    /**
     * The accessibilityTypeFedEx
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accessibilityTypeFedEx;
    /**
     * The isCargoAircraftOnlyFedEx
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isCargoAircraftOnlyFedEx;
    /**
     * The tranDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranDate;
    /**
     * The tranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranId;
    /**
     * The shipMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $shipMethod;
    /**
     * The generateIntegratedShipperLabel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $generateIntegratedShipperLabel;
    /**
     * The shippingCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $shippingCost;
    /**
     * The handlingCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $handlingCost;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The transferLocation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $transferLocation;
    /**
     * The packageList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemFulfillmentPackageList
     */
    public $packageList;
    /**
     * The packageUpsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemFulfillmentPackageUpsList
     */
    public $packageUpsList;
    /**
     * The packageUspsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemFulfillmentPackageUspsList
     */
    public $packageUspsList;
    /**
     * The packageFedExList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemFulfillmentPackageFedExList
     */
    public $packageFedExList;
    /**
     * The itemList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemFulfillmentItemList
     */
    public $itemList;
    /**
     * The accountingBookDetailList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccountingBookDetailList
     */
    public $accountingBookDetailList;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for ItemFulfillment
     * @uses ItemFulfillment::setCreatedDate()
     * @uses ItemFulfillment::setLastModifiedDate()
     * @uses ItemFulfillment::setCustomForm()
     * @uses ItemFulfillment::setPostingPeriod()
     * @uses ItemFulfillment::setEntity()
     * @uses ItemFulfillment::setCreatedFrom()
     * @uses ItemFulfillment::setRequestedBy()
     * @uses ItemFulfillment::setCreatedFromShipGroup()
     * @uses ItemFulfillment::setPartner()
     * @uses ItemFulfillment::setShippingAddress()
     * @uses ItemFulfillment::setPickedDate()
     * @uses ItemFulfillment::setPackedDate()
     * @uses ItemFulfillment::setShippedDate()
     * @uses ItemFulfillment::setShipIsResidential()
     * @uses ItemFulfillment::setShipAddressList()
     * @uses ItemFulfillment::setShipStatus()
     * @uses ItemFulfillment::setSaturdayDeliveryUps()
     * @uses ItemFulfillment::setSendShipNotifyEmailUps()
     * @uses ItemFulfillment::setSendBackupEmailUps()
     * @uses ItemFulfillment::setShipNotifyEmailAddressUps()
     * @uses ItemFulfillment::setShipNotifyEmailAddress2Ups()
     * @uses ItemFulfillment::setBackupEmailAddressUps()
     * @uses ItemFulfillment::setShipNotifyEmailMessageUps()
     * @uses ItemFulfillment::setThirdPartyAcctUps()
     * @uses ItemFulfillment::setThirdPartyZipcodeUps()
     * @uses ItemFulfillment::setThirdPartyCountryUps()
     * @uses ItemFulfillment::setThirdPartyTypeUps()
     * @uses ItemFulfillment::setPartiesToTransactionUps()
     * @uses ItemFulfillment::setExportTypeUps()
     * @uses ItemFulfillment::setMethodOfTransportUps()
     * @uses ItemFulfillment::setCarrierIdUps()
     * @uses ItemFulfillment::setEntryNumberUps()
     * @uses ItemFulfillment::setInbondCodeUps()
     * @uses ItemFulfillment::setIsRoutedExportTransactionUps()
     * @uses ItemFulfillment::setLicenseNumberUps()
     * @uses ItemFulfillment::setLicenseDateUps()
     * @uses ItemFulfillment::setLicenseExceptionUps()
     * @uses ItemFulfillment::setEccNumberUps()
     * @uses ItemFulfillment::setRecipientTaxIdUps()
     * @uses ItemFulfillment::setBlanketStartDateUps()
     * @uses ItemFulfillment::setBlanketEndDateUps()
     * @uses ItemFulfillment::setShipmentWeightUps()
     * @uses ItemFulfillment::setSaturdayDeliveryFedEx()
     * @uses ItemFulfillment::setSaturdayPickupFedex()
     * @uses ItemFulfillment::setSendShipNotifyEmailFedEx()
     * @uses ItemFulfillment::setSendBackupEmailFedEx()
     * @uses ItemFulfillment::setSignatureHomeDeliveryFedEx()
     * @uses ItemFulfillment::setShipNotifyEmailAddressFedEx()
     * @uses ItemFulfillment::setBackupEmailAddressFedEx()
     * @uses ItemFulfillment::setShipDateFedEx()
     * @uses ItemFulfillment::setHomeDeliveryTypeFedEx()
     * @uses ItemFulfillment::setHomeDeliveryDateFedEx()
     * @uses ItemFulfillment::setBookingConfirmationNumFedEx()
     * @uses ItemFulfillment::setIntlExemptionNumFedEx()
     * @uses ItemFulfillment::setB13aFilingOptionFedEx()
     * @uses ItemFulfillment::setB13aStatementDataFedEx()
     * @uses ItemFulfillment::setThirdPartyAcctFedEx()
     * @uses ItemFulfillment::setThirdPartyCountryFedEx()
     * @uses ItemFulfillment::setThirdPartyTypeFedEx()
     * @uses ItemFulfillment::setShipmentWeightFedEx()
     * @uses ItemFulfillment::setTermsOfSaleFedEx()
     * @uses ItemFulfillment::setTermsFreightChargeFedEx()
     * @uses ItemFulfillment::setTermsInsuranceChargeFedEx()
     * @uses ItemFulfillment::setInsideDeliveryFedEx()
     * @uses ItemFulfillment::setInsidePickupFedEx()
     * @uses ItemFulfillment::setAncillaryEndorsementFedEx()
     * @uses ItemFulfillment::setHoldAtLocationFedEx()
     * @uses ItemFulfillment::setHalPhoneFedEx()
     * @uses ItemFulfillment::setHalAddr1FedEx()
     * @uses ItemFulfillment::setHalAddr2FedEx()
     * @uses ItemFulfillment::setHalAddr3FedEx()
     * @uses ItemFulfillment::setHalCityFedEx()
     * @uses ItemFulfillment::setHalZipFedEx()
     * @uses ItemFulfillment::setHalStateFedEx()
     * @uses ItemFulfillment::setHalCountryFedEx()
     * @uses ItemFulfillment::setHazmatTypeFedEx()
     * @uses ItemFulfillment::setAccessibilityTypeFedEx()
     * @uses ItemFulfillment::setIsCargoAircraftOnlyFedEx()
     * @uses ItemFulfillment::setTranDate()
     * @uses ItemFulfillment::setTranId()
     * @uses ItemFulfillment::setShipMethod()
     * @uses ItemFulfillment::setGenerateIntegratedShipperLabel()
     * @uses ItemFulfillment::setShippingCost()
     * @uses ItemFulfillment::setHandlingCost()
     * @uses ItemFulfillment::setMemo()
     * @uses ItemFulfillment::setTransferLocation()
     * @uses ItemFulfillment::setPackageList()
     * @uses ItemFulfillment::setPackageUpsList()
     * @uses ItemFulfillment::setPackageUspsList()
     * @uses ItemFulfillment::setPackageFedExList()
     * @uses ItemFulfillment::setItemList()
     * @uses ItemFulfillment::setAccountingBookDetailList()
     * @uses ItemFulfillment::setCustomFieldList()
     * @uses ItemFulfillment::setInternalId()
     * @uses ItemFulfillment::setExternalId()
     * @param string $createdDate
     * @param string $lastModifiedDate
     * @param \StructType\RecordRef $customForm
     * @param \StructType\RecordRef $postingPeriod
     * @param \StructType\RecordRef $entity
     * @param \StructType\RecordRef $createdFrom
     * @param \StructType\RecordRef $requestedBy
     * @param int $createdFromShipGroup
     * @param \StructType\RecordRef $partner
     * @param \StructType\Address $shippingAddress
     * @param string $pickedDate
     * @param string $packedDate
     * @param string $shippedDate
     * @param bool $shipIsResidential
     * @param \StructType\RecordRef $shipAddressList
     * @param string $shipStatus
     * @param bool $saturdayDeliveryUps
     * @param bool $sendShipNotifyEmailUps
     * @param bool $sendBackupEmailUps
     * @param string $shipNotifyEmailAddressUps
     * @param string $shipNotifyEmailAddress2Ups
     * @param string $backupEmailAddressUps
     * @param string $shipNotifyEmailMessageUps
     * @param string $thirdPartyAcctUps
     * @param string $thirdPartyZipcodeUps
     * @param string $thirdPartyCountryUps
     * @param string $thirdPartyTypeUps
     * @param bool $partiesToTransactionUps
     * @param string $exportTypeUps
     * @param string $methodOfTransportUps
     * @param string $carrierIdUps
     * @param string $entryNumberUps
     * @param string $inbondCodeUps
     * @param bool $isRoutedExportTransactionUps
     * @param string $licenseNumberUps
     * @param string $licenseDateUps
     * @param string $licenseExceptionUps
     * @param string $eccNumberUps
     * @param string $recipientTaxIdUps
     * @param string $blanketStartDateUps
     * @param string $blanketEndDateUps
     * @param float $shipmentWeightUps
     * @param bool $saturdayDeliveryFedEx
     * @param bool $saturdayPickupFedex
     * @param bool $sendShipNotifyEmailFedEx
     * @param bool $sendBackupEmailFedEx
     * @param bool $signatureHomeDeliveryFedEx
     * @param string $shipNotifyEmailAddressFedEx
     * @param string $backupEmailAddressFedEx
     * @param string $shipDateFedEx
     * @param string $homeDeliveryTypeFedEx
     * @param string $homeDeliveryDateFedEx
     * @param string $bookingConfirmationNumFedEx
     * @param string $intlExemptionNumFedEx
     * @param string $b13aFilingOptionFedEx
     * @param string $b13aStatementDataFedEx
     * @param string $thirdPartyAcctFedEx
     * @param string $thirdPartyCountryFedEx
     * @param string $thirdPartyTypeFedEx
     * @param float $shipmentWeightFedEx
     * @param string $termsOfSaleFedEx
     * @param float $termsFreightChargeFedEx
     * @param float $termsInsuranceChargeFedEx
     * @param bool $insideDeliveryFedEx
     * @param bool $insidePickupFedEx
     * @param string $ancillaryEndorsementFedEx
     * @param bool $holdAtLocationFedEx
     * @param string $halPhoneFedEx
     * @param string $halAddr1FedEx
     * @param string $halAddr2FedEx
     * @param string $halAddr3FedEx
     * @param string $halCityFedEx
     * @param string $halZipFedEx
     * @param string $halStateFedEx
     * @param string $halCountryFedEx
     * @param string $hazmatTypeFedEx
     * @param string $accessibilityTypeFedEx
     * @param bool $isCargoAircraftOnlyFedEx
     * @param string $tranDate
     * @param string $tranId
     * @param \StructType\RecordRef $shipMethod
     * @param bool $generateIntegratedShipperLabel
     * @param float $shippingCost
     * @param float $handlingCost
     * @param string $memo
     * @param \StructType\RecordRef $transferLocation
     * @param \StructType\ItemFulfillmentPackageList $packageList
     * @param \StructType\ItemFulfillmentPackageUpsList $packageUpsList
     * @param \StructType\ItemFulfillmentPackageUspsList $packageUspsList
     * @param \StructType\ItemFulfillmentPackageFedExList $packageFedExList
     * @param \StructType\ItemFulfillmentItemList $itemList
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($createdDate = null, $lastModifiedDate = null, \StructType\RecordRef $customForm = null, \StructType\RecordRef $postingPeriod = null, \StructType\RecordRef $entity = null, \StructType\RecordRef $createdFrom = null, \StructType\RecordRef $requestedBy = null, $createdFromShipGroup = null, \StructType\RecordRef $partner = null, \StructType\Address $shippingAddress = null, $pickedDate = null, $packedDate = null, $shippedDate = null, $shipIsResidential = null, \StructType\RecordRef $shipAddressList = null, $shipStatus = null, $saturdayDeliveryUps = null, $sendShipNotifyEmailUps = null, $sendBackupEmailUps = null, $shipNotifyEmailAddressUps = null, $shipNotifyEmailAddress2Ups = null, $backupEmailAddressUps = null, $shipNotifyEmailMessageUps = null, $thirdPartyAcctUps = null, $thirdPartyZipcodeUps = null, $thirdPartyCountryUps = null, $thirdPartyTypeUps = null, $partiesToTransactionUps = null, $exportTypeUps = null, $methodOfTransportUps = null, $carrierIdUps = null, $entryNumberUps = null, $inbondCodeUps = null, $isRoutedExportTransactionUps = null, $licenseNumberUps = null, $licenseDateUps = null, $licenseExceptionUps = null, $eccNumberUps = null, $recipientTaxIdUps = null, $blanketStartDateUps = null, $blanketEndDateUps = null, $shipmentWeightUps = null, $saturdayDeliveryFedEx = null, $saturdayPickupFedex = null, $sendShipNotifyEmailFedEx = null, $sendBackupEmailFedEx = null, $signatureHomeDeliveryFedEx = null, $shipNotifyEmailAddressFedEx = null, $backupEmailAddressFedEx = null, $shipDateFedEx = null, $homeDeliveryTypeFedEx = null, $homeDeliveryDateFedEx = null, $bookingConfirmationNumFedEx = null, $intlExemptionNumFedEx = null, $b13aFilingOptionFedEx = null, $b13aStatementDataFedEx = null, $thirdPartyAcctFedEx = null, $thirdPartyCountryFedEx = null, $thirdPartyTypeFedEx = null, $shipmentWeightFedEx = null, $termsOfSaleFedEx = null, $termsFreightChargeFedEx = null, $termsInsuranceChargeFedEx = null, $insideDeliveryFedEx = null, $insidePickupFedEx = null, $ancillaryEndorsementFedEx = null, $holdAtLocationFedEx = null, $halPhoneFedEx = null, $halAddr1FedEx = null, $halAddr2FedEx = null, $halAddr3FedEx = null, $halCityFedEx = null, $halZipFedEx = null, $halStateFedEx = null, $halCountryFedEx = null, $hazmatTypeFedEx = null, $accessibilityTypeFedEx = null, $isCargoAircraftOnlyFedEx = null, $tranDate = null, $tranId = null, \StructType\RecordRef $shipMethod = null, $generateIntegratedShipperLabel = null, $shippingCost = null, $handlingCost = null, $memo = null, \StructType\RecordRef $transferLocation = null, \StructType\ItemFulfillmentPackageList $packageList = null, \StructType\ItemFulfillmentPackageUpsList $packageUpsList = null, \StructType\ItemFulfillmentPackageUspsList $packageUspsList = null, \StructType\ItemFulfillmentPackageFedExList $packageFedExList = null, \StructType\ItemFulfillmentItemList $itemList = null, \StructType\AccountingBookDetailList $accountingBookDetailList = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCreatedDate($createdDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setCustomForm($customForm)
            ->setPostingPeriod($postingPeriod)
            ->setEntity($entity)
            ->setCreatedFrom($createdFrom)
            ->setRequestedBy($requestedBy)
            ->setCreatedFromShipGroup($createdFromShipGroup)
            ->setPartner($partner)
            ->setShippingAddress($shippingAddress)
            ->setPickedDate($pickedDate)
            ->setPackedDate($packedDate)
            ->setShippedDate($shippedDate)
            ->setShipIsResidential($shipIsResidential)
            ->setShipAddressList($shipAddressList)
            ->setShipStatus($shipStatus)
            ->setSaturdayDeliveryUps($saturdayDeliveryUps)
            ->setSendShipNotifyEmailUps($sendShipNotifyEmailUps)
            ->setSendBackupEmailUps($sendBackupEmailUps)
            ->setShipNotifyEmailAddressUps($shipNotifyEmailAddressUps)
            ->setShipNotifyEmailAddress2Ups($shipNotifyEmailAddress2Ups)
            ->setBackupEmailAddressUps($backupEmailAddressUps)
            ->setShipNotifyEmailMessageUps($shipNotifyEmailMessageUps)
            ->setThirdPartyAcctUps($thirdPartyAcctUps)
            ->setThirdPartyZipcodeUps($thirdPartyZipcodeUps)
            ->setThirdPartyCountryUps($thirdPartyCountryUps)
            ->setThirdPartyTypeUps($thirdPartyTypeUps)
            ->setPartiesToTransactionUps($partiesToTransactionUps)
            ->setExportTypeUps($exportTypeUps)
            ->setMethodOfTransportUps($methodOfTransportUps)
            ->setCarrierIdUps($carrierIdUps)
            ->setEntryNumberUps($entryNumberUps)
            ->setInbondCodeUps($inbondCodeUps)
            ->setIsRoutedExportTransactionUps($isRoutedExportTransactionUps)
            ->setLicenseNumberUps($licenseNumberUps)
            ->setLicenseDateUps($licenseDateUps)
            ->setLicenseExceptionUps($licenseExceptionUps)
            ->setEccNumberUps($eccNumberUps)
            ->setRecipientTaxIdUps($recipientTaxIdUps)
            ->setBlanketStartDateUps($blanketStartDateUps)
            ->setBlanketEndDateUps($blanketEndDateUps)
            ->setShipmentWeightUps($shipmentWeightUps)
            ->setSaturdayDeliveryFedEx($saturdayDeliveryFedEx)
            ->setSaturdayPickupFedex($saturdayPickupFedex)
            ->setSendShipNotifyEmailFedEx($sendShipNotifyEmailFedEx)
            ->setSendBackupEmailFedEx($sendBackupEmailFedEx)
            ->setSignatureHomeDeliveryFedEx($signatureHomeDeliveryFedEx)
            ->setShipNotifyEmailAddressFedEx($shipNotifyEmailAddressFedEx)
            ->setBackupEmailAddressFedEx($backupEmailAddressFedEx)
            ->setShipDateFedEx($shipDateFedEx)
            ->setHomeDeliveryTypeFedEx($homeDeliveryTypeFedEx)
            ->setHomeDeliveryDateFedEx($homeDeliveryDateFedEx)
            ->setBookingConfirmationNumFedEx($bookingConfirmationNumFedEx)
            ->setIntlExemptionNumFedEx($intlExemptionNumFedEx)
            ->setB13aFilingOptionFedEx($b13aFilingOptionFedEx)
            ->setB13aStatementDataFedEx($b13aStatementDataFedEx)
            ->setThirdPartyAcctFedEx($thirdPartyAcctFedEx)
            ->setThirdPartyCountryFedEx($thirdPartyCountryFedEx)
            ->setThirdPartyTypeFedEx($thirdPartyTypeFedEx)
            ->setShipmentWeightFedEx($shipmentWeightFedEx)
            ->setTermsOfSaleFedEx($termsOfSaleFedEx)
            ->setTermsFreightChargeFedEx($termsFreightChargeFedEx)
            ->setTermsInsuranceChargeFedEx($termsInsuranceChargeFedEx)
            ->setInsideDeliveryFedEx($insideDeliveryFedEx)
            ->setInsidePickupFedEx($insidePickupFedEx)
            ->setAncillaryEndorsementFedEx($ancillaryEndorsementFedEx)
            ->setHoldAtLocationFedEx($holdAtLocationFedEx)
            ->setHalPhoneFedEx($halPhoneFedEx)
            ->setHalAddr1FedEx($halAddr1FedEx)
            ->setHalAddr2FedEx($halAddr2FedEx)
            ->setHalAddr3FedEx($halAddr3FedEx)
            ->setHalCityFedEx($halCityFedEx)
            ->setHalZipFedEx($halZipFedEx)
            ->setHalStateFedEx($halStateFedEx)
            ->setHalCountryFedEx($halCountryFedEx)
            ->setHazmatTypeFedEx($hazmatTypeFedEx)
            ->setAccessibilityTypeFedEx($accessibilityTypeFedEx)
            ->setIsCargoAircraftOnlyFedEx($isCargoAircraftOnlyFedEx)
            ->setTranDate($tranDate)
            ->setTranId($tranId)
            ->setShipMethod($shipMethod)
            ->setGenerateIntegratedShipperLabel($generateIntegratedShipperLabel)
            ->setShippingCost($shippingCost)
            ->setHandlingCost($handlingCost)
            ->setMemo($memo)
            ->setTransferLocation($transferLocation)
            ->setPackageList($packageList)
            ->setPackageUpsList($packageUpsList)
            ->setPackageUspsList($packageUspsList)
            ->setPackageFedExList($packageFedExList)
            ->setItemList($itemList)
            ->setAccountingBookDetailList($accountingBookDetailList)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\ItemFulfillment
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\ItemFulfillment
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\ItemFulfillment
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get postingPeriod value
     * @return \StructType\RecordRef|null
     */
    public function getPostingPeriod()
    {
        return $this->postingPeriod;
    }
    /**
     * Set postingPeriod value
     * @param \StructType\RecordRef $postingPeriod
     * @return \StructType\ItemFulfillment
     */
    public function setPostingPeriod(\StructType\RecordRef $postingPeriod = null)
    {
        $this->postingPeriod = $postingPeriod;
        return $this;
    }
    /**
     * Get entity value
     * @return \StructType\RecordRef|null
     */
    public function getEntity()
    {
        return $this->entity;
    }
    /**
     * Set entity value
     * @param \StructType\RecordRef $entity
     * @return \StructType\ItemFulfillment
     */
    public function setEntity(\StructType\RecordRef $entity = null)
    {
        $this->entity = $entity;
        return $this;
    }
    /**
     * Get createdFrom value
     * @return \StructType\RecordRef|null
     */
    public function getCreatedFrom()
    {
        return $this->createdFrom;
    }
    /**
     * Set createdFrom value
     * @param \StructType\RecordRef $createdFrom
     * @return \StructType\ItemFulfillment
     */
    public function setCreatedFrom(\StructType\RecordRef $createdFrom = null)
    {
        $this->createdFrom = $createdFrom;
        return $this;
    }
    /**
     * Get requestedBy value
     * @return \StructType\RecordRef|null
     */
    public function getRequestedBy()
    {
        return $this->requestedBy;
    }
    /**
     * Set requestedBy value
     * @param \StructType\RecordRef $requestedBy
     * @return \StructType\ItemFulfillment
     */
    public function setRequestedBy(\StructType\RecordRef $requestedBy = null)
    {
        $this->requestedBy = $requestedBy;
        return $this;
    }
    /**
     * Get createdFromShipGroup value
     * @return int|null
     */
    public function getCreatedFromShipGroup()
    {
        return $this->createdFromShipGroup;
    }
    /**
     * Set createdFromShipGroup value
     * @param int $createdFromShipGroup
     * @return \StructType\ItemFulfillment
     */
    public function setCreatedFromShipGroup($createdFromShipGroup = null)
    {
        // validation for constraint: int
        if (!is_null($createdFromShipGroup) && !(is_int($createdFromShipGroup) || ctype_digit($createdFromShipGroup))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($createdFromShipGroup, true), gettype($createdFromShipGroup)), __LINE__);
        }
        $this->createdFromShipGroup = $createdFromShipGroup;
        return $this;
    }
    /**
     * Get partner value
     * @return \StructType\RecordRef|null
     */
    public function getPartner()
    {
        return $this->partner;
    }
    /**
     * Set partner value
     * @param \StructType\RecordRef $partner
     * @return \StructType\ItemFulfillment
     */
    public function setPartner(\StructType\RecordRef $partner = null)
    {
        $this->partner = $partner;
        return $this;
    }
    /**
     * Get shippingAddress value
     * @return \StructType\Address|null
     */
    public function getShippingAddress()
    {
        return $this->shippingAddress;
    }
    /**
     * Set shippingAddress value
     * @param \StructType\Address $shippingAddress
     * @return \StructType\ItemFulfillment
     */
    public function setShippingAddress(\StructType\Address $shippingAddress = null)
    {
        $this->shippingAddress = $shippingAddress;
        return $this;
    }
    /**
     * Get pickedDate value
     * @return string|null
     */
    public function getPickedDate()
    {
        return $this->pickedDate;
    }
    /**
     * Set pickedDate value
     * @param string $pickedDate
     * @return \StructType\ItemFulfillment
     */
    public function setPickedDate($pickedDate = null)
    {
        // validation for constraint: string
        if (!is_null($pickedDate) && !is_string($pickedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickedDate, true), gettype($pickedDate)), __LINE__);
        }
        $this->pickedDate = $pickedDate;
        return $this;
    }
    /**
     * Get packedDate value
     * @return string|null
     */
    public function getPackedDate()
    {
        return $this->packedDate;
    }
    /**
     * Set packedDate value
     * @param string $packedDate
     * @return \StructType\ItemFulfillment
     */
    public function setPackedDate($packedDate = null)
    {
        // validation for constraint: string
        if (!is_null($packedDate) && !is_string($packedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packedDate, true), gettype($packedDate)), __LINE__);
        }
        $this->packedDate = $packedDate;
        return $this;
    }
    /**
     * Get shippedDate value
     * @return string|null
     */
    public function getShippedDate()
    {
        return $this->shippedDate;
    }
    /**
     * Set shippedDate value
     * @param string $shippedDate
     * @return \StructType\ItemFulfillment
     */
    public function setShippedDate($shippedDate = null)
    {
        // validation for constraint: string
        if (!is_null($shippedDate) && !is_string($shippedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippedDate, true), gettype($shippedDate)), __LINE__);
        }
        $this->shippedDate = $shippedDate;
        return $this;
    }
    /**
     * Get shipIsResidential value
     * @return bool|null
     */
    public function getShipIsResidential()
    {
        return $this->shipIsResidential;
    }
    /**
     * Set shipIsResidential value
     * @param bool $shipIsResidential
     * @return \StructType\ItemFulfillment
     */
    public function setShipIsResidential($shipIsResidential = null)
    {
        // validation for constraint: boolean
        if (!is_null($shipIsResidential) && !is_bool($shipIsResidential)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shipIsResidential, true), gettype($shipIsResidential)), __LINE__);
        }
        $this->shipIsResidential = $shipIsResidential;
        return $this;
    }
    /**
     * Get shipAddressList value
     * @return \StructType\RecordRef|null
     */
    public function getShipAddressList()
    {
        return $this->shipAddressList;
    }
    /**
     * Set shipAddressList value
     * @param \StructType\RecordRef $shipAddressList
     * @return \StructType\ItemFulfillment
     */
    public function setShipAddressList(\StructType\RecordRef $shipAddressList = null)
    {
        $this->shipAddressList = $shipAddressList;
        return $this;
    }
    /**
     * Get shipStatus value
     * @return string|null
     */
    public function getShipStatus()
    {
        return $this->shipStatus;
    }
    /**
     * Set shipStatus value
     * @uses \EnumType\ItemFulfillmentShipStatus::valueIsValid()
     * @uses \EnumType\ItemFulfillmentShipStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $shipStatus
     * @return \StructType\ItemFulfillment
     */
    public function setShipStatus($shipStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemFulfillmentShipStatus::valueIsValid($shipStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemFulfillmentShipStatus', is_array($shipStatus) ? implode(', ', $shipStatus) : var_export($shipStatus, true), implode(', ', \EnumType\ItemFulfillmentShipStatus::getValidValues())), __LINE__);
        }
        $this->shipStatus = $shipStatus;
        return $this;
    }
    /**
     * Get saturdayDeliveryUps value
     * @return bool|null
     */
    public function getSaturdayDeliveryUps()
    {
        return $this->saturdayDeliveryUps;
    }
    /**
     * Set saturdayDeliveryUps value
     * @param bool $saturdayDeliveryUps
     * @return \StructType\ItemFulfillment
     */
    public function setSaturdayDeliveryUps($saturdayDeliveryUps = null)
    {
        // validation for constraint: boolean
        if (!is_null($saturdayDeliveryUps) && !is_bool($saturdayDeliveryUps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($saturdayDeliveryUps, true), gettype($saturdayDeliveryUps)), __LINE__);
        }
        $this->saturdayDeliveryUps = $saturdayDeliveryUps;
        return $this;
    }
    /**
     * Get sendShipNotifyEmailUps value
     * @return bool|null
     */
    public function getSendShipNotifyEmailUps()
    {
        return $this->sendShipNotifyEmailUps;
    }
    /**
     * Set sendShipNotifyEmailUps value
     * @param bool $sendShipNotifyEmailUps
     * @return \StructType\ItemFulfillment
     */
    public function setSendShipNotifyEmailUps($sendShipNotifyEmailUps = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendShipNotifyEmailUps) && !is_bool($sendShipNotifyEmailUps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendShipNotifyEmailUps, true), gettype($sendShipNotifyEmailUps)), __LINE__);
        }
        $this->sendShipNotifyEmailUps = $sendShipNotifyEmailUps;
        return $this;
    }
    /**
     * Get sendBackupEmailUps value
     * @return bool|null
     */
    public function getSendBackupEmailUps()
    {
        return $this->sendBackupEmailUps;
    }
    /**
     * Set sendBackupEmailUps value
     * @param bool $sendBackupEmailUps
     * @return \StructType\ItemFulfillment
     */
    public function setSendBackupEmailUps($sendBackupEmailUps = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendBackupEmailUps) && !is_bool($sendBackupEmailUps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendBackupEmailUps, true), gettype($sendBackupEmailUps)), __LINE__);
        }
        $this->sendBackupEmailUps = $sendBackupEmailUps;
        return $this;
    }
    /**
     * Get shipNotifyEmailAddressUps value
     * @return string|null
     */
    public function getShipNotifyEmailAddressUps()
    {
        return $this->shipNotifyEmailAddressUps;
    }
    /**
     * Set shipNotifyEmailAddressUps value
     * @param string $shipNotifyEmailAddressUps
     * @return \StructType\ItemFulfillment
     */
    public function setShipNotifyEmailAddressUps($shipNotifyEmailAddressUps = null)
    {
        // validation for constraint: string
        if (!is_null($shipNotifyEmailAddressUps) && !is_string($shipNotifyEmailAddressUps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipNotifyEmailAddressUps, true), gettype($shipNotifyEmailAddressUps)), __LINE__);
        }
        $this->shipNotifyEmailAddressUps = $shipNotifyEmailAddressUps;
        return $this;
    }
    /**
     * Get shipNotifyEmailAddress2Ups value
     * @return string|null
     */
    public function getShipNotifyEmailAddress2Ups()
    {
        return $this->shipNotifyEmailAddress2Ups;
    }
    /**
     * Set shipNotifyEmailAddress2Ups value
     * @param string $shipNotifyEmailAddress2Ups
     * @return \StructType\ItemFulfillment
     */
    public function setShipNotifyEmailAddress2Ups($shipNotifyEmailAddress2Ups = null)
    {
        // validation for constraint: string
        if (!is_null($shipNotifyEmailAddress2Ups) && !is_string($shipNotifyEmailAddress2Ups)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipNotifyEmailAddress2Ups, true), gettype($shipNotifyEmailAddress2Ups)), __LINE__);
        }
        $this->shipNotifyEmailAddress2Ups = $shipNotifyEmailAddress2Ups;
        return $this;
    }
    /**
     * Get backupEmailAddressUps value
     * @return string|null
     */
    public function getBackupEmailAddressUps()
    {
        return $this->backupEmailAddressUps;
    }
    /**
     * Set backupEmailAddressUps value
     * @param string $backupEmailAddressUps
     * @return \StructType\ItemFulfillment
     */
    public function setBackupEmailAddressUps($backupEmailAddressUps = null)
    {
        // validation for constraint: string
        if (!is_null($backupEmailAddressUps) && !is_string($backupEmailAddressUps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($backupEmailAddressUps, true), gettype($backupEmailAddressUps)), __LINE__);
        }
        $this->backupEmailAddressUps = $backupEmailAddressUps;
        return $this;
    }
    /**
     * Get shipNotifyEmailMessageUps value
     * @return string|null
     */
    public function getShipNotifyEmailMessageUps()
    {
        return $this->shipNotifyEmailMessageUps;
    }
    /**
     * Set shipNotifyEmailMessageUps value
     * @param string $shipNotifyEmailMessageUps
     * @return \StructType\ItemFulfillment
     */
    public function setShipNotifyEmailMessageUps($shipNotifyEmailMessageUps = null)
    {
        // validation for constraint: string
        if (!is_null($shipNotifyEmailMessageUps) && !is_string($shipNotifyEmailMessageUps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipNotifyEmailMessageUps, true), gettype($shipNotifyEmailMessageUps)), __LINE__);
        }
        $this->shipNotifyEmailMessageUps = $shipNotifyEmailMessageUps;
        return $this;
    }
    /**
     * Get thirdPartyAcctUps value
     * @return string|null
     */
    public function getThirdPartyAcctUps()
    {
        return $this->thirdPartyAcctUps;
    }
    /**
     * Set thirdPartyAcctUps value
     * @param string $thirdPartyAcctUps
     * @return \StructType\ItemFulfillment
     */
    public function setThirdPartyAcctUps($thirdPartyAcctUps = null)
    {
        // validation for constraint: string
        if (!is_null($thirdPartyAcctUps) && !is_string($thirdPartyAcctUps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thirdPartyAcctUps, true), gettype($thirdPartyAcctUps)), __LINE__);
        }
        $this->thirdPartyAcctUps = $thirdPartyAcctUps;
        return $this;
    }
    /**
     * Get thirdPartyZipcodeUps value
     * @return string|null
     */
    public function getThirdPartyZipcodeUps()
    {
        return $this->thirdPartyZipcodeUps;
    }
    /**
     * Set thirdPartyZipcodeUps value
     * @param string $thirdPartyZipcodeUps
     * @return \StructType\ItemFulfillment
     */
    public function setThirdPartyZipcodeUps($thirdPartyZipcodeUps = null)
    {
        // validation for constraint: string
        if (!is_null($thirdPartyZipcodeUps) && !is_string($thirdPartyZipcodeUps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thirdPartyZipcodeUps, true), gettype($thirdPartyZipcodeUps)), __LINE__);
        }
        $this->thirdPartyZipcodeUps = $thirdPartyZipcodeUps;
        return $this;
    }
    /**
     * Get thirdPartyCountryUps value
     * @return string|null
     */
    public function getThirdPartyCountryUps()
    {
        return $this->thirdPartyCountryUps;
    }
    /**
     * Set thirdPartyCountryUps value
     * @uses \EnumType\Country::valueIsValid()
     * @uses \EnumType\Country::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $thirdPartyCountryUps
     * @return \StructType\ItemFulfillment
     */
    public function setThirdPartyCountryUps($thirdPartyCountryUps = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Country::valueIsValid($thirdPartyCountryUps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Country', is_array($thirdPartyCountryUps) ? implode(', ', $thirdPartyCountryUps) : var_export($thirdPartyCountryUps, true), implode(', ', \EnumType\Country::getValidValues())), __LINE__);
        }
        $this->thirdPartyCountryUps = $thirdPartyCountryUps;
        return $this;
    }
    /**
     * Get thirdPartyTypeUps value
     * @return string|null
     */
    public function getThirdPartyTypeUps()
    {
        return $this->thirdPartyTypeUps;
    }
    /**
     * Set thirdPartyTypeUps value
     * @uses \EnumType\ItemFulfillmentThirdPartyTypeUps::valueIsValid()
     * @uses \EnumType\ItemFulfillmentThirdPartyTypeUps::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $thirdPartyTypeUps
     * @return \StructType\ItemFulfillment
     */
    public function setThirdPartyTypeUps($thirdPartyTypeUps = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemFulfillmentThirdPartyTypeUps::valueIsValid($thirdPartyTypeUps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemFulfillmentThirdPartyTypeUps', is_array($thirdPartyTypeUps) ? implode(', ', $thirdPartyTypeUps) : var_export($thirdPartyTypeUps, true), implode(', ', \EnumType\ItemFulfillmentThirdPartyTypeUps::getValidValues())), __LINE__);
        }
        $this->thirdPartyTypeUps = $thirdPartyTypeUps;
        return $this;
    }
    /**
     * Get partiesToTransactionUps value
     * @return bool|null
     */
    public function getPartiesToTransactionUps()
    {
        return $this->partiesToTransactionUps;
    }
    /**
     * Set partiesToTransactionUps value
     * @param bool $partiesToTransactionUps
     * @return \StructType\ItemFulfillment
     */
    public function setPartiesToTransactionUps($partiesToTransactionUps = null)
    {
        // validation for constraint: boolean
        if (!is_null($partiesToTransactionUps) && !is_bool($partiesToTransactionUps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($partiesToTransactionUps, true), gettype($partiesToTransactionUps)), __LINE__);
        }
        $this->partiesToTransactionUps = $partiesToTransactionUps;
        return $this;
    }
    /**
     * Get exportTypeUps value
     * @return string|null
     */
    public function getExportTypeUps()
    {
        return $this->exportTypeUps;
    }
    /**
     * Set exportTypeUps value
     * @uses \EnumType\ItemFulfillmentExportTypeUps::valueIsValid()
     * @uses \EnumType\ItemFulfillmentExportTypeUps::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $exportTypeUps
     * @return \StructType\ItemFulfillment
     */
    public function setExportTypeUps($exportTypeUps = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemFulfillmentExportTypeUps::valueIsValid($exportTypeUps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemFulfillmentExportTypeUps', is_array($exportTypeUps) ? implode(', ', $exportTypeUps) : var_export($exportTypeUps, true), implode(', ', \EnumType\ItemFulfillmentExportTypeUps::getValidValues())), __LINE__);
        }
        $this->exportTypeUps = $exportTypeUps;
        return $this;
    }
    /**
     * Get methodOfTransportUps value
     * @return string|null
     */
    public function getMethodOfTransportUps()
    {
        return $this->methodOfTransportUps;
    }
    /**
     * Set methodOfTransportUps value
     * @uses \EnumType\ItemFulfillmentMethodOfTransportUps::valueIsValid()
     * @uses \EnumType\ItemFulfillmentMethodOfTransportUps::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $methodOfTransportUps
     * @return \StructType\ItemFulfillment
     */
    public function setMethodOfTransportUps($methodOfTransportUps = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemFulfillmentMethodOfTransportUps::valueIsValid($methodOfTransportUps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemFulfillmentMethodOfTransportUps', is_array($methodOfTransportUps) ? implode(', ', $methodOfTransportUps) : var_export($methodOfTransportUps, true), implode(', ', \EnumType\ItemFulfillmentMethodOfTransportUps::getValidValues())), __LINE__);
        }
        $this->methodOfTransportUps = $methodOfTransportUps;
        return $this;
    }
    /**
     * Get carrierIdUps value
     * @return string|null
     */
    public function getCarrierIdUps()
    {
        return $this->carrierIdUps;
    }
    /**
     * Set carrierIdUps value
     * @param string $carrierIdUps
     * @return \StructType\ItemFulfillment
     */
    public function setCarrierIdUps($carrierIdUps = null)
    {
        // validation for constraint: string
        if (!is_null($carrierIdUps) && !is_string($carrierIdUps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierIdUps, true), gettype($carrierIdUps)), __LINE__);
        }
        $this->carrierIdUps = $carrierIdUps;
        return $this;
    }
    /**
     * Get entryNumberUps value
     * @return string|null
     */
    public function getEntryNumberUps()
    {
        return $this->entryNumberUps;
    }
    /**
     * Set entryNumberUps value
     * @param string $entryNumberUps
     * @return \StructType\ItemFulfillment
     */
    public function setEntryNumberUps($entryNumberUps = null)
    {
        // validation for constraint: string
        if (!is_null($entryNumberUps) && !is_string($entryNumberUps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entryNumberUps, true), gettype($entryNumberUps)), __LINE__);
        }
        $this->entryNumberUps = $entryNumberUps;
        return $this;
    }
    /**
     * Get inbondCodeUps value
     * @return string|null
     */
    public function getInbondCodeUps()
    {
        return $this->inbondCodeUps;
    }
    /**
     * Set inbondCodeUps value
     * @param string $inbondCodeUps
     * @return \StructType\ItemFulfillment
     */
    public function setInbondCodeUps($inbondCodeUps = null)
    {
        // validation for constraint: string
        if (!is_null($inbondCodeUps) && !is_string($inbondCodeUps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inbondCodeUps, true), gettype($inbondCodeUps)), __LINE__);
        }
        $this->inbondCodeUps = $inbondCodeUps;
        return $this;
    }
    /**
     * Get isRoutedExportTransactionUps value
     * @return bool|null
     */
    public function getIsRoutedExportTransactionUps()
    {
        return $this->isRoutedExportTransactionUps;
    }
    /**
     * Set isRoutedExportTransactionUps value
     * @param bool $isRoutedExportTransactionUps
     * @return \StructType\ItemFulfillment
     */
    public function setIsRoutedExportTransactionUps($isRoutedExportTransactionUps = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRoutedExportTransactionUps) && !is_bool($isRoutedExportTransactionUps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRoutedExportTransactionUps, true), gettype($isRoutedExportTransactionUps)), __LINE__);
        }
        $this->isRoutedExportTransactionUps = $isRoutedExportTransactionUps;
        return $this;
    }
    /**
     * Get licenseNumberUps value
     * @return string|null
     */
    public function getLicenseNumberUps()
    {
        return $this->licenseNumberUps;
    }
    /**
     * Set licenseNumberUps value
     * @param string $licenseNumberUps
     * @return \StructType\ItemFulfillment
     */
    public function setLicenseNumberUps($licenseNumberUps = null)
    {
        // validation for constraint: string
        if (!is_null($licenseNumberUps) && !is_string($licenseNumberUps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($licenseNumberUps, true), gettype($licenseNumberUps)), __LINE__);
        }
        $this->licenseNumberUps = $licenseNumberUps;
        return $this;
    }
    /**
     * Get licenseDateUps value
     * @return string|null
     */
    public function getLicenseDateUps()
    {
        return $this->licenseDateUps;
    }
    /**
     * Set licenseDateUps value
     * @param string $licenseDateUps
     * @return \StructType\ItemFulfillment
     */
    public function setLicenseDateUps($licenseDateUps = null)
    {
        // validation for constraint: string
        if (!is_null($licenseDateUps) && !is_string($licenseDateUps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($licenseDateUps, true), gettype($licenseDateUps)), __LINE__);
        }
        $this->licenseDateUps = $licenseDateUps;
        return $this;
    }
    /**
     * Get licenseExceptionUps value
     * @return string|null
     */
    public function getLicenseExceptionUps()
    {
        return $this->licenseExceptionUps;
    }
    /**
     * Set licenseExceptionUps value
     * @uses \EnumType\ItemFulfillmentLicenseExceptionUps::valueIsValid()
     * @uses \EnumType\ItemFulfillmentLicenseExceptionUps::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $licenseExceptionUps
     * @return \StructType\ItemFulfillment
     */
    public function setLicenseExceptionUps($licenseExceptionUps = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemFulfillmentLicenseExceptionUps::valueIsValid($licenseExceptionUps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemFulfillmentLicenseExceptionUps', is_array($licenseExceptionUps) ? implode(', ', $licenseExceptionUps) : var_export($licenseExceptionUps, true), implode(', ', \EnumType\ItemFulfillmentLicenseExceptionUps::getValidValues())), __LINE__);
        }
        $this->licenseExceptionUps = $licenseExceptionUps;
        return $this;
    }
    /**
     * Get eccNumberUps value
     * @return string|null
     */
    public function getEccNumberUps()
    {
        return $this->eccNumberUps;
    }
    /**
     * Set eccNumberUps value
     * @param string $eccNumberUps
     * @return \StructType\ItemFulfillment
     */
    public function setEccNumberUps($eccNumberUps = null)
    {
        // validation for constraint: string
        if (!is_null($eccNumberUps) && !is_string($eccNumberUps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eccNumberUps, true), gettype($eccNumberUps)), __LINE__);
        }
        $this->eccNumberUps = $eccNumberUps;
        return $this;
    }
    /**
     * Get recipientTaxIdUps value
     * @return string|null
     */
    public function getRecipientTaxIdUps()
    {
        return $this->recipientTaxIdUps;
    }
    /**
     * Set recipientTaxIdUps value
     * @param string $recipientTaxIdUps
     * @return \StructType\ItemFulfillment
     */
    public function setRecipientTaxIdUps($recipientTaxIdUps = null)
    {
        // validation for constraint: string
        if (!is_null($recipientTaxIdUps) && !is_string($recipientTaxIdUps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recipientTaxIdUps, true), gettype($recipientTaxIdUps)), __LINE__);
        }
        $this->recipientTaxIdUps = $recipientTaxIdUps;
        return $this;
    }
    /**
     * Get blanketStartDateUps value
     * @return string|null
     */
    public function getBlanketStartDateUps()
    {
        return $this->blanketStartDateUps;
    }
    /**
     * Set blanketStartDateUps value
     * @param string $blanketStartDateUps
     * @return \StructType\ItemFulfillment
     */
    public function setBlanketStartDateUps($blanketStartDateUps = null)
    {
        // validation for constraint: string
        if (!is_null($blanketStartDateUps) && !is_string($blanketStartDateUps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($blanketStartDateUps, true), gettype($blanketStartDateUps)), __LINE__);
        }
        $this->blanketStartDateUps = $blanketStartDateUps;
        return $this;
    }
    /**
     * Get blanketEndDateUps value
     * @return string|null
     */
    public function getBlanketEndDateUps()
    {
        return $this->blanketEndDateUps;
    }
    /**
     * Set blanketEndDateUps value
     * @param string $blanketEndDateUps
     * @return \StructType\ItemFulfillment
     */
    public function setBlanketEndDateUps($blanketEndDateUps = null)
    {
        // validation for constraint: string
        if (!is_null($blanketEndDateUps) && !is_string($blanketEndDateUps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($blanketEndDateUps, true), gettype($blanketEndDateUps)), __LINE__);
        }
        $this->blanketEndDateUps = $blanketEndDateUps;
        return $this;
    }
    /**
     * Get shipmentWeightUps value
     * @return float|null
     */
    public function getShipmentWeightUps()
    {
        return $this->shipmentWeightUps;
    }
    /**
     * Set shipmentWeightUps value
     * @param float $shipmentWeightUps
     * @return \StructType\ItemFulfillment
     */
    public function setShipmentWeightUps($shipmentWeightUps = null)
    {
        // validation for constraint: float
        if (!is_null($shipmentWeightUps) && !(is_float($shipmentWeightUps) || is_numeric($shipmentWeightUps))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shipmentWeightUps, true), gettype($shipmentWeightUps)), __LINE__);
        }
        $this->shipmentWeightUps = $shipmentWeightUps;
        return $this;
    }
    /**
     * Get saturdayDeliveryFedEx value
     * @return bool|null
     */
    public function getSaturdayDeliveryFedEx()
    {
        return $this->saturdayDeliveryFedEx;
    }
    /**
     * Set saturdayDeliveryFedEx value
     * @param bool $saturdayDeliveryFedEx
     * @return \StructType\ItemFulfillment
     */
    public function setSaturdayDeliveryFedEx($saturdayDeliveryFedEx = null)
    {
        // validation for constraint: boolean
        if (!is_null($saturdayDeliveryFedEx) && !is_bool($saturdayDeliveryFedEx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($saturdayDeliveryFedEx, true), gettype($saturdayDeliveryFedEx)), __LINE__);
        }
        $this->saturdayDeliveryFedEx = $saturdayDeliveryFedEx;
        return $this;
    }
    /**
     * Get saturdayPickupFedex value
     * @return bool|null
     */
    public function getSaturdayPickupFedex()
    {
        return $this->saturdayPickupFedex;
    }
    /**
     * Set saturdayPickupFedex value
     * @param bool $saturdayPickupFedex
     * @return \StructType\ItemFulfillment
     */
    public function setSaturdayPickupFedex($saturdayPickupFedex = null)
    {
        // validation for constraint: boolean
        if (!is_null($saturdayPickupFedex) && !is_bool($saturdayPickupFedex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($saturdayPickupFedex, true), gettype($saturdayPickupFedex)), __LINE__);
        }
        $this->saturdayPickupFedex = $saturdayPickupFedex;
        return $this;
    }
    /**
     * Get sendShipNotifyEmailFedEx value
     * @return bool|null
     */
    public function getSendShipNotifyEmailFedEx()
    {
        return $this->sendShipNotifyEmailFedEx;
    }
    /**
     * Set sendShipNotifyEmailFedEx value
     * @param bool $sendShipNotifyEmailFedEx
     * @return \StructType\ItemFulfillment
     */
    public function setSendShipNotifyEmailFedEx($sendShipNotifyEmailFedEx = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendShipNotifyEmailFedEx) && !is_bool($sendShipNotifyEmailFedEx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendShipNotifyEmailFedEx, true), gettype($sendShipNotifyEmailFedEx)), __LINE__);
        }
        $this->sendShipNotifyEmailFedEx = $sendShipNotifyEmailFedEx;
        return $this;
    }
    /**
     * Get sendBackupEmailFedEx value
     * @return bool|null
     */
    public function getSendBackupEmailFedEx()
    {
        return $this->sendBackupEmailFedEx;
    }
    /**
     * Set sendBackupEmailFedEx value
     * @param bool $sendBackupEmailFedEx
     * @return \StructType\ItemFulfillment
     */
    public function setSendBackupEmailFedEx($sendBackupEmailFedEx = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendBackupEmailFedEx) && !is_bool($sendBackupEmailFedEx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendBackupEmailFedEx, true), gettype($sendBackupEmailFedEx)), __LINE__);
        }
        $this->sendBackupEmailFedEx = $sendBackupEmailFedEx;
        return $this;
    }
    /**
     * Get signatureHomeDeliveryFedEx value
     * @return bool|null
     */
    public function getSignatureHomeDeliveryFedEx()
    {
        return $this->signatureHomeDeliveryFedEx;
    }
    /**
     * Set signatureHomeDeliveryFedEx value
     * @param bool $signatureHomeDeliveryFedEx
     * @return \StructType\ItemFulfillment
     */
    public function setSignatureHomeDeliveryFedEx($signatureHomeDeliveryFedEx = null)
    {
        // validation for constraint: boolean
        if (!is_null($signatureHomeDeliveryFedEx) && !is_bool($signatureHomeDeliveryFedEx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($signatureHomeDeliveryFedEx, true), gettype($signatureHomeDeliveryFedEx)), __LINE__);
        }
        $this->signatureHomeDeliveryFedEx = $signatureHomeDeliveryFedEx;
        return $this;
    }
    /**
     * Get shipNotifyEmailAddressFedEx value
     * @return string|null
     */
    public function getShipNotifyEmailAddressFedEx()
    {
        return $this->shipNotifyEmailAddressFedEx;
    }
    /**
     * Set shipNotifyEmailAddressFedEx value
     * @param string $shipNotifyEmailAddressFedEx
     * @return \StructType\ItemFulfillment
     */
    public function setShipNotifyEmailAddressFedEx($shipNotifyEmailAddressFedEx = null)
    {
        // validation for constraint: string
        if (!is_null($shipNotifyEmailAddressFedEx) && !is_string($shipNotifyEmailAddressFedEx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipNotifyEmailAddressFedEx, true), gettype($shipNotifyEmailAddressFedEx)), __LINE__);
        }
        $this->shipNotifyEmailAddressFedEx = $shipNotifyEmailAddressFedEx;
        return $this;
    }
    /**
     * Get backupEmailAddressFedEx value
     * @return string|null
     */
    public function getBackupEmailAddressFedEx()
    {
        return $this->backupEmailAddressFedEx;
    }
    /**
     * Set backupEmailAddressFedEx value
     * @param string $backupEmailAddressFedEx
     * @return \StructType\ItemFulfillment
     */
    public function setBackupEmailAddressFedEx($backupEmailAddressFedEx = null)
    {
        // validation for constraint: string
        if (!is_null($backupEmailAddressFedEx) && !is_string($backupEmailAddressFedEx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($backupEmailAddressFedEx, true), gettype($backupEmailAddressFedEx)), __LINE__);
        }
        $this->backupEmailAddressFedEx = $backupEmailAddressFedEx;
        return $this;
    }
    /**
     * Get shipDateFedEx value
     * @return string|null
     */
    public function getShipDateFedEx()
    {
        return $this->shipDateFedEx;
    }
    /**
     * Set shipDateFedEx value
     * @param string $shipDateFedEx
     * @return \StructType\ItemFulfillment
     */
    public function setShipDateFedEx($shipDateFedEx = null)
    {
        // validation for constraint: string
        if (!is_null($shipDateFedEx) && !is_string($shipDateFedEx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipDateFedEx, true), gettype($shipDateFedEx)), __LINE__);
        }
        $this->shipDateFedEx = $shipDateFedEx;
        return $this;
    }
    /**
     * Get homeDeliveryTypeFedEx value
     * @return string|null
     */
    public function getHomeDeliveryTypeFedEx()
    {
        return $this->homeDeliveryTypeFedEx;
    }
    /**
     * Set homeDeliveryTypeFedEx value
     * @uses \EnumType\ItemFulfillmentHomeDeliveryTypeFedEx::valueIsValid()
     * @uses \EnumType\ItemFulfillmentHomeDeliveryTypeFedEx::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $homeDeliveryTypeFedEx
     * @return \StructType\ItemFulfillment
     */
    public function setHomeDeliveryTypeFedEx($homeDeliveryTypeFedEx = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemFulfillmentHomeDeliveryTypeFedEx::valueIsValid($homeDeliveryTypeFedEx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemFulfillmentHomeDeliveryTypeFedEx', is_array($homeDeliveryTypeFedEx) ? implode(', ', $homeDeliveryTypeFedEx) : var_export($homeDeliveryTypeFedEx, true), implode(', ', \EnumType\ItemFulfillmentHomeDeliveryTypeFedEx::getValidValues())), __LINE__);
        }
        $this->homeDeliveryTypeFedEx = $homeDeliveryTypeFedEx;
        return $this;
    }
    /**
     * Get homeDeliveryDateFedEx value
     * @return string|null
     */
    public function getHomeDeliveryDateFedEx()
    {
        return $this->homeDeliveryDateFedEx;
    }
    /**
     * Set homeDeliveryDateFedEx value
     * @param string $homeDeliveryDateFedEx
     * @return \StructType\ItemFulfillment
     */
    public function setHomeDeliveryDateFedEx($homeDeliveryDateFedEx = null)
    {
        // validation for constraint: string
        if (!is_null($homeDeliveryDateFedEx) && !is_string($homeDeliveryDateFedEx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homeDeliveryDateFedEx, true), gettype($homeDeliveryDateFedEx)), __LINE__);
        }
        $this->homeDeliveryDateFedEx = $homeDeliveryDateFedEx;
        return $this;
    }
    /**
     * Get bookingConfirmationNumFedEx value
     * @return string|null
     */
    public function getBookingConfirmationNumFedEx()
    {
        return $this->bookingConfirmationNumFedEx;
    }
    /**
     * Set bookingConfirmationNumFedEx value
     * @param string $bookingConfirmationNumFedEx
     * @return \StructType\ItemFulfillment
     */
    public function setBookingConfirmationNumFedEx($bookingConfirmationNumFedEx = null)
    {
        // validation for constraint: string
        if (!is_null($bookingConfirmationNumFedEx) && !is_string($bookingConfirmationNumFedEx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingConfirmationNumFedEx, true), gettype($bookingConfirmationNumFedEx)), __LINE__);
        }
        $this->bookingConfirmationNumFedEx = $bookingConfirmationNumFedEx;
        return $this;
    }
    /**
     * Get intlExemptionNumFedEx value
     * @return string|null
     */
    public function getIntlExemptionNumFedEx()
    {
        return $this->intlExemptionNumFedEx;
    }
    /**
     * Set intlExemptionNumFedEx value
     * @param string $intlExemptionNumFedEx
     * @return \StructType\ItemFulfillment
     */
    public function setIntlExemptionNumFedEx($intlExemptionNumFedEx = null)
    {
        // validation for constraint: string
        if (!is_null($intlExemptionNumFedEx) && !is_string($intlExemptionNumFedEx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($intlExemptionNumFedEx, true), gettype($intlExemptionNumFedEx)), __LINE__);
        }
        $this->intlExemptionNumFedEx = $intlExemptionNumFedEx;
        return $this;
    }
    /**
     * Get b13aFilingOptionFedEx value
     * @return string|null
     */
    public function getB13aFilingOptionFedEx()
    {
        return $this->b13aFilingOptionFedEx;
    }
    /**
     * Set b13aFilingOptionFedEx value
     * @uses \EnumType\ItemFulfillmentB13AFilingOptionFedEx::valueIsValid()
     * @uses \EnumType\ItemFulfillmentB13AFilingOptionFedEx::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $b13aFilingOptionFedEx
     * @return \StructType\ItemFulfillment
     */
    public function setB13aFilingOptionFedEx($b13aFilingOptionFedEx = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemFulfillmentB13AFilingOptionFedEx::valueIsValid($b13aFilingOptionFedEx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemFulfillmentB13AFilingOptionFedEx', is_array($b13aFilingOptionFedEx) ? implode(', ', $b13aFilingOptionFedEx) : var_export($b13aFilingOptionFedEx, true), implode(', ', \EnumType\ItemFulfillmentB13AFilingOptionFedEx::getValidValues())), __LINE__);
        }
        $this->b13aFilingOptionFedEx = $b13aFilingOptionFedEx;
        return $this;
    }
    /**
     * Get b13aStatementDataFedEx value
     * @return string|null
     */
    public function getB13aStatementDataFedEx()
    {
        return $this->b13aStatementDataFedEx;
    }
    /**
     * Set b13aStatementDataFedEx value
     * @param string $b13aStatementDataFedEx
     * @return \StructType\ItemFulfillment
     */
    public function setB13aStatementDataFedEx($b13aStatementDataFedEx = null)
    {
        // validation for constraint: string
        if (!is_null($b13aStatementDataFedEx) && !is_string($b13aStatementDataFedEx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($b13aStatementDataFedEx, true), gettype($b13aStatementDataFedEx)), __LINE__);
        }
        $this->b13aStatementDataFedEx = $b13aStatementDataFedEx;
        return $this;
    }
    /**
     * Get thirdPartyAcctFedEx value
     * @return string|null
     */
    public function getThirdPartyAcctFedEx()
    {
        return $this->thirdPartyAcctFedEx;
    }
    /**
     * Set thirdPartyAcctFedEx value
     * @param string $thirdPartyAcctFedEx
     * @return \StructType\ItemFulfillment
     */
    public function setThirdPartyAcctFedEx($thirdPartyAcctFedEx = null)
    {
        // validation for constraint: string
        if (!is_null($thirdPartyAcctFedEx) && !is_string($thirdPartyAcctFedEx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thirdPartyAcctFedEx, true), gettype($thirdPartyAcctFedEx)), __LINE__);
        }
        $this->thirdPartyAcctFedEx = $thirdPartyAcctFedEx;
        return $this;
    }
    /**
     * Get thirdPartyCountryFedEx value
     * @return string|null
     */
    public function getThirdPartyCountryFedEx()
    {
        return $this->thirdPartyCountryFedEx;
    }
    /**
     * Set thirdPartyCountryFedEx value
     * @uses \EnumType\Country::valueIsValid()
     * @uses \EnumType\Country::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $thirdPartyCountryFedEx
     * @return \StructType\ItemFulfillment
     */
    public function setThirdPartyCountryFedEx($thirdPartyCountryFedEx = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Country::valueIsValid($thirdPartyCountryFedEx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Country', is_array($thirdPartyCountryFedEx) ? implode(', ', $thirdPartyCountryFedEx) : var_export($thirdPartyCountryFedEx, true), implode(', ', \EnumType\Country::getValidValues())), __LINE__);
        }
        $this->thirdPartyCountryFedEx = $thirdPartyCountryFedEx;
        return $this;
    }
    /**
     * Get thirdPartyTypeFedEx value
     * @return string|null
     */
    public function getThirdPartyTypeFedEx()
    {
        return $this->thirdPartyTypeFedEx;
    }
    /**
     * Set thirdPartyTypeFedEx value
     * @uses \EnumType\ItemFulfillmentThirdPartyTypeFedEx::valueIsValid()
     * @uses \EnumType\ItemFulfillmentThirdPartyTypeFedEx::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $thirdPartyTypeFedEx
     * @return \StructType\ItemFulfillment
     */
    public function setThirdPartyTypeFedEx($thirdPartyTypeFedEx = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemFulfillmentThirdPartyTypeFedEx::valueIsValid($thirdPartyTypeFedEx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemFulfillmentThirdPartyTypeFedEx', is_array($thirdPartyTypeFedEx) ? implode(', ', $thirdPartyTypeFedEx) : var_export($thirdPartyTypeFedEx, true), implode(', ', \EnumType\ItemFulfillmentThirdPartyTypeFedEx::getValidValues())), __LINE__);
        }
        $this->thirdPartyTypeFedEx = $thirdPartyTypeFedEx;
        return $this;
    }
    /**
     * Get shipmentWeightFedEx value
     * @return float|null
     */
    public function getShipmentWeightFedEx()
    {
        return $this->shipmentWeightFedEx;
    }
    /**
     * Set shipmentWeightFedEx value
     * @param float $shipmentWeightFedEx
     * @return \StructType\ItemFulfillment
     */
    public function setShipmentWeightFedEx($shipmentWeightFedEx = null)
    {
        // validation for constraint: float
        if (!is_null($shipmentWeightFedEx) && !(is_float($shipmentWeightFedEx) || is_numeric($shipmentWeightFedEx))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shipmentWeightFedEx, true), gettype($shipmentWeightFedEx)), __LINE__);
        }
        $this->shipmentWeightFedEx = $shipmentWeightFedEx;
        return $this;
    }
    /**
     * Get termsOfSaleFedEx value
     * @return string|null
     */
    public function getTermsOfSaleFedEx()
    {
        return $this->termsOfSaleFedEx;
    }
    /**
     * Set termsOfSaleFedEx value
     * @uses \EnumType\ItemFulfillmentTermsOfSaleFedEx::valueIsValid()
     * @uses \EnumType\ItemFulfillmentTermsOfSaleFedEx::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $termsOfSaleFedEx
     * @return \StructType\ItemFulfillment
     */
    public function setTermsOfSaleFedEx($termsOfSaleFedEx = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemFulfillmentTermsOfSaleFedEx::valueIsValid($termsOfSaleFedEx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemFulfillmentTermsOfSaleFedEx', is_array($termsOfSaleFedEx) ? implode(', ', $termsOfSaleFedEx) : var_export($termsOfSaleFedEx, true), implode(', ', \EnumType\ItemFulfillmentTermsOfSaleFedEx::getValidValues())), __LINE__);
        }
        $this->termsOfSaleFedEx = $termsOfSaleFedEx;
        return $this;
    }
    /**
     * Get termsFreightChargeFedEx value
     * @return float|null
     */
    public function getTermsFreightChargeFedEx()
    {
        return $this->termsFreightChargeFedEx;
    }
    /**
     * Set termsFreightChargeFedEx value
     * @param float $termsFreightChargeFedEx
     * @return \StructType\ItemFulfillment
     */
    public function setTermsFreightChargeFedEx($termsFreightChargeFedEx = null)
    {
        // validation for constraint: float
        if (!is_null($termsFreightChargeFedEx) && !(is_float($termsFreightChargeFedEx) || is_numeric($termsFreightChargeFedEx))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($termsFreightChargeFedEx, true), gettype($termsFreightChargeFedEx)), __LINE__);
        }
        $this->termsFreightChargeFedEx = $termsFreightChargeFedEx;
        return $this;
    }
    /**
     * Get termsInsuranceChargeFedEx value
     * @return float|null
     */
    public function getTermsInsuranceChargeFedEx()
    {
        return $this->termsInsuranceChargeFedEx;
    }
    /**
     * Set termsInsuranceChargeFedEx value
     * @param float $termsInsuranceChargeFedEx
     * @return \StructType\ItemFulfillment
     */
    public function setTermsInsuranceChargeFedEx($termsInsuranceChargeFedEx = null)
    {
        // validation for constraint: float
        if (!is_null($termsInsuranceChargeFedEx) && !(is_float($termsInsuranceChargeFedEx) || is_numeric($termsInsuranceChargeFedEx))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($termsInsuranceChargeFedEx, true), gettype($termsInsuranceChargeFedEx)), __LINE__);
        }
        $this->termsInsuranceChargeFedEx = $termsInsuranceChargeFedEx;
        return $this;
    }
    /**
     * Get insideDeliveryFedEx value
     * @return bool|null
     */
    public function getInsideDeliveryFedEx()
    {
        return $this->insideDeliveryFedEx;
    }
    /**
     * Set insideDeliveryFedEx value
     * @param bool $insideDeliveryFedEx
     * @return \StructType\ItemFulfillment
     */
    public function setInsideDeliveryFedEx($insideDeliveryFedEx = null)
    {
        // validation for constraint: boolean
        if (!is_null($insideDeliveryFedEx) && !is_bool($insideDeliveryFedEx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($insideDeliveryFedEx, true), gettype($insideDeliveryFedEx)), __LINE__);
        }
        $this->insideDeliveryFedEx = $insideDeliveryFedEx;
        return $this;
    }
    /**
     * Get insidePickupFedEx value
     * @return bool|null
     */
    public function getInsidePickupFedEx()
    {
        return $this->insidePickupFedEx;
    }
    /**
     * Set insidePickupFedEx value
     * @param bool $insidePickupFedEx
     * @return \StructType\ItemFulfillment
     */
    public function setInsidePickupFedEx($insidePickupFedEx = null)
    {
        // validation for constraint: boolean
        if (!is_null($insidePickupFedEx) && !is_bool($insidePickupFedEx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($insidePickupFedEx, true), gettype($insidePickupFedEx)), __LINE__);
        }
        $this->insidePickupFedEx = $insidePickupFedEx;
        return $this;
    }
    /**
     * Get ancillaryEndorsementFedEx value
     * @return string|null
     */
    public function getAncillaryEndorsementFedEx()
    {
        return $this->ancillaryEndorsementFedEx;
    }
    /**
     * Set ancillaryEndorsementFedEx value
     * @uses \EnumType\ItemFulfillmentAncillaryEndorsementFedEx::valueIsValid()
     * @uses \EnumType\ItemFulfillmentAncillaryEndorsementFedEx::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ancillaryEndorsementFedEx
     * @return \StructType\ItemFulfillment
     */
    public function setAncillaryEndorsementFedEx($ancillaryEndorsementFedEx = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemFulfillmentAncillaryEndorsementFedEx::valueIsValid($ancillaryEndorsementFedEx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemFulfillmentAncillaryEndorsementFedEx', is_array($ancillaryEndorsementFedEx) ? implode(', ', $ancillaryEndorsementFedEx) : var_export($ancillaryEndorsementFedEx, true), implode(', ', \EnumType\ItemFulfillmentAncillaryEndorsementFedEx::getValidValues())), __LINE__);
        }
        $this->ancillaryEndorsementFedEx = $ancillaryEndorsementFedEx;
        return $this;
    }
    /**
     * Get holdAtLocationFedEx value
     * @return bool|null
     */
    public function getHoldAtLocationFedEx()
    {
        return $this->holdAtLocationFedEx;
    }
    /**
     * Set holdAtLocationFedEx value
     * @param bool $holdAtLocationFedEx
     * @return \StructType\ItemFulfillment
     */
    public function setHoldAtLocationFedEx($holdAtLocationFedEx = null)
    {
        // validation for constraint: boolean
        if (!is_null($holdAtLocationFedEx) && !is_bool($holdAtLocationFedEx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($holdAtLocationFedEx, true), gettype($holdAtLocationFedEx)), __LINE__);
        }
        $this->holdAtLocationFedEx = $holdAtLocationFedEx;
        return $this;
    }
    /**
     * Get halPhoneFedEx value
     * @return string|null
     */
    public function getHalPhoneFedEx()
    {
        return $this->halPhoneFedEx;
    }
    /**
     * Set halPhoneFedEx value
     * @param string $halPhoneFedEx
     * @return \StructType\ItemFulfillment
     */
    public function setHalPhoneFedEx($halPhoneFedEx = null)
    {
        // validation for constraint: string
        if (!is_null($halPhoneFedEx) && !is_string($halPhoneFedEx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($halPhoneFedEx, true), gettype($halPhoneFedEx)), __LINE__);
        }
        $this->halPhoneFedEx = $halPhoneFedEx;
        return $this;
    }
    /**
     * Get halAddr1FedEx value
     * @return string|null
     */
    public function getHalAddr1FedEx()
    {
        return $this->halAddr1FedEx;
    }
    /**
     * Set halAddr1FedEx value
     * @param string $halAddr1FedEx
     * @return \StructType\ItemFulfillment
     */
    public function setHalAddr1FedEx($halAddr1FedEx = null)
    {
        // validation for constraint: string
        if (!is_null($halAddr1FedEx) && !is_string($halAddr1FedEx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($halAddr1FedEx, true), gettype($halAddr1FedEx)), __LINE__);
        }
        $this->halAddr1FedEx = $halAddr1FedEx;
        return $this;
    }
    /**
     * Get halAddr2FedEx value
     * @return string|null
     */
    public function getHalAddr2FedEx()
    {
        return $this->halAddr2FedEx;
    }
    /**
     * Set halAddr2FedEx value
     * @param string $halAddr2FedEx
     * @return \StructType\ItemFulfillment
     */
    public function setHalAddr2FedEx($halAddr2FedEx = null)
    {
        // validation for constraint: string
        if (!is_null($halAddr2FedEx) && !is_string($halAddr2FedEx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($halAddr2FedEx, true), gettype($halAddr2FedEx)), __LINE__);
        }
        $this->halAddr2FedEx = $halAddr2FedEx;
        return $this;
    }
    /**
     * Get halAddr3FedEx value
     * @return string|null
     */
    public function getHalAddr3FedEx()
    {
        return $this->halAddr3FedEx;
    }
    /**
     * Set halAddr3FedEx value
     * @param string $halAddr3FedEx
     * @return \StructType\ItemFulfillment
     */
    public function setHalAddr3FedEx($halAddr3FedEx = null)
    {
        // validation for constraint: string
        if (!is_null($halAddr3FedEx) && !is_string($halAddr3FedEx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($halAddr3FedEx, true), gettype($halAddr3FedEx)), __LINE__);
        }
        $this->halAddr3FedEx = $halAddr3FedEx;
        return $this;
    }
    /**
     * Get halCityFedEx value
     * @return string|null
     */
    public function getHalCityFedEx()
    {
        return $this->halCityFedEx;
    }
    /**
     * Set halCityFedEx value
     * @param string $halCityFedEx
     * @return \StructType\ItemFulfillment
     */
    public function setHalCityFedEx($halCityFedEx = null)
    {
        // validation for constraint: string
        if (!is_null($halCityFedEx) && !is_string($halCityFedEx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($halCityFedEx, true), gettype($halCityFedEx)), __LINE__);
        }
        $this->halCityFedEx = $halCityFedEx;
        return $this;
    }
    /**
     * Get halZipFedEx value
     * @return string|null
     */
    public function getHalZipFedEx()
    {
        return $this->halZipFedEx;
    }
    /**
     * Set halZipFedEx value
     * @param string $halZipFedEx
     * @return \StructType\ItemFulfillment
     */
    public function setHalZipFedEx($halZipFedEx = null)
    {
        // validation for constraint: string
        if (!is_null($halZipFedEx) && !is_string($halZipFedEx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($halZipFedEx, true), gettype($halZipFedEx)), __LINE__);
        }
        $this->halZipFedEx = $halZipFedEx;
        return $this;
    }
    /**
     * Get halStateFedEx value
     * @return string|null
     */
    public function getHalStateFedEx()
    {
        return $this->halStateFedEx;
    }
    /**
     * Set halStateFedEx value
     * @param string $halStateFedEx
     * @return \StructType\ItemFulfillment
     */
    public function setHalStateFedEx($halStateFedEx = null)
    {
        // validation for constraint: string
        if (!is_null($halStateFedEx) && !is_string($halStateFedEx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($halStateFedEx, true), gettype($halStateFedEx)), __LINE__);
        }
        $this->halStateFedEx = $halStateFedEx;
        return $this;
    }
    /**
     * Get halCountryFedEx value
     * @return string|null
     */
    public function getHalCountryFedEx()
    {
        return $this->halCountryFedEx;
    }
    /**
     * Set halCountryFedEx value
     * @param string $halCountryFedEx
     * @return \StructType\ItemFulfillment
     */
    public function setHalCountryFedEx($halCountryFedEx = null)
    {
        // validation for constraint: string
        if (!is_null($halCountryFedEx) && !is_string($halCountryFedEx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($halCountryFedEx, true), gettype($halCountryFedEx)), __LINE__);
        }
        $this->halCountryFedEx = $halCountryFedEx;
        return $this;
    }
    /**
     * Get hazmatTypeFedEx value
     * @return string|null
     */
    public function getHazmatTypeFedEx()
    {
        return $this->hazmatTypeFedEx;
    }
    /**
     * Set hazmatTypeFedEx value
     * @uses \EnumType\ItemFulfillmentHazmatTypeFedEx::valueIsValid()
     * @uses \EnumType\ItemFulfillmentHazmatTypeFedEx::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hazmatTypeFedEx
     * @return \StructType\ItemFulfillment
     */
    public function setHazmatTypeFedEx($hazmatTypeFedEx = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemFulfillmentHazmatTypeFedEx::valueIsValid($hazmatTypeFedEx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemFulfillmentHazmatTypeFedEx', is_array($hazmatTypeFedEx) ? implode(', ', $hazmatTypeFedEx) : var_export($hazmatTypeFedEx, true), implode(', ', \EnumType\ItemFulfillmentHazmatTypeFedEx::getValidValues())), __LINE__);
        }
        $this->hazmatTypeFedEx = $hazmatTypeFedEx;
        return $this;
    }
    /**
     * Get accessibilityTypeFedEx value
     * @return string|null
     */
    public function getAccessibilityTypeFedEx()
    {
        return $this->accessibilityTypeFedEx;
    }
    /**
     * Set accessibilityTypeFedEx value
     * @uses \EnumType\ItemFulfillmentAccessibilityTypeFedEx::valueIsValid()
     * @uses \EnumType\ItemFulfillmentAccessibilityTypeFedEx::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accessibilityTypeFedEx
     * @return \StructType\ItemFulfillment
     */
    public function setAccessibilityTypeFedEx($accessibilityTypeFedEx = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemFulfillmentAccessibilityTypeFedEx::valueIsValid($accessibilityTypeFedEx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemFulfillmentAccessibilityTypeFedEx', is_array($accessibilityTypeFedEx) ? implode(', ', $accessibilityTypeFedEx) : var_export($accessibilityTypeFedEx, true), implode(', ', \EnumType\ItemFulfillmentAccessibilityTypeFedEx::getValidValues())), __LINE__);
        }
        $this->accessibilityTypeFedEx = $accessibilityTypeFedEx;
        return $this;
    }
    /**
     * Get isCargoAircraftOnlyFedEx value
     * @return bool|null
     */
    public function getIsCargoAircraftOnlyFedEx()
    {
        return $this->isCargoAircraftOnlyFedEx;
    }
    /**
     * Set isCargoAircraftOnlyFedEx value
     * @param bool $isCargoAircraftOnlyFedEx
     * @return \StructType\ItemFulfillment
     */
    public function setIsCargoAircraftOnlyFedEx($isCargoAircraftOnlyFedEx = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCargoAircraftOnlyFedEx) && !is_bool($isCargoAircraftOnlyFedEx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCargoAircraftOnlyFedEx, true), gettype($isCargoAircraftOnlyFedEx)), __LINE__);
        }
        $this->isCargoAircraftOnlyFedEx = $isCargoAircraftOnlyFedEx;
        return $this;
    }
    /**
     * Get tranDate value
     * @return string|null
     */
    public function getTranDate()
    {
        return $this->tranDate;
    }
    /**
     * Set tranDate value
     * @param string $tranDate
     * @return \StructType\ItemFulfillment
     */
    public function setTranDate($tranDate = null)
    {
        // validation for constraint: string
        if (!is_null($tranDate) && !is_string($tranDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranDate, true), gettype($tranDate)), __LINE__);
        }
        $this->tranDate = $tranDate;
        return $this;
    }
    /**
     * Get tranId value
     * @return string|null
     */
    public function getTranId()
    {
        return $this->tranId;
    }
    /**
     * Set tranId value
     * @param string $tranId
     * @return \StructType\ItemFulfillment
     */
    public function setTranId($tranId = null)
    {
        // validation for constraint: string
        if (!is_null($tranId) && !is_string($tranId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranId, true), gettype($tranId)), __LINE__);
        }
        $this->tranId = $tranId;
        return $this;
    }
    /**
     * Get shipMethod value
     * @return \StructType\RecordRef|null
     */
    public function getShipMethod()
    {
        return $this->shipMethod;
    }
    /**
     * Set shipMethod value
     * @param \StructType\RecordRef $shipMethod
     * @return \StructType\ItemFulfillment
     */
    public function setShipMethod(\StructType\RecordRef $shipMethod = null)
    {
        $this->shipMethod = $shipMethod;
        return $this;
    }
    /**
     * Get generateIntegratedShipperLabel value
     * @return bool|null
     */
    public function getGenerateIntegratedShipperLabel()
    {
        return $this->generateIntegratedShipperLabel;
    }
    /**
     * Set generateIntegratedShipperLabel value
     * @param bool $generateIntegratedShipperLabel
     * @return \StructType\ItemFulfillment
     */
    public function setGenerateIntegratedShipperLabel($generateIntegratedShipperLabel = null)
    {
        // validation for constraint: boolean
        if (!is_null($generateIntegratedShipperLabel) && !is_bool($generateIntegratedShipperLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($generateIntegratedShipperLabel, true), gettype($generateIntegratedShipperLabel)), __LINE__);
        }
        $this->generateIntegratedShipperLabel = $generateIntegratedShipperLabel;
        return $this;
    }
    /**
     * Get shippingCost value
     * @return float|null
     */
    public function getShippingCost()
    {
        return $this->shippingCost;
    }
    /**
     * Set shippingCost value
     * @param float $shippingCost
     * @return \StructType\ItemFulfillment
     */
    public function setShippingCost($shippingCost = null)
    {
        // validation for constraint: float
        if (!is_null($shippingCost) && !(is_float($shippingCost) || is_numeric($shippingCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shippingCost, true), gettype($shippingCost)), __LINE__);
        }
        $this->shippingCost = $shippingCost;
        return $this;
    }
    /**
     * Get handlingCost value
     * @return float|null
     */
    public function getHandlingCost()
    {
        return $this->handlingCost;
    }
    /**
     * Set handlingCost value
     * @param float $handlingCost
     * @return \StructType\ItemFulfillment
     */
    public function setHandlingCost($handlingCost = null)
    {
        // validation for constraint: float
        if (!is_null($handlingCost) && !(is_float($handlingCost) || is_numeric($handlingCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($handlingCost, true), gettype($handlingCost)), __LINE__);
        }
        $this->handlingCost = $handlingCost;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\ItemFulfillment
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get transferLocation value
     * @return \StructType\RecordRef|null
     */
    public function getTransferLocation()
    {
        return $this->transferLocation;
    }
    /**
     * Set transferLocation value
     * @param \StructType\RecordRef $transferLocation
     * @return \StructType\ItemFulfillment
     */
    public function setTransferLocation(\StructType\RecordRef $transferLocation = null)
    {
        $this->transferLocation = $transferLocation;
        return $this;
    }
    /**
     * Get packageList value
     * @return \StructType\ItemFulfillmentPackageList|null
     */
    public function getPackageList()
    {
        return $this->packageList;
    }
    /**
     * Set packageList value
     * @param \StructType\ItemFulfillmentPackageList $packageList
     * @return \StructType\ItemFulfillment
     */
    public function setPackageList(\StructType\ItemFulfillmentPackageList $packageList = null)
    {
        $this->packageList = $packageList;
        return $this;
    }
    /**
     * Get packageUpsList value
     * @return \StructType\ItemFulfillmentPackageUpsList|null
     */
    public function getPackageUpsList()
    {
        return $this->packageUpsList;
    }
    /**
     * Set packageUpsList value
     * @param \StructType\ItemFulfillmentPackageUpsList $packageUpsList
     * @return \StructType\ItemFulfillment
     */
    public function setPackageUpsList(\StructType\ItemFulfillmentPackageUpsList $packageUpsList = null)
    {
        $this->packageUpsList = $packageUpsList;
        return $this;
    }
    /**
     * Get packageUspsList value
     * @return \StructType\ItemFulfillmentPackageUspsList|null
     */
    public function getPackageUspsList()
    {
        return $this->packageUspsList;
    }
    /**
     * Set packageUspsList value
     * @param \StructType\ItemFulfillmentPackageUspsList $packageUspsList
     * @return \StructType\ItemFulfillment
     */
    public function setPackageUspsList(\StructType\ItemFulfillmentPackageUspsList $packageUspsList = null)
    {
        $this->packageUspsList = $packageUspsList;
        return $this;
    }
    /**
     * Get packageFedExList value
     * @return \StructType\ItemFulfillmentPackageFedExList|null
     */
    public function getPackageFedExList()
    {
        return $this->packageFedExList;
    }
    /**
     * Set packageFedExList value
     * @param \StructType\ItemFulfillmentPackageFedExList $packageFedExList
     * @return \StructType\ItemFulfillment
     */
    public function setPackageFedExList(\StructType\ItemFulfillmentPackageFedExList $packageFedExList = null)
    {
        $this->packageFedExList = $packageFedExList;
        return $this;
    }
    /**
     * Get itemList value
     * @return \StructType\ItemFulfillmentItemList|null
     */
    public function getItemList()
    {
        return $this->itemList;
    }
    /**
     * Set itemList value
     * @param \StructType\ItemFulfillmentItemList $itemList
     * @return \StructType\ItemFulfillment
     */
    public function setItemList(\StructType\ItemFulfillmentItemList $itemList = null)
    {
        $this->itemList = $itemList;
        return $this;
    }
    /**
     * Get accountingBookDetailList value
     * @return \StructType\AccountingBookDetailList|null
     */
    public function getAccountingBookDetailList()
    {
        return $this->accountingBookDetailList;
    }
    /**
     * Set accountingBookDetailList value
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @return \StructType\ItemFulfillment
     */
    public function setAccountingBookDetailList(\StructType\AccountingBookDetailList $accountingBookDetailList = null)
    {
        $this->accountingBookDetailList = $accountingBookDetailList;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\ItemFulfillment
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\ItemFulfillment
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\ItemFulfillment
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
