<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemDemandPlan StructType
 * @subpackage Structs
 */
class ItemDemandPlan extends Record
{
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiary;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The units
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $units;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The year
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $year;
    /**
     * The month
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $month;
    /**
     * The startDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * The demandPlanCalendarType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $demandPlanCalendarType;
    /**
     * The demandPlanMatrix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DemandPlanMatrix
     */
    public $demandPlanMatrix;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for ItemDemandPlan
     * @uses ItemDemandPlan::setCustomForm()
     * @uses ItemDemandPlan::setSubsidiary()
     * @uses ItemDemandPlan::setLocation()
     * @uses ItemDemandPlan::setItem()
     * @uses ItemDemandPlan::setUnits()
     * @uses ItemDemandPlan::setMemo()
     * @uses ItemDemandPlan::setYear()
     * @uses ItemDemandPlan::setMonth()
     * @uses ItemDemandPlan::setStartDate()
     * @uses ItemDemandPlan::setEndDate()
     * @uses ItemDemandPlan::setDemandPlanCalendarType()
     * @uses ItemDemandPlan::setDemandPlanMatrix()
     * @uses ItemDemandPlan::setCustomFieldList()
     * @uses ItemDemandPlan::setInternalId()
     * @uses ItemDemandPlan::setExternalId()
     * @param \StructType\RecordRef $customForm
     * @param \StructType\RecordRef $subsidiary
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRef $item
     * @param \StructType\RecordRef $units
     * @param string $memo
     * @param int $year
     * @param string $month
     * @param string $startDate
     * @param string $endDate
     * @param string $demandPlanCalendarType
     * @param \StructType\DemandPlanMatrix $demandPlanMatrix
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct(\StructType\RecordRef $customForm = null, \StructType\RecordRef $subsidiary = null, \StructType\RecordRef $location = null, \StructType\RecordRef $item = null, \StructType\RecordRef $units = null, $memo = null, $year = null, $month = null, $startDate = null, $endDate = null, $demandPlanCalendarType = null, \StructType\DemandPlanMatrix $demandPlanMatrix = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCustomForm($customForm)
            ->setSubsidiary($subsidiary)
            ->setLocation($location)
            ->setItem($item)
            ->setUnits($units)
            ->setMemo($memo)
            ->setYear($year)
            ->setMonth($month)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setDemandPlanCalendarType($demandPlanCalendarType)
            ->setDemandPlanMatrix($demandPlanMatrix)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\ItemDemandPlan
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\RecordRef $subsidiary
     * @return \StructType\ItemDemandPlan
     */
    public function setSubsidiary(\StructType\RecordRef $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\ItemDemandPlan
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get item value
     * @return \StructType\RecordRef|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\ItemDemandPlan
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get units value
     * @return \StructType\RecordRef|null
     */
    public function getUnits()
    {
        return $this->units;
    }
    /**
     * Set units value
     * @param \StructType\RecordRef $units
     * @return \StructType\ItemDemandPlan
     */
    public function setUnits(\StructType\RecordRef $units = null)
    {
        $this->units = $units;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\ItemDemandPlan
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get year value
     * @return int|null
     */
    public function getYear()
    {
        return $this->year;
    }
    /**
     * Set year value
     * @param int $year
     * @return \StructType\ItemDemandPlan
     */
    public function setYear($year = null)
    {
        // validation for constraint: int
        if (!is_null($year) && !(is_int($year) || ctype_digit($year))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($year, true), gettype($year)), __LINE__);
        }
        $this->year = $year;
        return $this;
    }
    /**
     * Get month value
     * @return string|null
     */
    public function getMonth()
    {
        return $this->month;
    }
    /**
     * Set month value
     * @uses \EnumType\DemandPlanMonth::valueIsValid()
     * @uses \EnumType\DemandPlanMonth::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $month
     * @return \StructType\ItemDemandPlan
     */
    public function setMonth($month = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DemandPlanMonth::valueIsValid($month)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DemandPlanMonth', is_array($month) ? implode(', ', $month) : var_export($month, true), implode(', ', \EnumType\DemandPlanMonth::getValidValues())), __LINE__);
        }
        $this->month = $month;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\ItemDemandPlan
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\ItemDemandPlan
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get demandPlanCalendarType value
     * @return string|null
     */
    public function getDemandPlanCalendarType()
    {
        return $this->demandPlanCalendarType;
    }
    /**
     * Set demandPlanCalendarType value
     * @uses \EnumType\DemandPlanCalendarType::valueIsValid()
     * @uses \EnumType\DemandPlanCalendarType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $demandPlanCalendarType
     * @return \StructType\ItemDemandPlan
     */
    public function setDemandPlanCalendarType($demandPlanCalendarType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DemandPlanCalendarType::valueIsValid($demandPlanCalendarType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DemandPlanCalendarType', is_array($demandPlanCalendarType) ? implode(', ', $demandPlanCalendarType) : var_export($demandPlanCalendarType, true), implode(', ', \EnumType\DemandPlanCalendarType::getValidValues())), __LINE__);
        }
        $this->demandPlanCalendarType = $demandPlanCalendarType;
        return $this;
    }
    /**
     * Get demandPlanMatrix value
     * @return \StructType\DemandPlanMatrix|null
     */
    public function getDemandPlanMatrix()
    {
        return $this->demandPlanMatrix;
    }
    /**
     * Set demandPlanMatrix value
     * @param \StructType\DemandPlanMatrix $demandPlanMatrix
     * @return \StructType\ItemDemandPlan
     */
    public function setDemandPlanMatrix(\StructType\DemandPlanMatrix $demandPlanMatrix = null)
    {
        $this->demandPlanMatrix = $demandPlanMatrix;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\ItemDemandPlan
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\ItemDemandPlan
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\ItemDemandPlan
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
