<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemAccountMapping StructType
 * @subpackage Structs
 */
class ItemAccountMapping extends Record
{
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The effectiveDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $effectiveDate;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * The accountingBook
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $accountingBook;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiary;
    /**
     * The itemAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemAccount;
    /**
     * The sourceAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $sourceAccount;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The destinationAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $destinationAccount;
    /**
     * The customDimension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BaseRef
     */
    public $customDimension;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for ItemAccountMapping
     * @uses ItemAccountMapping::setCustomForm()
     * @uses ItemAccountMapping::setEffectiveDate()
     * @uses ItemAccountMapping::setEndDate()
     * @uses ItemAccountMapping::setAccountingBook()
     * @uses ItemAccountMapping::setSubsidiary()
     * @uses ItemAccountMapping::setItemAccount()
     * @uses ItemAccountMapping::setSourceAccount()
     * @uses ItemAccountMapping::setClass()
     * @uses ItemAccountMapping::setDepartment()
     * @uses ItemAccountMapping::setLocation()
     * @uses ItemAccountMapping::setDestinationAccount()
     * @uses ItemAccountMapping::setCustomDimension()
     * @uses ItemAccountMapping::setCustomFieldList()
     * @uses ItemAccountMapping::setInternalId()
     * @uses ItemAccountMapping::setExternalId()
     * @param \StructType\RecordRef $customForm
     * @param string $effectiveDate
     * @param string $endDate
     * @param \StructType\RecordRef $accountingBook
     * @param \StructType\RecordRef $subsidiary
     * @param string $itemAccount
     * @param \StructType\RecordRef $sourceAccount
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRef $destinationAccount
     * @param \StructType\BaseRef $customDimension
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct(\StructType\RecordRef $customForm = null, $effectiveDate = null, $endDate = null, \StructType\RecordRef $accountingBook = null, \StructType\RecordRef $subsidiary = null, $itemAccount = null, \StructType\RecordRef $sourceAccount = null, \StructType\RecordRef $class = null, \StructType\RecordRef $department = null, \StructType\RecordRef $location = null, \StructType\RecordRef $destinationAccount = null, \StructType\BaseRef $customDimension = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCustomForm($customForm)
            ->setEffectiveDate($effectiveDate)
            ->setEndDate($endDate)
            ->setAccountingBook($accountingBook)
            ->setSubsidiary($subsidiary)
            ->setItemAccount($itemAccount)
            ->setSourceAccount($sourceAccount)
            ->setClass($class)
            ->setDepartment($department)
            ->setLocation($location)
            ->setDestinationAccount($destinationAccount)
            ->setCustomDimension($customDimension)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\ItemAccountMapping
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get effectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->effectiveDate;
    }
    /**
     * Set effectiveDate value
     * @param string $effectiveDate
     * @return \StructType\ItemAccountMapping
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->effectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\ItemAccountMapping
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get accountingBook value
     * @return \StructType\RecordRef|null
     */
    public function getAccountingBook()
    {
        return $this->accountingBook;
    }
    /**
     * Set accountingBook value
     * @param \StructType\RecordRef $accountingBook
     * @return \StructType\ItemAccountMapping
     */
    public function setAccountingBook(\StructType\RecordRef $accountingBook = null)
    {
        $this->accountingBook = $accountingBook;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\RecordRef $subsidiary
     * @return \StructType\ItemAccountMapping
     */
    public function setSubsidiary(\StructType\RecordRef $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get itemAccount value
     * @return string|null
     */
    public function getItemAccount()
    {
        return $this->itemAccount;
    }
    /**
     * Set itemAccount value
     * @uses \EnumType\ItemAccountMappingItemAccount::valueIsValid()
     * @uses \EnumType\ItemAccountMappingItemAccount::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $itemAccount
     * @return \StructType\ItemAccountMapping
     */
    public function setItemAccount($itemAccount = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemAccountMappingItemAccount::valueIsValid($itemAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemAccountMappingItemAccount', is_array($itemAccount) ? implode(', ', $itemAccount) : var_export($itemAccount, true), implode(', ', \EnumType\ItemAccountMappingItemAccount::getValidValues())), __LINE__);
        }
        $this->itemAccount = $itemAccount;
        return $this;
    }
    /**
     * Get sourceAccount value
     * @return \StructType\RecordRef|null
     */
    public function getSourceAccount()
    {
        return $this->sourceAccount;
    }
    /**
     * Set sourceAccount value
     * @param \StructType\RecordRef $sourceAccount
     * @return \StructType\ItemAccountMapping
     */
    public function setSourceAccount(\StructType\RecordRef $sourceAccount = null)
    {
        $this->sourceAccount = $sourceAccount;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\ItemAccountMapping
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\ItemAccountMapping
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\ItemAccountMapping
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get destinationAccount value
     * @return \StructType\RecordRef|null
     */
    public function getDestinationAccount()
    {
        return $this->destinationAccount;
    }
    /**
     * Set destinationAccount value
     * @param \StructType\RecordRef $destinationAccount
     * @return \StructType\ItemAccountMapping
     */
    public function setDestinationAccount(\StructType\RecordRef $destinationAccount = null)
    {
        $this->destinationAccount = $destinationAccount;
        return $this;
    }
    /**
     * Get customDimension value
     * @return \StructType\BaseRef|null
     */
    public function getCustomDimension()
    {
        return $this->customDimension;
    }
    /**
     * Set customDimension value
     * @param \StructType\BaseRef $customDimension
     * @return \StructType\ItemAccountMapping
     */
    public function setCustomDimension(\StructType\BaseRef $customDimension = null)
    {
        $this->customDimension = $customDimension;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\ItemAccountMapping
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\ItemAccountMapping
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\ItemAccountMapping
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
