<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IssueVersionList StructType
 * @subpackage Structs
 */
class IssueVersionList extends AbstractStructBase
{
    /**
     * The issueVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\IssueVersion[]
     */
    public $issueVersion;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for IssueVersionList
     * @uses IssueVersionList::setIssueVersion()
     * @uses IssueVersionList::setReplaceAll()
     * @param \StructType\IssueVersion[] $issueVersion
     * @param bool $replaceAll
     */
    public function __construct(array $issueVersion = array(), $replaceAll = true)
    {
        $this
            ->setIssueVersion($issueVersion)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get issueVersion value
     * @return \StructType\IssueVersion[]|null
     */
    public function getIssueVersion()
    {
        return $this->issueVersion;
    }
    /**
     * This method is responsible for validating the values passed to the setIssueVersion method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIssueVersion method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIssueVersionForArrayConstraintsFromSetIssueVersion(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $issueVersionListIssueVersionItem) {
            // validation for constraint: itemType
            if (!$issueVersionListIssueVersionItem instanceof \StructType\IssueVersion) {
                $invalidValues[] = is_object($issueVersionListIssueVersionItem) ? get_class($issueVersionListIssueVersionItem) : sprintf('%s(%s)', gettype($issueVersionListIssueVersionItem), var_export($issueVersionListIssueVersionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The issueVersion property can only contain items of type \StructType\IssueVersion, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set issueVersion value
     * @throws \InvalidArgumentException
     * @param \StructType\IssueVersion[] $issueVersion
     * @return \StructType\IssueVersionList
     */
    public function setIssueVersion(array $issueVersion = array())
    {
        // validation for constraint: array
        if ('' !== ($issueVersionArrayErrorMessage = self::validateIssueVersionForArrayConstraintsFromSetIssueVersion($issueVersion))) {
            throw new \InvalidArgumentException($issueVersionArrayErrorMessage, __LINE__);
        }
        $this->issueVersion = $issueVersion;
        return $this;
    }
    /**
     * Add item to issueVersion value
     * @throws \InvalidArgumentException
     * @param \StructType\IssueVersion $item
     * @return \StructType\IssueVersionList
     */
    public function addToIssueVersion(\StructType\IssueVersion $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\IssueVersion) {
            throw new \InvalidArgumentException(sprintf('The issueVersion property can only contain items of type \StructType\IssueVersion, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->issueVersion[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\IssueVersionList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
