<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IssueSearch StructType
 * @subpackage Structs
 */
class IssueSearch extends SearchRecord
{
    /**
     * The basic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\IssueSearchBasic
     */
    public $basic;
    /**
     * The caseJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SupportCaseSearchBasic
     */
    public $caseJoin;
    /**
     * The employeeJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmployeeSearchBasic
     */
    public $employeeJoin;
    /**
     * The fileJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FileSearchBasic
     */
    public $fileJoin;
    /**
     * The productTeamJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EntityGroupSearchBasic
     */
    public $productTeamJoin;
    /**
     * The userJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmployeeSearchBasic
     */
    public $userJoin;
    /**
     * The userNotesJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NoteSearchBasic
     */
    public $userNotesJoin;
    /**
     * The customSearchJoin
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomSearchJoin[]
     */
    public $customSearchJoin;
    /**
     * Constructor method for IssueSearch
     * @uses IssueSearch::setBasic()
     * @uses IssueSearch::setCaseJoin()
     * @uses IssueSearch::setEmployeeJoin()
     * @uses IssueSearch::setFileJoin()
     * @uses IssueSearch::setProductTeamJoin()
     * @uses IssueSearch::setUserJoin()
     * @uses IssueSearch::setUserNotesJoin()
     * @uses IssueSearch::setCustomSearchJoin()
     * @param \StructType\IssueSearchBasic $basic
     * @param \StructType\SupportCaseSearchBasic $caseJoin
     * @param \StructType\EmployeeSearchBasic $employeeJoin
     * @param \StructType\FileSearchBasic $fileJoin
     * @param \StructType\EntityGroupSearchBasic $productTeamJoin
     * @param \StructType\EmployeeSearchBasic $userJoin
     * @param \StructType\NoteSearchBasic $userNotesJoin
     * @param \StructType\CustomSearchJoin[] $customSearchJoin
     */
    public function __construct(\StructType\IssueSearchBasic $basic = null, \StructType\SupportCaseSearchBasic $caseJoin = null, \StructType\EmployeeSearchBasic $employeeJoin = null, \StructType\FileSearchBasic $fileJoin = null, \StructType\EntityGroupSearchBasic $productTeamJoin = null, \StructType\EmployeeSearchBasic $userJoin = null, \StructType\NoteSearchBasic $userNotesJoin = null, array $customSearchJoin = array())
    {
        $this
            ->setBasic($basic)
            ->setCaseJoin($caseJoin)
            ->setEmployeeJoin($employeeJoin)
            ->setFileJoin($fileJoin)
            ->setProductTeamJoin($productTeamJoin)
            ->setUserJoin($userJoin)
            ->setUserNotesJoin($userNotesJoin)
            ->setCustomSearchJoin($customSearchJoin);
    }
    /**
     * Get basic value
     * @return \StructType\IssueSearchBasic|null
     */
    public function getBasic()
    {
        return $this->basic;
    }
    /**
     * Set basic value
     * @param \StructType\IssueSearchBasic $basic
     * @return \StructType\IssueSearch
     */
    public function setBasic(\StructType\IssueSearchBasic $basic = null)
    {
        $this->basic = $basic;
        return $this;
    }
    /**
     * Get caseJoin value
     * @return \StructType\SupportCaseSearchBasic|null
     */
    public function getCaseJoin()
    {
        return $this->caseJoin;
    }
    /**
     * Set caseJoin value
     * @param \StructType\SupportCaseSearchBasic $caseJoin
     * @return \StructType\IssueSearch
     */
    public function setCaseJoin(\StructType\SupportCaseSearchBasic $caseJoin = null)
    {
        $this->caseJoin = $caseJoin;
        return $this;
    }
    /**
     * Get employeeJoin value
     * @return \StructType\EmployeeSearchBasic|null
     */
    public function getEmployeeJoin()
    {
        return $this->employeeJoin;
    }
    /**
     * Set employeeJoin value
     * @param \StructType\EmployeeSearchBasic $employeeJoin
     * @return \StructType\IssueSearch
     */
    public function setEmployeeJoin(\StructType\EmployeeSearchBasic $employeeJoin = null)
    {
        $this->employeeJoin = $employeeJoin;
        return $this;
    }
    /**
     * Get fileJoin value
     * @return \StructType\FileSearchBasic|null
     */
    public function getFileJoin()
    {
        return $this->fileJoin;
    }
    /**
     * Set fileJoin value
     * @param \StructType\FileSearchBasic $fileJoin
     * @return \StructType\IssueSearch
     */
    public function setFileJoin(\StructType\FileSearchBasic $fileJoin = null)
    {
        $this->fileJoin = $fileJoin;
        return $this;
    }
    /**
     * Get productTeamJoin value
     * @return \StructType\EntityGroupSearchBasic|null
     */
    public function getProductTeamJoin()
    {
        return $this->productTeamJoin;
    }
    /**
     * Set productTeamJoin value
     * @param \StructType\EntityGroupSearchBasic $productTeamJoin
     * @return \StructType\IssueSearch
     */
    public function setProductTeamJoin(\StructType\EntityGroupSearchBasic $productTeamJoin = null)
    {
        $this->productTeamJoin = $productTeamJoin;
        return $this;
    }
    /**
     * Get userJoin value
     * @return \StructType\EmployeeSearchBasic|null
     */
    public function getUserJoin()
    {
        return $this->userJoin;
    }
    /**
     * Set userJoin value
     * @param \StructType\EmployeeSearchBasic $userJoin
     * @return \StructType\IssueSearch
     */
    public function setUserJoin(\StructType\EmployeeSearchBasic $userJoin = null)
    {
        $this->userJoin = $userJoin;
        return $this;
    }
    /**
     * Get userNotesJoin value
     * @return \StructType\NoteSearchBasic|null
     */
    public function getUserNotesJoin()
    {
        return $this->userNotesJoin;
    }
    /**
     * Set userNotesJoin value
     * @param \StructType\NoteSearchBasic $userNotesJoin
     * @return \StructType\IssueSearch
     */
    public function setUserNotesJoin(\StructType\NoteSearchBasic $userNotesJoin = null)
    {
        $this->userNotesJoin = $userNotesJoin;
        return $this;
    }
    /**
     * Get customSearchJoin value
     * @return \StructType\CustomSearchJoin[]|null
     */
    public function getCustomSearchJoin()
    {
        return $this->customSearchJoin;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomSearchJoin method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomSearchJoin method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $issueSearchCustomSearchJoinItem) {
            // validation for constraint: itemType
            if (!$issueSearchCustomSearchJoinItem instanceof \StructType\CustomSearchJoin) {
                $invalidValues[] = is_object($issueSearchCustomSearchJoinItem) ? get_class($issueSearchCustomSearchJoinItem) : sprintf('%s(%s)', gettype($issueSearchCustomSearchJoinItem), var_export($issueSearchCustomSearchJoinItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchJoin, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchJoin[] $customSearchJoin
     * @return \StructType\IssueSearch
     */
    public function setCustomSearchJoin(array $customSearchJoin = array())
    {
        // validation for constraint: array
        if ('' !== ($customSearchJoinArrayErrorMessage = self::validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin($customSearchJoin))) {
            throw new \InvalidArgumentException($customSearchJoinArrayErrorMessage, __LINE__);
        }
        $this->customSearchJoin = $customSearchJoin;
        return $this;
    }
    /**
     * Add item to customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchJoin $item
     * @return \StructType\IssueSearch
     */
    public function addToCustomSearchJoin(\StructType\CustomSearchJoin $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomSearchJoin) {
            throw new \InvalidArgumentException(sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchJoin, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customSearchJoin[] = $item;
        return $this;
    }
}
