<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Issue StructType
 * Meta information extracted from the WSDL
 * - type: listSupport:Issue
 * @subpackage Structs
 */
class Issue extends Record
{
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The issueNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $issueNumber;
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The issueType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $issueType;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $product;
    /**
     * The module
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $module;
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The productTeam
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $productTeam;
    /**
     * The source
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $source;
    /**
     * The reportedBy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $reportedBy;
    /**
     * The reproduce
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $reproduce;
    /**
     * The versionBroken
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $versionBroken;
    /**
     * The buildBroken
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $buildBroken;
    /**
     * The versionTarget
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $versionTarget;
    /**
     * The buildTarget
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $buildTarget;
    /**
     * The versionFixed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $versionFixed;
    /**
     * The buildFixed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $buildFixed;
    /**
     * The severity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $severity;
    /**
     * The priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $priority;
    /**
     * The isShowStopper
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isShowStopper;
    /**
     * The assigned
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $assigned;
    /**
     * The reviewer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $reviewer;
    /**
     * The isReviewed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isReviewed;
    /**
     * The issueStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $issueStatus;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The issueTagsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRefList
     */
    public $issueTagsList;
    /**
     * The issueAbstract
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $issueAbstract;
    /**
     * The newDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $newDetails;
    /**
     * The isOwner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isOwner;
    /**
     * The trackCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $trackCode;
    /**
     * The emailAssignee
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $emailAssignee;
    /**
     * The emailEmployeesList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmailEmployeesList
     */
    public $emailEmployeesList;
    /**
     * The emailCellsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRefList
     */
    public $emailCellsList;
    /**
     * The externalAbstract
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $externalAbstract;
    /**
     * The externalDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $externalDetails;
    /**
     * The brokenInVersionList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\IssueVersionList
     */
    public $brokenInVersionList;
    /**
     * The targetVersionList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\IssueVersionList
     */
    public $targetVersionList;
    /**
     * The fixedInVersionList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\IssueVersionList
     */
    public $fixedInVersionList;
    /**
     * The relatedIssuesList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\IssueRelatedIssuesList
     */
    public $relatedIssuesList;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for Issue
     * @uses Issue::setCustomForm()
     * @uses Issue::setIssueNumber()
     * @uses Issue::setCreatedDate()
     * @uses Issue::setIssueType()
     * @uses Issue::setProduct()
     * @uses Issue::setModule()
     * @uses Issue::setItem()
     * @uses Issue::setProductTeam()
     * @uses Issue::setSource()
     * @uses Issue::setReportedBy()
     * @uses Issue::setReproduce()
     * @uses Issue::setVersionBroken()
     * @uses Issue::setBuildBroken()
     * @uses Issue::setVersionTarget()
     * @uses Issue::setBuildTarget()
     * @uses Issue::setVersionFixed()
     * @uses Issue::setBuildFixed()
     * @uses Issue::setSeverity()
     * @uses Issue::setPriority()
     * @uses Issue::setIsShowStopper()
     * @uses Issue::setAssigned()
     * @uses Issue::setReviewer()
     * @uses Issue::setIsReviewed()
     * @uses Issue::setIssueStatus()
     * @uses Issue::setLastModifiedDate()
     * @uses Issue::setIssueTagsList()
     * @uses Issue::setIssueAbstract()
     * @uses Issue::setNewDetails()
     * @uses Issue::setIsOwner()
     * @uses Issue::setTrackCode()
     * @uses Issue::setEmailAssignee()
     * @uses Issue::setEmailEmployeesList()
     * @uses Issue::setEmailCellsList()
     * @uses Issue::setExternalAbstract()
     * @uses Issue::setExternalDetails()
     * @uses Issue::setBrokenInVersionList()
     * @uses Issue::setTargetVersionList()
     * @uses Issue::setFixedInVersionList()
     * @uses Issue::setRelatedIssuesList()
     * @uses Issue::setCustomFieldList()
     * @uses Issue::setInternalId()
     * @uses Issue::setExternalId()
     * @param \StructType\RecordRef $customForm
     * @param string $issueNumber
     * @param string $createdDate
     * @param \StructType\RecordRef $issueType
     * @param \StructType\RecordRef $product
     * @param \StructType\RecordRef $module
     * @param \StructType\RecordRef $item
     * @param \StructType\RecordRef $productTeam
     * @param \StructType\RecordRef $source
     * @param \StructType\RecordRef $reportedBy
     * @param \StructType\RecordRef $reproduce
     * @param \StructType\RecordRef $versionBroken
     * @param \StructType\RecordRef $buildBroken
     * @param \StructType\RecordRef $versionTarget
     * @param \StructType\RecordRef $buildTarget
     * @param \StructType\RecordRef $versionFixed
     * @param \StructType\RecordRef $buildFixed
     * @param \StructType\RecordRef $severity
     * @param \StructType\RecordRef $priority
     * @param bool $isShowStopper
     * @param \StructType\RecordRef $assigned
     * @param \StructType\RecordRef $reviewer
     * @param bool $isReviewed
     * @param \StructType\RecordRef $issueStatus
     * @param string $lastModifiedDate
     * @param \StructType\RecordRefList $issueTagsList
     * @param string $issueAbstract
     * @param string $newDetails
     * @param bool $isOwner
     * @param string $trackCode
     * @param bool $emailAssignee
     * @param \StructType\EmailEmployeesList $emailEmployeesList
     * @param \StructType\RecordRefList $emailCellsList
     * @param string $externalAbstract
     * @param string $externalDetails
     * @param \StructType\IssueVersionList $brokenInVersionList
     * @param \StructType\IssueVersionList $targetVersionList
     * @param \StructType\IssueVersionList $fixedInVersionList
     * @param \StructType\IssueRelatedIssuesList $relatedIssuesList
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct(\StructType\RecordRef $customForm = null, $issueNumber = null, $createdDate = null, \StructType\RecordRef $issueType = null, \StructType\RecordRef $product = null, \StructType\RecordRef $module = null, \StructType\RecordRef $item = null, \StructType\RecordRef $productTeam = null, \StructType\RecordRef $source = null, \StructType\RecordRef $reportedBy = null, \StructType\RecordRef $reproduce = null, \StructType\RecordRef $versionBroken = null, \StructType\RecordRef $buildBroken = null, \StructType\RecordRef $versionTarget = null, \StructType\RecordRef $buildTarget = null, \StructType\RecordRef $versionFixed = null, \StructType\RecordRef $buildFixed = null, \StructType\RecordRef $severity = null, \StructType\RecordRef $priority = null, $isShowStopper = null, \StructType\RecordRef $assigned = null, \StructType\RecordRef $reviewer = null, $isReviewed = null, \StructType\RecordRef $issueStatus = null, $lastModifiedDate = null, \StructType\RecordRefList $issueTagsList = null, $issueAbstract = null, $newDetails = null, $isOwner = null, $trackCode = null, $emailAssignee = null, \StructType\EmailEmployeesList $emailEmployeesList = null, \StructType\RecordRefList $emailCellsList = null, $externalAbstract = null, $externalDetails = null, \StructType\IssueVersionList $brokenInVersionList = null, \StructType\IssueVersionList $targetVersionList = null, \StructType\IssueVersionList $fixedInVersionList = null, \StructType\IssueRelatedIssuesList $relatedIssuesList = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCustomForm($customForm)
            ->setIssueNumber($issueNumber)
            ->setCreatedDate($createdDate)
            ->setIssueType($issueType)
            ->setProduct($product)
            ->setModule($module)
            ->setItem($item)
            ->setProductTeam($productTeam)
            ->setSource($source)
            ->setReportedBy($reportedBy)
            ->setReproduce($reproduce)
            ->setVersionBroken($versionBroken)
            ->setBuildBroken($buildBroken)
            ->setVersionTarget($versionTarget)
            ->setBuildTarget($buildTarget)
            ->setVersionFixed($versionFixed)
            ->setBuildFixed($buildFixed)
            ->setSeverity($severity)
            ->setPriority($priority)
            ->setIsShowStopper($isShowStopper)
            ->setAssigned($assigned)
            ->setReviewer($reviewer)
            ->setIsReviewed($isReviewed)
            ->setIssueStatus($issueStatus)
            ->setLastModifiedDate($lastModifiedDate)
            ->setIssueTagsList($issueTagsList)
            ->setIssueAbstract($issueAbstract)
            ->setNewDetails($newDetails)
            ->setIsOwner($isOwner)
            ->setTrackCode($trackCode)
            ->setEmailAssignee($emailAssignee)
            ->setEmailEmployeesList($emailEmployeesList)
            ->setEmailCellsList($emailCellsList)
            ->setExternalAbstract($externalAbstract)
            ->setExternalDetails($externalDetails)
            ->setBrokenInVersionList($brokenInVersionList)
            ->setTargetVersionList($targetVersionList)
            ->setFixedInVersionList($fixedInVersionList)
            ->setRelatedIssuesList($relatedIssuesList)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\Issue
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get issueNumber value
     * @return string|null
     */
    public function getIssueNumber()
    {
        return $this->issueNumber;
    }
    /**
     * Set issueNumber value
     * @param string $issueNumber
     * @return \StructType\Issue
     */
    public function setIssueNumber($issueNumber = null)
    {
        // validation for constraint: string
        if (!is_null($issueNumber) && !is_string($issueNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueNumber, true), gettype($issueNumber)), __LINE__);
        }
        $this->issueNumber = $issueNumber;
        return $this;
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\Issue
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get issueType value
     * @return \StructType\RecordRef|null
     */
    public function getIssueType()
    {
        return $this->issueType;
    }
    /**
     * Set issueType value
     * @param \StructType\RecordRef $issueType
     * @return \StructType\Issue
     */
    public function setIssueType(\StructType\RecordRef $issueType = null)
    {
        $this->issueType = $issueType;
        return $this;
    }
    /**
     * Get product value
     * @return \StructType\RecordRef|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param \StructType\RecordRef $product
     * @return \StructType\Issue
     */
    public function setProduct(\StructType\RecordRef $product = null)
    {
        $this->product = $product;
        return $this;
    }
    /**
     * Get module value
     * @return \StructType\RecordRef|null
     */
    public function getModule()
    {
        return $this->module;
    }
    /**
     * Set module value
     * @param \StructType\RecordRef $module
     * @return \StructType\Issue
     */
    public function setModule(\StructType\RecordRef $module = null)
    {
        $this->module = $module;
        return $this;
    }
    /**
     * Get item value
     * @return \StructType\RecordRef|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\Issue
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get productTeam value
     * @return \StructType\RecordRef|null
     */
    public function getProductTeam()
    {
        return $this->productTeam;
    }
    /**
     * Set productTeam value
     * @param \StructType\RecordRef $productTeam
     * @return \StructType\Issue
     */
    public function setProductTeam(\StructType\RecordRef $productTeam = null)
    {
        $this->productTeam = $productTeam;
        return $this;
    }
    /**
     * Get source value
     * @return \StructType\RecordRef|null
     */
    public function getSource()
    {
        return $this->source;
    }
    /**
     * Set source value
     * @param \StructType\RecordRef $source
     * @return \StructType\Issue
     */
    public function setSource(\StructType\RecordRef $source = null)
    {
        $this->source = $source;
        return $this;
    }
    /**
     * Get reportedBy value
     * @return \StructType\RecordRef|null
     */
    public function getReportedBy()
    {
        return $this->reportedBy;
    }
    /**
     * Set reportedBy value
     * @param \StructType\RecordRef $reportedBy
     * @return \StructType\Issue
     */
    public function setReportedBy(\StructType\RecordRef $reportedBy = null)
    {
        $this->reportedBy = $reportedBy;
        return $this;
    }
    /**
     * Get reproduce value
     * @return \StructType\RecordRef|null
     */
    public function getReproduce()
    {
        return $this->reproduce;
    }
    /**
     * Set reproduce value
     * @param \StructType\RecordRef $reproduce
     * @return \StructType\Issue
     */
    public function setReproduce(\StructType\RecordRef $reproduce = null)
    {
        $this->reproduce = $reproduce;
        return $this;
    }
    /**
     * Get versionBroken value
     * @return \StructType\RecordRef|null
     */
    public function getVersionBroken()
    {
        return $this->versionBroken;
    }
    /**
     * Set versionBroken value
     * @param \StructType\RecordRef $versionBroken
     * @return \StructType\Issue
     */
    public function setVersionBroken(\StructType\RecordRef $versionBroken = null)
    {
        $this->versionBroken = $versionBroken;
        return $this;
    }
    /**
     * Get buildBroken value
     * @return \StructType\RecordRef|null
     */
    public function getBuildBroken()
    {
        return $this->buildBroken;
    }
    /**
     * Set buildBroken value
     * @param \StructType\RecordRef $buildBroken
     * @return \StructType\Issue
     */
    public function setBuildBroken(\StructType\RecordRef $buildBroken = null)
    {
        $this->buildBroken = $buildBroken;
        return $this;
    }
    /**
     * Get versionTarget value
     * @return \StructType\RecordRef|null
     */
    public function getVersionTarget()
    {
        return $this->versionTarget;
    }
    /**
     * Set versionTarget value
     * @param \StructType\RecordRef $versionTarget
     * @return \StructType\Issue
     */
    public function setVersionTarget(\StructType\RecordRef $versionTarget = null)
    {
        $this->versionTarget = $versionTarget;
        return $this;
    }
    /**
     * Get buildTarget value
     * @return \StructType\RecordRef|null
     */
    public function getBuildTarget()
    {
        return $this->buildTarget;
    }
    /**
     * Set buildTarget value
     * @param \StructType\RecordRef $buildTarget
     * @return \StructType\Issue
     */
    public function setBuildTarget(\StructType\RecordRef $buildTarget = null)
    {
        $this->buildTarget = $buildTarget;
        return $this;
    }
    /**
     * Get versionFixed value
     * @return \StructType\RecordRef|null
     */
    public function getVersionFixed()
    {
        return $this->versionFixed;
    }
    /**
     * Set versionFixed value
     * @param \StructType\RecordRef $versionFixed
     * @return \StructType\Issue
     */
    public function setVersionFixed(\StructType\RecordRef $versionFixed = null)
    {
        $this->versionFixed = $versionFixed;
        return $this;
    }
    /**
     * Get buildFixed value
     * @return \StructType\RecordRef|null
     */
    public function getBuildFixed()
    {
        return $this->buildFixed;
    }
    /**
     * Set buildFixed value
     * @param \StructType\RecordRef $buildFixed
     * @return \StructType\Issue
     */
    public function setBuildFixed(\StructType\RecordRef $buildFixed = null)
    {
        $this->buildFixed = $buildFixed;
        return $this;
    }
    /**
     * Get severity value
     * @return \StructType\RecordRef|null
     */
    public function getSeverity()
    {
        return $this->severity;
    }
    /**
     * Set severity value
     * @param \StructType\RecordRef $severity
     * @return \StructType\Issue
     */
    public function setSeverity(\StructType\RecordRef $severity = null)
    {
        $this->severity = $severity;
        return $this;
    }
    /**
     * Get priority value
     * @return \StructType\RecordRef|null
     */
    public function getPriority()
    {
        return $this->priority;
    }
    /**
     * Set priority value
     * @param \StructType\RecordRef $priority
     * @return \StructType\Issue
     */
    public function setPriority(\StructType\RecordRef $priority = null)
    {
        $this->priority = $priority;
        return $this;
    }
    /**
     * Get isShowStopper value
     * @return bool|null
     */
    public function getIsShowStopper()
    {
        return $this->isShowStopper;
    }
    /**
     * Set isShowStopper value
     * @param bool $isShowStopper
     * @return \StructType\Issue
     */
    public function setIsShowStopper($isShowStopper = null)
    {
        // validation for constraint: boolean
        if (!is_null($isShowStopper) && !is_bool($isShowStopper)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isShowStopper, true), gettype($isShowStopper)), __LINE__);
        }
        $this->isShowStopper = $isShowStopper;
        return $this;
    }
    /**
     * Get assigned value
     * @return \StructType\RecordRef|null
     */
    public function getAssigned()
    {
        return $this->assigned;
    }
    /**
     * Set assigned value
     * @param \StructType\RecordRef $assigned
     * @return \StructType\Issue
     */
    public function setAssigned(\StructType\RecordRef $assigned = null)
    {
        $this->assigned = $assigned;
        return $this;
    }
    /**
     * Get reviewer value
     * @return \StructType\RecordRef|null
     */
    public function getReviewer()
    {
        return $this->reviewer;
    }
    /**
     * Set reviewer value
     * @param \StructType\RecordRef $reviewer
     * @return \StructType\Issue
     */
    public function setReviewer(\StructType\RecordRef $reviewer = null)
    {
        $this->reviewer = $reviewer;
        return $this;
    }
    /**
     * Get isReviewed value
     * @return bool|null
     */
    public function getIsReviewed()
    {
        return $this->isReviewed;
    }
    /**
     * Set isReviewed value
     * @param bool $isReviewed
     * @return \StructType\Issue
     */
    public function setIsReviewed($isReviewed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReviewed) && !is_bool($isReviewed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReviewed, true), gettype($isReviewed)), __LINE__);
        }
        $this->isReviewed = $isReviewed;
        return $this;
    }
    /**
     * Get issueStatus value
     * @return \StructType\RecordRef|null
     */
    public function getIssueStatus()
    {
        return $this->issueStatus;
    }
    /**
     * Set issueStatus value
     * @param \StructType\RecordRef $issueStatus
     * @return \StructType\Issue
     */
    public function setIssueStatus(\StructType\RecordRef $issueStatus = null)
    {
        $this->issueStatus = $issueStatus;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\Issue
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get issueTagsList value
     * @return \StructType\RecordRefList|null
     */
    public function getIssueTagsList()
    {
        return $this->issueTagsList;
    }
    /**
     * Set issueTagsList value
     * @param \StructType\RecordRefList $issueTagsList
     * @return \StructType\Issue
     */
    public function setIssueTagsList(\StructType\RecordRefList $issueTagsList = null)
    {
        $this->issueTagsList = $issueTagsList;
        return $this;
    }
    /**
     * Get issueAbstract value
     * @return string|null
     */
    public function getIssueAbstract()
    {
        return $this->issueAbstract;
    }
    /**
     * Set issueAbstract value
     * @param string $issueAbstract
     * @return \StructType\Issue
     */
    public function setIssueAbstract($issueAbstract = null)
    {
        // validation for constraint: string
        if (!is_null($issueAbstract) && !is_string($issueAbstract)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueAbstract, true), gettype($issueAbstract)), __LINE__);
        }
        $this->issueAbstract = $issueAbstract;
        return $this;
    }
    /**
     * Get newDetails value
     * @return string|null
     */
    public function getNewDetails()
    {
        return $this->newDetails;
    }
    /**
     * Set newDetails value
     * @param string $newDetails
     * @return \StructType\Issue
     */
    public function setNewDetails($newDetails = null)
    {
        // validation for constraint: string
        if (!is_null($newDetails) && !is_string($newDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newDetails, true), gettype($newDetails)), __LINE__);
        }
        $this->newDetails = $newDetails;
        return $this;
    }
    /**
     * Get isOwner value
     * @return bool|null
     */
    public function getIsOwner()
    {
        return $this->isOwner;
    }
    /**
     * Set isOwner value
     * @param bool $isOwner
     * @return \StructType\Issue
     */
    public function setIsOwner($isOwner = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOwner) && !is_bool($isOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOwner, true), gettype($isOwner)), __LINE__);
        }
        $this->isOwner = $isOwner;
        return $this;
    }
    /**
     * Get trackCode value
     * @return string|null
     */
    public function getTrackCode()
    {
        return $this->trackCode;
    }
    /**
     * Set trackCode value
     * @uses \EnumType\IssueTrackCode::valueIsValid()
     * @uses \EnumType\IssueTrackCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trackCode
     * @return \StructType\Issue
     */
    public function setTrackCode($trackCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IssueTrackCode::valueIsValid($trackCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\IssueTrackCode', is_array($trackCode) ? implode(', ', $trackCode) : var_export($trackCode, true), implode(', ', \EnumType\IssueTrackCode::getValidValues())), __LINE__);
        }
        $this->trackCode = $trackCode;
        return $this;
    }
    /**
     * Get emailAssignee value
     * @return bool|null
     */
    public function getEmailAssignee()
    {
        return $this->emailAssignee;
    }
    /**
     * Set emailAssignee value
     * @param bool $emailAssignee
     * @return \StructType\Issue
     */
    public function setEmailAssignee($emailAssignee = null)
    {
        // validation for constraint: boolean
        if (!is_null($emailAssignee) && !is_bool($emailAssignee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($emailAssignee, true), gettype($emailAssignee)), __LINE__);
        }
        $this->emailAssignee = $emailAssignee;
        return $this;
    }
    /**
     * Get emailEmployeesList value
     * @return \StructType\EmailEmployeesList|null
     */
    public function getEmailEmployeesList()
    {
        return $this->emailEmployeesList;
    }
    /**
     * Set emailEmployeesList value
     * @param \StructType\EmailEmployeesList $emailEmployeesList
     * @return \StructType\Issue
     */
    public function setEmailEmployeesList(\StructType\EmailEmployeesList $emailEmployeesList = null)
    {
        $this->emailEmployeesList = $emailEmployeesList;
        return $this;
    }
    /**
     * Get emailCellsList value
     * @return \StructType\RecordRefList|null
     */
    public function getEmailCellsList()
    {
        return $this->emailCellsList;
    }
    /**
     * Set emailCellsList value
     * @param \StructType\RecordRefList $emailCellsList
     * @return \StructType\Issue
     */
    public function setEmailCellsList(\StructType\RecordRefList $emailCellsList = null)
    {
        $this->emailCellsList = $emailCellsList;
        return $this;
    }
    /**
     * Get externalAbstract value
     * @return string|null
     */
    public function getExternalAbstract()
    {
        return $this->externalAbstract;
    }
    /**
     * Set externalAbstract value
     * @param string $externalAbstract
     * @return \StructType\Issue
     */
    public function setExternalAbstract($externalAbstract = null)
    {
        // validation for constraint: string
        if (!is_null($externalAbstract) && !is_string($externalAbstract)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalAbstract, true), gettype($externalAbstract)), __LINE__);
        }
        $this->externalAbstract = $externalAbstract;
        return $this;
    }
    /**
     * Get externalDetails value
     * @return string|null
     */
    public function getExternalDetails()
    {
        return $this->externalDetails;
    }
    /**
     * Set externalDetails value
     * @param string $externalDetails
     * @return \StructType\Issue
     */
    public function setExternalDetails($externalDetails = null)
    {
        // validation for constraint: string
        if (!is_null($externalDetails) && !is_string($externalDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalDetails, true), gettype($externalDetails)), __LINE__);
        }
        $this->externalDetails = $externalDetails;
        return $this;
    }
    /**
     * Get brokenInVersionList value
     * @return \StructType\IssueVersionList|null
     */
    public function getBrokenInVersionList()
    {
        return $this->brokenInVersionList;
    }
    /**
     * Set brokenInVersionList value
     * @param \StructType\IssueVersionList $brokenInVersionList
     * @return \StructType\Issue
     */
    public function setBrokenInVersionList(\StructType\IssueVersionList $brokenInVersionList = null)
    {
        $this->brokenInVersionList = $brokenInVersionList;
        return $this;
    }
    /**
     * Get targetVersionList value
     * @return \StructType\IssueVersionList|null
     */
    public function getTargetVersionList()
    {
        return $this->targetVersionList;
    }
    /**
     * Set targetVersionList value
     * @param \StructType\IssueVersionList $targetVersionList
     * @return \StructType\Issue
     */
    public function setTargetVersionList(\StructType\IssueVersionList $targetVersionList = null)
    {
        $this->targetVersionList = $targetVersionList;
        return $this;
    }
    /**
     * Get fixedInVersionList value
     * @return \StructType\IssueVersionList|null
     */
    public function getFixedInVersionList()
    {
        return $this->fixedInVersionList;
    }
    /**
     * Set fixedInVersionList value
     * @param \StructType\IssueVersionList $fixedInVersionList
     * @return \StructType\Issue
     */
    public function setFixedInVersionList(\StructType\IssueVersionList $fixedInVersionList = null)
    {
        $this->fixedInVersionList = $fixedInVersionList;
        return $this;
    }
    /**
     * Get relatedIssuesList value
     * @return \StructType\IssueRelatedIssuesList|null
     */
    public function getRelatedIssuesList()
    {
        return $this->relatedIssuesList;
    }
    /**
     * Set relatedIssuesList value
     * @param \StructType\IssueRelatedIssuesList $relatedIssuesList
     * @return \StructType\Issue
     */
    public function setRelatedIssuesList(\StructType\IssueRelatedIssuesList $relatedIssuesList = null)
    {
        $this->relatedIssuesList = $relatedIssuesList;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\Issue
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\Issue
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\Issue
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
