<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceTimeList StructType
 * @subpackage Structs
 */
class InvoiceTimeList extends AbstractStructBase
{
    /**
     * The time
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InvoiceTime[]
     */
    public $time;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for InvoiceTimeList
     * @uses InvoiceTimeList::setTime()
     * @uses InvoiceTimeList::setReplaceAll()
     * @param \StructType\InvoiceTime[] $time
     * @param bool $replaceAll
     */
    public function __construct(array $time = array(), $replaceAll = true)
    {
        $this
            ->setTime($time)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get time value
     * @return \StructType\InvoiceTime[]|null
     */
    public function getTime()
    {
        return $this->time;
    }
    /**
     * This method is responsible for validating the values passed to the setTime method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTime method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTimeForArrayConstraintsFromSetTime(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTimeListTimeItem) {
            // validation for constraint: itemType
            if (!$invoiceTimeListTimeItem instanceof \StructType\InvoiceTime) {
                $invalidValues[] = is_object($invoiceTimeListTimeItem) ? get_class($invoiceTimeListTimeItem) : sprintf('%s(%s)', gettype($invoiceTimeListTimeItem), var_export($invoiceTimeListTimeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The time property can only contain items of type \StructType\InvoiceTime, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set time value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceTime[] $time
     * @return \StructType\InvoiceTimeList
     */
    public function setTime(array $time = array())
    {
        // validation for constraint: array
        if ('' !== ($timeArrayErrorMessage = self::validateTimeForArrayConstraintsFromSetTime($time))) {
            throw new \InvalidArgumentException($timeArrayErrorMessage, __LINE__);
        }
        $this->time = $time;
        return $this;
    }
    /**
     * Add item to time value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceTime $item
     * @return \StructType\InvoiceTimeList
     */
    public function addToTime(\StructType\InvoiceTime $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InvoiceTime) {
            throw new \InvalidArgumentException(sprintf('The time property can only contain items of type \StructType\InvoiceTime, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->time[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\InvoiceTimeList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
