<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceItem StructType
 * @subpackage Structs
 */
class InvoiceItem extends AbstractStructBase
{
    /**
     * The job
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $job;
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The line
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $line;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * The isTaxable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isTaxable;
    /**
     * The options
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $options;
    /**
     * The subscriptionLine
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subscriptionLine;
    /**
     * The deferRevRec
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $deferRevRec;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantity;
    /**
     * The currentPercent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $currentPercent;
    /**
     * The units
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $units;
    /**
     * The inventoryDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InventoryDetail
     */
    public $inventoryDetail;
    /**
     * The serialNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serialNumbers;
    /**
     * The binNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $binNumbers;
    /**
     * The price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $price;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $rate;
    /**
     * The percentComplete
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $percentComplete;
    /**
     * The quantityOnHand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityOnHand;
    /**
     * The quantityAvailable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityAvailable;
    /**
     * The quantityOrdered
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityOrdered;
    /**
     * The quantityRemaining
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityRemaining;
    /**
     * The quantityFulfilled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityFulfilled;
    /**
     * The amountOrdered
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amountOrdered;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The orderLine
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $orderLine;
    /**
     * The licenseCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $licenseCode;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The revRecSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $revRecSchedule;
    /**
     * The revRecStartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $revRecStartDate;
    /**
     * The revRecEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $revRecEndDate;
    /**
     * The grossAmt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $grossAmt;
    /**
     * The costEstimateType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $costEstimateType;
    /**
     * The costEstimate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $costEstimate;
    /**
     * The taxDetailsReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxDetailsReference;
    /**
     * The excludeFromRateRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $excludeFromRateRequest;
    /**
     * The catchUpPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $catchUpPeriod;
    /**
     * The tax1Amt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $tax1Amt;
    /**
     * The taxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxCode;
    /**
     * The taxRate1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxRate1;
    /**
     * The taxRate2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxRate2;
    /**
     * The giftCertFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $giftCertFrom;
    /**
     * The giftCertRecipientName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $giftCertRecipientName;
    /**
     * The giftCertRecipientEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $giftCertRecipientEmail;
    /**
     * The giftCertMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $giftCertMessage;
    /**
     * The taxAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxAmount;
    /**
     * The giftCertNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $giftCertNumber;
    /**
     * The shipGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $shipGroup;
    /**
     * The itemIsFulfilled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $itemIsFulfilled;
    /**
     * The shipAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $shipAddress;
    /**
     * The shipMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $shipMethod;
    /**
     * The vsoeSopGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vsoeSopGroup;
    /**
     * The vsoeIsEstimate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $vsoeIsEstimate;
    /**
     * The vsoePrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $vsoePrice;
    /**
     * The vsoeAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $vsoeAmount;
    /**
     * The vsoeAllocation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $vsoeAllocation;
    /**
     * The vsoeDeferral
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vsoeDeferral;
    /**
     * The vsoePermitDiscount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vsoePermitDiscount;
    /**
     * The vsoeDelivered
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $vsoeDelivered;
    /**
     * The chargeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $chargeType;
    /**
     * The chargesList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRefList
     */
    public $chargesList;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for InvoiceItem
     * @uses InvoiceItem::setJob()
     * @uses InvoiceItem::setItem()
     * @uses InvoiceItem::setLine()
     * @uses InvoiceItem::setDescription()
     * @uses InvoiceItem::setAmount()
     * @uses InvoiceItem::setIsTaxable()
     * @uses InvoiceItem::setOptions()
     * @uses InvoiceItem::setSubscriptionLine()
     * @uses InvoiceItem::setDeferRevRec()
     * @uses InvoiceItem::setQuantity()
     * @uses InvoiceItem::setCurrentPercent()
     * @uses InvoiceItem::setUnits()
     * @uses InvoiceItem::setInventoryDetail()
     * @uses InvoiceItem::setSerialNumbers()
     * @uses InvoiceItem::setBinNumbers()
     * @uses InvoiceItem::setPrice()
     * @uses InvoiceItem::setRate()
     * @uses InvoiceItem::setPercentComplete()
     * @uses InvoiceItem::setQuantityOnHand()
     * @uses InvoiceItem::setQuantityAvailable()
     * @uses InvoiceItem::setQuantityOrdered()
     * @uses InvoiceItem::setQuantityRemaining()
     * @uses InvoiceItem::setQuantityFulfilled()
     * @uses InvoiceItem::setAmountOrdered()
     * @uses InvoiceItem::setDepartment()
     * @uses InvoiceItem::setOrderLine()
     * @uses InvoiceItem::setLicenseCode()
     * @uses InvoiceItem::setClass()
     * @uses InvoiceItem::setLocation()
     * @uses InvoiceItem::setRevRecSchedule()
     * @uses InvoiceItem::setRevRecStartDate()
     * @uses InvoiceItem::setRevRecEndDate()
     * @uses InvoiceItem::setGrossAmt()
     * @uses InvoiceItem::setCostEstimateType()
     * @uses InvoiceItem::setCostEstimate()
     * @uses InvoiceItem::setTaxDetailsReference()
     * @uses InvoiceItem::setExcludeFromRateRequest()
     * @uses InvoiceItem::setCatchUpPeriod()
     * @uses InvoiceItem::setTax1Amt()
     * @uses InvoiceItem::setTaxCode()
     * @uses InvoiceItem::setTaxRate1()
     * @uses InvoiceItem::setTaxRate2()
     * @uses InvoiceItem::setGiftCertFrom()
     * @uses InvoiceItem::setGiftCertRecipientName()
     * @uses InvoiceItem::setGiftCertRecipientEmail()
     * @uses InvoiceItem::setGiftCertMessage()
     * @uses InvoiceItem::setTaxAmount()
     * @uses InvoiceItem::setGiftCertNumber()
     * @uses InvoiceItem::setShipGroup()
     * @uses InvoiceItem::setItemIsFulfilled()
     * @uses InvoiceItem::setShipAddress()
     * @uses InvoiceItem::setShipMethod()
     * @uses InvoiceItem::setVsoeSopGroup()
     * @uses InvoiceItem::setVsoeIsEstimate()
     * @uses InvoiceItem::setVsoePrice()
     * @uses InvoiceItem::setVsoeAmount()
     * @uses InvoiceItem::setVsoeAllocation()
     * @uses InvoiceItem::setVsoeDeferral()
     * @uses InvoiceItem::setVsoePermitDiscount()
     * @uses InvoiceItem::setVsoeDelivered()
     * @uses InvoiceItem::setChargeType()
     * @uses InvoiceItem::setChargesList()
     * @uses InvoiceItem::setCustomFieldList()
     * @param \StructType\RecordRef $job
     * @param \StructType\RecordRef $item
     * @param int $line
     * @param string $description
     * @param float $amount
     * @param bool $isTaxable
     * @param \StructType\CustomFieldList $options
     * @param \StructType\RecordRef $subscriptionLine
     * @param bool $deferRevRec
     * @param float $quantity
     * @param float $currentPercent
     * @param \StructType\RecordRef $units
     * @param \StructType\InventoryDetail $inventoryDetail
     * @param string $serialNumbers
     * @param string $binNumbers
     * @param \StructType\RecordRef $price
     * @param string $rate
     * @param float $percentComplete
     * @param float $quantityOnHand
     * @param float $quantityAvailable
     * @param float $quantityOrdered
     * @param float $quantityRemaining
     * @param float $quantityFulfilled
     * @param float $amountOrdered
     * @param \StructType\RecordRef $department
     * @param int $orderLine
     * @param string $licenseCode
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRef $revRecSchedule
     * @param string $revRecStartDate
     * @param string $revRecEndDate
     * @param float $grossAmt
     * @param string $costEstimateType
     * @param float $costEstimate
     * @param string $taxDetailsReference
     * @param bool $excludeFromRateRequest
     * @param \StructType\RecordRef $catchUpPeriod
     * @param float $tax1Amt
     * @param \StructType\RecordRef $taxCode
     * @param float $taxRate1
     * @param float $taxRate2
     * @param string $giftCertFrom
     * @param string $giftCertRecipientName
     * @param string $giftCertRecipientEmail
     * @param string $giftCertMessage
     * @param float $taxAmount
     * @param string $giftCertNumber
     * @param int $shipGroup
     * @param bool $itemIsFulfilled
     * @param \StructType\RecordRef $shipAddress
     * @param \StructType\RecordRef $shipMethod
     * @param string $vsoeSopGroup
     * @param bool $vsoeIsEstimate
     * @param float $vsoePrice
     * @param float $vsoeAmount
     * @param float $vsoeAllocation
     * @param string $vsoeDeferral
     * @param string $vsoePermitDiscount
     * @param bool $vsoeDelivered
     * @param \StructType\RecordRef $chargeType
     * @param \StructType\RecordRefList $chargesList
     * @param \StructType\CustomFieldList $customFieldList
     */
    public function __construct(\StructType\RecordRef $job = null, \StructType\RecordRef $item = null, $line = null, $description = null, $amount = null, $isTaxable = null, \StructType\CustomFieldList $options = null, \StructType\RecordRef $subscriptionLine = null, $deferRevRec = null, $quantity = null, $currentPercent = null, \StructType\RecordRef $units = null, \StructType\InventoryDetail $inventoryDetail = null, $serialNumbers = null, $binNumbers = null, \StructType\RecordRef $price = null, $rate = null, $percentComplete = null, $quantityOnHand = null, $quantityAvailable = null, $quantityOrdered = null, $quantityRemaining = null, $quantityFulfilled = null, $amountOrdered = null, \StructType\RecordRef $department = null, $orderLine = null, $licenseCode = null, \StructType\RecordRef $class = null, \StructType\RecordRef $location = null, \StructType\RecordRef $revRecSchedule = null, $revRecStartDate = null, $revRecEndDate = null, $grossAmt = null, $costEstimateType = null, $costEstimate = null, $taxDetailsReference = null, $excludeFromRateRequest = null, \StructType\RecordRef $catchUpPeriod = null, $tax1Amt = null, \StructType\RecordRef $taxCode = null, $taxRate1 = null, $taxRate2 = null, $giftCertFrom = null, $giftCertRecipientName = null, $giftCertRecipientEmail = null, $giftCertMessage = null, $taxAmount = null, $giftCertNumber = null, $shipGroup = null, $itemIsFulfilled = null, \StructType\RecordRef $shipAddress = null, \StructType\RecordRef $shipMethod = null, $vsoeSopGroup = null, $vsoeIsEstimate = null, $vsoePrice = null, $vsoeAmount = null, $vsoeAllocation = null, $vsoeDeferral = null, $vsoePermitDiscount = null, $vsoeDelivered = null, \StructType\RecordRef $chargeType = null, \StructType\RecordRefList $chargesList = null, \StructType\CustomFieldList $customFieldList = null)
    {
        $this
            ->setJob($job)
            ->setItem($item)
            ->setLine($line)
            ->setDescription($description)
            ->setAmount($amount)
            ->setIsTaxable($isTaxable)
            ->setOptions($options)
            ->setSubscriptionLine($subscriptionLine)
            ->setDeferRevRec($deferRevRec)
            ->setQuantity($quantity)
            ->setCurrentPercent($currentPercent)
            ->setUnits($units)
            ->setInventoryDetail($inventoryDetail)
            ->setSerialNumbers($serialNumbers)
            ->setBinNumbers($binNumbers)
            ->setPrice($price)
            ->setRate($rate)
            ->setPercentComplete($percentComplete)
            ->setQuantityOnHand($quantityOnHand)
            ->setQuantityAvailable($quantityAvailable)
            ->setQuantityOrdered($quantityOrdered)
            ->setQuantityRemaining($quantityRemaining)
            ->setQuantityFulfilled($quantityFulfilled)
            ->setAmountOrdered($amountOrdered)
            ->setDepartment($department)
            ->setOrderLine($orderLine)
            ->setLicenseCode($licenseCode)
            ->setClass($class)
            ->setLocation($location)
            ->setRevRecSchedule($revRecSchedule)
            ->setRevRecStartDate($revRecStartDate)
            ->setRevRecEndDate($revRecEndDate)
            ->setGrossAmt($grossAmt)
            ->setCostEstimateType($costEstimateType)
            ->setCostEstimate($costEstimate)
            ->setTaxDetailsReference($taxDetailsReference)
            ->setExcludeFromRateRequest($excludeFromRateRequest)
            ->setCatchUpPeriod($catchUpPeriod)
            ->setTax1Amt($tax1Amt)
            ->setTaxCode($taxCode)
            ->setTaxRate1($taxRate1)
            ->setTaxRate2($taxRate2)
            ->setGiftCertFrom($giftCertFrom)
            ->setGiftCertRecipientName($giftCertRecipientName)
            ->setGiftCertRecipientEmail($giftCertRecipientEmail)
            ->setGiftCertMessage($giftCertMessage)
            ->setTaxAmount($taxAmount)
            ->setGiftCertNumber($giftCertNumber)
            ->setShipGroup($shipGroup)
            ->setItemIsFulfilled($itemIsFulfilled)
            ->setShipAddress($shipAddress)
            ->setShipMethod($shipMethod)
            ->setVsoeSopGroup($vsoeSopGroup)
            ->setVsoeIsEstimate($vsoeIsEstimate)
            ->setVsoePrice($vsoePrice)
            ->setVsoeAmount($vsoeAmount)
            ->setVsoeAllocation($vsoeAllocation)
            ->setVsoeDeferral($vsoeDeferral)
            ->setVsoePermitDiscount($vsoePermitDiscount)
            ->setVsoeDelivered($vsoeDelivered)
            ->setChargeType($chargeType)
            ->setChargesList($chargesList)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get job value
     * @return \StructType\RecordRef|null
     */
    public function getJob()
    {
        return $this->job;
    }
    /**
     * Set job value
     * @param \StructType\RecordRef $job
     * @return \StructType\InvoiceItem
     */
    public function setJob(\StructType\RecordRef $job = null)
    {
        $this->job = $job;
        return $this;
    }
    /**
     * Get item value
     * @return \StructType\RecordRef|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\InvoiceItem
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get line value
     * @return int|null
     */
    public function getLine()
    {
        return $this->line;
    }
    /**
     * Set line value
     * @param int $line
     * @return \StructType\InvoiceItem
     */
    public function setLine($line = null)
    {
        // validation for constraint: int
        if (!is_null($line) && !(is_int($line) || ctype_digit($line))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($line, true), gettype($line)), __LINE__);
        }
        $this->line = $line;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\InvoiceItem
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\InvoiceItem
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get isTaxable value
     * @return bool|null
     */
    public function getIsTaxable()
    {
        return $this->isTaxable;
    }
    /**
     * Set isTaxable value
     * @param bool $isTaxable
     * @return \StructType\InvoiceItem
     */
    public function setIsTaxable($isTaxable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTaxable) && !is_bool($isTaxable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTaxable, true), gettype($isTaxable)), __LINE__);
        }
        $this->isTaxable = $isTaxable;
        return $this;
    }
    /**
     * Get options value
     * @return \StructType\CustomFieldList|null
     */
    public function getOptions()
    {
        return $this->options;
    }
    /**
     * Set options value
     * @param \StructType\CustomFieldList $options
     * @return \StructType\InvoiceItem
     */
    public function setOptions(\StructType\CustomFieldList $options = null)
    {
        $this->options = $options;
        return $this;
    }
    /**
     * Get subscriptionLine value
     * @return \StructType\RecordRef|null
     */
    public function getSubscriptionLine()
    {
        return $this->subscriptionLine;
    }
    /**
     * Set subscriptionLine value
     * @param \StructType\RecordRef $subscriptionLine
     * @return \StructType\InvoiceItem
     */
    public function setSubscriptionLine(\StructType\RecordRef $subscriptionLine = null)
    {
        $this->subscriptionLine = $subscriptionLine;
        return $this;
    }
    /**
     * Get deferRevRec value
     * @return bool|null
     */
    public function getDeferRevRec()
    {
        return $this->deferRevRec;
    }
    /**
     * Set deferRevRec value
     * @param bool $deferRevRec
     * @return \StructType\InvoiceItem
     */
    public function setDeferRevRec($deferRevRec = null)
    {
        // validation for constraint: boolean
        if (!is_null($deferRevRec) && !is_bool($deferRevRec)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($deferRevRec, true), gettype($deferRevRec)), __LINE__);
        }
        $this->deferRevRec = $deferRevRec;
        return $this;
    }
    /**
     * Get quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param float $quantity
     * @return \StructType\InvoiceItem
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get currentPercent value
     * @return float|null
     */
    public function getCurrentPercent()
    {
        return $this->currentPercent;
    }
    /**
     * Set currentPercent value
     * @param float $currentPercent
     * @return \StructType\InvoiceItem
     */
    public function setCurrentPercent($currentPercent = null)
    {
        // validation for constraint: float
        if (!is_null($currentPercent) && !(is_float($currentPercent) || is_numeric($currentPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($currentPercent, true), gettype($currentPercent)), __LINE__);
        }
        $this->currentPercent = $currentPercent;
        return $this;
    }
    /**
     * Get units value
     * @return \StructType\RecordRef|null
     */
    public function getUnits()
    {
        return $this->units;
    }
    /**
     * Set units value
     * @param \StructType\RecordRef $units
     * @return \StructType\InvoiceItem
     */
    public function setUnits(\StructType\RecordRef $units = null)
    {
        $this->units = $units;
        return $this;
    }
    /**
     * Get inventoryDetail value
     * @return \StructType\InventoryDetail|null
     */
    public function getInventoryDetail()
    {
        return $this->inventoryDetail;
    }
    /**
     * Set inventoryDetail value
     * @param \StructType\InventoryDetail $inventoryDetail
     * @return \StructType\InvoiceItem
     */
    public function setInventoryDetail(\StructType\InventoryDetail $inventoryDetail = null)
    {
        $this->inventoryDetail = $inventoryDetail;
        return $this;
    }
    /**
     * Get serialNumbers value
     * @return string|null
     */
    public function getSerialNumbers()
    {
        return $this->serialNumbers;
    }
    /**
     * Set serialNumbers value
     * @param string $serialNumbers
     * @return \StructType\InvoiceItem
     */
    public function setSerialNumbers($serialNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumbers) && !is_string($serialNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serialNumbers, true), gettype($serialNumbers)), __LINE__);
        }
        $this->serialNumbers = $serialNumbers;
        return $this;
    }
    /**
     * Get binNumbers value
     * @return string|null
     */
    public function getBinNumbers()
    {
        return $this->binNumbers;
    }
    /**
     * Set binNumbers value
     * @param string $binNumbers
     * @return \StructType\InvoiceItem
     */
    public function setBinNumbers($binNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($binNumbers) && !is_string($binNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($binNumbers, true), gettype($binNumbers)), __LINE__);
        }
        $this->binNumbers = $binNumbers;
        return $this;
    }
    /**
     * Get price value
     * @return \StructType\RecordRef|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param \StructType\RecordRef $price
     * @return \StructType\InvoiceItem
     */
    public function setPrice(\StructType\RecordRef $price = null)
    {
        $this->price = $price;
        return $this;
    }
    /**
     * Get rate value
     * @return string|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param string $rate
     * @return \StructType\InvoiceItem
     */
    public function setRate($rate = null)
    {
        // validation for constraint: string
        if (!is_null($rate) && !is_string($rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get percentComplete value
     * @return float|null
     */
    public function getPercentComplete()
    {
        return $this->percentComplete;
    }
    /**
     * Set percentComplete value
     * @param float $percentComplete
     * @return \StructType\InvoiceItem
     */
    public function setPercentComplete($percentComplete = null)
    {
        // validation for constraint: float
        if (!is_null($percentComplete) && !(is_float($percentComplete) || is_numeric($percentComplete))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percentComplete, true), gettype($percentComplete)), __LINE__);
        }
        $this->percentComplete = $percentComplete;
        return $this;
    }
    /**
     * Get quantityOnHand value
     * @return float|null
     */
    public function getQuantityOnHand()
    {
        return $this->quantityOnHand;
    }
    /**
     * Set quantityOnHand value
     * @param float $quantityOnHand
     * @return \StructType\InvoiceItem
     */
    public function setQuantityOnHand($quantityOnHand = null)
    {
        // validation for constraint: float
        if (!is_null($quantityOnHand) && !(is_float($quantityOnHand) || is_numeric($quantityOnHand))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityOnHand, true), gettype($quantityOnHand)), __LINE__);
        }
        $this->quantityOnHand = $quantityOnHand;
        return $this;
    }
    /**
     * Get quantityAvailable value
     * @return float|null
     */
    public function getQuantityAvailable()
    {
        return $this->quantityAvailable;
    }
    /**
     * Set quantityAvailable value
     * @param float $quantityAvailable
     * @return \StructType\InvoiceItem
     */
    public function setQuantityAvailable($quantityAvailable = null)
    {
        // validation for constraint: float
        if (!is_null($quantityAvailable) && !(is_float($quantityAvailable) || is_numeric($quantityAvailable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityAvailable, true), gettype($quantityAvailable)), __LINE__);
        }
        $this->quantityAvailable = $quantityAvailable;
        return $this;
    }
    /**
     * Get quantityOrdered value
     * @return float|null
     */
    public function getQuantityOrdered()
    {
        return $this->quantityOrdered;
    }
    /**
     * Set quantityOrdered value
     * @param float $quantityOrdered
     * @return \StructType\InvoiceItem
     */
    public function setQuantityOrdered($quantityOrdered = null)
    {
        // validation for constraint: float
        if (!is_null($quantityOrdered) && !(is_float($quantityOrdered) || is_numeric($quantityOrdered))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityOrdered, true), gettype($quantityOrdered)), __LINE__);
        }
        $this->quantityOrdered = $quantityOrdered;
        return $this;
    }
    /**
     * Get quantityRemaining value
     * @return float|null
     */
    public function getQuantityRemaining()
    {
        return $this->quantityRemaining;
    }
    /**
     * Set quantityRemaining value
     * @param float $quantityRemaining
     * @return \StructType\InvoiceItem
     */
    public function setQuantityRemaining($quantityRemaining = null)
    {
        // validation for constraint: float
        if (!is_null($quantityRemaining) && !(is_float($quantityRemaining) || is_numeric($quantityRemaining))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityRemaining, true), gettype($quantityRemaining)), __LINE__);
        }
        $this->quantityRemaining = $quantityRemaining;
        return $this;
    }
    /**
     * Get quantityFulfilled value
     * @return float|null
     */
    public function getQuantityFulfilled()
    {
        return $this->quantityFulfilled;
    }
    /**
     * Set quantityFulfilled value
     * @param float $quantityFulfilled
     * @return \StructType\InvoiceItem
     */
    public function setQuantityFulfilled($quantityFulfilled = null)
    {
        // validation for constraint: float
        if (!is_null($quantityFulfilled) && !(is_float($quantityFulfilled) || is_numeric($quantityFulfilled))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityFulfilled, true), gettype($quantityFulfilled)), __LINE__);
        }
        $this->quantityFulfilled = $quantityFulfilled;
        return $this;
    }
    /**
     * Get amountOrdered value
     * @return float|null
     */
    public function getAmountOrdered()
    {
        return $this->amountOrdered;
    }
    /**
     * Set amountOrdered value
     * @param float $amountOrdered
     * @return \StructType\InvoiceItem
     */
    public function setAmountOrdered($amountOrdered = null)
    {
        // validation for constraint: float
        if (!is_null($amountOrdered) && !(is_float($amountOrdered) || is_numeric($amountOrdered))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountOrdered, true), gettype($amountOrdered)), __LINE__);
        }
        $this->amountOrdered = $amountOrdered;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\InvoiceItem
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get orderLine value
     * @return int|null
     */
    public function getOrderLine()
    {
        return $this->orderLine;
    }
    /**
     * Set orderLine value
     * @param int $orderLine
     * @return \StructType\InvoiceItem
     */
    public function setOrderLine($orderLine = null)
    {
        // validation for constraint: int
        if (!is_null($orderLine) && !(is_int($orderLine) || ctype_digit($orderLine))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderLine, true), gettype($orderLine)), __LINE__);
        }
        $this->orderLine = $orderLine;
        return $this;
    }
    /**
     * Get licenseCode value
     * @return string|null
     */
    public function getLicenseCode()
    {
        return $this->licenseCode;
    }
    /**
     * Set licenseCode value
     * @param string $licenseCode
     * @return \StructType\InvoiceItem
     */
    public function setLicenseCode($licenseCode = null)
    {
        // validation for constraint: string
        if (!is_null($licenseCode) && !is_string($licenseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($licenseCode, true), gettype($licenseCode)), __LINE__);
        }
        $this->licenseCode = $licenseCode;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\InvoiceItem
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\InvoiceItem
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get revRecSchedule value
     * @return \StructType\RecordRef|null
     */
    public function getRevRecSchedule()
    {
        return $this->revRecSchedule;
    }
    /**
     * Set revRecSchedule value
     * @param \StructType\RecordRef $revRecSchedule
     * @return \StructType\InvoiceItem
     */
    public function setRevRecSchedule(\StructType\RecordRef $revRecSchedule = null)
    {
        $this->revRecSchedule = $revRecSchedule;
        return $this;
    }
    /**
     * Get revRecStartDate value
     * @return string|null
     */
    public function getRevRecStartDate()
    {
        return $this->revRecStartDate;
    }
    /**
     * Set revRecStartDate value
     * @param string $revRecStartDate
     * @return \StructType\InvoiceItem
     */
    public function setRevRecStartDate($revRecStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($revRecStartDate) && !is_string($revRecStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($revRecStartDate, true), gettype($revRecStartDate)), __LINE__);
        }
        $this->revRecStartDate = $revRecStartDate;
        return $this;
    }
    /**
     * Get revRecEndDate value
     * @return string|null
     */
    public function getRevRecEndDate()
    {
        return $this->revRecEndDate;
    }
    /**
     * Set revRecEndDate value
     * @param string $revRecEndDate
     * @return \StructType\InvoiceItem
     */
    public function setRevRecEndDate($revRecEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($revRecEndDate) && !is_string($revRecEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($revRecEndDate, true), gettype($revRecEndDate)), __LINE__);
        }
        $this->revRecEndDate = $revRecEndDate;
        return $this;
    }
    /**
     * Get grossAmt value
     * @return float|null
     */
    public function getGrossAmt()
    {
        return $this->grossAmt;
    }
    /**
     * Set grossAmt value
     * @param float $grossAmt
     * @return \StructType\InvoiceItem
     */
    public function setGrossAmt($grossAmt = null)
    {
        // validation for constraint: float
        if (!is_null($grossAmt) && !(is_float($grossAmt) || is_numeric($grossAmt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($grossAmt, true), gettype($grossAmt)), __LINE__);
        }
        $this->grossAmt = $grossAmt;
        return $this;
    }
    /**
     * Get costEstimateType value
     * @return string|null
     */
    public function getCostEstimateType()
    {
        return $this->costEstimateType;
    }
    /**
     * Set costEstimateType value
     * @uses \EnumType\ItemCostEstimateType::valueIsValid()
     * @uses \EnumType\ItemCostEstimateType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $costEstimateType
     * @return \StructType\InvoiceItem
     */
    public function setCostEstimateType($costEstimateType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemCostEstimateType::valueIsValid($costEstimateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemCostEstimateType', is_array($costEstimateType) ? implode(', ', $costEstimateType) : var_export($costEstimateType, true), implode(', ', \EnumType\ItemCostEstimateType::getValidValues())), __LINE__);
        }
        $this->costEstimateType = $costEstimateType;
        return $this;
    }
    /**
     * Get costEstimate value
     * @return float|null
     */
    public function getCostEstimate()
    {
        return $this->costEstimate;
    }
    /**
     * Set costEstimate value
     * @param float $costEstimate
     * @return \StructType\InvoiceItem
     */
    public function setCostEstimate($costEstimate = null)
    {
        // validation for constraint: float
        if (!is_null($costEstimate) && !(is_float($costEstimate) || is_numeric($costEstimate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($costEstimate, true), gettype($costEstimate)), __LINE__);
        }
        $this->costEstimate = $costEstimate;
        return $this;
    }
    /**
     * Get taxDetailsReference value
     * @return string|null
     */
    public function getTaxDetailsReference()
    {
        return $this->taxDetailsReference;
    }
    /**
     * Set taxDetailsReference value
     * @param string $taxDetailsReference
     * @return \StructType\InvoiceItem
     */
    public function setTaxDetailsReference($taxDetailsReference = null)
    {
        // validation for constraint: string
        if (!is_null($taxDetailsReference) && !is_string($taxDetailsReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxDetailsReference, true), gettype($taxDetailsReference)), __LINE__);
        }
        $this->taxDetailsReference = $taxDetailsReference;
        return $this;
    }
    /**
     * Get excludeFromRateRequest value
     * @return bool|null
     */
    public function getExcludeFromRateRequest()
    {
        return $this->excludeFromRateRequest;
    }
    /**
     * Set excludeFromRateRequest value
     * @param bool $excludeFromRateRequest
     * @return \StructType\InvoiceItem
     */
    public function setExcludeFromRateRequest($excludeFromRateRequest = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludeFromRateRequest) && !is_bool($excludeFromRateRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($excludeFromRateRequest, true), gettype($excludeFromRateRequest)), __LINE__);
        }
        $this->excludeFromRateRequest = $excludeFromRateRequest;
        return $this;
    }
    /**
     * Get catchUpPeriod value
     * @return \StructType\RecordRef|null
     */
    public function getCatchUpPeriod()
    {
        return $this->catchUpPeriod;
    }
    /**
     * Set catchUpPeriod value
     * @param \StructType\RecordRef $catchUpPeriod
     * @return \StructType\InvoiceItem
     */
    public function setCatchUpPeriod(\StructType\RecordRef $catchUpPeriod = null)
    {
        $this->catchUpPeriod = $catchUpPeriod;
        return $this;
    }
    /**
     * Get tax1Amt value
     * @return float|null
     */
    public function getTax1Amt()
    {
        return $this->tax1Amt;
    }
    /**
     * Set tax1Amt value
     * @param float $tax1Amt
     * @return \StructType\InvoiceItem
     */
    public function setTax1Amt($tax1Amt = null)
    {
        // validation for constraint: float
        if (!is_null($tax1Amt) && !(is_float($tax1Amt) || is_numeric($tax1Amt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax1Amt, true), gettype($tax1Amt)), __LINE__);
        }
        $this->tax1Amt = $tax1Amt;
        return $this;
    }
    /**
     * Get taxCode value
     * @return \StructType\RecordRef|null
     */
    public function getTaxCode()
    {
        return $this->taxCode;
    }
    /**
     * Set taxCode value
     * @param \StructType\RecordRef $taxCode
     * @return \StructType\InvoiceItem
     */
    public function setTaxCode(\StructType\RecordRef $taxCode = null)
    {
        $this->taxCode = $taxCode;
        return $this;
    }
    /**
     * Get taxRate1 value
     * @return float|null
     */
    public function getTaxRate1()
    {
        return $this->taxRate1;
    }
    /**
     * Set taxRate1 value
     * @param float $taxRate1
     * @return \StructType\InvoiceItem
     */
    public function setTaxRate1($taxRate1 = null)
    {
        // validation for constraint: float
        if (!is_null($taxRate1) && !(is_float($taxRate1) || is_numeric($taxRate1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxRate1, true), gettype($taxRate1)), __LINE__);
        }
        $this->taxRate1 = $taxRate1;
        return $this;
    }
    /**
     * Get taxRate2 value
     * @return float|null
     */
    public function getTaxRate2()
    {
        return $this->taxRate2;
    }
    /**
     * Set taxRate2 value
     * @param float $taxRate2
     * @return \StructType\InvoiceItem
     */
    public function setTaxRate2($taxRate2 = null)
    {
        // validation for constraint: float
        if (!is_null($taxRate2) && !(is_float($taxRate2) || is_numeric($taxRate2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxRate2, true), gettype($taxRate2)), __LINE__);
        }
        $this->taxRate2 = $taxRate2;
        return $this;
    }
    /**
     * Get giftCertFrom value
     * @return string|null
     */
    public function getGiftCertFrom()
    {
        return $this->giftCertFrom;
    }
    /**
     * Set giftCertFrom value
     * @param string $giftCertFrom
     * @return \StructType\InvoiceItem
     */
    public function setGiftCertFrom($giftCertFrom = null)
    {
        // validation for constraint: string
        if (!is_null($giftCertFrom) && !is_string($giftCertFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftCertFrom, true), gettype($giftCertFrom)), __LINE__);
        }
        $this->giftCertFrom = $giftCertFrom;
        return $this;
    }
    /**
     * Get giftCertRecipientName value
     * @return string|null
     */
    public function getGiftCertRecipientName()
    {
        return $this->giftCertRecipientName;
    }
    /**
     * Set giftCertRecipientName value
     * @param string $giftCertRecipientName
     * @return \StructType\InvoiceItem
     */
    public function setGiftCertRecipientName($giftCertRecipientName = null)
    {
        // validation for constraint: string
        if (!is_null($giftCertRecipientName) && !is_string($giftCertRecipientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftCertRecipientName, true), gettype($giftCertRecipientName)), __LINE__);
        }
        $this->giftCertRecipientName = $giftCertRecipientName;
        return $this;
    }
    /**
     * Get giftCertRecipientEmail value
     * @return string|null
     */
    public function getGiftCertRecipientEmail()
    {
        return $this->giftCertRecipientEmail;
    }
    /**
     * Set giftCertRecipientEmail value
     * @param string $giftCertRecipientEmail
     * @return \StructType\InvoiceItem
     */
    public function setGiftCertRecipientEmail($giftCertRecipientEmail = null)
    {
        // validation for constraint: string
        if (!is_null($giftCertRecipientEmail) && !is_string($giftCertRecipientEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftCertRecipientEmail, true), gettype($giftCertRecipientEmail)), __LINE__);
        }
        $this->giftCertRecipientEmail = $giftCertRecipientEmail;
        return $this;
    }
    /**
     * Get giftCertMessage value
     * @return string|null
     */
    public function getGiftCertMessage()
    {
        return $this->giftCertMessage;
    }
    /**
     * Set giftCertMessage value
     * @param string $giftCertMessage
     * @return \StructType\InvoiceItem
     */
    public function setGiftCertMessage($giftCertMessage = null)
    {
        // validation for constraint: string
        if (!is_null($giftCertMessage) && !is_string($giftCertMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftCertMessage, true), gettype($giftCertMessage)), __LINE__);
        }
        $this->giftCertMessage = $giftCertMessage;
        return $this;
    }
    /**
     * Get taxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->taxAmount;
    }
    /**
     * Set taxAmount value
     * @param float $taxAmount
     * @return \StructType\InvoiceItem
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxAmount) && !(is_float($taxAmount) || is_numeric($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->taxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get giftCertNumber value
     * @return string|null
     */
    public function getGiftCertNumber()
    {
        return $this->giftCertNumber;
    }
    /**
     * Set giftCertNumber value
     * @param string $giftCertNumber
     * @return \StructType\InvoiceItem
     */
    public function setGiftCertNumber($giftCertNumber = null)
    {
        // validation for constraint: string
        if (!is_null($giftCertNumber) && !is_string($giftCertNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftCertNumber, true), gettype($giftCertNumber)), __LINE__);
        }
        $this->giftCertNumber = $giftCertNumber;
        return $this;
    }
    /**
     * Get shipGroup value
     * @return int|null
     */
    public function getShipGroup()
    {
        return $this->shipGroup;
    }
    /**
     * Set shipGroup value
     * @param int $shipGroup
     * @return \StructType\InvoiceItem
     */
    public function setShipGroup($shipGroup = null)
    {
        // validation for constraint: int
        if (!is_null($shipGroup) && !(is_int($shipGroup) || ctype_digit($shipGroup))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shipGroup, true), gettype($shipGroup)), __LINE__);
        }
        $this->shipGroup = $shipGroup;
        return $this;
    }
    /**
     * Get itemIsFulfilled value
     * @return bool|null
     */
    public function getItemIsFulfilled()
    {
        return $this->itemIsFulfilled;
    }
    /**
     * Set itemIsFulfilled value
     * @param bool $itemIsFulfilled
     * @return \StructType\InvoiceItem
     */
    public function setItemIsFulfilled($itemIsFulfilled = null)
    {
        // validation for constraint: boolean
        if (!is_null($itemIsFulfilled) && !is_bool($itemIsFulfilled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($itemIsFulfilled, true), gettype($itemIsFulfilled)), __LINE__);
        }
        $this->itemIsFulfilled = $itemIsFulfilled;
        return $this;
    }
    /**
     * Get shipAddress value
     * @return \StructType\RecordRef|null
     */
    public function getShipAddress()
    {
        return $this->shipAddress;
    }
    /**
     * Set shipAddress value
     * @param \StructType\RecordRef $shipAddress
     * @return \StructType\InvoiceItem
     */
    public function setShipAddress(\StructType\RecordRef $shipAddress = null)
    {
        $this->shipAddress = $shipAddress;
        return $this;
    }
    /**
     * Get shipMethod value
     * @return \StructType\RecordRef|null
     */
    public function getShipMethod()
    {
        return $this->shipMethod;
    }
    /**
     * Set shipMethod value
     * @param \StructType\RecordRef $shipMethod
     * @return \StructType\InvoiceItem
     */
    public function setShipMethod(\StructType\RecordRef $shipMethod = null)
    {
        $this->shipMethod = $shipMethod;
        return $this;
    }
    /**
     * Get vsoeSopGroup value
     * @return string|null
     */
    public function getVsoeSopGroup()
    {
        return $this->vsoeSopGroup;
    }
    /**
     * Set vsoeSopGroup value
     * @uses \EnumType\VsoeSopGroup::valueIsValid()
     * @uses \EnumType\VsoeSopGroup::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vsoeSopGroup
     * @return \StructType\InvoiceItem
     */
    public function setVsoeSopGroup($vsoeSopGroup = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VsoeSopGroup::valueIsValid($vsoeSopGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VsoeSopGroup', is_array($vsoeSopGroup) ? implode(', ', $vsoeSopGroup) : var_export($vsoeSopGroup, true), implode(', ', \EnumType\VsoeSopGroup::getValidValues())), __LINE__);
        }
        $this->vsoeSopGroup = $vsoeSopGroup;
        return $this;
    }
    /**
     * Get vsoeIsEstimate value
     * @return bool|null
     */
    public function getVsoeIsEstimate()
    {
        return $this->vsoeIsEstimate;
    }
    /**
     * Set vsoeIsEstimate value
     * @param bool $vsoeIsEstimate
     * @return \StructType\InvoiceItem
     */
    public function setVsoeIsEstimate($vsoeIsEstimate = null)
    {
        // validation for constraint: boolean
        if (!is_null($vsoeIsEstimate) && !is_bool($vsoeIsEstimate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vsoeIsEstimate, true), gettype($vsoeIsEstimate)), __LINE__);
        }
        $this->vsoeIsEstimate = $vsoeIsEstimate;
        return $this;
    }
    /**
     * Get vsoePrice value
     * @return float|null
     */
    public function getVsoePrice()
    {
        return $this->vsoePrice;
    }
    /**
     * Set vsoePrice value
     * @param float $vsoePrice
     * @return \StructType\InvoiceItem
     */
    public function setVsoePrice($vsoePrice = null)
    {
        // validation for constraint: float
        if (!is_null($vsoePrice) && !(is_float($vsoePrice) || is_numeric($vsoePrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vsoePrice, true), gettype($vsoePrice)), __LINE__);
        }
        $this->vsoePrice = $vsoePrice;
        return $this;
    }
    /**
     * Get vsoeAmount value
     * @return float|null
     */
    public function getVsoeAmount()
    {
        return $this->vsoeAmount;
    }
    /**
     * Set vsoeAmount value
     * @param float $vsoeAmount
     * @return \StructType\InvoiceItem
     */
    public function setVsoeAmount($vsoeAmount = null)
    {
        // validation for constraint: float
        if (!is_null($vsoeAmount) && !(is_float($vsoeAmount) || is_numeric($vsoeAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vsoeAmount, true), gettype($vsoeAmount)), __LINE__);
        }
        $this->vsoeAmount = $vsoeAmount;
        return $this;
    }
    /**
     * Get vsoeAllocation value
     * @return float|null
     */
    public function getVsoeAllocation()
    {
        return $this->vsoeAllocation;
    }
    /**
     * Set vsoeAllocation value
     * @param float $vsoeAllocation
     * @return \StructType\InvoiceItem
     */
    public function setVsoeAllocation($vsoeAllocation = null)
    {
        // validation for constraint: float
        if (!is_null($vsoeAllocation) && !(is_float($vsoeAllocation) || is_numeric($vsoeAllocation))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vsoeAllocation, true), gettype($vsoeAllocation)), __LINE__);
        }
        $this->vsoeAllocation = $vsoeAllocation;
        return $this;
    }
    /**
     * Get vsoeDeferral value
     * @return string|null
     */
    public function getVsoeDeferral()
    {
        return $this->vsoeDeferral;
    }
    /**
     * Set vsoeDeferral value
     * @uses \EnumType\VsoeDeferral::valueIsValid()
     * @uses \EnumType\VsoeDeferral::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vsoeDeferral
     * @return \StructType\InvoiceItem
     */
    public function setVsoeDeferral($vsoeDeferral = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VsoeDeferral::valueIsValid($vsoeDeferral)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VsoeDeferral', is_array($vsoeDeferral) ? implode(', ', $vsoeDeferral) : var_export($vsoeDeferral, true), implode(', ', \EnumType\VsoeDeferral::getValidValues())), __LINE__);
        }
        $this->vsoeDeferral = $vsoeDeferral;
        return $this;
    }
    /**
     * Get vsoePermitDiscount value
     * @return string|null
     */
    public function getVsoePermitDiscount()
    {
        return $this->vsoePermitDiscount;
    }
    /**
     * Set vsoePermitDiscount value
     * @uses \EnumType\VsoePermitDiscount::valueIsValid()
     * @uses \EnumType\VsoePermitDiscount::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vsoePermitDiscount
     * @return \StructType\InvoiceItem
     */
    public function setVsoePermitDiscount($vsoePermitDiscount = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VsoePermitDiscount::valueIsValid($vsoePermitDiscount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VsoePermitDiscount', is_array($vsoePermitDiscount) ? implode(', ', $vsoePermitDiscount) : var_export($vsoePermitDiscount, true), implode(', ', \EnumType\VsoePermitDiscount::getValidValues())), __LINE__);
        }
        $this->vsoePermitDiscount = $vsoePermitDiscount;
        return $this;
    }
    /**
     * Get vsoeDelivered value
     * @return bool|null
     */
    public function getVsoeDelivered()
    {
        return $this->vsoeDelivered;
    }
    /**
     * Set vsoeDelivered value
     * @param bool $vsoeDelivered
     * @return \StructType\InvoiceItem
     */
    public function setVsoeDelivered($vsoeDelivered = null)
    {
        // validation for constraint: boolean
        if (!is_null($vsoeDelivered) && !is_bool($vsoeDelivered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vsoeDelivered, true), gettype($vsoeDelivered)), __LINE__);
        }
        $this->vsoeDelivered = $vsoeDelivered;
        return $this;
    }
    /**
     * Get chargeType value
     * @return \StructType\RecordRef|null
     */
    public function getChargeType()
    {
        return $this->chargeType;
    }
    /**
     * Set chargeType value
     * @param \StructType\RecordRef $chargeType
     * @return \StructType\InvoiceItem
     */
    public function setChargeType(\StructType\RecordRef $chargeType = null)
    {
        $this->chargeType = $chargeType;
        return $this;
    }
    /**
     * Get chargesList value
     * @return \StructType\RecordRefList|null
     */
    public function getChargesList()
    {
        return $this->chargesList;
    }
    /**
     * Set chargesList value
     * @param \StructType\RecordRefList $chargesList
     * @return \StructType\InvoiceItem
     */
    public function setChargesList(\StructType\RecordRefList $chargesList = null)
    {
        $this->chargesList = $chargesList;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\InvoiceItem
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
