<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceExpCostList StructType
 * @subpackage Structs
 */
class InvoiceExpCostList extends AbstractStructBase
{
    /**
     * The expCost
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InvoiceExpCost[]
     */
    public $expCost;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for InvoiceExpCostList
     * @uses InvoiceExpCostList::setExpCost()
     * @uses InvoiceExpCostList::setReplaceAll()
     * @param \StructType\InvoiceExpCost[] $expCost
     * @param bool $replaceAll
     */
    public function __construct(array $expCost = array(), $replaceAll = true)
    {
        $this
            ->setExpCost($expCost)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get expCost value
     * @return \StructType\InvoiceExpCost[]|null
     */
    public function getExpCost()
    {
        return $this->expCost;
    }
    /**
     * This method is responsible for validating the values passed to the setExpCost method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpCost method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpCostForArrayConstraintsFromSetExpCost(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceExpCostListExpCostItem) {
            // validation for constraint: itemType
            if (!$invoiceExpCostListExpCostItem instanceof \StructType\InvoiceExpCost) {
                $invalidValues[] = is_object($invoiceExpCostListExpCostItem) ? get_class($invoiceExpCostListExpCostItem) : sprintf('%s(%s)', gettype($invoiceExpCostListExpCostItem), var_export($invoiceExpCostListExpCostItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The expCost property can only contain items of type \StructType\InvoiceExpCost, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set expCost value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceExpCost[] $expCost
     * @return \StructType\InvoiceExpCostList
     */
    public function setExpCost(array $expCost = array())
    {
        // validation for constraint: array
        if ('' !== ($expCostArrayErrorMessage = self::validateExpCostForArrayConstraintsFromSetExpCost($expCost))) {
            throw new \InvalidArgumentException($expCostArrayErrorMessage, __LINE__);
        }
        $this->expCost = $expCost;
        return $this;
    }
    /**
     * Add item to expCost value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceExpCost $item
     * @return \StructType\InvoiceExpCostList
     */
    public function addToExpCost(\StructType\InvoiceExpCost $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InvoiceExpCost) {
            throw new \InvalidArgumentException(sprintf('The expCost property can only contain items of type \StructType\InvoiceExpCost, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->expCost[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\InvoiceExpCostList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
