<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InventoryItemBinNumberList StructType
 * @subpackage Structs
 */
class InventoryItemBinNumberList extends AbstractStructBase
{
    /**
     * The binNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InventoryItemBinNumber[]
     */
    public $binNumber;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for InventoryItemBinNumberList
     * @uses InventoryItemBinNumberList::setBinNumber()
     * @uses InventoryItemBinNumberList::setReplaceAll()
     * @param \StructType\InventoryItemBinNumber[] $binNumber
     * @param bool $replaceAll
     */
    public function __construct(array $binNumber = array(), $replaceAll = true)
    {
        $this
            ->setBinNumber($binNumber)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get binNumber value
     * @return \StructType\InventoryItemBinNumber[]|null
     */
    public function getBinNumber()
    {
        return $this->binNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setBinNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBinNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBinNumberForArrayConstraintsFromSetBinNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inventoryItemBinNumberListBinNumberItem) {
            // validation for constraint: itemType
            if (!$inventoryItemBinNumberListBinNumberItem instanceof \StructType\InventoryItemBinNumber) {
                $invalidValues[] = is_object($inventoryItemBinNumberListBinNumberItem) ? get_class($inventoryItemBinNumberListBinNumberItem) : sprintf('%s(%s)', gettype($inventoryItemBinNumberListBinNumberItem), var_export($inventoryItemBinNumberListBinNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The binNumber property can only contain items of type \StructType\InventoryItemBinNumber, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set binNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\InventoryItemBinNumber[] $binNumber
     * @return \StructType\InventoryItemBinNumberList
     */
    public function setBinNumber(array $binNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($binNumberArrayErrorMessage = self::validateBinNumberForArrayConstraintsFromSetBinNumber($binNumber))) {
            throw new \InvalidArgumentException($binNumberArrayErrorMessage, __LINE__);
        }
        $this->binNumber = $binNumber;
        return $this;
    }
    /**
     * Add item to binNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\InventoryItemBinNumber $item
     * @return \StructType\InventoryItemBinNumberList
     */
    public function addToBinNumber(\StructType\InventoryItemBinNumber $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InventoryItemBinNumber) {
            throw new \InvalidArgumentException(sprintf('The binNumber property can only contain items of type \StructType\InventoryItemBinNumber, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->binNumber[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\InventoryItemBinNumberList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
