<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InventoryAdjustmentInventory StructType
 * @subpackage Structs
 */
class InventoryAdjustmentInventory extends AbstractStructBase
{
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The line
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $line;
    /**
     * The inventoryDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InventoryDetail
     */
    public $inventoryDetail;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The units
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $units;
    /**
     * The quantityOnHand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityOnHand;
    /**
     * The currentValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $currentValue;
    /**
     * The adjustQtyBy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $adjustQtyBy;
    /**
     * The binNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $binNumbers;
    /**
     * The serialNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serialNumbers;
    /**
     * The newQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $newQuantity;
    /**
     * The unitCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $unitCost;
    /**
     * The foreignCurrencyUnitCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $foreignCurrencyUnitCost;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currency;
    /**
     * The expirationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $expirationDate;
    /**
     * The exchangeRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $exchangeRate;
    /**
     * Constructor method for InventoryAdjustmentInventory
     * @uses InventoryAdjustmentInventory::setItem()
     * @uses InventoryAdjustmentInventory::setLine()
     * @uses InventoryAdjustmentInventory::setInventoryDetail()
     * @uses InventoryAdjustmentInventory::setDescription()
     * @uses InventoryAdjustmentInventory::setDepartment()
     * @uses InventoryAdjustmentInventory::setClass()
     * @uses InventoryAdjustmentInventory::setLocation()
     * @uses InventoryAdjustmentInventory::setUnits()
     * @uses InventoryAdjustmentInventory::setQuantityOnHand()
     * @uses InventoryAdjustmentInventory::setCurrentValue()
     * @uses InventoryAdjustmentInventory::setAdjustQtyBy()
     * @uses InventoryAdjustmentInventory::setBinNumbers()
     * @uses InventoryAdjustmentInventory::setSerialNumbers()
     * @uses InventoryAdjustmentInventory::setNewQuantity()
     * @uses InventoryAdjustmentInventory::setUnitCost()
     * @uses InventoryAdjustmentInventory::setForeignCurrencyUnitCost()
     * @uses InventoryAdjustmentInventory::setMemo()
     * @uses InventoryAdjustmentInventory::setCurrency()
     * @uses InventoryAdjustmentInventory::setExpirationDate()
     * @uses InventoryAdjustmentInventory::setExchangeRate()
     * @param \StructType\RecordRef $item
     * @param int $line
     * @param \StructType\InventoryDetail $inventoryDetail
     * @param string $description
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRef $units
     * @param float $quantityOnHand
     * @param float $currentValue
     * @param float $adjustQtyBy
     * @param string $binNumbers
     * @param string $serialNumbers
     * @param float $newQuantity
     * @param float $unitCost
     * @param float $foreignCurrencyUnitCost
     * @param string $memo
     * @param string $currency
     * @param string $expirationDate
     * @param float $exchangeRate
     */
    public function __construct(\StructType\RecordRef $item = null, $line = null, \StructType\InventoryDetail $inventoryDetail = null, $description = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRef $location = null, \StructType\RecordRef $units = null, $quantityOnHand = null, $currentValue = null, $adjustQtyBy = null, $binNumbers = null, $serialNumbers = null, $newQuantity = null, $unitCost = null, $foreignCurrencyUnitCost = null, $memo = null, $currency = null, $expirationDate = null, $exchangeRate = null)
    {
        $this
            ->setItem($item)
            ->setLine($line)
            ->setInventoryDetail($inventoryDetail)
            ->setDescription($description)
            ->setDepartment($department)
            ->setClass($class)
            ->setLocation($location)
            ->setUnits($units)
            ->setQuantityOnHand($quantityOnHand)
            ->setCurrentValue($currentValue)
            ->setAdjustQtyBy($adjustQtyBy)
            ->setBinNumbers($binNumbers)
            ->setSerialNumbers($serialNumbers)
            ->setNewQuantity($newQuantity)
            ->setUnitCost($unitCost)
            ->setForeignCurrencyUnitCost($foreignCurrencyUnitCost)
            ->setMemo($memo)
            ->setCurrency($currency)
            ->setExpirationDate($expirationDate)
            ->setExchangeRate($exchangeRate);
    }
    /**
     * Get item value
     * @return \StructType\RecordRef|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\InventoryAdjustmentInventory
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get line value
     * @return int|null
     */
    public function getLine()
    {
        return $this->line;
    }
    /**
     * Set line value
     * @param int $line
     * @return \StructType\InventoryAdjustmentInventory
     */
    public function setLine($line = null)
    {
        // validation for constraint: int
        if (!is_null($line) && !(is_int($line) || ctype_digit($line))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($line, true), gettype($line)), __LINE__);
        }
        $this->line = $line;
        return $this;
    }
    /**
     * Get inventoryDetail value
     * @return \StructType\InventoryDetail|null
     */
    public function getInventoryDetail()
    {
        return $this->inventoryDetail;
    }
    /**
     * Set inventoryDetail value
     * @param \StructType\InventoryDetail $inventoryDetail
     * @return \StructType\InventoryAdjustmentInventory
     */
    public function setInventoryDetail(\StructType\InventoryDetail $inventoryDetail = null)
    {
        $this->inventoryDetail = $inventoryDetail;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\InventoryAdjustmentInventory
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\InventoryAdjustmentInventory
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\InventoryAdjustmentInventory
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\InventoryAdjustmentInventory
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get units value
     * @return \StructType\RecordRef|null
     */
    public function getUnits()
    {
        return $this->units;
    }
    /**
     * Set units value
     * @param \StructType\RecordRef $units
     * @return \StructType\InventoryAdjustmentInventory
     */
    public function setUnits(\StructType\RecordRef $units = null)
    {
        $this->units = $units;
        return $this;
    }
    /**
     * Get quantityOnHand value
     * @return float|null
     */
    public function getQuantityOnHand()
    {
        return $this->quantityOnHand;
    }
    /**
     * Set quantityOnHand value
     * @param float $quantityOnHand
     * @return \StructType\InventoryAdjustmentInventory
     */
    public function setQuantityOnHand($quantityOnHand = null)
    {
        // validation for constraint: float
        if (!is_null($quantityOnHand) && !(is_float($quantityOnHand) || is_numeric($quantityOnHand))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityOnHand, true), gettype($quantityOnHand)), __LINE__);
        }
        $this->quantityOnHand = $quantityOnHand;
        return $this;
    }
    /**
     * Get currentValue value
     * @return float|null
     */
    public function getCurrentValue()
    {
        return $this->currentValue;
    }
    /**
     * Set currentValue value
     * @param float $currentValue
     * @return \StructType\InventoryAdjustmentInventory
     */
    public function setCurrentValue($currentValue = null)
    {
        // validation for constraint: float
        if (!is_null($currentValue) && !(is_float($currentValue) || is_numeric($currentValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($currentValue, true), gettype($currentValue)), __LINE__);
        }
        $this->currentValue = $currentValue;
        return $this;
    }
    /**
     * Get adjustQtyBy value
     * @return float|null
     */
    public function getAdjustQtyBy()
    {
        return $this->adjustQtyBy;
    }
    /**
     * Set adjustQtyBy value
     * @param float $adjustQtyBy
     * @return \StructType\InventoryAdjustmentInventory
     */
    public function setAdjustQtyBy($adjustQtyBy = null)
    {
        // validation for constraint: float
        if (!is_null($adjustQtyBy) && !(is_float($adjustQtyBy) || is_numeric($adjustQtyBy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($adjustQtyBy, true), gettype($adjustQtyBy)), __LINE__);
        }
        $this->adjustQtyBy = $adjustQtyBy;
        return $this;
    }
    /**
     * Get binNumbers value
     * @return string|null
     */
    public function getBinNumbers()
    {
        return $this->binNumbers;
    }
    /**
     * Set binNumbers value
     * @param string $binNumbers
     * @return \StructType\InventoryAdjustmentInventory
     */
    public function setBinNumbers($binNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($binNumbers) && !is_string($binNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($binNumbers, true), gettype($binNumbers)), __LINE__);
        }
        $this->binNumbers = $binNumbers;
        return $this;
    }
    /**
     * Get serialNumbers value
     * @return string|null
     */
    public function getSerialNumbers()
    {
        return $this->serialNumbers;
    }
    /**
     * Set serialNumbers value
     * @param string $serialNumbers
     * @return \StructType\InventoryAdjustmentInventory
     */
    public function setSerialNumbers($serialNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumbers) && !is_string($serialNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serialNumbers, true), gettype($serialNumbers)), __LINE__);
        }
        $this->serialNumbers = $serialNumbers;
        return $this;
    }
    /**
     * Get newQuantity value
     * @return float|null
     */
    public function getNewQuantity()
    {
        return $this->newQuantity;
    }
    /**
     * Set newQuantity value
     * @param float $newQuantity
     * @return \StructType\InventoryAdjustmentInventory
     */
    public function setNewQuantity($newQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($newQuantity) && !(is_float($newQuantity) || is_numeric($newQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($newQuantity, true), gettype($newQuantity)), __LINE__);
        }
        $this->newQuantity = $newQuantity;
        return $this;
    }
    /**
     * Get unitCost value
     * @return float|null
     */
    public function getUnitCost()
    {
        return $this->unitCost;
    }
    /**
     * Set unitCost value
     * @param float $unitCost
     * @return \StructType\InventoryAdjustmentInventory
     */
    public function setUnitCost($unitCost = null)
    {
        // validation for constraint: float
        if (!is_null($unitCost) && !(is_float($unitCost) || is_numeric($unitCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitCost, true), gettype($unitCost)), __LINE__);
        }
        $this->unitCost = $unitCost;
        return $this;
    }
    /**
     * Get foreignCurrencyUnitCost value
     * @return float|null
     */
    public function getForeignCurrencyUnitCost()
    {
        return $this->foreignCurrencyUnitCost;
    }
    /**
     * Set foreignCurrencyUnitCost value
     * @param float $foreignCurrencyUnitCost
     * @return \StructType\InventoryAdjustmentInventory
     */
    public function setForeignCurrencyUnitCost($foreignCurrencyUnitCost = null)
    {
        // validation for constraint: float
        if (!is_null($foreignCurrencyUnitCost) && !(is_float($foreignCurrencyUnitCost) || is_numeric($foreignCurrencyUnitCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($foreignCurrencyUnitCost, true), gettype($foreignCurrencyUnitCost)), __LINE__);
        }
        $this->foreignCurrencyUnitCost = $foreignCurrencyUnitCost;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\InventoryAdjustmentInventory
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\InventoryAdjustmentInventory
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get expirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->expirationDate;
    }
    /**
     * Set expirationDate value
     * @param string $expirationDate
     * @return \StructType\InventoryAdjustmentInventory
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        $this->expirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get exchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->exchangeRate;
    }
    /**
     * Set exchangeRate value
     * @param float $exchangeRate
     * @return \StructType\InventoryAdjustmentInventory
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->exchangeRate = $exchangeRate;
        return $this;
    }
}
