<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InboundShipment StructType
 * @subpackage Structs
 */
class InboundShipment extends Record
{
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The shipmentNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shipmentNumber;
    /**
     * The externalDocumentNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $externalDocumentNumber;
    /**
     * The shipmentStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shipmentStatus;
    /**
     * The expectedShippingDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $expectedShippingDate;
    /**
     * The actualShippingDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $actualShippingDate;
    /**
     * The expectedDeliveryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $expectedDeliveryDate;
    /**
     * The actualDeliveryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $actualDeliveryDate;
    /**
     * The shipmentMemo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shipmentMemo;
    /**
     * The vesselNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vesselNumber;
    /**
     * The billOfLading
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $billOfLading;
    /**
     * The landedCostList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InboundShipmentLandedCostList
     */
    public $landedCostList;
    /**
     * The itemsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InboundShipmentItemsList
     */
    public $itemsList;
    /**
     * The shipmentBaseCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $shipmentBaseCurrency;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for InboundShipment
     * @uses InboundShipment::setCustomForm()
     * @uses InboundShipment::setShipmentNumber()
     * @uses InboundShipment::setExternalDocumentNumber()
     * @uses InboundShipment::setShipmentStatus()
     * @uses InboundShipment::setExpectedShippingDate()
     * @uses InboundShipment::setActualShippingDate()
     * @uses InboundShipment::setExpectedDeliveryDate()
     * @uses InboundShipment::setActualDeliveryDate()
     * @uses InboundShipment::setShipmentMemo()
     * @uses InboundShipment::setVesselNumber()
     * @uses InboundShipment::setBillOfLading()
     * @uses InboundShipment::setLandedCostList()
     * @uses InboundShipment::setItemsList()
     * @uses InboundShipment::setShipmentBaseCurrency()
     * @uses InboundShipment::setCustomFieldList()
     * @uses InboundShipment::setInternalId()
     * @uses InboundShipment::setExternalId()
     * @param \StructType\RecordRef $customForm
     * @param string $shipmentNumber
     * @param string $externalDocumentNumber
     * @param string $shipmentStatus
     * @param string $expectedShippingDate
     * @param string $actualShippingDate
     * @param string $expectedDeliveryDate
     * @param string $actualDeliveryDate
     * @param string $shipmentMemo
     * @param string $vesselNumber
     * @param string $billOfLading
     * @param \StructType\InboundShipmentLandedCostList $landedCostList
     * @param \StructType\InboundShipmentItemsList $itemsList
     * @param \StructType\RecordRef $shipmentBaseCurrency
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct(\StructType\RecordRef $customForm = null, $shipmentNumber = null, $externalDocumentNumber = null, $shipmentStatus = null, $expectedShippingDate = null, $actualShippingDate = null, $expectedDeliveryDate = null, $actualDeliveryDate = null, $shipmentMemo = null, $vesselNumber = null, $billOfLading = null, \StructType\InboundShipmentLandedCostList $landedCostList = null, \StructType\InboundShipmentItemsList $itemsList = null, \StructType\RecordRef $shipmentBaseCurrency = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCustomForm($customForm)
            ->setShipmentNumber($shipmentNumber)
            ->setExternalDocumentNumber($externalDocumentNumber)
            ->setShipmentStatus($shipmentStatus)
            ->setExpectedShippingDate($expectedShippingDate)
            ->setActualShippingDate($actualShippingDate)
            ->setExpectedDeliveryDate($expectedDeliveryDate)
            ->setActualDeliveryDate($actualDeliveryDate)
            ->setShipmentMemo($shipmentMemo)
            ->setVesselNumber($vesselNumber)
            ->setBillOfLading($billOfLading)
            ->setLandedCostList($landedCostList)
            ->setItemsList($itemsList)
            ->setShipmentBaseCurrency($shipmentBaseCurrency)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\InboundShipment
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get shipmentNumber value
     * @return string|null
     */
    public function getShipmentNumber()
    {
        return $this->shipmentNumber;
    }
    /**
     * Set shipmentNumber value
     * @param string $shipmentNumber
     * @return \StructType\InboundShipment
     */
    public function setShipmentNumber($shipmentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentNumber) && !is_string($shipmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentNumber, true), gettype($shipmentNumber)), __LINE__);
        }
        $this->shipmentNumber = $shipmentNumber;
        return $this;
    }
    /**
     * Get externalDocumentNumber value
     * @return string|null
     */
    public function getExternalDocumentNumber()
    {
        return $this->externalDocumentNumber;
    }
    /**
     * Set externalDocumentNumber value
     * @param string $externalDocumentNumber
     * @return \StructType\InboundShipment
     */
    public function setExternalDocumentNumber($externalDocumentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($externalDocumentNumber) && !is_string($externalDocumentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalDocumentNumber, true), gettype($externalDocumentNumber)), __LINE__);
        }
        $this->externalDocumentNumber = $externalDocumentNumber;
        return $this;
    }
    /**
     * Get shipmentStatus value
     * @return string|null
     */
    public function getShipmentStatus()
    {
        return $this->shipmentStatus;
    }
    /**
     * Set shipmentStatus value
     * @uses \EnumType\InboundShipmentShipmentStatus::valueIsValid()
     * @uses \EnumType\InboundShipmentShipmentStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $shipmentStatus
     * @return \StructType\InboundShipment
     */
    public function setShipmentStatus($shipmentStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\InboundShipmentShipmentStatus::valueIsValid($shipmentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\InboundShipmentShipmentStatus', is_array($shipmentStatus) ? implode(', ', $shipmentStatus) : var_export($shipmentStatus, true), implode(', ', \EnumType\InboundShipmentShipmentStatus::getValidValues())), __LINE__);
        }
        $this->shipmentStatus = $shipmentStatus;
        return $this;
    }
    /**
     * Get expectedShippingDate value
     * @return string|null
     */
    public function getExpectedShippingDate()
    {
        return $this->expectedShippingDate;
    }
    /**
     * Set expectedShippingDate value
     * @param string $expectedShippingDate
     * @return \StructType\InboundShipment
     */
    public function setExpectedShippingDate($expectedShippingDate = null)
    {
        // validation for constraint: string
        if (!is_null($expectedShippingDate) && !is_string($expectedShippingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expectedShippingDate, true), gettype($expectedShippingDate)), __LINE__);
        }
        $this->expectedShippingDate = $expectedShippingDate;
        return $this;
    }
    /**
     * Get actualShippingDate value
     * @return string|null
     */
    public function getActualShippingDate()
    {
        return $this->actualShippingDate;
    }
    /**
     * Set actualShippingDate value
     * @param string $actualShippingDate
     * @return \StructType\InboundShipment
     */
    public function setActualShippingDate($actualShippingDate = null)
    {
        // validation for constraint: string
        if (!is_null($actualShippingDate) && !is_string($actualShippingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actualShippingDate, true), gettype($actualShippingDate)), __LINE__);
        }
        $this->actualShippingDate = $actualShippingDate;
        return $this;
    }
    /**
     * Get expectedDeliveryDate value
     * @return string|null
     */
    public function getExpectedDeliveryDate()
    {
        return $this->expectedDeliveryDate;
    }
    /**
     * Set expectedDeliveryDate value
     * @param string $expectedDeliveryDate
     * @return \StructType\InboundShipment
     */
    public function setExpectedDeliveryDate($expectedDeliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expectedDeliveryDate) && !is_string($expectedDeliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expectedDeliveryDate, true), gettype($expectedDeliveryDate)), __LINE__);
        }
        $this->expectedDeliveryDate = $expectedDeliveryDate;
        return $this;
    }
    /**
     * Get actualDeliveryDate value
     * @return string|null
     */
    public function getActualDeliveryDate()
    {
        return $this->actualDeliveryDate;
    }
    /**
     * Set actualDeliveryDate value
     * @param string $actualDeliveryDate
     * @return \StructType\InboundShipment
     */
    public function setActualDeliveryDate($actualDeliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($actualDeliveryDate) && !is_string($actualDeliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actualDeliveryDate, true), gettype($actualDeliveryDate)), __LINE__);
        }
        $this->actualDeliveryDate = $actualDeliveryDate;
        return $this;
    }
    /**
     * Get shipmentMemo value
     * @return string|null
     */
    public function getShipmentMemo()
    {
        return $this->shipmentMemo;
    }
    /**
     * Set shipmentMemo value
     * @param string $shipmentMemo
     * @return \StructType\InboundShipment
     */
    public function setShipmentMemo($shipmentMemo = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentMemo) && !is_string($shipmentMemo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentMemo, true), gettype($shipmentMemo)), __LINE__);
        }
        $this->shipmentMemo = $shipmentMemo;
        return $this;
    }
    /**
     * Get vesselNumber value
     * @return string|null
     */
    public function getVesselNumber()
    {
        return $this->vesselNumber;
    }
    /**
     * Set vesselNumber value
     * @param string $vesselNumber
     * @return \StructType\InboundShipment
     */
    public function setVesselNumber($vesselNumber = null)
    {
        // validation for constraint: string
        if (!is_null($vesselNumber) && !is_string($vesselNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vesselNumber, true), gettype($vesselNumber)), __LINE__);
        }
        $this->vesselNumber = $vesselNumber;
        return $this;
    }
    /**
     * Get billOfLading value
     * @return string|null
     */
    public function getBillOfLading()
    {
        return $this->billOfLading;
    }
    /**
     * Set billOfLading value
     * @param string $billOfLading
     * @return \StructType\InboundShipment
     */
    public function setBillOfLading($billOfLading = null)
    {
        // validation for constraint: string
        if (!is_null($billOfLading) && !is_string($billOfLading)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billOfLading, true), gettype($billOfLading)), __LINE__);
        }
        $this->billOfLading = $billOfLading;
        return $this;
    }
    /**
     * Get landedCostList value
     * @return \StructType\InboundShipmentLandedCostList|null
     */
    public function getLandedCostList()
    {
        return $this->landedCostList;
    }
    /**
     * Set landedCostList value
     * @param \StructType\InboundShipmentLandedCostList $landedCostList
     * @return \StructType\InboundShipment
     */
    public function setLandedCostList(\StructType\InboundShipmentLandedCostList $landedCostList = null)
    {
        $this->landedCostList = $landedCostList;
        return $this;
    }
    /**
     * Get itemsList value
     * @return \StructType\InboundShipmentItemsList|null
     */
    public function getItemsList()
    {
        return $this->itemsList;
    }
    /**
     * Set itemsList value
     * @param \StructType\InboundShipmentItemsList $itemsList
     * @return \StructType\InboundShipment
     */
    public function setItemsList(\StructType\InboundShipmentItemsList $itemsList = null)
    {
        $this->itemsList = $itemsList;
        return $this;
    }
    /**
     * Get shipmentBaseCurrency value
     * @return \StructType\RecordRef|null
     */
    public function getShipmentBaseCurrency()
    {
        return $this->shipmentBaseCurrency;
    }
    /**
     * Set shipmentBaseCurrency value
     * @param \StructType\RecordRef $shipmentBaseCurrency
     * @return \StructType\InboundShipment
     */
    public function setShipmentBaseCurrency(\StructType\RecordRef $shipmentBaseCurrency = null)
    {
        $this->shipmentBaseCurrency = $shipmentBaseCurrency;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\InboundShipment
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\InboundShipment
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\InboundShipment
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
