<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HcmJobSearch StructType
 * @subpackage Structs
 */
class HcmJobSearch extends SearchRecord
{
    /**
     * The basic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\HcmJobSearchBasic
     */
    public $basic;
    /**
     * The employeeJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmployeeSearchBasic
     */
    public $employeeJoin;
    /**
     * The customSearchJoin
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomSearchJoin[]
     */
    public $customSearchJoin;
    /**
     * Constructor method for HcmJobSearch
     * @uses HcmJobSearch::setBasic()
     * @uses HcmJobSearch::setEmployeeJoin()
     * @uses HcmJobSearch::setCustomSearchJoin()
     * @param \StructType\HcmJobSearchBasic $basic
     * @param \StructType\EmployeeSearchBasic $employeeJoin
     * @param \StructType\CustomSearchJoin[] $customSearchJoin
     */
    public function __construct(\StructType\HcmJobSearchBasic $basic = null, \StructType\EmployeeSearchBasic $employeeJoin = null, array $customSearchJoin = array())
    {
        $this
            ->setBasic($basic)
            ->setEmployeeJoin($employeeJoin)
            ->setCustomSearchJoin($customSearchJoin);
    }
    /**
     * Get basic value
     * @return \StructType\HcmJobSearchBasic|null
     */
    public function getBasic()
    {
        return $this->basic;
    }
    /**
     * Set basic value
     * @param \StructType\HcmJobSearchBasic $basic
     * @return \StructType\HcmJobSearch
     */
    public function setBasic(\StructType\HcmJobSearchBasic $basic = null)
    {
        $this->basic = $basic;
        return $this;
    }
    /**
     * Get employeeJoin value
     * @return \StructType\EmployeeSearchBasic|null
     */
    public function getEmployeeJoin()
    {
        return $this->employeeJoin;
    }
    /**
     * Set employeeJoin value
     * @param \StructType\EmployeeSearchBasic $employeeJoin
     * @return \StructType\HcmJobSearch
     */
    public function setEmployeeJoin(\StructType\EmployeeSearchBasic $employeeJoin = null)
    {
        $this->employeeJoin = $employeeJoin;
        return $this;
    }
    /**
     * Get customSearchJoin value
     * @return \StructType\CustomSearchJoin[]|null
     */
    public function getCustomSearchJoin()
    {
        return $this->customSearchJoin;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomSearchJoin method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomSearchJoin method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hcmJobSearchCustomSearchJoinItem) {
            // validation for constraint: itemType
            if (!$hcmJobSearchCustomSearchJoinItem instanceof \StructType\CustomSearchJoin) {
                $invalidValues[] = is_object($hcmJobSearchCustomSearchJoinItem) ? get_class($hcmJobSearchCustomSearchJoinItem) : sprintf('%s(%s)', gettype($hcmJobSearchCustomSearchJoinItem), var_export($hcmJobSearchCustomSearchJoinItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchJoin, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchJoin[] $customSearchJoin
     * @return \StructType\HcmJobSearch
     */
    public function setCustomSearchJoin(array $customSearchJoin = array())
    {
        // validation for constraint: array
        if ('' !== ($customSearchJoinArrayErrorMessage = self::validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin($customSearchJoin))) {
            throw new \InvalidArgumentException($customSearchJoinArrayErrorMessage, __LINE__);
        }
        $this->customSearchJoin = $customSearchJoin;
        return $this;
    }
    /**
     * Add item to customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchJoin $item
     * @return \StructType\HcmJobSearch
     */
    public function addToCustomSearchJoin(\StructType\CustomSearchJoin $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomSearchJoin) {
            throw new \InvalidArgumentException(sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchJoin, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customSearchJoin[] = $item;
        return $this;
    }
}
