<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GiftCertificateSearchRowBasic StructType
 * @subpackage Structs
 */
class GiftCertificateSearchRowBasic extends SearchRowBasic
{
    /**
     * The amountRemaining
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $amountRemaining;
    /**
     * The amtAvailBilled
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $amtAvailBilled;
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $createdDate;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $email;
    /**
     * The expirationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $expirationDate;
    /**
     * The gcActive
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $gcActive;
    /**
     * The giftCertCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $giftCertCode;
    /**
     * The incomeAcct
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $incomeAcct;
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $internalId;
    /**
     * The item
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $item;
    /**
     * The liabilityAcct
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $liabilityAcct;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $message;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $name;
    /**
     * The originalAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $originalAmount;
    /**
     * The purchaseDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $purchaseDate;
    /**
     * The sender
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $sender;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchColumnCustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for GiftCertificateSearchRowBasic
     * @uses GiftCertificateSearchRowBasic::setAmountRemaining()
     * @uses GiftCertificateSearchRowBasic::setAmtAvailBilled()
     * @uses GiftCertificateSearchRowBasic::setCreatedDate()
     * @uses GiftCertificateSearchRowBasic::setEmail()
     * @uses GiftCertificateSearchRowBasic::setExpirationDate()
     * @uses GiftCertificateSearchRowBasic::setGcActive()
     * @uses GiftCertificateSearchRowBasic::setGiftCertCode()
     * @uses GiftCertificateSearchRowBasic::setIncomeAcct()
     * @uses GiftCertificateSearchRowBasic::setInternalId()
     * @uses GiftCertificateSearchRowBasic::setItem()
     * @uses GiftCertificateSearchRowBasic::setLiabilityAcct()
     * @uses GiftCertificateSearchRowBasic::setMessage()
     * @uses GiftCertificateSearchRowBasic::setName()
     * @uses GiftCertificateSearchRowBasic::setOriginalAmount()
     * @uses GiftCertificateSearchRowBasic::setPurchaseDate()
     * @uses GiftCertificateSearchRowBasic::setSender()
     * @uses GiftCertificateSearchRowBasic::setCustomFieldList()
     * @param \StructType\SearchColumnDoubleField[] $amountRemaining
     * @param \StructType\SearchColumnDoubleField[] $amtAvailBilled
     * @param \StructType\SearchColumnDateField[] $createdDate
     * @param \StructType\SearchColumnStringField[] $email
     * @param \StructType\SearchColumnDateField[] $expirationDate
     * @param \StructType\SearchColumnBooleanField[] $gcActive
     * @param \StructType\SearchColumnStringField[] $giftCertCode
     * @param \StructType\SearchColumnStringField[] $incomeAcct
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @param \StructType\SearchColumnSelectField[] $item
     * @param \StructType\SearchColumnStringField[] $liabilityAcct
     * @param \StructType\SearchColumnStringField[] $message
     * @param \StructType\SearchColumnStringField[] $name
     * @param \StructType\SearchColumnDoubleField[] $originalAmount
     * @param \StructType\SearchColumnDateField[] $purchaseDate
     * @param \StructType\SearchColumnStringField[] $sender
     * @param \StructType\SearchColumnCustomFieldList $customFieldList
     */
    public function __construct(array $amountRemaining = array(), array $amtAvailBilled = array(), array $createdDate = array(), array $email = array(), array $expirationDate = array(), array $gcActive = array(), array $giftCertCode = array(), array $incomeAcct = array(), array $internalId = array(), array $item = array(), array $liabilityAcct = array(), array $message = array(), array $name = array(), array $originalAmount = array(), array $purchaseDate = array(), array $sender = array(), \StructType\SearchColumnCustomFieldList $customFieldList = null)
    {
        $this
            ->setAmountRemaining($amountRemaining)
            ->setAmtAvailBilled($amtAvailBilled)
            ->setCreatedDate($createdDate)
            ->setEmail($email)
            ->setExpirationDate($expirationDate)
            ->setGcActive($gcActive)
            ->setGiftCertCode($giftCertCode)
            ->setIncomeAcct($incomeAcct)
            ->setInternalId($internalId)
            ->setItem($item)
            ->setLiabilityAcct($liabilityAcct)
            ->setMessage($message)
            ->setName($name)
            ->setOriginalAmount($originalAmount)
            ->setPurchaseDate($purchaseDate)
            ->setSender($sender)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get amountRemaining value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getAmountRemaining()
    {
        return $this->amountRemaining;
    }
    /**
     * This method is responsible for validating the values passed to the setAmountRemaining method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAmountRemaining method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAmountRemainingForArrayConstraintsFromSetAmountRemaining(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $giftCertificateSearchRowBasicAmountRemainingItem) {
            // validation for constraint: itemType
            if (!$giftCertificateSearchRowBasicAmountRemainingItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($giftCertificateSearchRowBasicAmountRemainingItem) ? get_class($giftCertificateSearchRowBasicAmountRemainingItem) : sprintf('%s(%s)', gettype($giftCertificateSearchRowBasicAmountRemainingItem), var_export($giftCertificateSearchRowBasicAmountRemainingItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The amountRemaining property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set amountRemaining value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $amountRemaining
     * @return \StructType\GiftCertificateSearchRowBasic
     */
    public function setAmountRemaining(array $amountRemaining = array())
    {
        // validation for constraint: array
        if ('' !== ($amountRemainingArrayErrorMessage = self::validateAmountRemainingForArrayConstraintsFromSetAmountRemaining($amountRemaining))) {
            throw new \InvalidArgumentException($amountRemainingArrayErrorMessage, __LINE__);
        }
        $this->amountRemaining = $amountRemaining;
        return $this;
    }
    /**
     * Add item to amountRemaining value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\GiftCertificateSearchRowBasic
     */
    public function addToAmountRemaining(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The amountRemaining property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->amountRemaining[] = $item;
        return $this;
    }
    /**
     * Get amtAvailBilled value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getAmtAvailBilled()
    {
        return $this->amtAvailBilled;
    }
    /**
     * This method is responsible for validating the values passed to the setAmtAvailBilled method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAmtAvailBilled method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAmtAvailBilledForArrayConstraintsFromSetAmtAvailBilled(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $giftCertificateSearchRowBasicAmtAvailBilledItem) {
            // validation for constraint: itemType
            if (!$giftCertificateSearchRowBasicAmtAvailBilledItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($giftCertificateSearchRowBasicAmtAvailBilledItem) ? get_class($giftCertificateSearchRowBasicAmtAvailBilledItem) : sprintf('%s(%s)', gettype($giftCertificateSearchRowBasicAmtAvailBilledItem), var_export($giftCertificateSearchRowBasicAmtAvailBilledItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The amtAvailBilled property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set amtAvailBilled value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $amtAvailBilled
     * @return \StructType\GiftCertificateSearchRowBasic
     */
    public function setAmtAvailBilled(array $amtAvailBilled = array())
    {
        // validation for constraint: array
        if ('' !== ($amtAvailBilledArrayErrorMessage = self::validateAmtAvailBilledForArrayConstraintsFromSetAmtAvailBilled($amtAvailBilled))) {
            throw new \InvalidArgumentException($amtAvailBilledArrayErrorMessage, __LINE__);
        }
        $this->amtAvailBilled = $amtAvailBilled;
        return $this;
    }
    /**
     * Add item to amtAvailBilled value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\GiftCertificateSearchRowBasic
     */
    public function addToAmtAvailBilled(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The amtAvailBilled property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->amtAvailBilled[] = $item;
        return $this;
    }
    /**
     * Get createdDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * This method is responsible for validating the values passed to the setCreatedDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCreatedDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCreatedDateForArrayConstraintsFromSetCreatedDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $giftCertificateSearchRowBasicCreatedDateItem) {
            // validation for constraint: itemType
            if (!$giftCertificateSearchRowBasicCreatedDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($giftCertificateSearchRowBasicCreatedDateItem) ? get_class($giftCertificateSearchRowBasicCreatedDateItem) : sprintf('%s(%s)', gettype($giftCertificateSearchRowBasicCreatedDateItem), var_export($giftCertificateSearchRowBasicCreatedDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The createdDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set createdDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $createdDate
     * @return \StructType\GiftCertificateSearchRowBasic
     */
    public function setCreatedDate(array $createdDate = array())
    {
        // validation for constraint: array
        if ('' !== ($createdDateArrayErrorMessage = self::validateCreatedDateForArrayConstraintsFromSetCreatedDate($createdDate))) {
            throw new \InvalidArgumentException($createdDateArrayErrorMessage, __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Add item to createdDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\GiftCertificateSearchRowBasic
     */
    public function addToCreatedDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The createdDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->createdDate[] = $item;
        return $this;
    }
    /**
     * Get email value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * This method is responsible for validating the values passed to the setEmail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmailForArrayConstraintsFromSetEmail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $giftCertificateSearchRowBasicEmailItem) {
            // validation for constraint: itemType
            if (!$giftCertificateSearchRowBasicEmailItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($giftCertificateSearchRowBasicEmailItem) ? get_class($giftCertificateSearchRowBasicEmailItem) : sprintf('%s(%s)', gettype($giftCertificateSearchRowBasicEmailItem), var_export($giftCertificateSearchRowBasicEmailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The email property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set email value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $email
     * @return \StructType\GiftCertificateSearchRowBasic
     */
    public function setEmail(array $email = array())
    {
        // validation for constraint: array
        if ('' !== ($emailArrayErrorMessage = self::validateEmailForArrayConstraintsFromSetEmail($email))) {
            throw new \InvalidArgumentException($emailArrayErrorMessage, __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Add item to email value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\GiftCertificateSearchRowBasic
     */
    public function addToEmail(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The email property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->email[] = $item;
        return $this;
    }
    /**
     * Get expirationDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getExpirationDate()
    {
        return $this->expirationDate;
    }
    /**
     * This method is responsible for validating the values passed to the setExpirationDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpirationDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpirationDateForArrayConstraintsFromSetExpirationDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $giftCertificateSearchRowBasicExpirationDateItem) {
            // validation for constraint: itemType
            if (!$giftCertificateSearchRowBasicExpirationDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($giftCertificateSearchRowBasicExpirationDateItem) ? get_class($giftCertificateSearchRowBasicExpirationDateItem) : sprintf('%s(%s)', gettype($giftCertificateSearchRowBasicExpirationDateItem), var_export($giftCertificateSearchRowBasicExpirationDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The expirationDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set expirationDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $expirationDate
     * @return \StructType\GiftCertificateSearchRowBasic
     */
    public function setExpirationDate(array $expirationDate = array())
    {
        // validation for constraint: array
        if ('' !== ($expirationDateArrayErrorMessage = self::validateExpirationDateForArrayConstraintsFromSetExpirationDate($expirationDate))) {
            throw new \InvalidArgumentException($expirationDateArrayErrorMessage, __LINE__);
        }
        $this->expirationDate = $expirationDate;
        return $this;
    }
    /**
     * Add item to expirationDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\GiftCertificateSearchRowBasic
     */
    public function addToExpirationDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The expirationDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->expirationDate[] = $item;
        return $this;
    }
    /**
     * Get gcActive value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getGcActive()
    {
        return $this->gcActive;
    }
    /**
     * This method is responsible for validating the values passed to the setGcActive method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGcActive method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGcActiveForArrayConstraintsFromSetGcActive(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $giftCertificateSearchRowBasicGcActiveItem) {
            // validation for constraint: itemType
            if (!$giftCertificateSearchRowBasicGcActiveItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($giftCertificateSearchRowBasicGcActiveItem) ? get_class($giftCertificateSearchRowBasicGcActiveItem) : sprintf('%s(%s)', gettype($giftCertificateSearchRowBasicGcActiveItem), var_export($giftCertificateSearchRowBasicGcActiveItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The gcActive property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set gcActive value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $gcActive
     * @return \StructType\GiftCertificateSearchRowBasic
     */
    public function setGcActive(array $gcActive = array())
    {
        // validation for constraint: array
        if ('' !== ($gcActiveArrayErrorMessage = self::validateGcActiveForArrayConstraintsFromSetGcActive($gcActive))) {
            throw new \InvalidArgumentException($gcActiveArrayErrorMessage, __LINE__);
        }
        $this->gcActive = $gcActive;
        return $this;
    }
    /**
     * Add item to gcActive value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\GiftCertificateSearchRowBasic
     */
    public function addToGcActive(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The gcActive property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->gcActive[] = $item;
        return $this;
    }
    /**
     * Get giftCertCode value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getGiftCertCode()
    {
        return $this->giftCertCode;
    }
    /**
     * This method is responsible for validating the values passed to the setGiftCertCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGiftCertCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGiftCertCodeForArrayConstraintsFromSetGiftCertCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $giftCertificateSearchRowBasicGiftCertCodeItem) {
            // validation for constraint: itemType
            if (!$giftCertificateSearchRowBasicGiftCertCodeItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($giftCertificateSearchRowBasicGiftCertCodeItem) ? get_class($giftCertificateSearchRowBasicGiftCertCodeItem) : sprintf('%s(%s)', gettype($giftCertificateSearchRowBasicGiftCertCodeItem), var_export($giftCertificateSearchRowBasicGiftCertCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The giftCertCode property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set giftCertCode value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $giftCertCode
     * @return \StructType\GiftCertificateSearchRowBasic
     */
    public function setGiftCertCode(array $giftCertCode = array())
    {
        // validation for constraint: array
        if ('' !== ($giftCertCodeArrayErrorMessage = self::validateGiftCertCodeForArrayConstraintsFromSetGiftCertCode($giftCertCode))) {
            throw new \InvalidArgumentException($giftCertCodeArrayErrorMessage, __LINE__);
        }
        $this->giftCertCode = $giftCertCode;
        return $this;
    }
    /**
     * Add item to giftCertCode value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\GiftCertificateSearchRowBasic
     */
    public function addToGiftCertCode(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The giftCertCode property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->giftCertCode[] = $item;
        return $this;
    }
    /**
     * Get incomeAcct value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getIncomeAcct()
    {
        return $this->incomeAcct;
    }
    /**
     * This method is responsible for validating the values passed to the setIncomeAcct method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIncomeAcct method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIncomeAcctForArrayConstraintsFromSetIncomeAcct(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $giftCertificateSearchRowBasicIncomeAcctItem) {
            // validation for constraint: itemType
            if (!$giftCertificateSearchRowBasicIncomeAcctItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($giftCertificateSearchRowBasicIncomeAcctItem) ? get_class($giftCertificateSearchRowBasicIncomeAcctItem) : sprintf('%s(%s)', gettype($giftCertificateSearchRowBasicIncomeAcctItem), var_export($giftCertificateSearchRowBasicIncomeAcctItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The incomeAcct property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set incomeAcct value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $incomeAcct
     * @return \StructType\GiftCertificateSearchRowBasic
     */
    public function setIncomeAcct(array $incomeAcct = array())
    {
        // validation for constraint: array
        if ('' !== ($incomeAcctArrayErrorMessage = self::validateIncomeAcctForArrayConstraintsFromSetIncomeAcct($incomeAcct))) {
            throw new \InvalidArgumentException($incomeAcctArrayErrorMessage, __LINE__);
        }
        $this->incomeAcct = $incomeAcct;
        return $this;
    }
    /**
     * Add item to incomeAcct value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\GiftCertificateSearchRowBasic
     */
    public function addToIncomeAcct(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The incomeAcct property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->incomeAcct[] = $item;
        return $this;
    }
    /**
     * Get internalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * This method is responsible for validating the values passed to the setInternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternalIdForArrayConstraintsFromSetInternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $giftCertificateSearchRowBasicInternalIdItem) {
            // validation for constraint: itemType
            if (!$giftCertificateSearchRowBasicInternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($giftCertificateSearchRowBasicInternalIdItem) ? get_class($giftCertificateSearchRowBasicInternalIdItem) : sprintf('%s(%s)', gettype($giftCertificateSearchRowBasicInternalIdItem), var_export($giftCertificateSearchRowBasicInternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @return \StructType\GiftCertificateSearchRowBasic
     */
    public function setInternalId(array $internalId = array())
    {
        // validation for constraint: array
        if ('' !== ($internalIdArrayErrorMessage = self::validateInternalIdForArrayConstraintsFromSetInternalId($internalId))) {
            throw new \InvalidArgumentException($internalIdArrayErrorMessage, __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Add item to internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\GiftCertificateSearchRowBasic
     */
    public function addToInternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->internalId[] = $item;
        return $this;
    }
    /**
     * Get item value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * This method is responsible for validating the values passed to the setItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemForArrayConstraintsFromSetItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $giftCertificateSearchRowBasicItemItem) {
            // validation for constraint: itemType
            if (!$giftCertificateSearchRowBasicItemItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($giftCertificateSearchRowBasicItemItem) ? get_class($giftCertificateSearchRowBasicItemItem) : sprintf('%s(%s)', gettype($giftCertificateSearchRowBasicItemItem), var_export($giftCertificateSearchRowBasicItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The item property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set item value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $item
     * @return \StructType\GiftCertificateSearchRowBasic
     */
    public function setItem(array $item = array())
    {
        // validation for constraint: array
        if ('' !== ($itemArrayErrorMessage = self::validateItemForArrayConstraintsFromSetItem($item))) {
            throw new \InvalidArgumentException($itemArrayErrorMessage, __LINE__);
        }
        $this->item = $item;
        return $this;
    }
    /**
     * Add item to item value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\GiftCertificateSearchRowBasic
     */
    public function addToItem(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The item property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->item[] = $item;
        return $this;
    }
    /**
     * Get liabilityAcct value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getLiabilityAcct()
    {
        return $this->liabilityAcct;
    }
    /**
     * This method is responsible for validating the values passed to the setLiabilityAcct method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLiabilityAcct method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLiabilityAcctForArrayConstraintsFromSetLiabilityAcct(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $giftCertificateSearchRowBasicLiabilityAcctItem) {
            // validation for constraint: itemType
            if (!$giftCertificateSearchRowBasicLiabilityAcctItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($giftCertificateSearchRowBasicLiabilityAcctItem) ? get_class($giftCertificateSearchRowBasicLiabilityAcctItem) : sprintf('%s(%s)', gettype($giftCertificateSearchRowBasicLiabilityAcctItem), var_export($giftCertificateSearchRowBasicLiabilityAcctItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The liabilityAcct property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set liabilityAcct value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $liabilityAcct
     * @return \StructType\GiftCertificateSearchRowBasic
     */
    public function setLiabilityAcct(array $liabilityAcct = array())
    {
        // validation for constraint: array
        if ('' !== ($liabilityAcctArrayErrorMessage = self::validateLiabilityAcctForArrayConstraintsFromSetLiabilityAcct($liabilityAcct))) {
            throw new \InvalidArgumentException($liabilityAcctArrayErrorMessage, __LINE__);
        }
        $this->liabilityAcct = $liabilityAcct;
        return $this;
    }
    /**
     * Add item to liabilityAcct value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\GiftCertificateSearchRowBasic
     */
    public function addToLiabilityAcct(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The liabilityAcct property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->liabilityAcct[] = $item;
        return $this;
    }
    /**
     * Get message value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * This method is responsible for validating the values passed to the setMessage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMessage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMessageForArrayConstraintsFromSetMessage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $giftCertificateSearchRowBasicMessageItem) {
            // validation for constraint: itemType
            if (!$giftCertificateSearchRowBasicMessageItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($giftCertificateSearchRowBasicMessageItem) ? get_class($giftCertificateSearchRowBasicMessageItem) : sprintf('%s(%s)', gettype($giftCertificateSearchRowBasicMessageItem), var_export($giftCertificateSearchRowBasicMessageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The message property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set message value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $message
     * @return \StructType\GiftCertificateSearchRowBasic
     */
    public function setMessage(array $message = array())
    {
        // validation for constraint: array
        if ('' !== ($messageArrayErrorMessage = self::validateMessageForArrayConstraintsFromSetMessage($message))) {
            throw new \InvalidArgumentException($messageArrayErrorMessage, __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Add item to message value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\GiftCertificateSearchRowBasic
     */
    public function addToMessage(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The message property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->message[] = $item;
        return $this;
    }
    /**
     * Get name value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * This method is responsible for validating the values passed to the setName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNameForArrayConstraintsFromSetName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $giftCertificateSearchRowBasicNameItem) {
            // validation for constraint: itemType
            if (!$giftCertificateSearchRowBasicNameItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($giftCertificateSearchRowBasicNameItem) ? get_class($giftCertificateSearchRowBasicNameItem) : sprintf('%s(%s)', gettype($giftCertificateSearchRowBasicNameItem), var_export($giftCertificateSearchRowBasicNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The name property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set name value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $name
     * @return \StructType\GiftCertificateSearchRowBasic
     */
    public function setName(array $name = array())
    {
        // validation for constraint: array
        if ('' !== ($nameArrayErrorMessage = self::validateNameForArrayConstraintsFromSetName($name))) {
            throw new \InvalidArgumentException($nameArrayErrorMessage, __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Add item to name value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\GiftCertificateSearchRowBasic
     */
    public function addToName(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The name property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->name[] = $item;
        return $this;
    }
    /**
     * Get originalAmount value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getOriginalAmount()
    {
        return $this->originalAmount;
    }
    /**
     * This method is responsible for validating the values passed to the setOriginalAmount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOriginalAmount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOriginalAmountForArrayConstraintsFromSetOriginalAmount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $giftCertificateSearchRowBasicOriginalAmountItem) {
            // validation for constraint: itemType
            if (!$giftCertificateSearchRowBasicOriginalAmountItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($giftCertificateSearchRowBasicOriginalAmountItem) ? get_class($giftCertificateSearchRowBasicOriginalAmountItem) : sprintf('%s(%s)', gettype($giftCertificateSearchRowBasicOriginalAmountItem), var_export($giftCertificateSearchRowBasicOriginalAmountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The originalAmount property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set originalAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $originalAmount
     * @return \StructType\GiftCertificateSearchRowBasic
     */
    public function setOriginalAmount(array $originalAmount = array())
    {
        // validation for constraint: array
        if ('' !== ($originalAmountArrayErrorMessage = self::validateOriginalAmountForArrayConstraintsFromSetOriginalAmount($originalAmount))) {
            throw new \InvalidArgumentException($originalAmountArrayErrorMessage, __LINE__);
        }
        $this->originalAmount = $originalAmount;
        return $this;
    }
    /**
     * Add item to originalAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\GiftCertificateSearchRowBasic
     */
    public function addToOriginalAmount(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The originalAmount property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->originalAmount[] = $item;
        return $this;
    }
    /**
     * Get purchaseDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getPurchaseDate()
    {
        return $this->purchaseDate;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchaseDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchaseDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchaseDateForArrayConstraintsFromSetPurchaseDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $giftCertificateSearchRowBasicPurchaseDateItem) {
            // validation for constraint: itemType
            if (!$giftCertificateSearchRowBasicPurchaseDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($giftCertificateSearchRowBasicPurchaseDateItem) ? get_class($giftCertificateSearchRowBasicPurchaseDateItem) : sprintf('%s(%s)', gettype($giftCertificateSearchRowBasicPurchaseDateItem), var_export($giftCertificateSearchRowBasicPurchaseDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The purchaseDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set purchaseDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $purchaseDate
     * @return \StructType\GiftCertificateSearchRowBasic
     */
    public function setPurchaseDate(array $purchaseDate = array())
    {
        // validation for constraint: array
        if ('' !== ($purchaseDateArrayErrorMessage = self::validatePurchaseDateForArrayConstraintsFromSetPurchaseDate($purchaseDate))) {
            throw new \InvalidArgumentException($purchaseDateArrayErrorMessage, __LINE__);
        }
        $this->purchaseDate = $purchaseDate;
        return $this;
    }
    /**
     * Add item to purchaseDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\GiftCertificateSearchRowBasic
     */
    public function addToPurchaseDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The purchaseDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->purchaseDate[] = $item;
        return $this;
    }
    /**
     * Get sender value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getSender()
    {
        return $this->sender;
    }
    /**
     * This method is responsible for validating the values passed to the setSender method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSender method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSenderForArrayConstraintsFromSetSender(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $giftCertificateSearchRowBasicSenderItem) {
            // validation for constraint: itemType
            if (!$giftCertificateSearchRowBasicSenderItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($giftCertificateSearchRowBasicSenderItem) ? get_class($giftCertificateSearchRowBasicSenderItem) : sprintf('%s(%s)', gettype($giftCertificateSearchRowBasicSenderItem), var_export($giftCertificateSearchRowBasicSenderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The sender property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set sender value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $sender
     * @return \StructType\GiftCertificateSearchRowBasic
     */
    public function setSender(array $sender = array())
    {
        // validation for constraint: array
        if ('' !== ($senderArrayErrorMessage = self::validateSenderForArrayConstraintsFromSetSender($sender))) {
            throw new \InvalidArgumentException($senderArrayErrorMessage, __LINE__);
        }
        $this->sender = $sender;
        return $this;
    }
    /**
     * Add item to sender value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\GiftCertificateSearchRowBasic
     */
    public function addToSender(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The sender property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->sender[] = $item;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\SearchColumnCustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\SearchColumnCustomFieldList $customFieldList
     * @return \StructType\GiftCertificateSearchRowBasic
     */
    public function setCustomFieldList(\StructType\SearchColumnCustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
