<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GiftCertificate StructType
 * Meta information extracted from the WSDL
 * - type: listAcct:GiftCertificate
 * @subpackage Structs
 */
class GiftCertificate extends Record
{
    /**
     * The giftCertCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $giftCertCode;
    /**
     * The sender
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sender;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * The expirationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $expirationDate;
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The originalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $originalAmount;
    /**
     * The amountRemaining
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amountRemaining;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * Constructor method for GiftCertificate
     * @uses GiftCertificate::setGiftCertCode()
     * @uses GiftCertificate::setSender()
     * @uses GiftCertificate::setName()
     * @uses GiftCertificate::setEmail()
     * @uses GiftCertificate::setMessage()
     * @uses GiftCertificate::setExpirationDate()
     * @uses GiftCertificate::setCreatedDate()
     * @uses GiftCertificate::setLastModifiedDate()
     * @uses GiftCertificate::setOriginalAmount()
     * @uses GiftCertificate::setAmountRemaining()
     * @uses GiftCertificate::setInternalId()
     * @param string $giftCertCode
     * @param string $sender
     * @param string $name
     * @param string $email
     * @param string $message
     * @param string $expirationDate
     * @param string $createdDate
     * @param string $lastModifiedDate
     * @param float $originalAmount
     * @param float $amountRemaining
     * @param string $internalId
     */
    public function __construct($giftCertCode = null, $sender = null, $name = null, $email = null, $message = null, $expirationDate = null, $createdDate = null, $lastModifiedDate = null, $originalAmount = null, $amountRemaining = null, $internalId = null)
    {
        $this
            ->setGiftCertCode($giftCertCode)
            ->setSender($sender)
            ->setName($name)
            ->setEmail($email)
            ->setMessage($message)
            ->setExpirationDate($expirationDate)
            ->setCreatedDate($createdDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setOriginalAmount($originalAmount)
            ->setAmountRemaining($amountRemaining)
            ->setInternalId($internalId);
    }
    /**
     * Get giftCertCode value
     * @return string|null
     */
    public function getGiftCertCode()
    {
        return $this->giftCertCode;
    }
    /**
     * Set giftCertCode value
     * @param string $giftCertCode
     * @return \StructType\GiftCertificate
     */
    public function setGiftCertCode($giftCertCode = null)
    {
        // validation for constraint: string
        if (!is_null($giftCertCode) && !is_string($giftCertCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftCertCode, true), gettype($giftCertCode)), __LINE__);
        }
        $this->giftCertCode = $giftCertCode;
        return $this;
    }
    /**
     * Get sender value
     * @return string|null
     */
    public function getSender()
    {
        return $this->sender;
    }
    /**
     * Set sender value
     * @param string $sender
     * @return \StructType\GiftCertificate
     */
    public function setSender($sender = null)
    {
        // validation for constraint: string
        if (!is_null($sender) && !is_string($sender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sender, true), gettype($sender)), __LINE__);
        }
        $this->sender = $sender;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\GiftCertificate
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\GiftCertificate
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\GiftCertificate
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get expirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->expirationDate;
    }
    /**
     * Set expirationDate value
     * @param string $expirationDate
     * @return \StructType\GiftCertificate
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        $this->expirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\GiftCertificate
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\GiftCertificate
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get originalAmount value
     * @return float|null
     */
    public function getOriginalAmount()
    {
        return $this->originalAmount;
    }
    /**
     * Set originalAmount value
     * @param float $originalAmount
     * @return \StructType\GiftCertificate
     */
    public function setOriginalAmount($originalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($originalAmount) && !(is_float($originalAmount) || is_numeric($originalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($originalAmount, true), gettype($originalAmount)), __LINE__);
        }
        $this->originalAmount = $originalAmount;
        return $this;
    }
    /**
     * Get amountRemaining value
     * @return float|null
     */
    public function getAmountRemaining()
    {
        return $this->amountRemaining;
    }
    /**
     * Set amountRemaining value
     * @param float $amountRemaining
     * @return \StructType\GiftCertificate
     */
    public function setAmountRemaining($amountRemaining = null)
    {
        // validation for constraint: float
        if (!is_null($amountRemaining) && !(is_float($amountRemaining) || is_numeric($amountRemaining))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountRemaining, true), gettype($amountRemaining)), __LINE__);
        }
        $this->amountRemaining = $amountRemaining;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\GiftCertificate
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
}
