<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetServerTimeResult StructType
 * @subpackage Structs
 */
class GetServerTimeResult extends AbstractStructBase
{
    /**
     * The status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - ref: platformCore:status
     * @var \StructType\Status
     */
    public $status;
    /**
     * The serverTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $serverTime;
    /**
     * Constructor method for GetServerTimeResult
     * @uses GetServerTimeResult::setStatus()
     * @uses GetServerTimeResult::setServerTime()
     * @param \StructType\Status $status
     * @param string $serverTime
     */
    public function __construct(\StructType\Status $status = null, $serverTime = null)
    {
        $this
            ->setStatus($status)
            ->setServerTime($serverTime);
    }
    /**
     * Get status value
     * @return \StructType\Status
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param \StructType\Status $status
     * @return \StructType\GetServerTimeResult
     */
    public function setStatus(\StructType\Status $status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Get serverTime value
     * @return string
     */
    public function getServerTime()
    {
        return $this->serverTime;
    }
    /**
     * Set serverTime value
     * @param string $serverTime
     * @return \StructType\GetServerTimeResult
     */
    public function setServerTime($serverTime = null)
    {
        // validation for constraint: string
        if (!is_null($serverTime) && !is_string($serverTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serverTime, true), gettype($serverTime)), __LINE__);
        }
        $this->serverTime = $serverTime;
        return $this;
    }
}
