<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSelectValueFilter StructType
 * @subpackage Structs
 */
class GetSelectValueFilter extends AbstractStructBase
{
    /**
     * The filterValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $filterValue;
    /**
     * The operator
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $operator;
    /**
     * Constructor method for GetSelectValueFilter
     * @uses GetSelectValueFilter::setFilterValue()
     * @uses GetSelectValueFilter::setOperator()
     * @param string $filterValue
     * @param string $operator
     */
    public function __construct($filterValue = null, $operator = null)
    {
        $this
            ->setFilterValue($filterValue)
            ->setOperator($operator);
    }
    /**
     * Get filterValue value
     * @return string
     */
    public function getFilterValue()
    {
        return $this->filterValue;
    }
    /**
     * Set filterValue value
     * @param string $filterValue
     * @return \StructType\GetSelectValueFilter
     */
    public function setFilterValue($filterValue = null)
    {
        // validation for constraint: string
        if (!is_null($filterValue) && !is_string($filterValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filterValue, true), gettype($filterValue)), __LINE__);
        }
        $this->filterValue = $filterValue;
        return $this;
    }
    /**
     * Get operator value
     * @return string
     */
    public function getOperator()
    {
        return $this->operator;
    }
    /**
     * Set operator value
     * @uses \EnumType\GetSelectValueFilterOperator::valueIsValid()
     * @uses \EnumType\GetSelectValueFilterOperator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operator
     * @return \StructType\GetSelectValueFilter
     */
    public function setOperator($operator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GetSelectValueFilterOperator::valueIsValid($operator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\GetSelectValueFilterOperator', is_array($operator) ? implode(', ', $operator) : var_export($operator, true), implode(', ', \EnumType\GetSelectValueFilterOperator::getValidValues())), __LINE__);
        }
        $this->operator = $operator;
        return $this;
    }
}
