<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSelectValueFieldDescription StructType
 * @subpackage Structs
 */
class GetSelectValueFieldDescription extends AbstractStructBase
{
    /**
     * The field
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $field;
    /**
     * The recordType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $recordType;
    /**
     * The customRecordType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customRecordType;
    /**
     * The customTransactionType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customTransactionType;
    /**
     * The sublist
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sublist;
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The filter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GetSelectValueFilter
     */
    public $filter;
    /**
     * The filterByValueList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GetSelectFilterByFieldValueList
     */
    public $filterByValueList;
    /**
     * Constructor method for GetSelectValueFieldDescription
     * @uses GetSelectValueFieldDescription::setField()
     * @uses GetSelectValueFieldDescription::setRecordType()
     * @uses GetSelectValueFieldDescription::setCustomRecordType()
     * @uses GetSelectValueFieldDescription::setCustomTransactionType()
     * @uses GetSelectValueFieldDescription::setSublist()
     * @uses GetSelectValueFieldDescription::setCustomForm()
     * @uses GetSelectValueFieldDescription::setFilter()
     * @uses GetSelectValueFieldDescription::setFilterByValueList()
     * @param string $field
     * @param string $recordType
     * @param \StructType\RecordRef $customRecordType
     * @param \StructType\RecordRef $customTransactionType
     * @param string $sublist
     * @param \StructType\RecordRef $customForm
     * @param \StructType\GetSelectValueFilter $filter
     * @param \StructType\GetSelectFilterByFieldValueList $filterByValueList
     */
    public function __construct($field = null, $recordType = null, \StructType\RecordRef $customRecordType = null, \StructType\RecordRef $customTransactionType = null, $sublist = null, \StructType\RecordRef $customForm = null, \StructType\GetSelectValueFilter $filter = null, \StructType\GetSelectFilterByFieldValueList $filterByValueList = null)
    {
        $this
            ->setField($field)
            ->setRecordType($recordType)
            ->setCustomRecordType($customRecordType)
            ->setCustomTransactionType($customTransactionType)
            ->setSublist($sublist)
            ->setCustomForm($customForm)
            ->setFilter($filter)
            ->setFilterByValueList($filterByValueList);
    }
    /**
     * Get field value
     * @return string
     */
    public function getField()
    {
        return $this->field;
    }
    /**
     * Set field value
     * @param string $field
     * @return \StructType\GetSelectValueFieldDescription
     */
    public function setField($field = null)
    {
        // validation for constraint: string
        if (!is_null($field) && !is_string($field)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($field, true), gettype($field)), __LINE__);
        }
        $this->field = $field;
        return $this;
    }
    /**
     * Get recordType value
     * @return string|null
     */
    public function getRecordType()
    {
        return $this->recordType;
    }
    /**
     * Set recordType value
     * @uses \EnumType\RecordType::valueIsValid()
     * @uses \EnumType\RecordType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $recordType
     * @return \StructType\GetSelectValueFieldDescription
     */
    public function setRecordType($recordType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RecordType::valueIsValid($recordType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RecordType', is_array($recordType) ? implode(', ', $recordType) : var_export($recordType, true), implode(', ', \EnumType\RecordType::getValidValues())), __LINE__);
        }
        $this->recordType = $recordType;
        return $this;
    }
    /**
     * Get customRecordType value
     * @return \StructType\RecordRef|null
     */
    public function getCustomRecordType()
    {
        return $this->customRecordType;
    }
    /**
     * Set customRecordType value
     * @param \StructType\RecordRef $customRecordType
     * @return \StructType\GetSelectValueFieldDescription
     */
    public function setCustomRecordType(\StructType\RecordRef $customRecordType = null)
    {
        $this->customRecordType = $customRecordType;
        return $this;
    }
    /**
     * Get customTransactionType value
     * @return \StructType\RecordRef|null
     */
    public function getCustomTransactionType()
    {
        return $this->customTransactionType;
    }
    /**
     * Set customTransactionType value
     * @param \StructType\RecordRef $customTransactionType
     * @return \StructType\GetSelectValueFieldDescription
     */
    public function setCustomTransactionType(\StructType\RecordRef $customTransactionType = null)
    {
        $this->customTransactionType = $customTransactionType;
        return $this;
    }
    /**
     * Get sublist value
     * @return string|null
     */
    public function getSublist()
    {
        return $this->sublist;
    }
    /**
     * Set sublist value
     * @param string $sublist
     * @return \StructType\GetSelectValueFieldDescription
     */
    public function setSublist($sublist = null)
    {
        // validation for constraint: string
        if (!is_null($sublist) && !is_string($sublist)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sublist, true), gettype($sublist)), __LINE__);
        }
        $this->sublist = $sublist;
        return $this;
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\GetSelectValueFieldDescription
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get filter value
     * @return \StructType\GetSelectValueFilter|null
     */
    public function getFilter()
    {
        return $this->filter;
    }
    /**
     * Set filter value
     * @param \StructType\GetSelectValueFilter $filter
     * @return \StructType\GetSelectValueFieldDescription
     */
    public function setFilter(\StructType\GetSelectValueFilter $filter = null)
    {
        $this->filter = $filter;
        return $this;
    }
    /**
     * Get filterByValueList value
     * @return \StructType\GetSelectFilterByFieldValueList|null
     */
    public function getFilterByValueList()
    {
        return $this->filterByValueList;
    }
    /**
     * Set filterByValueList value
     * @param \StructType\GetSelectFilterByFieldValueList $filterByValueList
     * @return \StructType\GetSelectValueFieldDescription
     */
    public function setFilterByValueList(\StructType\GetSelectFilterByFieldValueList $filterByValueList = null)
    {
        $this->filterByValueList = $filterByValueList;
        return $this;
    }
}
