<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetIntegrationGovernanceInfoResult StructType
 * @subpackage Structs
 */
class GetIntegrationGovernanceInfoResult extends AbstractStructBase
{
    /**
     * The status
     * Meta information extracted from the WSDL
     * - ref: platformCore:status
     * @var \StructType\Status
     */
    public $status;
    /**
     * The integrationConcurrencyLimit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $integrationConcurrencyLimit;
    /**
     * The limitType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $limitType;
    /**
     * Constructor method for GetIntegrationGovernanceInfoResult
     * @uses GetIntegrationGovernanceInfoResult::setStatus()
     * @uses GetIntegrationGovernanceInfoResult::setIntegrationConcurrencyLimit()
     * @uses GetIntegrationGovernanceInfoResult::setLimitType()
     * @param \StructType\Status $status
     * @param int $integrationConcurrencyLimit
     * @param string $limitType
     */
    public function __construct(\StructType\Status $status = null, $integrationConcurrencyLimit = null, $limitType = null)
    {
        $this
            ->setStatus($status)
            ->setIntegrationConcurrencyLimit($integrationConcurrencyLimit)
            ->setLimitType($limitType);
    }
    /**
     * Get status value
     * @return \StructType\Status|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param \StructType\Status $status
     * @return \StructType\GetIntegrationGovernanceInfoResult
     */
    public function setStatus(\StructType\Status $status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Get integrationConcurrencyLimit value
     * @return int|null
     */
    public function getIntegrationConcurrencyLimit()
    {
        return $this->integrationConcurrencyLimit;
    }
    /**
     * Set integrationConcurrencyLimit value
     * @param int $integrationConcurrencyLimit
     * @return \StructType\GetIntegrationGovernanceInfoResult
     */
    public function setIntegrationConcurrencyLimit($integrationConcurrencyLimit = null)
    {
        // validation for constraint: int
        if (!is_null($integrationConcurrencyLimit) && !(is_int($integrationConcurrencyLimit) || ctype_digit($integrationConcurrencyLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($integrationConcurrencyLimit, true), gettype($integrationConcurrencyLimit)), __LINE__);
        }
        $this->integrationConcurrencyLimit = $integrationConcurrencyLimit;
        return $this;
    }
    /**
     * Get limitType value
     * @return string|null
     */
    public function getLimitType()
    {
        return $this->limitType;
    }
    /**
     * Set limitType value
     * @uses \EnumType\GetIntegrationGovernanceInfoLimitType::valueIsValid()
     * @uses \EnumType\GetIntegrationGovernanceInfoLimitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $limitType
     * @return \StructType\GetIntegrationGovernanceInfoResult
     */
    public function setLimitType($limitType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GetIntegrationGovernanceInfoLimitType::valueIsValid($limitType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\GetIntegrationGovernanceInfoLimitType', is_array($limitType) ? implode(', ', $limitType) : var_export($limitType, true), implode(', ', \EnumType\GetIntegrationGovernanceInfoLimitType::getValidValues())), __LINE__);
        }
        $this->limitType = $limitType;
        return $this;
    }
}
