<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAccountGovernanceInfoResult StructType
 * @subpackage Structs
 */
class GetAccountGovernanceInfoResult extends AbstractStructBase
{
    /**
     * The status
     * Meta information extracted from the WSDL
     * - ref: platformCore:status
     * @var \StructType\Status
     */
    public $status;
    /**
     * The accountConcurrencyLimit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $accountConcurrencyLimit;
    /**
     * The unallocatedConcurrencyLimit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $unallocatedConcurrencyLimit;
    /**
     * Constructor method for GetAccountGovernanceInfoResult
     * @uses GetAccountGovernanceInfoResult::setStatus()
     * @uses GetAccountGovernanceInfoResult::setAccountConcurrencyLimit()
     * @uses GetAccountGovernanceInfoResult::setUnallocatedConcurrencyLimit()
     * @param \StructType\Status $status
     * @param int $accountConcurrencyLimit
     * @param int $unallocatedConcurrencyLimit
     */
    public function __construct(\StructType\Status $status = null, $accountConcurrencyLimit = null, $unallocatedConcurrencyLimit = null)
    {
        $this
            ->setStatus($status)
            ->setAccountConcurrencyLimit($accountConcurrencyLimit)
            ->setUnallocatedConcurrencyLimit($unallocatedConcurrencyLimit);
    }
    /**
     * Get status value
     * @return \StructType\Status|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param \StructType\Status $status
     * @return \StructType\GetAccountGovernanceInfoResult
     */
    public function setStatus(\StructType\Status $status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Get accountConcurrencyLimit value
     * @return int|null
     */
    public function getAccountConcurrencyLimit()
    {
        return $this->accountConcurrencyLimit;
    }
    /**
     * Set accountConcurrencyLimit value
     * @param int $accountConcurrencyLimit
     * @return \StructType\GetAccountGovernanceInfoResult
     */
    public function setAccountConcurrencyLimit($accountConcurrencyLimit = null)
    {
        // validation for constraint: int
        if (!is_null($accountConcurrencyLimit) && !(is_int($accountConcurrencyLimit) || ctype_digit($accountConcurrencyLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountConcurrencyLimit, true), gettype($accountConcurrencyLimit)), __LINE__);
        }
        $this->accountConcurrencyLimit = $accountConcurrencyLimit;
        return $this;
    }
    /**
     * Get unallocatedConcurrencyLimit value
     * @return int|null
     */
    public function getUnallocatedConcurrencyLimit()
    {
        return $this->unallocatedConcurrencyLimit;
    }
    /**
     * Set unallocatedConcurrencyLimit value
     * @param int $unallocatedConcurrencyLimit
     * @return \StructType\GetAccountGovernanceInfoResult
     */
    public function setUnallocatedConcurrencyLimit($unallocatedConcurrencyLimit = null)
    {
        // validation for constraint: int
        if (!is_null($unallocatedConcurrencyLimit) && !(is_int($unallocatedConcurrencyLimit) || ctype_digit($unallocatedConcurrencyLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($unallocatedConcurrencyLimit, true), gettype($unallocatedConcurrencyLimit)), __LINE__);
        }
        $this->unallocatedConcurrencyLimit = $unallocatedConcurrencyLimit;
        return $this;
    }
}
