<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EntityGroup StructType
 * Meta information extracted from the WSDL
 * - type: listRel:EntityGroup
 * @subpackage Structs
 */
class EntityGroup extends Record
{
    /**
     * The groupName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $groupName;
    /**
     * The groupType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $groupType;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The groupOwner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $groupOwner;
    /**
     * The isSavedSearch
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isSavedSearch;
    /**
     * The parentGroupType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $parentGroupType;
    /**
     * The savedSearch
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $savedSearch;
    /**
     * The isSalesTeam
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isSalesTeam;
    /**
     * The comments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $comments;
    /**
     * The isPrivate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isPrivate;
    /**
     * The restrictionGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $restrictionGroup;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The isSalesRep
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isSalesRep;
    /**
     * The isSupportRep
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isSupportRep;
    /**
     * The isProductTeam
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isProductTeam;
    /**
     * The isFunctionalTeam
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isFunctionalTeam;
    /**
     * The issueRole
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $issueRole;
    /**
     * The isManufacturingWorkCenter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isManufacturingWorkCenter;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiary;
    /**
     * The machineResources
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $machineResources;
    /**
     * The laborResources
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $laborResources;
    /**
     * The workCalendar
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $workCalendar;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for EntityGroup
     * @uses EntityGroup::setGroupName()
     * @uses EntityGroup::setGroupType()
     * @uses EntityGroup::setEmail()
     * @uses EntityGroup::setGroupOwner()
     * @uses EntityGroup::setIsSavedSearch()
     * @uses EntityGroup::setParentGroupType()
     * @uses EntityGroup::setSavedSearch()
     * @uses EntityGroup::setIsSalesTeam()
     * @uses EntityGroup::setComments()
     * @uses EntityGroup::setIsPrivate()
     * @uses EntityGroup::setRestrictionGroup()
     * @uses EntityGroup::setIsInactive()
     * @uses EntityGroup::setIsSalesRep()
     * @uses EntityGroup::setIsSupportRep()
     * @uses EntityGroup::setIsProductTeam()
     * @uses EntityGroup::setIsFunctionalTeam()
     * @uses EntityGroup::setIssueRole()
     * @uses EntityGroup::setIsManufacturingWorkCenter()
     * @uses EntityGroup::setSubsidiary()
     * @uses EntityGroup::setMachineResources()
     * @uses EntityGroup::setLaborResources()
     * @uses EntityGroup::setWorkCalendar()
     * @uses EntityGroup::setCustomFieldList()
     * @uses EntityGroup::setInternalId()
     * @uses EntityGroup::setExternalId()
     * @param string $groupName
     * @param string $groupType
     * @param string $email
     * @param \StructType\RecordRef $groupOwner
     * @param bool $isSavedSearch
     * @param string $parentGroupType
     * @param \StructType\RecordRef $savedSearch
     * @param bool $isSalesTeam
     * @param string $comments
     * @param bool $isPrivate
     * @param \StructType\RecordRef $restrictionGroup
     * @param bool $isInactive
     * @param bool $isSalesRep
     * @param bool $isSupportRep
     * @param bool $isProductTeam
     * @param bool $isFunctionalTeam
     * @param \StructType\RecordRef $issueRole
     * @param bool $isManufacturingWorkCenter
     * @param \StructType\RecordRef $subsidiary
     * @param float $machineResources
     * @param float $laborResources
     * @param \StructType\RecordRef $workCalendar
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($groupName = null, $groupType = null, $email = null, \StructType\RecordRef $groupOwner = null, $isSavedSearch = null, $parentGroupType = null, \StructType\RecordRef $savedSearch = null, $isSalesTeam = null, $comments = null, $isPrivate = null, \StructType\RecordRef $restrictionGroup = null, $isInactive = null, $isSalesRep = null, $isSupportRep = null, $isProductTeam = null, $isFunctionalTeam = null, \StructType\RecordRef $issueRole = null, $isManufacturingWorkCenter = null, \StructType\RecordRef $subsidiary = null, $machineResources = null, $laborResources = null, \StructType\RecordRef $workCalendar = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setGroupName($groupName)
            ->setGroupType($groupType)
            ->setEmail($email)
            ->setGroupOwner($groupOwner)
            ->setIsSavedSearch($isSavedSearch)
            ->setParentGroupType($parentGroupType)
            ->setSavedSearch($savedSearch)
            ->setIsSalesTeam($isSalesTeam)
            ->setComments($comments)
            ->setIsPrivate($isPrivate)
            ->setRestrictionGroup($restrictionGroup)
            ->setIsInactive($isInactive)
            ->setIsSalesRep($isSalesRep)
            ->setIsSupportRep($isSupportRep)
            ->setIsProductTeam($isProductTeam)
            ->setIsFunctionalTeam($isFunctionalTeam)
            ->setIssueRole($issueRole)
            ->setIsManufacturingWorkCenter($isManufacturingWorkCenter)
            ->setSubsidiary($subsidiary)
            ->setMachineResources($machineResources)
            ->setLaborResources($laborResources)
            ->setWorkCalendar($workCalendar)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get groupName value
     * @return string|null
     */
    public function getGroupName()
    {
        return $this->groupName;
    }
    /**
     * Set groupName value
     * @param string $groupName
     * @return \StructType\EntityGroup
     */
    public function setGroupName($groupName = null)
    {
        // validation for constraint: string
        if (!is_null($groupName) && !is_string($groupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupName, true), gettype($groupName)), __LINE__);
        }
        $this->groupName = $groupName;
        return $this;
    }
    /**
     * Get groupType value
     * @return string|null
     */
    public function getGroupType()
    {
        return $this->groupType;
    }
    /**
     * Set groupType value
     * @uses \EnumType\EntityGroupType::valueIsValid()
     * @uses \EnumType\EntityGroupType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $groupType
     * @return \StructType\EntityGroup
     */
    public function setGroupType($groupType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EntityGroupType::valueIsValid($groupType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EntityGroupType', is_array($groupType) ? implode(', ', $groupType) : var_export($groupType, true), implode(', ', \EnumType\EntityGroupType::getValidValues())), __LINE__);
        }
        $this->groupType = $groupType;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\EntityGroup
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get groupOwner value
     * @return \StructType\RecordRef|null
     */
    public function getGroupOwner()
    {
        return $this->groupOwner;
    }
    /**
     * Set groupOwner value
     * @param \StructType\RecordRef $groupOwner
     * @return \StructType\EntityGroup
     */
    public function setGroupOwner(\StructType\RecordRef $groupOwner = null)
    {
        $this->groupOwner = $groupOwner;
        return $this;
    }
    /**
     * Get isSavedSearch value
     * @return bool|null
     */
    public function getIsSavedSearch()
    {
        return $this->isSavedSearch;
    }
    /**
     * Set isSavedSearch value
     * @param bool $isSavedSearch
     * @return \StructType\EntityGroup
     */
    public function setIsSavedSearch($isSavedSearch = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSavedSearch) && !is_bool($isSavedSearch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSavedSearch, true), gettype($isSavedSearch)), __LINE__);
        }
        $this->isSavedSearch = $isSavedSearch;
        return $this;
    }
    /**
     * Get parentGroupType value
     * @return string|null
     */
    public function getParentGroupType()
    {
        return $this->parentGroupType;
    }
    /**
     * Set parentGroupType value
     * @uses \EnumType\EntityGroupType::valueIsValid()
     * @uses \EnumType\EntityGroupType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $parentGroupType
     * @return \StructType\EntityGroup
     */
    public function setParentGroupType($parentGroupType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EntityGroupType::valueIsValid($parentGroupType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EntityGroupType', is_array($parentGroupType) ? implode(', ', $parentGroupType) : var_export($parentGroupType, true), implode(', ', \EnumType\EntityGroupType::getValidValues())), __LINE__);
        }
        $this->parentGroupType = $parentGroupType;
        return $this;
    }
    /**
     * Get savedSearch value
     * @return \StructType\RecordRef|null
     */
    public function getSavedSearch()
    {
        return $this->savedSearch;
    }
    /**
     * Set savedSearch value
     * @param \StructType\RecordRef $savedSearch
     * @return \StructType\EntityGroup
     */
    public function setSavedSearch(\StructType\RecordRef $savedSearch = null)
    {
        $this->savedSearch = $savedSearch;
        return $this;
    }
    /**
     * Get isSalesTeam value
     * @return bool|null
     */
    public function getIsSalesTeam()
    {
        return $this->isSalesTeam;
    }
    /**
     * Set isSalesTeam value
     * @param bool $isSalesTeam
     * @return \StructType\EntityGroup
     */
    public function setIsSalesTeam($isSalesTeam = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSalesTeam) && !is_bool($isSalesTeam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSalesTeam, true), gettype($isSalesTeam)), __LINE__);
        }
        $this->isSalesTeam = $isSalesTeam;
        return $this;
    }
    /**
     * Get comments value
     * @return string|null
     */
    public function getComments()
    {
        return $this->comments;
    }
    /**
     * Set comments value
     * @param string $comments
     * @return \StructType\EntityGroup
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comments, true), gettype($comments)), __LINE__);
        }
        $this->comments = $comments;
        return $this;
    }
    /**
     * Get isPrivate value
     * @return bool|null
     */
    public function getIsPrivate()
    {
        return $this->isPrivate;
    }
    /**
     * Set isPrivate value
     * @param bool $isPrivate
     * @return \StructType\EntityGroup
     */
    public function setIsPrivate($isPrivate = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrivate) && !is_bool($isPrivate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrivate, true), gettype($isPrivate)), __LINE__);
        }
        $this->isPrivate = $isPrivate;
        return $this;
    }
    /**
     * Get restrictionGroup value
     * @return \StructType\RecordRef|null
     */
    public function getRestrictionGroup()
    {
        return $this->restrictionGroup;
    }
    /**
     * Set restrictionGroup value
     * @param \StructType\RecordRef $restrictionGroup
     * @return \StructType\EntityGroup
     */
    public function setRestrictionGroup(\StructType\RecordRef $restrictionGroup = null)
    {
        $this->restrictionGroup = $restrictionGroup;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\EntityGroup
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get isSalesRep value
     * @return bool|null
     */
    public function getIsSalesRep()
    {
        return $this->isSalesRep;
    }
    /**
     * Set isSalesRep value
     * @param bool $isSalesRep
     * @return \StructType\EntityGroup
     */
    public function setIsSalesRep($isSalesRep = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSalesRep) && !is_bool($isSalesRep)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSalesRep, true), gettype($isSalesRep)), __LINE__);
        }
        $this->isSalesRep = $isSalesRep;
        return $this;
    }
    /**
     * Get isSupportRep value
     * @return bool|null
     */
    public function getIsSupportRep()
    {
        return $this->isSupportRep;
    }
    /**
     * Set isSupportRep value
     * @param bool $isSupportRep
     * @return \StructType\EntityGroup
     */
    public function setIsSupportRep($isSupportRep = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSupportRep) && !is_bool($isSupportRep)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSupportRep, true), gettype($isSupportRep)), __LINE__);
        }
        $this->isSupportRep = $isSupportRep;
        return $this;
    }
    /**
     * Get isProductTeam value
     * @return bool|null
     */
    public function getIsProductTeam()
    {
        return $this->isProductTeam;
    }
    /**
     * Set isProductTeam value
     * @param bool $isProductTeam
     * @return \StructType\EntityGroup
     */
    public function setIsProductTeam($isProductTeam = null)
    {
        // validation for constraint: boolean
        if (!is_null($isProductTeam) && !is_bool($isProductTeam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isProductTeam, true), gettype($isProductTeam)), __LINE__);
        }
        $this->isProductTeam = $isProductTeam;
        return $this;
    }
    /**
     * Get isFunctionalTeam value
     * @return bool|null
     */
    public function getIsFunctionalTeam()
    {
        return $this->isFunctionalTeam;
    }
    /**
     * Set isFunctionalTeam value
     * @param bool $isFunctionalTeam
     * @return \StructType\EntityGroup
     */
    public function setIsFunctionalTeam($isFunctionalTeam = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFunctionalTeam) && !is_bool($isFunctionalTeam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFunctionalTeam, true), gettype($isFunctionalTeam)), __LINE__);
        }
        $this->isFunctionalTeam = $isFunctionalTeam;
        return $this;
    }
    /**
     * Get issueRole value
     * @return \StructType\RecordRef|null
     */
    public function getIssueRole()
    {
        return $this->issueRole;
    }
    /**
     * Set issueRole value
     * @param \StructType\RecordRef $issueRole
     * @return \StructType\EntityGroup
     */
    public function setIssueRole(\StructType\RecordRef $issueRole = null)
    {
        $this->issueRole = $issueRole;
        return $this;
    }
    /**
     * Get isManufacturingWorkCenter value
     * @return bool|null
     */
    public function getIsManufacturingWorkCenter()
    {
        return $this->isManufacturingWorkCenter;
    }
    /**
     * Set isManufacturingWorkCenter value
     * @param bool $isManufacturingWorkCenter
     * @return \StructType\EntityGroup
     */
    public function setIsManufacturingWorkCenter($isManufacturingWorkCenter = null)
    {
        // validation for constraint: boolean
        if (!is_null($isManufacturingWorkCenter) && !is_bool($isManufacturingWorkCenter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isManufacturingWorkCenter, true), gettype($isManufacturingWorkCenter)), __LINE__);
        }
        $this->isManufacturingWorkCenter = $isManufacturingWorkCenter;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\RecordRef $subsidiary
     * @return \StructType\EntityGroup
     */
    public function setSubsidiary(\StructType\RecordRef $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get machineResources value
     * @return float|null
     */
    public function getMachineResources()
    {
        return $this->machineResources;
    }
    /**
     * Set machineResources value
     * @param float $machineResources
     * @return \StructType\EntityGroup
     */
    public function setMachineResources($machineResources = null)
    {
        // validation for constraint: float
        if (!is_null($machineResources) && !(is_float($machineResources) || is_numeric($machineResources))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($machineResources, true), gettype($machineResources)), __LINE__);
        }
        $this->machineResources = $machineResources;
        return $this;
    }
    /**
     * Get laborResources value
     * @return float|null
     */
    public function getLaborResources()
    {
        return $this->laborResources;
    }
    /**
     * Set laborResources value
     * @param float $laborResources
     * @return \StructType\EntityGroup
     */
    public function setLaborResources($laborResources = null)
    {
        // validation for constraint: float
        if (!is_null($laborResources) && !(is_float($laborResources) || is_numeric($laborResources))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($laborResources, true), gettype($laborResources)), __LINE__);
        }
        $this->laborResources = $laborResources;
        return $this;
    }
    /**
     * Get workCalendar value
     * @return \StructType\RecordRef|null
     */
    public function getWorkCalendar()
    {
        return $this->workCalendar;
    }
    /**
     * Set workCalendar value
     * @param \StructType\RecordRef $workCalendar
     * @return \StructType\EntityGroup
     */
    public function setWorkCalendar(\StructType\RecordRef $workCalendar = null)
    {
        $this->workCalendar = $workCalendar;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\EntityGroup
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\EntityGroup
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\EntityGroup
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
