<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmployeeRatesList StructType
 * @subpackage Structs
 */
class EmployeeRatesList extends AbstractStructBase
{
    /**
     * The employeeRates
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EmployeeRates[]
     */
    public $employeeRates;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for EmployeeRatesList
     * @uses EmployeeRatesList::setEmployeeRates()
     * @uses EmployeeRatesList::setReplaceAll()
     * @param \StructType\EmployeeRates[] $employeeRates
     * @param bool $replaceAll
     */
    public function __construct(array $employeeRates = array(), $replaceAll = true)
    {
        $this
            ->setEmployeeRates($employeeRates)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get employeeRates value
     * @return \StructType\EmployeeRates[]|null
     */
    public function getEmployeeRates()
    {
        return $this->employeeRates;
    }
    /**
     * This method is responsible for validating the values passed to the setEmployeeRates method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmployeeRates method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmployeeRatesForArrayConstraintsFromSetEmployeeRates(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $employeeRatesListEmployeeRatesItem) {
            // validation for constraint: itemType
            if (!$employeeRatesListEmployeeRatesItem instanceof \StructType\EmployeeRates) {
                $invalidValues[] = is_object($employeeRatesListEmployeeRatesItem) ? get_class($employeeRatesListEmployeeRatesItem) : sprintf('%s(%s)', gettype($employeeRatesListEmployeeRatesItem), var_export($employeeRatesListEmployeeRatesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The employeeRates property can only contain items of type \StructType\EmployeeRates, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set employeeRates value
     * @throws \InvalidArgumentException
     * @param \StructType\EmployeeRates[] $employeeRates
     * @return \StructType\EmployeeRatesList
     */
    public function setEmployeeRates(array $employeeRates = array())
    {
        // validation for constraint: array
        if ('' !== ($employeeRatesArrayErrorMessage = self::validateEmployeeRatesForArrayConstraintsFromSetEmployeeRates($employeeRates))) {
            throw new \InvalidArgumentException($employeeRatesArrayErrorMessage, __LINE__);
        }
        $this->employeeRates = $employeeRates;
        return $this;
    }
    /**
     * Add item to employeeRates value
     * @throws \InvalidArgumentException
     * @param \StructType\EmployeeRates $item
     * @return \StructType\EmployeeRatesList
     */
    public function addToEmployeeRates(\StructType\EmployeeRates $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EmployeeRates) {
            throw new \InvalidArgumentException(sprintf('The employeeRates property can only contain items of type \StructType\EmployeeRates, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->employeeRates[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\EmployeeRatesList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
