<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmployeeRates StructType
 * @subpackage Structs
 */
class EmployeeRates extends AbstractStructBase
{
    /**
     * The entityCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entityCurrency;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $rate;
    /**
     * Constructor method for EmployeeRates
     * @uses EmployeeRates::setEntityCurrency()
     * @uses EmployeeRates::setRate()
     * @param \StructType\RecordRef $entityCurrency
     * @param float $rate
     */
    public function __construct(\StructType\RecordRef $entityCurrency = null, $rate = null)
    {
        $this
            ->setEntityCurrency($entityCurrency)
            ->setRate($rate);
    }
    /**
     * Get entityCurrency value
     * @return \StructType\RecordRef|null
     */
    public function getEntityCurrency()
    {
        return $this->entityCurrency;
    }
    /**
     * Set entityCurrency value
     * @param \StructType\RecordRef $entityCurrency
     * @return \StructType\EmployeeRates
     */
    public function setEntityCurrency(\StructType\RecordRef $entityCurrency = null)
    {
        $this->entityCurrency = $entityCurrency;
        return $this;
    }
    /**
     * Get rate value
     * @return float|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param float $rate
     * @return \StructType\EmployeeRates
     */
    public function setRate($rate = null)
    {
        // validation for constraint: float
        if (!is_null($rate) && !(is_float($rate) || is_numeric($rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
}
