<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Employee StructType
 * Meta information extracted from the WSDL
 * - type: listEmp:Employee
 * @subpackage Structs
 */
class Employee extends Record
{
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The template
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $template;
    /**
     * The entityId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $entityId;
    /**
     * The salutation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $salutation;
    /**
     * The firstName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $firstName;
    /**
     * The middleName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $middleName;
    /**
     * The lastName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastName;
    /**
     * The altName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $altName;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $phone;
    /**
     * The fax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fax;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The defaultAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $defaultAddress;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The phoneticName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $phoneticName;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The dateCreated
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateCreated;
    /**
     * The initials
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $initials;
    /**
     * The officePhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $officePhone;
    /**
     * The homePhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $homePhone;
    /**
     * The mobilePhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $mobilePhone;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiary;
    /**
     * The billingClass
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $billingClass;
    /**
     * The accountNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accountNumber;
    /**
     * The compensationCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $compensationCurrency;
    /**
     * The baseWageType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $baseWageType;
    /**
     * The baseWage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $baseWage;
    /**
     * The comments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $comments;
    /**
     * The globalSubscriptionStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $globalSubscriptionStatus;
    /**
     * The image
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $image;
    /**
     * The payFrequency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $payFrequency;
    /**
     * The lastPaidDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastPaidDate;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $currency;
    /**
     * The useTimeData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $useTimeData;
    /**
     * The usePerquest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $usePerquest;
    /**
     * The workplace
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $workplace;
    /**
     * The adpId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $adpId;
    /**
     * The directDeposit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $directDeposit;
    /**
     * The expenseLimit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $expenseLimit;
    /**
     * The purchaseOrderLimit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $purchaseOrderLimit;
    /**
     * The purchaseOrderApprovalLimit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $purchaseOrderApprovalLimit;
    /**
     * The socialSecurityNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $socialSecurityNumber;
    /**
     * The supervisor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $supervisor;
    /**
     * The approver
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $approver;
    /**
     * The approvalLimit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $approvalLimit;
    /**
     * The timeApprover
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $timeApprover;
    /**
     * The employeeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $employeeType;
    /**
     * The isSalesRep
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isSalesRep;
    /**
     * The salesRole
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $salesRole;
    /**
     * The isSupportRep
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isSupportRep;
    /**
     * The isJobResource
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isJobResource;
    /**
     * The laborCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $laborCost;
    /**
     * The birthDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $birthDate;
    /**
     * The hireDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $hireDate;
    /**
     * The releaseDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $releaseDate;
    /**
     * The terminationDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $terminationDetails;
    /**
     * The terminationReason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $terminationReason;
    /**
     * The terminationRegretted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $terminationRegretted;
    /**
     * The terminationCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $terminationCategory;
    /**
     * The timeOffPlan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $timeOffPlan;
    /**
     * The lastReviewDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastReviewDate;
    /**
     * The nextReviewDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nextReviewDate;
    /**
     * The title
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $title;
    /**
     * The employeeStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $employeeStatus;
    /**
     * The jobDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $jobDescription;
    /**
     * The workAssignment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $workAssignment;
    /**
     * The job
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $job;
    /**
     * The maritalStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $maritalStatus;
    /**
     * The ethnicity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $ethnicity;
    /**
     * The gender
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $gender;
    /**
     * The purchaseOrderApprover
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $purchaseOrderApprover;
    /**
     * The workCalendar
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $workCalendar;
    /**
     * The giveAccess
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $giveAccess;
    /**
     * The defaultExpenseReportCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $defaultExpenseReportCurrency;
    /**
     * The concurrentWebServicesUser
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $concurrentWebServicesUser;
    /**
     * The sendEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $sendEmail;
    /**
     * The hasOfflineAccess
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $hasOfflineAccess;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The password2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password2;
    /**
     * The requirePwdChange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $requirePwdChange;
    /**
     * The inheritIPRules
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $inheritIPRules;
    /**
     * The IPAddressRule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IPAddressRule;
    /**
     * The startDateTimeOffCalc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startDateTimeOffCalc;
    /**
     * The commissionPaymentPreference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $commissionPaymentPreference;
    /**
     * The billPay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $billPay;
    /**
     * The defaultAcctCorpCardExp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $defaultAcctCorpCardExp;
    /**
     * The eligibleForCommission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $eligibleForCommission;
    /**
     * The subscriptionsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmployeeSubscriptionsList
     */
    public $subscriptionsList;
    /**
     * The ratesList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmployeeRatesList
     */
    public $ratesList;
    /**
     * The addressbookList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmployeeAddressbookList
     */
    public $addressbookList;
    /**
     * The rolesList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmployeeRolesList
     */
    public $rolesList;
    /**
     * The hrEducationList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmployeeHrEducationList
     */
    public $hrEducationList;
    /**
     * The accruedTimeList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmployeeAccruedTimeList
     */
    public $accruedTimeList;
    /**
     * The directDepositList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmployeeDirectDepositList
     */
    public $directDepositList;
    /**
     * The currencyList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmployeeCurrencyList
     */
    public $currencyList;
    /**
     * The companyContributionList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmployeeCompanyContributionList
     */
    public $companyContributionList;
    /**
     * The earningList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmployeeEarningList
     */
    public $earningList;
    /**
     * The emergencyContactList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmployeeEmergencyContactList
     */
    public $emergencyContactList;
    /**
     * The hcmPositionList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmployeeHcmPositionList
     */
    public $hcmPositionList;
    /**
     * The deductionList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmployeeDeductionList
     */
    public $deductionList;
    /**
     * The isJobManager
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isJobManager;
    /**
     * The targetUtilization
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $targetUtilization;
    /**
     * The bonusTarget
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $bonusTarget;
    /**
     * The bonusTargetComment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bonusTargetComment;
    /**
     * The bonusTargetType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bonusTargetType;
    /**
     * The bonusTargetPayFrequency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bonusTargetPayFrequency;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for Employee
     * @uses Employee::setCustomForm()
     * @uses Employee::setTemplate()
     * @uses Employee::setEntityId()
     * @uses Employee::setSalutation()
     * @uses Employee::setFirstName()
     * @uses Employee::setMiddleName()
     * @uses Employee::setLastName()
     * @uses Employee::setAltName()
     * @uses Employee::setPhone()
     * @uses Employee::setFax()
     * @uses Employee::setEmail()
     * @uses Employee::setDefaultAddress()
     * @uses Employee::setIsInactive()
     * @uses Employee::setPhoneticName()
     * @uses Employee::setLastModifiedDate()
     * @uses Employee::setDateCreated()
     * @uses Employee::setInitials()
     * @uses Employee::setOfficePhone()
     * @uses Employee::setHomePhone()
     * @uses Employee::setMobilePhone()
     * @uses Employee::setDepartment()
     * @uses Employee::setClass()
     * @uses Employee::setLocation()
     * @uses Employee::setSubsidiary()
     * @uses Employee::setBillingClass()
     * @uses Employee::setAccountNumber()
     * @uses Employee::setCompensationCurrency()
     * @uses Employee::setBaseWageType()
     * @uses Employee::setBaseWage()
     * @uses Employee::setComments()
     * @uses Employee::setGlobalSubscriptionStatus()
     * @uses Employee::setImage()
     * @uses Employee::setPayFrequency()
     * @uses Employee::setLastPaidDate()
     * @uses Employee::setCurrency()
     * @uses Employee::setUseTimeData()
     * @uses Employee::setUsePerquest()
     * @uses Employee::setWorkplace()
     * @uses Employee::setAdpId()
     * @uses Employee::setDirectDeposit()
     * @uses Employee::setExpenseLimit()
     * @uses Employee::setPurchaseOrderLimit()
     * @uses Employee::setPurchaseOrderApprovalLimit()
     * @uses Employee::setSocialSecurityNumber()
     * @uses Employee::setSupervisor()
     * @uses Employee::setApprover()
     * @uses Employee::setApprovalLimit()
     * @uses Employee::setTimeApprover()
     * @uses Employee::setEmployeeType()
     * @uses Employee::setIsSalesRep()
     * @uses Employee::setSalesRole()
     * @uses Employee::setIsSupportRep()
     * @uses Employee::setIsJobResource()
     * @uses Employee::setLaborCost()
     * @uses Employee::setBirthDate()
     * @uses Employee::setHireDate()
     * @uses Employee::setReleaseDate()
     * @uses Employee::setTerminationDetails()
     * @uses Employee::setTerminationReason()
     * @uses Employee::setTerminationRegretted()
     * @uses Employee::setTerminationCategory()
     * @uses Employee::setTimeOffPlan()
     * @uses Employee::setLastReviewDate()
     * @uses Employee::setNextReviewDate()
     * @uses Employee::setTitle()
     * @uses Employee::setEmployeeStatus()
     * @uses Employee::setJobDescription()
     * @uses Employee::setWorkAssignment()
     * @uses Employee::setJob()
     * @uses Employee::setMaritalStatus()
     * @uses Employee::setEthnicity()
     * @uses Employee::setGender()
     * @uses Employee::setPurchaseOrderApprover()
     * @uses Employee::setWorkCalendar()
     * @uses Employee::setGiveAccess()
     * @uses Employee::setDefaultExpenseReportCurrency()
     * @uses Employee::setConcurrentWebServicesUser()
     * @uses Employee::setSendEmail()
     * @uses Employee::setHasOfflineAccess()
     * @uses Employee::setPassword()
     * @uses Employee::setPassword2()
     * @uses Employee::setRequirePwdChange()
     * @uses Employee::setInheritIPRules()
     * @uses Employee::setIPAddressRule()
     * @uses Employee::setStartDateTimeOffCalc()
     * @uses Employee::setCommissionPaymentPreference()
     * @uses Employee::setBillPay()
     * @uses Employee::setDefaultAcctCorpCardExp()
     * @uses Employee::setEligibleForCommission()
     * @uses Employee::setSubscriptionsList()
     * @uses Employee::setRatesList()
     * @uses Employee::setAddressbookList()
     * @uses Employee::setRolesList()
     * @uses Employee::setHrEducationList()
     * @uses Employee::setAccruedTimeList()
     * @uses Employee::setDirectDepositList()
     * @uses Employee::setCurrencyList()
     * @uses Employee::setCompanyContributionList()
     * @uses Employee::setEarningList()
     * @uses Employee::setEmergencyContactList()
     * @uses Employee::setHcmPositionList()
     * @uses Employee::setDeductionList()
     * @uses Employee::setIsJobManager()
     * @uses Employee::setTargetUtilization()
     * @uses Employee::setBonusTarget()
     * @uses Employee::setBonusTargetComment()
     * @uses Employee::setBonusTargetType()
     * @uses Employee::setBonusTargetPayFrequency()
     * @uses Employee::setCustomFieldList()
     * @uses Employee::setInternalId()
     * @uses Employee::setExternalId()
     * @param \StructType\RecordRef $customForm
     * @param \StructType\RecordRef $template
     * @param string $entityId
     * @param string $salutation
     * @param string $firstName
     * @param string $middleName
     * @param string $lastName
     * @param string $altName
     * @param string $phone
     * @param string $fax
     * @param string $email
     * @param string $defaultAddress
     * @param bool $isInactive
     * @param string $phoneticName
     * @param string $lastModifiedDate
     * @param string $dateCreated
     * @param string $initials
     * @param string $officePhone
     * @param string $homePhone
     * @param string $mobilePhone
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRef $subsidiary
     * @param \StructType\RecordRef $billingClass
     * @param string $accountNumber
     * @param string $compensationCurrency
     * @param string $baseWageType
     * @param float $baseWage
     * @param string $comments
     * @param string $globalSubscriptionStatus
     * @param \StructType\RecordRef $image
     * @param string $payFrequency
     * @param string $lastPaidDate
     * @param \StructType\RecordRef $currency
     * @param string $useTimeData
     * @param bool $usePerquest
     * @param \StructType\RecordRef $workplace
     * @param string $adpId
     * @param bool $directDeposit
     * @param float $expenseLimit
     * @param float $purchaseOrderLimit
     * @param float $purchaseOrderApprovalLimit
     * @param string $socialSecurityNumber
     * @param \StructType\RecordRef $supervisor
     * @param \StructType\RecordRef $approver
     * @param float $approvalLimit
     * @param \StructType\RecordRef $timeApprover
     * @param \StructType\RecordRef $employeeType
     * @param bool $isSalesRep
     * @param \StructType\RecordRef $salesRole
     * @param bool $isSupportRep
     * @param bool $isJobResource
     * @param float $laborCost
     * @param string $birthDate
     * @param string $hireDate
     * @param string $releaseDate
     * @param string $terminationDetails
     * @param \StructType\RecordRef $terminationReason
     * @param string $terminationRegretted
     * @param string $terminationCategory
     * @param \StructType\RecordRef $timeOffPlan
     * @param string $lastReviewDate
     * @param string $nextReviewDate
     * @param string $title
     * @param \StructType\RecordRef $employeeStatus
     * @param string $jobDescription
     * @param string $workAssignment
     * @param \StructType\RecordRef $job
     * @param \StructType\RecordRef $maritalStatus
     * @param \StructType\RecordRef $ethnicity
     * @param string $gender
     * @param \StructType\RecordRef $purchaseOrderApprover
     * @param \StructType\RecordRef $workCalendar
     * @param bool $giveAccess
     * @param \StructType\RecordRef $defaultExpenseReportCurrency
     * @param bool $concurrentWebServicesUser
     * @param bool $sendEmail
     * @param bool $hasOfflineAccess
     * @param string $password
     * @param string $password2
     * @param bool $requirePwdChange
     * @param bool $inheritIPRules
     * @param string $iPAddressRule
     * @param string $startDateTimeOffCalc
     * @param string $commissionPaymentPreference
     * @param bool $billPay
     * @param \StructType\RecordRef $defaultAcctCorpCardExp
     * @param bool $eligibleForCommission
     * @param \StructType\EmployeeSubscriptionsList $subscriptionsList
     * @param \StructType\EmployeeRatesList $ratesList
     * @param \StructType\EmployeeAddressbookList $addressbookList
     * @param \StructType\EmployeeRolesList $rolesList
     * @param \StructType\EmployeeHrEducationList $hrEducationList
     * @param \StructType\EmployeeAccruedTimeList $accruedTimeList
     * @param \StructType\EmployeeDirectDepositList $directDepositList
     * @param \StructType\EmployeeCurrencyList $currencyList
     * @param \StructType\EmployeeCompanyContributionList $companyContributionList
     * @param \StructType\EmployeeEarningList $earningList
     * @param \StructType\EmployeeEmergencyContactList $emergencyContactList
     * @param \StructType\EmployeeHcmPositionList $hcmPositionList
     * @param \StructType\EmployeeDeductionList $deductionList
     * @param bool $isJobManager
     * @param float $targetUtilization
     * @param float $bonusTarget
     * @param string $bonusTargetComment
     * @param string $bonusTargetType
     * @param string $bonusTargetPayFrequency
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct(\StructType\RecordRef $customForm = null, \StructType\RecordRef $template = null, $entityId = null, $salutation = null, $firstName = null, $middleName = null, $lastName = null, $altName = null, $phone = null, $fax = null, $email = null, $defaultAddress = null, $isInactive = null, $phoneticName = null, $lastModifiedDate = null, $dateCreated = null, $initials = null, $officePhone = null, $homePhone = null, $mobilePhone = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRef $location = null, \StructType\RecordRef $subsidiary = null, \StructType\RecordRef $billingClass = null, $accountNumber = null, $compensationCurrency = null, $baseWageType = null, $baseWage = null, $comments = null, $globalSubscriptionStatus = null, \StructType\RecordRef $image = null, $payFrequency = null, $lastPaidDate = null, \StructType\RecordRef $currency = null, $useTimeData = null, $usePerquest = null, \StructType\RecordRef $workplace = null, $adpId = null, $directDeposit = null, $expenseLimit = null, $purchaseOrderLimit = null, $purchaseOrderApprovalLimit = null, $socialSecurityNumber = null, \StructType\RecordRef $supervisor = null, \StructType\RecordRef $approver = null, $approvalLimit = null, \StructType\RecordRef $timeApprover = null, \StructType\RecordRef $employeeType = null, $isSalesRep = null, \StructType\RecordRef $salesRole = null, $isSupportRep = null, $isJobResource = null, $laborCost = null, $birthDate = null, $hireDate = null, $releaseDate = null, $terminationDetails = null, \StructType\RecordRef $terminationReason = null, $terminationRegretted = null, $terminationCategory = null, \StructType\RecordRef $timeOffPlan = null, $lastReviewDate = null, $nextReviewDate = null, $title = null, \StructType\RecordRef $employeeStatus = null, $jobDescription = null, $workAssignment = null, \StructType\RecordRef $job = null, \StructType\RecordRef $maritalStatus = null, \StructType\RecordRef $ethnicity = null, $gender = null, \StructType\RecordRef $purchaseOrderApprover = null, \StructType\RecordRef $workCalendar = null, $giveAccess = null, \StructType\RecordRef $defaultExpenseReportCurrency = null, $concurrentWebServicesUser = null, $sendEmail = null, $hasOfflineAccess = null, $password = null, $password2 = null, $requirePwdChange = null, $inheritIPRules = null, $iPAddressRule = null, $startDateTimeOffCalc = null, $commissionPaymentPreference = null, $billPay = null, \StructType\RecordRef $defaultAcctCorpCardExp = null, $eligibleForCommission = null, \StructType\EmployeeSubscriptionsList $subscriptionsList = null, \StructType\EmployeeRatesList $ratesList = null, \StructType\EmployeeAddressbookList $addressbookList = null, \StructType\EmployeeRolesList $rolesList = null, \StructType\EmployeeHrEducationList $hrEducationList = null, \StructType\EmployeeAccruedTimeList $accruedTimeList = null, \StructType\EmployeeDirectDepositList $directDepositList = null, \StructType\EmployeeCurrencyList $currencyList = null, \StructType\EmployeeCompanyContributionList $companyContributionList = null, \StructType\EmployeeEarningList $earningList = null, \StructType\EmployeeEmergencyContactList $emergencyContactList = null, \StructType\EmployeeHcmPositionList $hcmPositionList = null, \StructType\EmployeeDeductionList $deductionList = null, $isJobManager = null, $targetUtilization = null, $bonusTarget = null, $bonusTargetComment = null, $bonusTargetType = null, $bonusTargetPayFrequency = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCustomForm($customForm)
            ->setTemplate($template)
            ->setEntityId($entityId)
            ->setSalutation($salutation)
            ->setFirstName($firstName)
            ->setMiddleName($middleName)
            ->setLastName($lastName)
            ->setAltName($altName)
            ->setPhone($phone)
            ->setFax($fax)
            ->setEmail($email)
            ->setDefaultAddress($defaultAddress)
            ->setIsInactive($isInactive)
            ->setPhoneticName($phoneticName)
            ->setLastModifiedDate($lastModifiedDate)
            ->setDateCreated($dateCreated)
            ->setInitials($initials)
            ->setOfficePhone($officePhone)
            ->setHomePhone($homePhone)
            ->setMobilePhone($mobilePhone)
            ->setDepartment($department)
            ->setClass($class)
            ->setLocation($location)
            ->setSubsidiary($subsidiary)
            ->setBillingClass($billingClass)
            ->setAccountNumber($accountNumber)
            ->setCompensationCurrency($compensationCurrency)
            ->setBaseWageType($baseWageType)
            ->setBaseWage($baseWage)
            ->setComments($comments)
            ->setGlobalSubscriptionStatus($globalSubscriptionStatus)
            ->setImage($image)
            ->setPayFrequency($payFrequency)
            ->setLastPaidDate($lastPaidDate)
            ->setCurrency($currency)
            ->setUseTimeData($useTimeData)
            ->setUsePerquest($usePerquest)
            ->setWorkplace($workplace)
            ->setAdpId($adpId)
            ->setDirectDeposit($directDeposit)
            ->setExpenseLimit($expenseLimit)
            ->setPurchaseOrderLimit($purchaseOrderLimit)
            ->setPurchaseOrderApprovalLimit($purchaseOrderApprovalLimit)
            ->setSocialSecurityNumber($socialSecurityNumber)
            ->setSupervisor($supervisor)
            ->setApprover($approver)
            ->setApprovalLimit($approvalLimit)
            ->setTimeApprover($timeApprover)
            ->setEmployeeType($employeeType)
            ->setIsSalesRep($isSalesRep)
            ->setSalesRole($salesRole)
            ->setIsSupportRep($isSupportRep)
            ->setIsJobResource($isJobResource)
            ->setLaborCost($laborCost)
            ->setBirthDate($birthDate)
            ->setHireDate($hireDate)
            ->setReleaseDate($releaseDate)
            ->setTerminationDetails($terminationDetails)
            ->setTerminationReason($terminationReason)
            ->setTerminationRegretted($terminationRegretted)
            ->setTerminationCategory($terminationCategory)
            ->setTimeOffPlan($timeOffPlan)
            ->setLastReviewDate($lastReviewDate)
            ->setNextReviewDate($nextReviewDate)
            ->setTitle($title)
            ->setEmployeeStatus($employeeStatus)
            ->setJobDescription($jobDescription)
            ->setWorkAssignment($workAssignment)
            ->setJob($job)
            ->setMaritalStatus($maritalStatus)
            ->setEthnicity($ethnicity)
            ->setGender($gender)
            ->setPurchaseOrderApprover($purchaseOrderApprover)
            ->setWorkCalendar($workCalendar)
            ->setGiveAccess($giveAccess)
            ->setDefaultExpenseReportCurrency($defaultExpenseReportCurrency)
            ->setConcurrentWebServicesUser($concurrentWebServicesUser)
            ->setSendEmail($sendEmail)
            ->setHasOfflineAccess($hasOfflineAccess)
            ->setPassword($password)
            ->setPassword2($password2)
            ->setRequirePwdChange($requirePwdChange)
            ->setInheritIPRules($inheritIPRules)
            ->setIPAddressRule($iPAddressRule)
            ->setStartDateTimeOffCalc($startDateTimeOffCalc)
            ->setCommissionPaymentPreference($commissionPaymentPreference)
            ->setBillPay($billPay)
            ->setDefaultAcctCorpCardExp($defaultAcctCorpCardExp)
            ->setEligibleForCommission($eligibleForCommission)
            ->setSubscriptionsList($subscriptionsList)
            ->setRatesList($ratesList)
            ->setAddressbookList($addressbookList)
            ->setRolesList($rolesList)
            ->setHrEducationList($hrEducationList)
            ->setAccruedTimeList($accruedTimeList)
            ->setDirectDepositList($directDepositList)
            ->setCurrencyList($currencyList)
            ->setCompanyContributionList($companyContributionList)
            ->setEarningList($earningList)
            ->setEmergencyContactList($emergencyContactList)
            ->setHcmPositionList($hcmPositionList)
            ->setDeductionList($deductionList)
            ->setIsJobManager($isJobManager)
            ->setTargetUtilization($targetUtilization)
            ->setBonusTarget($bonusTarget)
            ->setBonusTargetComment($bonusTargetComment)
            ->setBonusTargetType($bonusTargetType)
            ->setBonusTargetPayFrequency($bonusTargetPayFrequency)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\Employee
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get template value
     * @return \StructType\RecordRef|null
     */
    public function getTemplate()
    {
        return $this->template;
    }
    /**
     * Set template value
     * @param \StructType\RecordRef $template
     * @return \StructType\Employee
     */
    public function setTemplate(\StructType\RecordRef $template = null)
    {
        $this->template = $template;
        return $this;
    }
    /**
     * Get entityId value
     * @return string|null
     */
    public function getEntityId()
    {
        return $this->entityId;
    }
    /**
     * Set entityId value
     * @param string $entityId
     * @return \StructType\Employee
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: string
        if (!is_null($entityId) && !is_string($entityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        $this->entityId = $entityId;
        return $this;
    }
    /**
     * Get salutation value
     * @return string|null
     */
    public function getSalutation()
    {
        return $this->salutation;
    }
    /**
     * Set salutation value
     * @param string $salutation
     * @return \StructType\Employee
     */
    public function setSalutation($salutation = null)
    {
        // validation for constraint: string
        if (!is_null($salutation) && !is_string($salutation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salutation, true), gettype($salutation)), __LINE__);
        }
        $this->salutation = $salutation;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \StructType\Employee
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get middleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->middleName;
    }
    /**
     * Set middleName value
     * @param string $middleName
     * @return \StructType\Employee
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middleName, true), gettype($middleName)), __LINE__);
        }
        $this->middleName = $middleName;
        return $this;
    }
    /**
     * Get lastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \StructType\Employee
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get altName value
     * @return string|null
     */
    public function getAltName()
    {
        return $this->altName;
    }
    /**
     * Set altName value
     * @param string $altName
     * @return \StructType\Employee
     */
    public function setAltName($altName = null)
    {
        // validation for constraint: string
        if (!is_null($altName) && !is_string($altName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($altName, true), gettype($altName)), __LINE__);
        }
        $this->altName = $altName;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \StructType\Employee
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->fax;
    }
    /**
     * Set fax value
     * @param string $fax
     * @return \StructType\Employee
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        $this->fax = $fax;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\Employee
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get defaultAddress value
     * @return string|null
     */
    public function getDefaultAddress()
    {
        return $this->defaultAddress;
    }
    /**
     * Set defaultAddress value
     * @param string $defaultAddress
     * @return \StructType\Employee
     */
    public function setDefaultAddress($defaultAddress = null)
    {
        // validation for constraint: string
        if (!is_null($defaultAddress) && !is_string($defaultAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultAddress, true), gettype($defaultAddress)), __LINE__);
        }
        $this->defaultAddress = $defaultAddress;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\Employee
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get phoneticName value
     * @return string|null
     */
    public function getPhoneticName()
    {
        return $this->phoneticName;
    }
    /**
     * Set phoneticName value
     * @param string $phoneticName
     * @return \StructType\Employee
     */
    public function setPhoneticName($phoneticName = null)
    {
        // validation for constraint: string
        if (!is_null($phoneticName) && !is_string($phoneticName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneticName, true), gettype($phoneticName)), __LINE__);
        }
        $this->phoneticName = $phoneticName;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\Employee
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get dateCreated value
     * @return string|null
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }
    /**
     * Set dateCreated value
     * @param string $dateCreated
     * @return \StructType\Employee
     */
    public function setDateCreated($dateCreated = null)
    {
        // validation for constraint: string
        if (!is_null($dateCreated) && !is_string($dateCreated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateCreated, true), gettype($dateCreated)), __LINE__);
        }
        $this->dateCreated = $dateCreated;
        return $this;
    }
    /**
     * Get initials value
     * @return string|null
     */
    public function getInitials()
    {
        return $this->initials;
    }
    /**
     * Set initials value
     * @param string $initials
     * @return \StructType\Employee
     */
    public function setInitials($initials = null)
    {
        // validation for constraint: string
        if (!is_null($initials) && !is_string($initials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($initials, true), gettype($initials)), __LINE__);
        }
        $this->initials = $initials;
        return $this;
    }
    /**
     * Get officePhone value
     * @return string|null
     */
    public function getOfficePhone()
    {
        return $this->officePhone;
    }
    /**
     * Set officePhone value
     * @param string $officePhone
     * @return \StructType\Employee
     */
    public function setOfficePhone($officePhone = null)
    {
        // validation for constraint: string
        if (!is_null($officePhone) && !is_string($officePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($officePhone, true), gettype($officePhone)), __LINE__);
        }
        $this->officePhone = $officePhone;
        return $this;
    }
    /**
     * Get homePhone value
     * @return string|null
     */
    public function getHomePhone()
    {
        return $this->homePhone;
    }
    /**
     * Set homePhone value
     * @param string $homePhone
     * @return \StructType\Employee
     */
    public function setHomePhone($homePhone = null)
    {
        // validation for constraint: string
        if (!is_null($homePhone) && !is_string($homePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homePhone, true), gettype($homePhone)), __LINE__);
        }
        $this->homePhone = $homePhone;
        return $this;
    }
    /**
     * Get mobilePhone value
     * @return string|null
     */
    public function getMobilePhone()
    {
        return $this->mobilePhone;
    }
    /**
     * Set mobilePhone value
     * @param string $mobilePhone
     * @return \StructType\Employee
     */
    public function setMobilePhone($mobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($mobilePhone) && !is_string($mobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobilePhone, true), gettype($mobilePhone)), __LINE__);
        }
        $this->mobilePhone = $mobilePhone;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\Employee
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\Employee
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\Employee
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\RecordRef $subsidiary
     * @return \StructType\Employee
     */
    public function setSubsidiary(\StructType\RecordRef $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get billingClass value
     * @return \StructType\RecordRef|null
     */
    public function getBillingClass()
    {
        return $this->billingClass;
    }
    /**
     * Set billingClass value
     * @param \StructType\RecordRef $billingClass
     * @return \StructType\Employee
     */
    public function setBillingClass(\StructType\RecordRef $billingClass = null)
    {
        $this->billingClass = $billingClass;
        return $this;
    }
    /**
     * Get accountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->accountNumber;
    }
    /**
     * Set accountNumber value
     * @param string $accountNumber
     * @return \StructType\Employee
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->accountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get compensationCurrency value
     * @return string|null
     */
    public function getCompensationCurrency()
    {
        return $this->compensationCurrency;
    }
    /**
     * Set compensationCurrency value
     * @uses \EnumType\EmployeeCompensationCurrency::valueIsValid()
     * @uses \EnumType\EmployeeCompensationCurrency::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $compensationCurrency
     * @return \StructType\Employee
     */
    public function setCompensationCurrency($compensationCurrency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EmployeeCompensationCurrency::valueIsValid($compensationCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EmployeeCompensationCurrency', is_array($compensationCurrency) ? implode(', ', $compensationCurrency) : var_export($compensationCurrency, true), implode(', ', \EnumType\EmployeeCompensationCurrency::getValidValues())), __LINE__);
        }
        $this->compensationCurrency = $compensationCurrency;
        return $this;
    }
    /**
     * Get baseWageType value
     * @return string|null
     */
    public function getBaseWageType()
    {
        return $this->baseWageType;
    }
    /**
     * Set baseWageType value
     * @uses \EnumType\EmployeeBaseWageType::valueIsValid()
     * @uses \EnumType\EmployeeBaseWageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $baseWageType
     * @return \StructType\Employee
     */
    public function setBaseWageType($baseWageType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EmployeeBaseWageType::valueIsValid($baseWageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EmployeeBaseWageType', is_array($baseWageType) ? implode(', ', $baseWageType) : var_export($baseWageType, true), implode(', ', \EnumType\EmployeeBaseWageType::getValidValues())), __LINE__);
        }
        $this->baseWageType = $baseWageType;
        return $this;
    }
    /**
     * Get baseWage value
     * @return float|null
     */
    public function getBaseWage()
    {
        return $this->baseWage;
    }
    /**
     * Set baseWage value
     * @param float $baseWage
     * @return \StructType\Employee
     */
    public function setBaseWage($baseWage = null)
    {
        // validation for constraint: float
        if (!is_null($baseWage) && !(is_float($baseWage) || is_numeric($baseWage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($baseWage, true), gettype($baseWage)), __LINE__);
        }
        $this->baseWage = $baseWage;
        return $this;
    }
    /**
     * Get comments value
     * @return string|null
     */
    public function getComments()
    {
        return $this->comments;
    }
    /**
     * Set comments value
     * @param string $comments
     * @return \StructType\Employee
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comments, true), gettype($comments)), __LINE__);
        }
        $this->comments = $comments;
        return $this;
    }
    /**
     * Get globalSubscriptionStatus value
     * @return string|null
     */
    public function getGlobalSubscriptionStatus()
    {
        return $this->globalSubscriptionStatus;
    }
    /**
     * Set globalSubscriptionStatus value
     * @uses \EnumType\GlobalSubscriptionStatus::valueIsValid()
     * @uses \EnumType\GlobalSubscriptionStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $globalSubscriptionStatus
     * @return \StructType\Employee
     */
    public function setGlobalSubscriptionStatus($globalSubscriptionStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GlobalSubscriptionStatus::valueIsValid($globalSubscriptionStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\GlobalSubscriptionStatus', is_array($globalSubscriptionStatus) ? implode(', ', $globalSubscriptionStatus) : var_export($globalSubscriptionStatus, true), implode(', ', \EnumType\GlobalSubscriptionStatus::getValidValues())), __LINE__);
        }
        $this->globalSubscriptionStatus = $globalSubscriptionStatus;
        return $this;
    }
    /**
     * Get image value
     * @return \StructType\RecordRef|null
     */
    public function getImage()
    {
        return $this->image;
    }
    /**
     * Set image value
     * @param \StructType\RecordRef $image
     * @return \StructType\Employee
     */
    public function setImage(\StructType\RecordRef $image = null)
    {
        $this->image = $image;
        return $this;
    }
    /**
     * Get payFrequency value
     * @return string|null
     */
    public function getPayFrequency()
    {
        return $this->payFrequency;
    }
    /**
     * Set payFrequency value
     * @uses \EnumType\EmployeePayFrequency::valueIsValid()
     * @uses \EnumType\EmployeePayFrequency::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $payFrequency
     * @return \StructType\Employee
     */
    public function setPayFrequency($payFrequency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EmployeePayFrequency::valueIsValid($payFrequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EmployeePayFrequency', is_array($payFrequency) ? implode(', ', $payFrequency) : var_export($payFrequency, true), implode(', ', \EnumType\EmployeePayFrequency::getValidValues())), __LINE__);
        }
        $this->payFrequency = $payFrequency;
        return $this;
    }
    /**
     * Get lastPaidDate value
     * @return string|null
     */
    public function getLastPaidDate()
    {
        return $this->lastPaidDate;
    }
    /**
     * Set lastPaidDate value
     * @param string $lastPaidDate
     * @return \StructType\Employee
     */
    public function setLastPaidDate($lastPaidDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastPaidDate) && !is_string($lastPaidDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastPaidDate, true), gettype($lastPaidDate)), __LINE__);
        }
        $this->lastPaidDate = $lastPaidDate;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\RecordRef|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \StructType\RecordRef $currency
     * @return \StructType\Employee
     */
    public function setCurrency(\StructType\RecordRef $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get useTimeData value
     * @return string|null
     */
    public function getUseTimeData()
    {
        return $this->useTimeData;
    }
    /**
     * Set useTimeData value
     * @uses \EnumType\EmployeeUseTimeData::valueIsValid()
     * @uses \EnumType\EmployeeUseTimeData::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useTimeData
     * @return \StructType\Employee
     */
    public function setUseTimeData($useTimeData = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EmployeeUseTimeData::valueIsValid($useTimeData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EmployeeUseTimeData', is_array($useTimeData) ? implode(', ', $useTimeData) : var_export($useTimeData, true), implode(', ', \EnumType\EmployeeUseTimeData::getValidValues())), __LINE__);
        }
        $this->useTimeData = $useTimeData;
        return $this;
    }
    /**
     * Get usePerquest value
     * @return bool|null
     */
    public function getUsePerquest()
    {
        return $this->usePerquest;
    }
    /**
     * Set usePerquest value
     * @param bool $usePerquest
     * @return \StructType\Employee
     */
    public function setUsePerquest($usePerquest = null)
    {
        // validation for constraint: boolean
        if (!is_null($usePerquest) && !is_bool($usePerquest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($usePerquest, true), gettype($usePerquest)), __LINE__);
        }
        $this->usePerquest = $usePerquest;
        return $this;
    }
    /**
     * Get workplace value
     * @return \StructType\RecordRef|null
     */
    public function getWorkplace()
    {
        return $this->workplace;
    }
    /**
     * Set workplace value
     * @param \StructType\RecordRef $workplace
     * @return \StructType\Employee
     */
    public function setWorkplace(\StructType\RecordRef $workplace = null)
    {
        $this->workplace = $workplace;
        return $this;
    }
    /**
     * Get adpId value
     * @return string|null
     */
    public function getAdpId()
    {
        return $this->adpId;
    }
    /**
     * Set adpId value
     * @param string $adpId
     * @return \StructType\Employee
     */
    public function setAdpId($adpId = null)
    {
        // validation for constraint: string
        if (!is_null($adpId) && !is_string($adpId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adpId, true), gettype($adpId)), __LINE__);
        }
        $this->adpId = $adpId;
        return $this;
    }
    /**
     * Get directDeposit value
     * @return bool|null
     */
    public function getDirectDeposit()
    {
        return $this->directDeposit;
    }
    /**
     * Set directDeposit value
     * @param bool $directDeposit
     * @return \StructType\Employee
     */
    public function setDirectDeposit($directDeposit = null)
    {
        // validation for constraint: boolean
        if (!is_null($directDeposit) && !is_bool($directDeposit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($directDeposit, true), gettype($directDeposit)), __LINE__);
        }
        $this->directDeposit = $directDeposit;
        return $this;
    }
    /**
     * Get expenseLimit value
     * @return float|null
     */
    public function getExpenseLimit()
    {
        return $this->expenseLimit;
    }
    /**
     * Set expenseLimit value
     * @param float $expenseLimit
     * @return \StructType\Employee
     */
    public function setExpenseLimit($expenseLimit = null)
    {
        // validation for constraint: float
        if (!is_null($expenseLimit) && !(is_float($expenseLimit) || is_numeric($expenseLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($expenseLimit, true), gettype($expenseLimit)), __LINE__);
        }
        $this->expenseLimit = $expenseLimit;
        return $this;
    }
    /**
     * Get purchaseOrderLimit value
     * @return float|null
     */
    public function getPurchaseOrderLimit()
    {
        return $this->purchaseOrderLimit;
    }
    /**
     * Set purchaseOrderLimit value
     * @param float $purchaseOrderLimit
     * @return \StructType\Employee
     */
    public function setPurchaseOrderLimit($purchaseOrderLimit = null)
    {
        // validation for constraint: float
        if (!is_null($purchaseOrderLimit) && !(is_float($purchaseOrderLimit) || is_numeric($purchaseOrderLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($purchaseOrderLimit, true), gettype($purchaseOrderLimit)), __LINE__);
        }
        $this->purchaseOrderLimit = $purchaseOrderLimit;
        return $this;
    }
    /**
     * Get purchaseOrderApprovalLimit value
     * @return float|null
     */
    public function getPurchaseOrderApprovalLimit()
    {
        return $this->purchaseOrderApprovalLimit;
    }
    /**
     * Set purchaseOrderApprovalLimit value
     * @param float $purchaseOrderApprovalLimit
     * @return \StructType\Employee
     */
    public function setPurchaseOrderApprovalLimit($purchaseOrderApprovalLimit = null)
    {
        // validation for constraint: float
        if (!is_null($purchaseOrderApprovalLimit) && !(is_float($purchaseOrderApprovalLimit) || is_numeric($purchaseOrderApprovalLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($purchaseOrderApprovalLimit, true), gettype($purchaseOrderApprovalLimit)), __LINE__);
        }
        $this->purchaseOrderApprovalLimit = $purchaseOrderApprovalLimit;
        return $this;
    }
    /**
     * Get socialSecurityNumber value
     * @return string|null
     */
    public function getSocialSecurityNumber()
    {
        return $this->socialSecurityNumber;
    }
    /**
     * Set socialSecurityNumber value
     * @param string $socialSecurityNumber
     * @return \StructType\Employee
     */
    public function setSocialSecurityNumber($socialSecurityNumber = null)
    {
        // validation for constraint: string
        if (!is_null($socialSecurityNumber) && !is_string($socialSecurityNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($socialSecurityNumber, true), gettype($socialSecurityNumber)), __LINE__);
        }
        $this->socialSecurityNumber = $socialSecurityNumber;
        return $this;
    }
    /**
     * Get supervisor value
     * @return \StructType\RecordRef|null
     */
    public function getSupervisor()
    {
        return $this->supervisor;
    }
    /**
     * Set supervisor value
     * @param \StructType\RecordRef $supervisor
     * @return \StructType\Employee
     */
    public function setSupervisor(\StructType\RecordRef $supervisor = null)
    {
        $this->supervisor = $supervisor;
        return $this;
    }
    /**
     * Get approver value
     * @return \StructType\RecordRef|null
     */
    public function getApprover()
    {
        return $this->approver;
    }
    /**
     * Set approver value
     * @param \StructType\RecordRef $approver
     * @return \StructType\Employee
     */
    public function setApprover(\StructType\RecordRef $approver = null)
    {
        $this->approver = $approver;
        return $this;
    }
    /**
     * Get approvalLimit value
     * @return float|null
     */
    public function getApprovalLimit()
    {
        return $this->approvalLimit;
    }
    /**
     * Set approvalLimit value
     * @param float $approvalLimit
     * @return \StructType\Employee
     */
    public function setApprovalLimit($approvalLimit = null)
    {
        // validation for constraint: float
        if (!is_null($approvalLimit) && !(is_float($approvalLimit) || is_numeric($approvalLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($approvalLimit, true), gettype($approvalLimit)), __LINE__);
        }
        $this->approvalLimit = $approvalLimit;
        return $this;
    }
    /**
     * Get timeApprover value
     * @return \StructType\RecordRef|null
     */
    public function getTimeApprover()
    {
        return $this->timeApprover;
    }
    /**
     * Set timeApprover value
     * @param \StructType\RecordRef $timeApprover
     * @return \StructType\Employee
     */
    public function setTimeApprover(\StructType\RecordRef $timeApprover = null)
    {
        $this->timeApprover = $timeApprover;
        return $this;
    }
    /**
     * Get employeeType value
     * @return \StructType\RecordRef|null
     */
    public function getEmployeeType()
    {
        return $this->employeeType;
    }
    /**
     * Set employeeType value
     * @param \StructType\RecordRef $employeeType
     * @return \StructType\Employee
     */
    public function setEmployeeType(\StructType\RecordRef $employeeType = null)
    {
        $this->employeeType = $employeeType;
        return $this;
    }
    /**
     * Get isSalesRep value
     * @return bool|null
     */
    public function getIsSalesRep()
    {
        return $this->isSalesRep;
    }
    /**
     * Set isSalesRep value
     * @param bool $isSalesRep
     * @return \StructType\Employee
     */
    public function setIsSalesRep($isSalesRep = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSalesRep) && !is_bool($isSalesRep)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSalesRep, true), gettype($isSalesRep)), __LINE__);
        }
        $this->isSalesRep = $isSalesRep;
        return $this;
    }
    /**
     * Get salesRole value
     * @return \StructType\RecordRef|null
     */
    public function getSalesRole()
    {
        return $this->salesRole;
    }
    /**
     * Set salesRole value
     * @param \StructType\RecordRef $salesRole
     * @return \StructType\Employee
     */
    public function setSalesRole(\StructType\RecordRef $salesRole = null)
    {
        $this->salesRole = $salesRole;
        return $this;
    }
    /**
     * Get isSupportRep value
     * @return bool|null
     */
    public function getIsSupportRep()
    {
        return $this->isSupportRep;
    }
    /**
     * Set isSupportRep value
     * @param bool $isSupportRep
     * @return \StructType\Employee
     */
    public function setIsSupportRep($isSupportRep = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSupportRep) && !is_bool($isSupportRep)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSupportRep, true), gettype($isSupportRep)), __LINE__);
        }
        $this->isSupportRep = $isSupportRep;
        return $this;
    }
    /**
     * Get isJobResource value
     * @return bool|null
     */
    public function getIsJobResource()
    {
        return $this->isJobResource;
    }
    /**
     * Set isJobResource value
     * @param bool $isJobResource
     * @return \StructType\Employee
     */
    public function setIsJobResource($isJobResource = null)
    {
        // validation for constraint: boolean
        if (!is_null($isJobResource) && !is_bool($isJobResource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isJobResource, true), gettype($isJobResource)), __LINE__);
        }
        $this->isJobResource = $isJobResource;
        return $this;
    }
    /**
     * Get laborCost value
     * @return float|null
     */
    public function getLaborCost()
    {
        return $this->laborCost;
    }
    /**
     * Set laborCost value
     * @param float $laborCost
     * @return \StructType\Employee
     */
    public function setLaborCost($laborCost = null)
    {
        // validation for constraint: float
        if (!is_null($laborCost) && !(is_float($laborCost) || is_numeric($laborCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($laborCost, true), gettype($laborCost)), __LINE__);
        }
        $this->laborCost = $laborCost;
        return $this;
    }
    /**
     * Get birthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->birthDate;
    }
    /**
     * Set birthDate value
     * @param string $birthDate
     * @return \StructType\Employee
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthDate, true), gettype($birthDate)), __LINE__);
        }
        $this->birthDate = $birthDate;
        return $this;
    }
    /**
     * Get hireDate value
     * @return string|null
     */
    public function getHireDate()
    {
        return $this->hireDate;
    }
    /**
     * Set hireDate value
     * @param string $hireDate
     * @return \StructType\Employee
     */
    public function setHireDate($hireDate = null)
    {
        // validation for constraint: string
        if (!is_null($hireDate) && !is_string($hireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hireDate, true), gettype($hireDate)), __LINE__);
        }
        $this->hireDate = $hireDate;
        return $this;
    }
    /**
     * Get releaseDate value
     * @return string|null
     */
    public function getReleaseDate()
    {
        return $this->releaseDate;
    }
    /**
     * Set releaseDate value
     * @param string $releaseDate
     * @return \StructType\Employee
     */
    public function setReleaseDate($releaseDate = null)
    {
        // validation for constraint: string
        if (!is_null($releaseDate) && !is_string($releaseDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($releaseDate, true), gettype($releaseDate)), __LINE__);
        }
        $this->releaseDate = $releaseDate;
        return $this;
    }
    /**
     * Get terminationDetails value
     * @return string|null
     */
    public function getTerminationDetails()
    {
        return $this->terminationDetails;
    }
    /**
     * Set terminationDetails value
     * @param string $terminationDetails
     * @return \StructType\Employee
     */
    public function setTerminationDetails($terminationDetails = null)
    {
        // validation for constraint: string
        if (!is_null($terminationDetails) && !is_string($terminationDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($terminationDetails, true), gettype($terminationDetails)), __LINE__);
        }
        $this->terminationDetails = $terminationDetails;
        return $this;
    }
    /**
     * Get terminationReason value
     * @return \StructType\RecordRef|null
     */
    public function getTerminationReason()
    {
        return $this->terminationReason;
    }
    /**
     * Set terminationReason value
     * @param \StructType\RecordRef $terminationReason
     * @return \StructType\Employee
     */
    public function setTerminationReason(\StructType\RecordRef $terminationReason = null)
    {
        $this->terminationReason = $terminationReason;
        return $this;
    }
    /**
     * Get terminationRegretted value
     * @return string|null
     */
    public function getTerminationRegretted()
    {
        return $this->terminationRegretted;
    }
    /**
     * Set terminationRegretted value
     * @uses \EnumType\EmployeeTerminationRegretted::valueIsValid()
     * @uses \EnumType\EmployeeTerminationRegretted::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $terminationRegretted
     * @return \StructType\Employee
     */
    public function setTerminationRegretted($terminationRegretted = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EmployeeTerminationRegretted::valueIsValid($terminationRegretted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EmployeeTerminationRegretted', is_array($terminationRegretted) ? implode(', ', $terminationRegretted) : var_export($terminationRegretted, true), implode(', ', \EnumType\EmployeeTerminationRegretted::getValidValues())), __LINE__);
        }
        $this->terminationRegretted = $terminationRegretted;
        return $this;
    }
    /**
     * Get terminationCategory value
     * @return string|null
     */
    public function getTerminationCategory()
    {
        return $this->terminationCategory;
    }
    /**
     * Set terminationCategory value
     * @uses \EnumType\EmployeeTerminationCategory::valueIsValid()
     * @uses \EnumType\EmployeeTerminationCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $terminationCategory
     * @return \StructType\Employee
     */
    public function setTerminationCategory($terminationCategory = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EmployeeTerminationCategory::valueIsValid($terminationCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EmployeeTerminationCategory', is_array($terminationCategory) ? implode(', ', $terminationCategory) : var_export($terminationCategory, true), implode(', ', \EnumType\EmployeeTerminationCategory::getValidValues())), __LINE__);
        }
        $this->terminationCategory = $terminationCategory;
        return $this;
    }
    /**
     * Get timeOffPlan value
     * @return \StructType\RecordRef|null
     */
    public function getTimeOffPlan()
    {
        return $this->timeOffPlan;
    }
    /**
     * Set timeOffPlan value
     * @param \StructType\RecordRef $timeOffPlan
     * @return \StructType\Employee
     */
    public function setTimeOffPlan(\StructType\RecordRef $timeOffPlan = null)
    {
        $this->timeOffPlan = $timeOffPlan;
        return $this;
    }
    /**
     * Get lastReviewDate value
     * @return string|null
     */
    public function getLastReviewDate()
    {
        return $this->lastReviewDate;
    }
    /**
     * Set lastReviewDate value
     * @param string $lastReviewDate
     * @return \StructType\Employee
     */
    public function setLastReviewDate($lastReviewDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastReviewDate) && !is_string($lastReviewDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastReviewDate, true), gettype($lastReviewDate)), __LINE__);
        }
        $this->lastReviewDate = $lastReviewDate;
        return $this;
    }
    /**
     * Get nextReviewDate value
     * @return string|null
     */
    public function getNextReviewDate()
    {
        return $this->nextReviewDate;
    }
    /**
     * Set nextReviewDate value
     * @param string $nextReviewDate
     * @return \StructType\Employee
     */
    public function setNextReviewDate($nextReviewDate = null)
    {
        // validation for constraint: string
        if (!is_null($nextReviewDate) && !is_string($nextReviewDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nextReviewDate, true), gettype($nextReviewDate)), __LINE__);
        }
        $this->nextReviewDate = $nextReviewDate;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\Employee
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get employeeStatus value
     * @return \StructType\RecordRef|null
     */
    public function getEmployeeStatus()
    {
        return $this->employeeStatus;
    }
    /**
     * Set employeeStatus value
     * @param \StructType\RecordRef $employeeStatus
     * @return \StructType\Employee
     */
    public function setEmployeeStatus(\StructType\RecordRef $employeeStatus = null)
    {
        $this->employeeStatus = $employeeStatus;
        return $this;
    }
    /**
     * Get jobDescription value
     * @return string|null
     */
    public function getJobDescription()
    {
        return $this->jobDescription;
    }
    /**
     * Set jobDescription value
     * @param string $jobDescription
     * @return \StructType\Employee
     */
    public function setJobDescription($jobDescription = null)
    {
        // validation for constraint: string
        if (!is_null($jobDescription) && !is_string($jobDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jobDescription, true), gettype($jobDescription)), __LINE__);
        }
        $this->jobDescription = $jobDescription;
        return $this;
    }
    /**
     * Get workAssignment value
     * @return string|null
     */
    public function getWorkAssignment()
    {
        return $this->workAssignment;
    }
    /**
     * Set workAssignment value
     * @uses \EnumType\EmployeeWorkAssignment::valueIsValid()
     * @uses \EnumType\EmployeeWorkAssignment::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $workAssignment
     * @return \StructType\Employee
     */
    public function setWorkAssignment($workAssignment = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EmployeeWorkAssignment::valueIsValid($workAssignment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EmployeeWorkAssignment', is_array($workAssignment) ? implode(', ', $workAssignment) : var_export($workAssignment, true), implode(', ', \EnumType\EmployeeWorkAssignment::getValidValues())), __LINE__);
        }
        $this->workAssignment = $workAssignment;
        return $this;
    }
    /**
     * Get job value
     * @return \StructType\RecordRef|null
     */
    public function getJob()
    {
        return $this->job;
    }
    /**
     * Set job value
     * @param \StructType\RecordRef $job
     * @return \StructType\Employee
     */
    public function setJob(\StructType\RecordRef $job = null)
    {
        $this->job = $job;
        return $this;
    }
    /**
     * Get maritalStatus value
     * @return \StructType\RecordRef|null
     */
    public function getMaritalStatus()
    {
        return $this->maritalStatus;
    }
    /**
     * Set maritalStatus value
     * @param \StructType\RecordRef $maritalStatus
     * @return \StructType\Employee
     */
    public function setMaritalStatus(\StructType\RecordRef $maritalStatus = null)
    {
        $this->maritalStatus = $maritalStatus;
        return $this;
    }
    /**
     * Get ethnicity value
     * @return \StructType\RecordRef|null
     */
    public function getEthnicity()
    {
        return $this->ethnicity;
    }
    /**
     * Set ethnicity value
     * @param \StructType\RecordRef $ethnicity
     * @return \StructType\Employee
     */
    public function setEthnicity(\StructType\RecordRef $ethnicity = null)
    {
        $this->ethnicity = $ethnicity;
        return $this;
    }
    /**
     * Get gender value
     * @return string|null
     */
    public function getGender()
    {
        return $this->gender;
    }
    /**
     * Set gender value
     * @uses \EnumType\Gender::valueIsValid()
     * @uses \EnumType\Gender::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gender
     * @return \StructType\Employee
     */
    public function setGender($gender = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Gender::valueIsValid($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Gender', is_array($gender) ? implode(', ', $gender) : var_export($gender, true), implode(', ', \EnumType\Gender::getValidValues())), __LINE__);
        }
        $this->gender = $gender;
        return $this;
    }
    /**
     * Get purchaseOrderApprover value
     * @return \StructType\RecordRef|null
     */
    public function getPurchaseOrderApprover()
    {
        return $this->purchaseOrderApprover;
    }
    /**
     * Set purchaseOrderApprover value
     * @param \StructType\RecordRef $purchaseOrderApprover
     * @return \StructType\Employee
     */
    public function setPurchaseOrderApprover(\StructType\RecordRef $purchaseOrderApprover = null)
    {
        $this->purchaseOrderApprover = $purchaseOrderApprover;
        return $this;
    }
    /**
     * Get workCalendar value
     * @return \StructType\RecordRef|null
     */
    public function getWorkCalendar()
    {
        return $this->workCalendar;
    }
    /**
     * Set workCalendar value
     * @param \StructType\RecordRef $workCalendar
     * @return \StructType\Employee
     */
    public function setWorkCalendar(\StructType\RecordRef $workCalendar = null)
    {
        $this->workCalendar = $workCalendar;
        return $this;
    }
    /**
     * Get giveAccess value
     * @return bool|null
     */
    public function getGiveAccess()
    {
        return $this->giveAccess;
    }
    /**
     * Set giveAccess value
     * @param bool $giveAccess
     * @return \StructType\Employee
     */
    public function setGiveAccess($giveAccess = null)
    {
        // validation for constraint: boolean
        if (!is_null($giveAccess) && !is_bool($giveAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($giveAccess, true), gettype($giveAccess)), __LINE__);
        }
        $this->giveAccess = $giveAccess;
        return $this;
    }
    /**
     * Get defaultExpenseReportCurrency value
     * @return \StructType\RecordRef|null
     */
    public function getDefaultExpenseReportCurrency()
    {
        return $this->defaultExpenseReportCurrency;
    }
    /**
     * Set defaultExpenseReportCurrency value
     * @param \StructType\RecordRef $defaultExpenseReportCurrency
     * @return \StructType\Employee
     */
    public function setDefaultExpenseReportCurrency(\StructType\RecordRef $defaultExpenseReportCurrency = null)
    {
        $this->defaultExpenseReportCurrency = $defaultExpenseReportCurrency;
        return $this;
    }
    /**
     * Get concurrentWebServicesUser value
     * @return bool|null
     */
    public function getConcurrentWebServicesUser()
    {
        return $this->concurrentWebServicesUser;
    }
    /**
     * Set concurrentWebServicesUser value
     * @param bool $concurrentWebServicesUser
     * @return \StructType\Employee
     */
    public function setConcurrentWebServicesUser($concurrentWebServicesUser = null)
    {
        // validation for constraint: boolean
        if (!is_null($concurrentWebServicesUser) && !is_bool($concurrentWebServicesUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($concurrentWebServicesUser, true), gettype($concurrentWebServicesUser)), __LINE__);
        }
        $this->concurrentWebServicesUser = $concurrentWebServicesUser;
        return $this;
    }
    /**
     * Get sendEmail value
     * @return bool|null
     */
    public function getSendEmail()
    {
        return $this->sendEmail;
    }
    /**
     * Set sendEmail value
     * @param bool $sendEmail
     * @return \StructType\Employee
     */
    public function setSendEmail($sendEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendEmail) && !is_bool($sendEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendEmail, true), gettype($sendEmail)), __LINE__);
        }
        $this->sendEmail = $sendEmail;
        return $this;
    }
    /**
     * Get hasOfflineAccess value
     * @return bool|null
     */
    public function getHasOfflineAccess()
    {
        return $this->hasOfflineAccess;
    }
    /**
     * Set hasOfflineAccess value
     * @param bool $hasOfflineAccess
     * @return \StructType\Employee
     */
    public function setHasOfflineAccess($hasOfflineAccess = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasOfflineAccess) && !is_bool($hasOfflineAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasOfflineAccess, true), gettype($hasOfflineAccess)), __LINE__);
        }
        $this->hasOfflineAccess = $hasOfflineAccess;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\Employee
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get password2 value
     * @return string|null
     */
    public function getPassword2()
    {
        return $this->password2;
    }
    /**
     * Set password2 value
     * @param string $password2
     * @return \StructType\Employee
     */
    public function setPassword2($password2 = null)
    {
        // validation for constraint: string
        if (!is_null($password2) && !is_string($password2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password2, true), gettype($password2)), __LINE__);
        }
        $this->password2 = $password2;
        return $this;
    }
    /**
     * Get requirePwdChange value
     * @return bool|null
     */
    public function getRequirePwdChange()
    {
        return $this->requirePwdChange;
    }
    /**
     * Set requirePwdChange value
     * @param bool $requirePwdChange
     * @return \StructType\Employee
     */
    public function setRequirePwdChange($requirePwdChange = null)
    {
        // validation for constraint: boolean
        if (!is_null($requirePwdChange) && !is_bool($requirePwdChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($requirePwdChange, true), gettype($requirePwdChange)), __LINE__);
        }
        $this->requirePwdChange = $requirePwdChange;
        return $this;
    }
    /**
     * Get inheritIPRules value
     * @return bool|null
     */
    public function getInheritIPRules()
    {
        return $this->inheritIPRules;
    }
    /**
     * Set inheritIPRules value
     * @param bool $inheritIPRules
     * @return \StructType\Employee
     */
    public function setInheritIPRules($inheritIPRules = null)
    {
        // validation for constraint: boolean
        if (!is_null($inheritIPRules) && !is_bool($inheritIPRules)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inheritIPRules, true), gettype($inheritIPRules)), __LINE__);
        }
        $this->inheritIPRules = $inheritIPRules;
        return $this;
    }
    /**
     * Get IPAddressRule value
     * @return string|null
     */
    public function getIPAddressRule()
    {
        return $this->IPAddressRule;
    }
    /**
     * Set IPAddressRule value
     * @param string $iPAddressRule
     * @return \StructType\Employee
     */
    public function setIPAddressRule($iPAddressRule = null)
    {
        // validation for constraint: string
        if (!is_null($iPAddressRule) && !is_string($iPAddressRule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iPAddressRule, true), gettype($iPAddressRule)), __LINE__);
        }
        $this->IPAddressRule = $iPAddressRule;
        return $this;
    }
    /**
     * Get startDateTimeOffCalc value
     * @return string|null
     */
    public function getStartDateTimeOffCalc()
    {
        return $this->startDateTimeOffCalc;
    }
    /**
     * Set startDateTimeOffCalc value
     * @param string $startDateTimeOffCalc
     * @return \StructType\Employee
     */
    public function setStartDateTimeOffCalc($startDateTimeOffCalc = null)
    {
        // validation for constraint: string
        if (!is_null($startDateTimeOffCalc) && !is_string($startDateTimeOffCalc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDateTimeOffCalc, true), gettype($startDateTimeOffCalc)), __LINE__);
        }
        $this->startDateTimeOffCalc = $startDateTimeOffCalc;
        return $this;
    }
    /**
     * Get commissionPaymentPreference value
     * @return string|null
     */
    public function getCommissionPaymentPreference()
    {
        return $this->commissionPaymentPreference;
    }
    /**
     * Set commissionPaymentPreference value
     * @uses \EnumType\EmployeeCommissionPaymentPreference::valueIsValid()
     * @uses \EnumType\EmployeeCommissionPaymentPreference::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $commissionPaymentPreference
     * @return \StructType\Employee
     */
    public function setCommissionPaymentPreference($commissionPaymentPreference = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EmployeeCommissionPaymentPreference::valueIsValid($commissionPaymentPreference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EmployeeCommissionPaymentPreference', is_array($commissionPaymentPreference) ? implode(', ', $commissionPaymentPreference) : var_export($commissionPaymentPreference, true), implode(', ', \EnumType\EmployeeCommissionPaymentPreference::getValidValues())), __LINE__);
        }
        $this->commissionPaymentPreference = $commissionPaymentPreference;
        return $this;
    }
    /**
     * Get billPay value
     * @return bool|null
     */
    public function getBillPay()
    {
        return $this->billPay;
    }
    /**
     * Set billPay value
     * @param bool $billPay
     * @return \StructType\Employee
     */
    public function setBillPay($billPay = null)
    {
        // validation for constraint: boolean
        if (!is_null($billPay) && !is_bool($billPay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($billPay, true), gettype($billPay)), __LINE__);
        }
        $this->billPay = $billPay;
        return $this;
    }
    /**
     * Get defaultAcctCorpCardExp value
     * @return \StructType\RecordRef|null
     */
    public function getDefaultAcctCorpCardExp()
    {
        return $this->defaultAcctCorpCardExp;
    }
    /**
     * Set defaultAcctCorpCardExp value
     * @param \StructType\RecordRef $defaultAcctCorpCardExp
     * @return \StructType\Employee
     */
    public function setDefaultAcctCorpCardExp(\StructType\RecordRef $defaultAcctCorpCardExp = null)
    {
        $this->defaultAcctCorpCardExp = $defaultAcctCorpCardExp;
        return $this;
    }
    /**
     * Get eligibleForCommission value
     * @return bool|null
     */
    public function getEligibleForCommission()
    {
        return $this->eligibleForCommission;
    }
    /**
     * Set eligibleForCommission value
     * @param bool $eligibleForCommission
     * @return \StructType\Employee
     */
    public function setEligibleForCommission($eligibleForCommission = null)
    {
        // validation for constraint: boolean
        if (!is_null($eligibleForCommission) && !is_bool($eligibleForCommission)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($eligibleForCommission, true), gettype($eligibleForCommission)), __LINE__);
        }
        $this->eligibleForCommission = $eligibleForCommission;
        return $this;
    }
    /**
     * Get subscriptionsList value
     * @return \StructType\EmployeeSubscriptionsList|null
     */
    public function getSubscriptionsList()
    {
        return $this->subscriptionsList;
    }
    /**
     * Set subscriptionsList value
     * @param \StructType\EmployeeSubscriptionsList $subscriptionsList
     * @return \StructType\Employee
     */
    public function setSubscriptionsList(\StructType\EmployeeSubscriptionsList $subscriptionsList = null)
    {
        $this->subscriptionsList = $subscriptionsList;
        return $this;
    }
    /**
     * Get ratesList value
     * @return \StructType\EmployeeRatesList|null
     */
    public function getRatesList()
    {
        return $this->ratesList;
    }
    /**
     * Set ratesList value
     * @param \StructType\EmployeeRatesList $ratesList
     * @return \StructType\Employee
     */
    public function setRatesList(\StructType\EmployeeRatesList $ratesList = null)
    {
        $this->ratesList = $ratesList;
        return $this;
    }
    /**
     * Get addressbookList value
     * @return \StructType\EmployeeAddressbookList|null
     */
    public function getAddressbookList()
    {
        return $this->addressbookList;
    }
    /**
     * Set addressbookList value
     * @param \StructType\EmployeeAddressbookList $addressbookList
     * @return \StructType\Employee
     */
    public function setAddressbookList(\StructType\EmployeeAddressbookList $addressbookList = null)
    {
        $this->addressbookList = $addressbookList;
        return $this;
    }
    /**
     * Get rolesList value
     * @return \StructType\EmployeeRolesList|null
     */
    public function getRolesList()
    {
        return $this->rolesList;
    }
    /**
     * Set rolesList value
     * @param \StructType\EmployeeRolesList $rolesList
     * @return \StructType\Employee
     */
    public function setRolesList(\StructType\EmployeeRolesList $rolesList = null)
    {
        $this->rolesList = $rolesList;
        return $this;
    }
    /**
     * Get hrEducationList value
     * @return \StructType\EmployeeHrEducationList|null
     */
    public function getHrEducationList()
    {
        return $this->hrEducationList;
    }
    /**
     * Set hrEducationList value
     * @param \StructType\EmployeeHrEducationList $hrEducationList
     * @return \StructType\Employee
     */
    public function setHrEducationList(\StructType\EmployeeHrEducationList $hrEducationList = null)
    {
        $this->hrEducationList = $hrEducationList;
        return $this;
    }
    /**
     * Get accruedTimeList value
     * @return \StructType\EmployeeAccruedTimeList|null
     */
    public function getAccruedTimeList()
    {
        return $this->accruedTimeList;
    }
    /**
     * Set accruedTimeList value
     * @param \StructType\EmployeeAccruedTimeList $accruedTimeList
     * @return \StructType\Employee
     */
    public function setAccruedTimeList(\StructType\EmployeeAccruedTimeList $accruedTimeList = null)
    {
        $this->accruedTimeList = $accruedTimeList;
        return $this;
    }
    /**
     * Get directDepositList value
     * @return \StructType\EmployeeDirectDepositList|null
     */
    public function getDirectDepositList()
    {
        return $this->directDepositList;
    }
    /**
     * Set directDepositList value
     * @param \StructType\EmployeeDirectDepositList $directDepositList
     * @return \StructType\Employee
     */
    public function setDirectDepositList(\StructType\EmployeeDirectDepositList $directDepositList = null)
    {
        $this->directDepositList = $directDepositList;
        return $this;
    }
    /**
     * Get currencyList value
     * @return \StructType\EmployeeCurrencyList|null
     */
    public function getCurrencyList()
    {
        return $this->currencyList;
    }
    /**
     * Set currencyList value
     * @param \StructType\EmployeeCurrencyList $currencyList
     * @return \StructType\Employee
     */
    public function setCurrencyList(\StructType\EmployeeCurrencyList $currencyList = null)
    {
        $this->currencyList = $currencyList;
        return $this;
    }
    /**
     * Get companyContributionList value
     * @return \StructType\EmployeeCompanyContributionList|null
     */
    public function getCompanyContributionList()
    {
        return $this->companyContributionList;
    }
    /**
     * Set companyContributionList value
     * @param \StructType\EmployeeCompanyContributionList $companyContributionList
     * @return \StructType\Employee
     */
    public function setCompanyContributionList(\StructType\EmployeeCompanyContributionList $companyContributionList = null)
    {
        $this->companyContributionList = $companyContributionList;
        return $this;
    }
    /**
     * Get earningList value
     * @return \StructType\EmployeeEarningList|null
     */
    public function getEarningList()
    {
        return $this->earningList;
    }
    /**
     * Set earningList value
     * @param \StructType\EmployeeEarningList $earningList
     * @return \StructType\Employee
     */
    public function setEarningList(\StructType\EmployeeEarningList $earningList = null)
    {
        $this->earningList = $earningList;
        return $this;
    }
    /**
     * Get emergencyContactList value
     * @return \StructType\EmployeeEmergencyContactList|null
     */
    public function getEmergencyContactList()
    {
        return $this->emergencyContactList;
    }
    /**
     * Set emergencyContactList value
     * @param \StructType\EmployeeEmergencyContactList $emergencyContactList
     * @return \StructType\Employee
     */
    public function setEmergencyContactList(\StructType\EmployeeEmergencyContactList $emergencyContactList = null)
    {
        $this->emergencyContactList = $emergencyContactList;
        return $this;
    }
    /**
     * Get hcmPositionList value
     * @return \StructType\EmployeeHcmPositionList|null
     */
    public function getHcmPositionList()
    {
        return $this->hcmPositionList;
    }
    /**
     * Set hcmPositionList value
     * @param \StructType\EmployeeHcmPositionList $hcmPositionList
     * @return \StructType\Employee
     */
    public function setHcmPositionList(\StructType\EmployeeHcmPositionList $hcmPositionList = null)
    {
        $this->hcmPositionList = $hcmPositionList;
        return $this;
    }
    /**
     * Get deductionList value
     * @return \StructType\EmployeeDeductionList|null
     */
    public function getDeductionList()
    {
        return $this->deductionList;
    }
    /**
     * Set deductionList value
     * @param \StructType\EmployeeDeductionList $deductionList
     * @return \StructType\Employee
     */
    public function setDeductionList(\StructType\EmployeeDeductionList $deductionList = null)
    {
        $this->deductionList = $deductionList;
        return $this;
    }
    /**
     * Get isJobManager value
     * @return bool|null
     */
    public function getIsJobManager()
    {
        return $this->isJobManager;
    }
    /**
     * Set isJobManager value
     * @param bool $isJobManager
     * @return \StructType\Employee
     */
    public function setIsJobManager($isJobManager = null)
    {
        // validation for constraint: boolean
        if (!is_null($isJobManager) && !is_bool($isJobManager)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isJobManager, true), gettype($isJobManager)), __LINE__);
        }
        $this->isJobManager = $isJobManager;
        return $this;
    }
    /**
     * Get targetUtilization value
     * @return float|null
     */
    public function getTargetUtilization()
    {
        return $this->targetUtilization;
    }
    /**
     * Set targetUtilization value
     * @param float $targetUtilization
     * @return \StructType\Employee
     */
    public function setTargetUtilization($targetUtilization = null)
    {
        // validation for constraint: float
        if (!is_null($targetUtilization) && !(is_float($targetUtilization) || is_numeric($targetUtilization))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($targetUtilization, true), gettype($targetUtilization)), __LINE__);
        }
        $this->targetUtilization = $targetUtilization;
        return $this;
    }
    /**
     * Get bonusTarget value
     * @return float|null
     */
    public function getBonusTarget()
    {
        return $this->bonusTarget;
    }
    /**
     * Set bonusTarget value
     * @param float $bonusTarget
     * @return \StructType\Employee
     */
    public function setBonusTarget($bonusTarget = null)
    {
        // validation for constraint: float
        if (!is_null($bonusTarget) && !(is_float($bonusTarget) || is_numeric($bonusTarget))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bonusTarget, true), gettype($bonusTarget)), __LINE__);
        }
        $this->bonusTarget = $bonusTarget;
        return $this;
    }
    /**
     * Get bonusTargetComment value
     * @return string|null
     */
    public function getBonusTargetComment()
    {
        return $this->bonusTargetComment;
    }
    /**
     * Set bonusTargetComment value
     * @param string $bonusTargetComment
     * @return \StructType\Employee
     */
    public function setBonusTargetComment($bonusTargetComment = null)
    {
        // validation for constraint: string
        if (!is_null($bonusTargetComment) && !is_string($bonusTargetComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bonusTargetComment, true), gettype($bonusTargetComment)), __LINE__);
        }
        $this->bonusTargetComment = $bonusTargetComment;
        return $this;
    }
    /**
     * Get bonusTargetType value
     * @return string|null
     */
    public function getBonusTargetType()
    {
        return $this->bonusTargetType;
    }
    /**
     * Set bonusTargetType value
     * @uses \EnumType\EmployeeBonusTargetType::valueIsValid()
     * @uses \EnumType\EmployeeBonusTargetType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bonusTargetType
     * @return \StructType\Employee
     */
    public function setBonusTargetType($bonusTargetType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EmployeeBonusTargetType::valueIsValid($bonusTargetType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EmployeeBonusTargetType', is_array($bonusTargetType) ? implode(', ', $bonusTargetType) : var_export($bonusTargetType, true), implode(', ', \EnumType\EmployeeBonusTargetType::getValidValues())), __LINE__);
        }
        $this->bonusTargetType = $bonusTargetType;
        return $this;
    }
    /**
     * Get bonusTargetPayFrequency value
     * @return string|null
     */
    public function getBonusTargetPayFrequency()
    {
        return $this->bonusTargetPayFrequency;
    }
    /**
     * Set bonusTargetPayFrequency value
     * @uses \EnumType\EmployeeBonusTargetPayFrequency::valueIsValid()
     * @uses \EnumType\EmployeeBonusTargetPayFrequency::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bonusTargetPayFrequency
     * @return \StructType\Employee
     */
    public function setBonusTargetPayFrequency($bonusTargetPayFrequency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EmployeeBonusTargetPayFrequency::valueIsValid($bonusTargetPayFrequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EmployeeBonusTargetPayFrequency', is_array($bonusTargetPayFrequency) ? implode(', ', $bonusTargetPayFrequency) : var_export($bonusTargetPayFrequency, true), implode(', ', \EnumType\EmployeeBonusTargetPayFrequency::getValidValues())), __LINE__);
        }
        $this->bonusTargetPayFrequency = $bonusTargetPayFrequency;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\Employee
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\Employee
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\Employee
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
