<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DepositPaymentList StructType
 * @subpackage Structs
 */
class DepositPaymentList extends AbstractStructBase
{
    /**
     * The depositPayment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DepositPayment[]
     */
    public $depositPayment;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for DepositPaymentList
     * @uses DepositPaymentList::setDepositPayment()
     * @uses DepositPaymentList::setReplaceAll()
     * @param \StructType\DepositPayment[] $depositPayment
     * @param bool $replaceAll
     */
    public function __construct(array $depositPayment = array(), $replaceAll = true)
    {
        $this
            ->setDepositPayment($depositPayment)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get depositPayment value
     * @return \StructType\DepositPayment[]|null
     */
    public function getDepositPayment()
    {
        return $this->depositPayment;
    }
    /**
     * This method is responsible for validating the values passed to the setDepositPayment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDepositPayment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDepositPaymentForArrayConstraintsFromSetDepositPayment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $depositPaymentListDepositPaymentItem) {
            // validation for constraint: itemType
            if (!$depositPaymentListDepositPaymentItem instanceof \StructType\DepositPayment) {
                $invalidValues[] = is_object($depositPaymentListDepositPaymentItem) ? get_class($depositPaymentListDepositPaymentItem) : sprintf('%s(%s)', gettype($depositPaymentListDepositPaymentItem), var_export($depositPaymentListDepositPaymentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The depositPayment property can only contain items of type \StructType\DepositPayment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set depositPayment value
     * @throws \InvalidArgumentException
     * @param \StructType\DepositPayment[] $depositPayment
     * @return \StructType\DepositPaymentList
     */
    public function setDepositPayment(array $depositPayment = array())
    {
        // validation for constraint: array
        if ('' !== ($depositPaymentArrayErrorMessage = self::validateDepositPaymentForArrayConstraintsFromSetDepositPayment($depositPayment))) {
            throw new \InvalidArgumentException($depositPaymentArrayErrorMessage, __LINE__);
        }
        $this->depositPayment = $depositPayment;
        return $this;
    }
    /**
     * Add item to depositPayment value
     * @throws \InvalidArgumentException
     * @param \StructType\DepositPayment $item
     * @return \StructType\DepositPaymentList
     */
    public function addToDepositPayment(\StructType\DepositPayment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DepositPayment) {
            throw new \InvalidArgumentException(sprintf('The depositPayment property can only contain items of type \StructType\DepositPayment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->depositPayment[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\DepositPaymentList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
