<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DepositOther StructType
 * @subpackage Structs
 */
class DepositOther extends AbstractStructBase
{
    /**
     * The entity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entity;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * The account
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $account;
    /**
     * The paymentMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $paymentMethod;
    /**
     * The refNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $refNum;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * Constructor method for DepositOther
     * @uses DepositOther::setEntity()
     * @uses DepositOther::setAmount()
     * @uses DepositOther::setAccount()
     * @uses DepositOther::setPaymentMethod()
     * @uses DepositOther::setRefNum()
     * @uses DepositOther::setDepartment()
     * @uses DepositOther::setClass()
     * @uses DepositOther::setLocation()
     * @uses DepositOther::setMemo()
     * @param \StructType\RecordRef $entity
     * @param float $amount
     * @param \StructType\RecordRef $account
     * @param \StructType\RecordRef $paymentMethod
     * @param string $refNum
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $location
     * @param string $memo
     */
    public function __construct(\StructType\RecordRef $entity = null, $amount = null, \StructType\RecordRef $account = null, \StructType\RecordRef $paymentMethod = null, $refNum = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRef $location = null, $memo = null)
    {
        $this
            ->setEntity($entity)
            ->setAmount($amount)
            ->setAccount($account)
            ->setPaymentMethod($paymentMethod)
            ->setRefNum($refNum)
            ->setDepartment($department)
            ->setClass($class)
            ->setLocation($location)
            ->setMemo($memo);
    }
    /**
     * Get entity value
     * @return \StructType\RecordRef|null
     */
    public function getEntity()
    {
        return $this->entity;
    }
    /**
     * Set entity value
     * @param \StructType\RecordRef $entity
     * @return \StructType\DepositOther
     */
    public function setEntity(\StructType\RecordRef $entity = null)
    {
        $this->entity = $entity;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\DepositOther
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get account value
     * @return \StructType\RecordRef|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * Set account value
     * @param \StructType\RecordRef $account
     * @return \StructType\DepositOther
     */
    public function setAccount(\StructType\RecordRef $account = null)
    {
        $this->account = $account;
        return $this;
    }
    /**
     * Get paymentMethod value
     * @return \StructType\RecordRef|null
     */
    public function getPaymentMethod()
    {
        return $this->paymentMethod;
    }
    /**
     * Set paymentMethod value
     * @param \StructType\RecordRef $paymentMethod
     * @return \StructType\DepositOther
     */
    public function setPaymentMethod(\StructType\RecordRef $paymentMethod = null)
    {
        $this->paymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get refNum value
     * @return string|null
     */
    public function getRefNum()
    {
        return $this->refNum;
    }
    /**
     * Set refNum value
     * @param string $refNum
     * @return \StructType\DepositOther
     */
    public function setRefNum($refNum = null)
    {
        // validation for constraint: string
        if (!is_null($refNum) && !is_string($refNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refNum, true), gettype($refNum)), __LINE__);
        }
        $this->refNum = $refNum;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\DepositOther
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\DepositOther
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\DepositOther
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\DepositOther
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
}
