<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeletedRecord StructType
 * @subpackage Structs
 */
class DeletedRecord extends AbstractStructBase
{
    /**
     * The deletedDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $deletedDate;
    /**
     * The record
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BaseRef
     */
    public $record;
    /**
     * Constructor method for DeletedRecord
     * @uses DeletedRecord::setDeletedDate()
     * @uses DeletedRecord::setRecord()
     * @param string $deletedDate
     * @param \StructType\BaseRef $record
     */
    public function __construct($deletedDate = null, \StructType\BaseRef $record = null)
    {
        $this
            ->setDeletedDate($deletedDate)
            ->setRecord($record);
    }
    /**
     * Get deletedDate value
     * @return string|null
     */
    public function getDeletedDate()
    {
        return $this->deletedDate;
    }
    /**
     * Set deletedDate value
     * @param string $deletedDate
     * @return \StructType\DeletedRecord
     */
    public function setDeletedDate($deletedDate = null)
    {
        // validation for constraint: string
        if (!is_null($deletedDate) && !is_string($deletedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deletedDate, true), gettype($deletedDate)), __LINE__);
        }
        $this->deletedDate = $deletedDate;
        return $this;
    }
    /**
     * Get record value
     * @return \StructType\BaseRef|null
     */
    public function getRecord()
    {
        return $this->record;
    }
    /**
     * Set record value
     * @param \StructType\BaseRef $record
     * @return \StructType\DeletedRecord
     */
    public function setRecord(\StructType\BaseRef $record = null)
    {
        $this->record = $record;
        return $this;
    }
}
