<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerDepositApplyList StructType
 * @subpackage Structs
 */
class CustomerDepositApplyList extends AbstractStructBase
{
    /**
     * The customerDepositApply
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerDepositApply[]
     */
    public $customerDepositApply;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for CustomerDepositApplyList
     * @uses CustomerDepositApplyList::setCustomerDepositApply()
     * @uses CustomerDepositApplyList::setReplaceAll()
     * @param \StructType\CustomerDepositApply[] $customerDepositApply
     * @param bool $replaceAll
     */
    public function __construct(array $customerDepositApply = array(), $replaceAll = true)
    {
        $this
            ->setCustomerDepositApply($customerDepositApply)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get customerDepositApply value
     * @return \StructType\CustomerDepositApply[]|null
     */
    public function getCustomerDepositApply()
    {
        return $this->customerDepositApply;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomerDepositApply method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomerDepositApply method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomerDepositApplyForArrayConstraintsFromSetCustomerDepositApply(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerDepositApplyListCustomerDepositApplyItem) {
            // validation for constraint: itemType
            if (!$customerDepositApplyListCustomerDepositApplyItem instanceof \StructType\CustomerDepositApply) {
                $invalidValues[] = is_object($customerDepositApplyListCustomerDepositApplyItem) ? get_class($customerDepositApplyListCustomerDepositApplyItem) : sprintf('%s(%s)', gettype($customerDepositApplyListCustomerDepositApplyItem), var_export($customerDepositApplyListCustomerDepositApplyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customerDepositApply property can only contain items of type \StructType\CustomerDepositApply, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customerDepositApply value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerDepositApply[] $customerDepositApply
     * @return \StructType\CustomerDepositApplyList
     */
    public function setCustomerDepositApply(array $customerDepositApply = array())
    {
        // validation for constraint: array
        if ('' !== ($customerDepositApplyArrayErrorMessage = self::validateCustomerDepositApplyForArrayConstraintsFromSetCustomerDepositApply($customerDepositApply))) {
            throw new \InvalidArgumentException($customerDepositApplyArrayErrorMessage, __LINE__);
        }
        $this->customerDepositApply = $customerDepositApply;
        return $this;
    }
    /**
     * Add item to customerDepositApply value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerDepositApply $item
     * @return \StructType\CustomerDepositApplyList
     */
    public function addToCustomerDepositApply(\StructType\CustomerDepositApply $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerDepositApply) {
            throw new \InvalidArgumentException(sprintf('The customerDepositApply property can only contain items of type \StructType\CustomerDepositApply, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customerDepositApply[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\CustomerDepositApplyList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
