<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerDeposit StructType
 * Meta information extracted from the WSDL
 * - type: tranCust:CustomerDeposit
 * @subpackage Structs
 */
class CustomerDeposit extends Record
{
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customer;
    /**
     * The salesOrder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $salesOrder;
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The payment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $payment;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $currency;
    /**
     * The tranDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranDate;
    /**
     * The postingPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $postingPeriod;
    /**
     * The paymentMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $paymentMethod;
    /**
     * The ccIsPurchaseCardBin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ccIsPurchaseCardBin;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The ccProcessAsPurchaseCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ccProcessAsPurchaseCard;
    /**
     * The currencyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currencyName;
    /**
     * The exchangeRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $exchangeRate;
    /**
     * The checkNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $checkNum;
    /**
     * The creditCardProcessor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $creditCardProcessor;
    /**
     * The creditCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $creditCard;
    /**
     * The ccSecurityCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ccSecurityCode;
    /**
     * The ccNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ccNumber;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiary;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The paymentOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $paymentOption;
    /**
     * The inputAuthCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $inputAuthCode;
    /**
     * The inputReferenceCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $inputReferenceCode;
    /**
     * The checkNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $checkNumber;
    /**
     * The paymentCardCsc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paymentCardCsc;
    /**
     * The paymentProcessingProfile
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $paymentProcessingProfile;
    /**
     * The handlingMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $handlingMode;
    /**
     * The outputAuthCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $outputAuthCode;
    /**
     * The outputReferenceCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $outputReferenceCode;
    /**
     * The paymentOperation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paymentOperation;
    /**
     * The dynamicDescriptor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dynamicDescriptor;
    /**
     * The ccExpireDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ccExpireDate;
    /**
     * The debitCardIssueNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $debitCardIssueNo;
    /**
     * The validFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $validFrom;
    /**
     * The ccName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ccName;
    /**
     * The ccStreet
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ccStreet;
    /**
     * The ccZipCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ccZipCode;
    /**
     * The chargeIt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $chargeIt;
    /**
     * The ccApproved
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ccApproved;
    /**
     * The pnRefNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pnRefNum;
    /**
     * The authCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $authCode;
    /**
     * The ccAvsStreetMatch
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ccAvsStreetMatch;
    /**
     * The softDescriptor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $softDescriptor;
    /**
     * The ccAvsZipMatch
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ccAvsZipMatch;
    /**
     * The isRecurringPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isRecurringPayment;
    /**
     * The ccSecurityCodeMatch
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ccSecurityCodeMatch;
    /**
     * The threeDStatusCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $threeDStatusCode;
    /**
     * The ignoreAvs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ignoreAvs;
    /**
     * The account
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $account;
    /**
     * The undepFunds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $undepFunds;
    /**
     * The tranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranId;
    /**
     * The applyList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomerDepositApplyList
     */
    public $applyList;
    /**
     * The accountingBookDetailList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccountingBookDetailList
     */
    public $accountingBookDetailList;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for CustomerDeposit
     * @uses CustomerDeposit::setCreatedDate()
     * @uses CustomerDeposit::setLastModifiedDate()
     * @uses CustomerDeposit::setStatus()
     * @uses CustomerDeposit::setCustomer()
     * @uses CustomerDeposit::setSalesOrder()
     * @uses CustomerDeposit::setCustomForm()
     * @uses CustomerDeposit::setPayment()
     * @uses CustomerDeposit::setCurrency()
     * @uses CustomerDeposit::setTranDate()
     * @uses CustomerDeposit::setPostingPeriod()
     * @uses CustomerDeposit::setPaymentMethod()
     * @uses CustomerDeposit::setCcIsPurchaseCardBin()
     * @uses CustomerDeposit::setMemo()
     * @uses CustomerDeposit::setCcProcessAsPurchaseCard()
     * @uses CustomerDeposit::setCurrencyName()
     * @uses CustomerDeposit::setExchangeRate()
     * @uses CustomerDeposit::setCheckNum()
     * @uses CustomerDeposit::setCreditCardProcessor()
     * @uses CustomerDeposit::setCreditCard()
     * @uses CustomerDeposit::setCcSecurityCode()
     * @uses CustomerDeposit::setCcNumber()
     * @uses CustomerDeposit::setSubsidiary()
     * @uses CustomerDeposit::setDepartment()
     * @uses CustomerDeposit::setClass()
     * @uses CustomerDeposit::setLocation()
     * @uses CustomerDeposit::setPaymentOption()
     * @uses CustomerDeposit::setInputAuthCode()
     * @uses CustomerDeposit::setInputReferenceCode()
     * @uses CustomerDeposit::setCheckNumber()
     * @uses CustomerDeposit::setPaymentCardCsc()
     * @uses CustomerDeposit::setPaymentProcessingProfile()
     * @uses CustomerDeposit::setHandlingMode()
     * @uses CustomerDeposit::setOutputAuthCode()
     * @uses CustomerDeposit::setOutputReferenceCode()
     * @uses CustomerDeposit::setPaymentOperation()
     * @uses CustomerDeposit::setDynamicDescriptor()
     * @uses CustomerDeposit::setCcExpireDate()
     * @uses CustomerDeposit::setDebitCardIssueNo()
     * @uses CustomerDeposit::setValidFrom()
     * @uses CustomerDeposit::setCcName()
     * @uses CustomerDeposit::setCcStreet()
     * @uses CustomerDeposit::setCcZipCode()
     * @uses CustomerDeposit::setChargeIt()
     * @uses CustomerDeposit::setCcApproved()
     * @uses CustomerDeposit::setPnRefNum()
     * @uses CustomerDeposit::setAuthCode()
     * @uses CustomerDeposit::setCcAvsStreetMatch()
     * @uses CustomerDeposit::setSoftDescriptor()
     * @uses CustomerDeposit::setCcAvsZipMatch()
     * @uses CustomerDeposit::setIsRecurringPayment()
     * @uses CustomerDeposit::setCcSecurityCodeMatch()
     * @uses CustomerDeposit::setThreeDStatusCode()
     * @uses CustomerDeposit::setIgnoreAvs()
     * @uses CustomerDeposit::setAccount()
     * @uses CustomerDeposit::setUndepFunds()
     * @uses CustomerDeposit::setTranId()
     * @uses CustomerDeposit::setApplyList()
     * @uses CustomerDeposit::setAccountingBookDetailList()
     * @uses CustomerDeposit::setCustomFieldList()
     * @uses CustomerDeposit::setInternalId()
     * @uses CustomerDeposit::setExternalId()
     * @param string $createdDate
     * @param string $lastModifiedDate
     * @param string $status
     * @param \StructType\RecordRef $customer
     * @param \StructType\RecordRef $salesOrder
     * @param \StructType\RecordRef $customForm
     * @param float $payment
     * @param \StructType\RecordRef $currency
     * @param string $tranDate
     * @param \StructType\RecordRef $postingPeriod
     * @param \StructType\RecordRef $paymentMethod
     * @param bool $ccIsPurchaseCardBin
     * @param string $memo
     * @param bool $ccProcessAsPurchaseCard
     * @param string $currencyName
     * @param float $exchangeRate
     * @param string $checkNum
     * @param \StructType\RecordRef $creditCardProcessor
     * @param \StructType\RecordRef $creditCard
     * @param string $ccSecurityCode
     * @param string $ccNumber
     * @param \StructType\RecordRef $subsidiary
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRef $paymentOption
     * @param string $inputAuthCode
     * @param string $inputReferenceCode
     * @param string $checkNumber
     * @param string $paymentCardCsc
     * @param \StructType\RecordRef $paymentProcessingProfile
     * @param string $handlingMode
     * @param string $outputAuthCode
     * @param string $outputReferenceCode
     * @param string $paymentOperation
     * @param string $dynamicDescriptor
     * @param string $ccExpireDate
     * @param string $debitCardIssueNo
     * @param string $validFrom
     * @param string $ccName
     * @param string $ccStreet
     * @param string $ccZipCode
     * @param bool $chargeIt
     * @param bool $ccApproved
     * @param string $pnRefNum
     * @param string $authCode
     * @param string $ccAvsStreetMatch
     * @param string $softDescriptor
     * @param string $ccAvsZipMatch
     * @param bool $isRecurringPayment
     * @param string $ccSecurityCodeMatch
     * @param string $threeDStatusCode
     * @param bool $ignoreAvs
     * @param \StructType\RecordRef $account
     * @param bool $undepFunds
     * @param string $tranId
     * @param \StructType\CustomerDepositApplyList $applyList
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($createdDate = null, $lastModifiedDate = null, $status = null, \StructType\RecordRef $customer = null, \StructType\RecordRef $salesOrder = null, \StructType\RecordRef $customForm = null, $payment = null, \StructType\RecordRef $currency = null, $tranDate = null, \StructType\RecordRef $postingPeriod = null, \StructType\RecordRef $paymentMethod = null, $ccIsPurchaseCardBin = null, $memo = null, $ccProcessAsPurchaseCard = null, $currencyName = null, $exchangeRate = null, $checkNum = null, \StructType\RecordRef $creditCardProcessor = null, \StructType\RecordRef $creditCard = null, $ccSecurityCode = null, $ccNumber = null, \StructType\RecordRef $subsidiary = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRef $location = null, \StructType\RecordRef $paymentOption = null, $inputAuthCode = null, $inputReferenceCode = null, $checkNumber = null, $paymentCardCsc = null, \StructType\RecordRef $paymentProcessingProfile = null, $handlingMode = null, $outputAuthCode = null, $outputReferenceCode = null, $paymentOperation = null, $dynamicDescriptor = null, $ccExpireDate = null, $debitCardIssueNo = null, $validFrom = null, $ccName = null, $ccStreet = null, $ccZipCode = null, $chargeIt = null, $ccApproved = null, $pnRefNum = null, $authCode = null, $ccAvsStreetMatch = null, $softDescriptor = null, $ccAvsZipMatch = null, $isRecurringPayment = null, $ccSecurityCodeMatch = null, $threeDStatusCode = null, $ignoreAvs = null, \StructType\RecordRef $account = null, $undepFunds = null, $tranId = null, \StructType\CustomerDepositApplyList $applyList = null, \StructType\AccountingBookDetailList $accountingBookDetailList = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCreatedDate($createdDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setStatus($status)
            ->setCustomer($customer)
            ->setSalesOrder($salesOrder)
            ->setCustomForm($customForm)
            ->setPayment($payment)
            ->setCurrency($currency)
            ->setTranDate($tranDate)
            ->setPostingPeriod($postingPeriod)
            ->setPaymentMethod($paymentMethod)
            ->setCcIsPurchaseCardBin($ccIsPurchaseCardBin)
            ->setMemo($memo)
            ->setCcProcessAsPurchaseCard($ccProcessAsPurchaseCard)
            ->setCurrencyName($currencyName)
            ->setExchangeRate($exchangeRate)
            ->setCheckNum($checkNum)
            ->setCreditCardProcessor($creditCardProcessor)
            ->setCreditCard($creditCard)
            ->setCcSecurityCode($ccSecurityCode)
            ->setCcNumber($ccNumber)
            ->setSubsidiary($subsidiary)
            ->setDepartment($department)
            ->setClass($class)
            ->setLocation($location)
            ->setPaymentOption($paymentOption)
            ->setInputAuthCode($inputAuthCode)
            ->setInputReferenceCode($inputReferenceCode)
            ->setCheckNumber($checkNumber)
            ->setPaymentCardCsc($paymentCardCsc)
            ->setPaymentProcessingProfile($paymentProcessingProfile)
            ->setHandlingMode($handlingMode)
            ->setOutputAuthCode($outputAuthCode)
            ->setOutputReferenceCode($outputReferenceCode)
            ->setPaymentOperation($paymentOperation)
            ->setDynamicDescriptor($dynamicDescriptor)
            ->setCcExpireDate($ccExpireDate)
            ->setDebitCardIssueNo($debitCardIssueNo)
            ->setValidFrom($validFrom)
            ->setCcName($ccName)
            ->setCcStreet($ccStreet)
            ->setCcZipCode($ccZipCode)
            ->setChargeIt($chargeIt)
            ->setCcApproved($ccApproved)
            ->setPnRefNum($pnRefNum)
            ->setAuthCode($authCode)
            ->setCcAvsStreetMatch($ccAvsStreetMatch)
            ->setSoftDescriptor($softDescriptor)
            ->setCcAvsZipMatch($ccAvsZipMatch)
            ->setIsRecurringPayment($isRecurringPayment)
            ->setCcSecurityCodeMatch($ccSecurityCodeMatch)
            ->setThreeDStatusCode($threeDStatusCode)
            ->setIgnoreAvs($ignoreAvs)
            ->setAccount($account)
            ->setUndepFunds($undepFunds)
            ->setTranId($tranId)
            ->setApplyList($applyList)
            ->setAccountingBookDetailList($accountingBookDetailList)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\CustomerDeposit
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\CustomerDeposit
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\CustomerDeposit
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get customer value
     * @return \StructType\RecordRef|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param \StructType\RecordRef $customer
     * @return \StructType\CustomerDeposit
     */
    public function setCustomer(\StructType\RecordRef $customer = null)
    {
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get salesOrder value
     * @return \StructType\RecordRef|null
     */
    public function getSalesOrder()
    {
        return $this->salesOrder;
    }
    /**
     * Set salesOrder value
     * @param \StructType\RecordRef $salesOrder
     * @return \StructType\CustomerDeposit
     */
    public function setSalesOrder(\StructType\RecordRef $salesOrder = null)
    {
        $this->salesOrder = $salesOrder;
        return $this;
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\CustomerDeposit
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get payment value
     * @return float|null
     */
    public function getPayment()
    {
        return $this->payment;
    }
    /**
     * Set payment value
     * @param float $payment
     * @return \StructType\CustomerDeposit
     */
    public function setPayment($payment = null)
    {
        // validation for constraint: float
        if (!is_null($payment) && !(is_float($payment) || is_numeric($payment))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($payment, true), gettype($payment)), __LINE__);
        }
        $this->payment = $payment;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\RecordRef|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \StructType\RecordRef $currency
     * @return \StructType\CustomerDeposit
     */
    public function setCurrency(\StructType\RecordRef $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get tranDate value
     * @return string|null
     */
    public function getTranDate()
    {
        return $this->tranDate;
    }
    /**
     * Set tranDate value
     * @param string $tranDate
     * @return \StructType\CustomerDeposit
     */
    public function setTranDate($tranDate = null)
    {
        // validation for constraint: string
        if (!is_null($tranDate) && !is_string($tranDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranDate, true), gettype($tranDate)), __LINE__);
        }
        $this->tranDate = $tranDate;
        return $this;
    }
    /**
     * Get postingPeriod value
     * @return \StructType\RecordRef|null
     */
    public function getPostingPeriod()
    {
        return $this->postingPeriod;
    }
    /**
     * Set postingPeriod value
     * @param \StructType\RecordRef $postingPeriod
     * @return \StructType\CustomerDeposit
     */
    public function setPostingPeriod(\StructType\RecordRef $postingPeriod = null)
    {
        $this->postingPeriod = $postingPeriod;
        return $this;
    }
    /**
     * Get paymentMethod value
     * @return \StructType\RecordRef|null
     */
    public function getPaymentMethod()
    {
        return $this->paymentMethod;
    }
    /**
     * Set paymentMethod value
     * @param \StructType\RecordRef $paymentMethod
     * @return \StructType\CustomerDeposit
     */
    public function setPaymentMethod(\StructType\RecordRef $paymentMethod = null)
    {
        $this->paymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get ccIsPurchaseCardBin value
     * @return bool|null
     */
    public function getCcIsPurchaseCardBin()
    {
        return $this->ccIsPurchaseCardBin;
    }
    /**
     * Set ccIsPurchaseCardBin value
     * @param bool $ccIsPurchaseCardBin
     * @return \StructType\CustomerDeposit
     */
    public function setCcIsPurchaseCardBin($ccIsPurchaseCardBin = null)
    {
        // validation for constraint: boolean
        if (!is_null($ccIsPurchaseCardBin) && !is_bool($ccIsPurchaseCardBin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ccIsPurchaseCardBin, true), gettype($ccIsPurchaseCardBin)), __LINE__);
        }
        $this->ccIsPurchaseCardBin = $ccIsPurchaseCardBin;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\CustomerDeposit
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get ccProcessAsPurchaseCard value
     * @return bool|null
     */
    public function getCcProcessAsPurchaseCard()
    {
        return $this->ccProcessAsPurchaseCard;
    }
    /**
     * Set ccProcessAsPurchaseCard value
     * @param bool $ccProcessAsPurchaseCard
     * @return \StructType\CustomerDeposit
     */
    public function setCcProcessAsPurchaseCard($ccProcessAsPurchaseCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($ccProcessAsPurchaseCard) && !is_bool($ccProcessAsPurchaseCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ccProcessAsPurchaseCard, true), gettype($ccProcessAsPurchaseCard)), __LINE__);
        }
        $this->ccProcessAsPurchaseCard = $ccProcessAsPurchaseCard;
        return $this;
    }
    /**
     * Get currencyName value
     * @return string|null
     */
    public function getCurrencyName()
    {
        return $this->currencyName;
    }
    /**
     * Set currencyName value
     * @param string $currencyName
     * @return \StructType\CustomerDeposit
     */
    public function setCurrencyName($currencyName = null)
    {
        // validation for constraint: string
        if (!is_null($currencyName) && !is_string($currencyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyName, true), gettype($currencyName)), __LINE__);
        }
        $this->currencyName = $currencyName;
        return $this;
    }
    /**
     * Get exchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->exchangeRate;
    }
    /**
     * Set exchangeRate value
     * @param float $exchangeRate
     * @return \StructType\CustomerDeposit
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->exchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get checkNum value
     * @return string|null
     */
    public function getCheckNum()
    {
        return $this->checkNum;
    }
    /**
     * Set checkNum value
     * @param string $checkNum
     * @return \StructType\CustomerDeposit
     */
    public function setCheckNum($checkNum = null)
    {
        // validation for constraint: string
        if (!is_null($checkNum) && !is_string($checkNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkNum, true), gettype($checkNum)), __LINE__);
        }
        $this->checkNum = $checkNum;
        return $this;
    }
    /**
     * Get creditCardProcessor value
     * @return \StructType\RecordRef|null
     */
    public function getCreditCardProcessor()
    {
        return $this->creditCardProcessor;
    }
    /**
     * Set creditCardProcessor value
     * @param \StructType\RecordRef $creditCardProcessor
     * @return \StructType\CustomerDeposit
     */
    public function setCreditCardProcessor(\StructType\RecordRef $creditCardProcessor = null)
    {
        $this->creditCardProcessor = $creditCardProcessor;
        return $this;
    }
    /**
     * Get creditCard value
     * @return \StructType\RecordRef|null
     */
    public function getCreditCard()
    {
        return $this->creditCard;
    }
    /**
     * Set creditCard value
     * @param \StructType\RecordRef $creditCard
     * @return \StructType\CustomerDeposit
     */
    public function setCreditCard(\StructType\RecordRef $creditCard = null)
    {
        $this->creditCard = $creditCard;
        return $this;
    }
    /**
     * Get ccSecurityCode value
     * @return string|null
     */
    public function getCcSecurityCode()
    {
        return $this->ccSecurityCode;
    }
    /**
     * Set ccSecurityCode value
     * @param string $ccSecurityCode
     * @return \StructType\CustomerDeposit
     */
    public function setCcSecurityCode($ccSecurityCode = null)
    {
        // validation for constraint: string
        if (!is_null($ccSecurityCode) && !is_string($ccSecurityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ccSecurityCode, true), gettype($ccSecurityCode)), __LINE__);
        }
        $this->ccSecurityCode = $ccSecurityCode;
        return $this;
    }
    /**
     * Get ccNumber value
     * @return string|null
     */
    public function getCcNumber()
    {
        return $this->ccNumber;
    }
    /**
     * Set ccNumber value
     * @param string $ccNumber
     * @return \StructType\CustomerDeposit
     */
    public function setCcNumber($ccNumber = null)
    {
        // validation for constraint: string
        if (!is_null($ccNumber) && !is_string($ccNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ccNumber, true), gettype($ccNumber)), __LINE__);
        }
        $this->ccNumber = $ccNumber;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\RecordRef $subsidiary
     * @return \StructType\CustomerDeposit
     */
    public function setSubsidiary(\StructType\RecordRef $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\CustomerDeposit
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\CustomerDeposit
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\CustomerDeposit
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get paymentOption value
     * @return \StructType\RecordRef|null
     */
    public function getPaymentOption()
    {
        return $this->paymentOption;
    }
    /**
     * Set paymentOption value
     * @param \StructType\RecordRef $paymentOption
     * @return \StructType\CustomerDeposit
     */
    public function setPaymentOption(\StructType\RecordRef $paymentOption = null)
    {
        $this->paymentOption = $paymentOption;
        return $this;
    }
    /**
     * Get inputAuthCode value
     * @return string|null
     */
    public function getInputAuthCode()
    {
        return $this->inputAuthCode;
    }
    /**
     * Set inputAuthCode value
     * @param string $inputAuthCode
     * @return \StructType\CustomerDeposit
     */
    public function setInputAuthCode($inputAuthCode = null)
    {
        // validation for constraint: string
        if (!is_null($inputAuthCode) && !is_string($inputAuthCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inputAuthCode, true), gettype($inputAuthCode)), __LINE__);
        }
        $this->inputAuthCode = $inputAuthCode;
        return $this;
    }
    /**
     * Get inputReferenceCode value
     * @return string|null
     */
    public function getInputReferenceCode()
    {
        return $this->inputReferenceCode;
    }
    /**
     * Set inputReferenceCode value
     * @param string $inputReferenceCode
     * @return \StructType\CustomerDeposit
     */
    public function setInputReferenceCode($inputReferenceCode = null)
    {
        // validation for constraint: string
        if (!is_null($inputReferenceCode) && !is_string($inputReferenceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inputReferenceCode, true), gettype($inputReferenceCode)), __LINE__);
        }
        $this->inputReferenceCode = $inputReferenceCode;
        return $this;
    }
    /**
     * Get checkNumber value
     * @return string|null
     */
    public function getCheckNumber()
    {
        return $this->checkNumber;
    }
    /**
     * Set checkNumber value
     * @param string $checkNumber
     * @return \StructType\CustomerDeposit
     */
    public function setCheckNumber($checkNumber = null)
    {
        // validation for constraint: string
        if (!is_null($checkNumber) && !is_string($checkNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkNumber, true), gettype($checkNumber)), __LINE__);
        }
        $this->checkNumber = $checkNumber;
        return $this;
    }
    /**
     * Get paymentCardCsc value
     * @return string|null
     */
    public function getPaymentCardCsc()
    {
        return $this->paymentCardCsc;
    }
    /**
     * Set paymentCardCsc value
     * @param string $paymentCardCsc
     * @return \StructType\CustomerDeposit
     */
    public function setPaymentCardCsc($paymentCardCsc = null)
    {
        // validation for constraint: string
        if (!is_null($paymentCardCsc) && !is_string($paymentCardCsc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentCardCsc, true), gettype($paymentCardCsc)), __LINE__);
        }
        $this->paymentCardCsc = $paymentCardCsc;
        return $this;
    }
    /**
     * Get paymentProcessingProfile value
     * @return \StructType\RecordRef|null
     */
    public function getPaymentProcessingProfile()
    {
        return $this->paymentProcessingProfile;
    }
    /**
     * Set paymentProcessingProfile value
     * @param \StructType\RecordRef $paymentProcessingProfile
     * @return \StructType\CustomerDeposit
     */
    public function setPaymentProcessingProfile(\StructType\RecordRef $paymentProcessingProfile = null)
    {
        $this->paymentProcessingProfile = $paymentProcessingProfile;
        return $this;
    }
    /**
     * Get handlingMode value
     * @return string|null
     */
    public function getHandlingMode()
    {
        return $this->handlingMode;
    }
    /**
     * Set handlingMode value
     * @uses \EnumType\CustomerDepositHandlingMode::valueIsValid()
     * @uses \EnumType\CustomerDepositHandlingMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $handlingMode
     * @return \StructType\CustomerDeposit
     */
    public function setHandlingMode($handlingMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CustomerDepositHandlingMode::valueIsValid($handlingMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CustomerDepositHandlingMode', is_array($handlingMode) ? implode(', ', $handlingMode) : var_export($handlingMode, true), implode(', ', \EnumType\CustomerDepositHandlingMode::getValidValues())), __LINE__);
        }
        $this->handlingMode = $handlingMode;
        return $this;
    }
    /**
     * Get outputAuthCode value
     * @return string|null
     */
    public function getOutputAuthCode()
    {
        return $this->outputAuthCode;
    }
    /**
     * Set outputAuthCode value
     * @param string $outputAuthCode
     * @return \StructType\CustomerDeposit
     */
    public function setOutputAuthCode($outputAuthCode = null)
    {
        // validation for constraint: string
        if (!is_null($outputAuthCode) && !is_string($outputAuthCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($outputAuthCode, true), gettype($outputAuthCode)), __LINE__);
        }
        $this->outputAuthCode = $outputAuthCode;
        return $this;
    }
    /**
     * Get outputReferenceCode value
     * @return string|null
     */
    public function getOutputReferenceCode()
    {
        return $this->outputReferenceCode;
    }
    /**
     * Set outputReferenceCode value
     * @param string $outputReferenceCode
     * @return \StructType\CustomerDeposit
     */
    public function setOutputReferenceCode($outputReferenceCode = null)
    {
        // validation for constraint: string
        if (!is_null($outputReferenceCode) && !is_string($outputReferenceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($outputReferenceCode, true), gettype($outputReferenceCode)), __LINE__);
        }
        $this->outputReferenceCode = $outputReferenceCode;
        return $this;
    }
    /**
     * Get paymentOperation value
     * @return string|null
     */
    public function getPaymentOperation()
    {
        return $this->paymentOperation;
    }
    /**
     * Set paymentOperation value
     * @uses \EnumType\CustomerDepositPaymentOperation::valueIsValid()
     * @uses \EnumType\CustomerDepositPaymentOperation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentOperation
     * @return \StructType\CustomerDeposit
     */
    public function setPaymentOperation($paymentOperation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CustomerDepositPaymentOperation::valueIsValid($paymentOperation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CustomerDepositPaymentOperation', is_array($paymentOperation) ? implode(', ', $paymentOperation) : var_export($paymentOperation, true), implode(', ', \EnumType\CustomerDepositPaymentOperation::getValidValues())), __LINE__);
        }
        $this->paymentOperation = $paymentOperation;
        return $this;
    }
    /**
     * Get dynamicDescriptor value
     * @return string|null
     */
    public function getDynamicDescriptor()
    {
        return $this->dynamicDescriptor;
    }
    /**
     * Set dynamicDescriptor value
     * @param string $dynamicDescriptor
     * @return \StructType\CustomerDeposit
     */
    public function setDynamicDescriptor($dynamicDescriptor = null)
    {
        // validation for constraint: string
        if (!is_null($dynamicDescriptor) && !is_string($dynamicDescriptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dynamicDescriptor, true), gettype($dynamicDescriptor)), __LINE__);
        }
        $this->dynamicDescriptor = $dynamicDescriptor;
        return $this;
    }
    /**
     * Get ccExpireDate value
     * @return string|null
     */
    public function getCcExpireDate()
    {
        return $this->ccExpireDate;
    }
    /**
     * Set ccExpireDate value
     * @param string $ccExpireDate
     * @return \StructType\CustomerDeposit
     */
    public function setCcExpireDate($ccExpireDate = null)
    {
        // validation for constraint: string
        if (!is_null($ccExpireDate) && !is_string($ccExpireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ccExpireDate, true), gettype($ccExpireDate)), __LINE__);
        }
        $this->ccExpireDate = $ccExpireDate;
        return $this;
    }
    /**
     * Get debitCardIssueNo value
     * @return string|null
     */
    public function getDebitCardIssueNo()
    {
        return $this->debitCardIssueNo;
    }
    /**
     * Set debitCardIssueNo value
     * @param string $debitCardIssueNo
     * @return \StructType\CustomerDeposit
     */
    public function setDebitCardIssueNo($debitCardIssueNo = null)
    {
        // validation for constraint: string
        if (!is_null($debitCardIssueNo) && !is_string($debitCardIssueNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($debitCardIssueNo, true), gettype($debitCardIssueNo)), __LINE__);
        }
        $this->debitCardIssueNo = $debitCardIssueNo;
        return $this;
    }
    /**
     * Get validFrom value
     * @return string|null
     */
    public function getValidFrom()
    {
        return $this->validFrom;
    }
    /**
     * Set validFrom value
     * @param string $validFrom
     * @return \StructType\CustomerDeposit
     */
    public function setValidFrom($validFrom = null)
    {
        // validation for constraint: string
        if (!is_null($validFrom) && !is_string($validFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validFrom, true), gettype($validFrom)), __LINE__);
        }
        $this->validFrom = $validFrom;
        return $this;
    }
    /**
     * Get ccName value
     * @return string|null
     */
    public function getCcName()
    {
        return $this->ccName;
    }
    /**
     * Set ccName value
     * @param string $ccName
     * @return \StructType\CustomerDeposit
     */
    public function setCcName($ccName = null)
    {
        // validation for constraint: string
        if (!is_null($ccName) && !is_string($ccName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ccName, true), gettype($ccName)), __LINE__);
        }
        $this->ccName = $ccName;
        return $this;
    }
    /**
     * Get ccStreet value
     * @return string|null
     */
    public function getCcStreet()
    {
        return $this->ccStreet;
    }
    /**
     * Set ccStreet value
     * @param string $ccStreet
     * @return \StructType\CustomerDeposit
     */
    public function setCcStreet($ccStreet = null)
    {
        // validation for constraint: string
        if (!is_null($ccStreet) && !is_string($ccStreet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ccStreet, true), gettype($ccStreet)), __LINE__);
        }
        $this->ccStreet = $ccStreet;
        return $this;
    }
    /**
     * Get ccZipCode value
     * @return string|null
     */
    public function getCcZipCode()
    {
        return $this->ccZipCode;
    }
    /**
     * Set ccZipCode value
     * @param string $ccZipCode
     * @return \StructType\CustomerDeposit
     */
    public function setCcZipCode($ccZipCode = null)
    {
        // validation for constraint: string
        if (!is_null($ccZipCode) && !is_string($ccZipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ccZipCode, true), gettype($ccZipCode)), __LINE__);
        }
        $this->ccZipCode = $ccZipCode;
        return $this;
    }
    /**
     * Get chargeIt value
     * @return bool|null
     */
    public function getChargeIt()
    {
        return $this->chargeIt;
    }
    /**
     * Set chargeIt value
     * @param bool $chargeIt
     * @return \StructType\CustomerDeposit
     */
    public function setChargeIt($chargeIt = null)
    {
        // validation for constraint: boolean
        if (!is_null($chargeIt) && !is_bool($chargeIt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($chargeIt, true), gettype($chargeIt)), __LINE__);
        }
        $this->chargeIt = $chargeIt;
        return $this;
    }
    /**
     * Get ccApproved value
     * @return bool|null
     */
    public function getCcApproved()
    {
        return $this->ccApproved;
    }
    /**
     * Set ccApproved value
     * @param bool $ccApproved
     * @return \StructType\CustomerDeposit
     */
    public function setCcApproved($ccApproved = null)
    {
        // validation for constraint: boolean
        if (!is_null($ccApproved) && !is_bool($ccApproved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ccApproved, true), gettype($ccApproved)), __LINE__);
        }
        $this->ccApproved = $ccApproved;
        return $this;
    }
    /**
     * Get pnRefNum value
     * @return string|null
     */
    public function getPnRefNum()
    {
        return $this->pnRefNum;
    }
    /**
     * Set pnRefNum value
     * @param string $pnRefNum
     * @return \StructType\CustomerDeposit
     */
    public function setPnRefNum($pnRefNum = null)
    {
        // validation for constraint: string
        if (!is_null($pnRefNum) && !is_string($pnRefNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pnRefNum, true), gettype($pnRefNum)), __LINE__);
        }
        $this->pnRefNum = $pnRefNum;
        return $this;
    }
    /**
     * Get authCode value
     * @return string|null
     */
    public function getAuthCode()
    {
        return $this->authCode;
    }
    /**
     * Set authCode value
     * @param string $authCode
     * @return \StructType\CustomerDeposit
     */
    public function setAuthCode($authCode = null)
    {
        // validation for constraint: string
        if (!is_null($authCode) && !is_string($authCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authCode, true), gettype($authCode)), __LINE__);
        }
        $this->authCode = $authCode;
        return $this;
    }
    /**
     * Get ccAvsStreetMatch value
     * @return string|null
     */
    public function getCcAvsStreetMatch()
    {
        return $this->ccAvsStreetMatch;
    }
    /**
     * Set ccAvsStreetMatch value
     * @uses \EnumType\AvsMatchCode::valueIsValid()
     * @uses \EnumType\AvsMatchCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ccAvsStreetMatch
     * @return \StructType\CustomerDeposit
     */
    public function setCcAvsStreetMatch($ccAvsStreetMatch = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AvsMatchCode::valueIsValid($ccAvsStreetMatch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AvsMatchCode', is_array($ccAvsStreetMatch) ? implode(', ', $ccAvsStreetMatch) : var_export($ccAvsStreetMatch, true), implode(', ', \EnumType\AvsMatchCode::getValidValues())), __LINE__);
        }
        $this->ccAvsStreetMatch = $ccAvsStreetMatch;
        return $this;
    }
    /**
     * Get softDescriptor value
     * @return string|null
     */
    public function getSoftDescriptor()
    {
        return $this->softDescriptor;
    }
    /**
     * Set softDescriptor value
     * @param string $softDescriptor
     * @return \StructType\CustomerDeposit
     */
    public function setSoftDescriptor($softDescriptor = null)
    {
        // validation for constraint: string
        if (!is_null($softDescriptor) && !is_string($softDescriptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($softDescriptor, true), gettype($softDescriptor)), __LINE__);
        }
        $this->softDescriptor = $softDescriptor;
        return $this;
    }
    /**
     * Get ccAvsZipMatch value
     * @return string|null
     */
    public function getCcAvsZipMatch()
    {
        return $this->ccAvsZipMatch;
    }
    /**
     * Set ccAvsZipMatch value
     * @uses \EnumType\AvsMatchCode::valueIsValid()
     * @uses \EnumType\AvsMatchCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ccAvsZipMatch
     * @return \StructType\CustomerDeposit
     */
    public function setCcAvsZipMatch($ccAvsZipMatch = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AvsMatchCode::valueIsValid($ccAvsZipMatch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AvsMatchCode', is_array($ccAvsZipMatch) ? implode(', ', $ccAvsZipMatch) : var_export($ccAvsZipMatch, true), implode(', ', \EnumType\AvsMatchCode::getValidValues())), __LINE__);
        }
        $this->ccAvsZipMatch = $ccAvsZipMatch;
        return $this;
    }
    /**
     * Get isRecurringPayment value
     * @return bool|null
     */
    public function getIsRecurringPayment()
    {
        return $this->isRecurringPayment;
    }
    /**
     * Set isRecurringPayment value
     * @param bool $isRecurringPayment
     * @return \StructType\CustomerDeposit
     */
    public function setIsRecurringPayment($isRecurringPayment = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRecurringPayment) && !is_bool($isRecurringPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRecurringPayment, true), gettype($isRecurringPayment)), __LINE__);
        }
        $this->isRecurringPayment = $isRecurringPayment;
        return $this;
    }
    /**
     * Get ccSecurityCodeMatch value
     * @return string|null
     */
    public function getCcSecurityCodeMatch()
    {
        return $this->ccSecurityCodeMatch;
    }
    /**
     * Set ccSecurityCodeMatch value
     * @uses \EnumType\AvsMatchCode::valueIsValid()
     * @uses \EnumType\AvsMatchCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ccSecurityCodeMatch
     * @return \StructType\CustomerDeposit
     */
    public function setCcSecurityCodeMatch($ccSecurityCodeMatch = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AvsMatchCode::valueIsValid($ccSecurityCodeMatch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AvsMatchCode', is_array($ccSecurityCodeMatch) ? implode(', ', $ccSecurityCodeMatch) : var_export($ccSecurityCodeMatch, true), implode(', ', \EnumType\AvsMatchCode::getValidValues())), __LINE__);
        }
        $this->ccSecurityCodeMatch = $ccSecurityCodeMatch;
        return $this;
    }
    /**
     * Get threeDStatusCode value
     * @return string|null
     */
    public function getThreeDStatusCode()
    {
        return $this->threeDStatusCode;
    }
    /**
     * Set threeDStatusCode value
     * @param string $threeDStatusCode
     * @return \StructType\CustomerDeposit
     */
    public function setThreeDStatusCode($threeDStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($threeDStatusCode) && !is_string($threeDStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($threeDStatusCode, true), gettype($threeDStatusCode)), __LINE__);
        }
        $this->threeDStatusCode = $threeDStatusCode;
        return $this;
    }
    /**
     * Get ignoreAvs value
     * @return bool|null
     */
    public function getIgnoreAvs()
    {
        return $this->ignoreAvs;
    }
    /**
     * Set ignoreAvs value
     * @param bool $ignoreAvs
     * @return \StructType\CustomerDeposit
     */
    public function setIgnoreAvs($ignoreAvs = null)
    {
        // validation for constraint: boolean
        if (!is_null($ignoreAvs) && !is_bool($ignoreAvs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ignoreAvs, true), gettype($ignoreAvs)), __LINE__);
        }
        $this->ignoreAvs = $ignoreAvs;
        return $this;
    }
    /**
     * Get account value
     * @return \StructType\RecordRef|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * Set account value
     * @param \StructType\RecordRef $account
     * @return \StructType\CustomerDeposit
     */
    public function setAccount(\StructType\RecordRef $account = null)
    {
        $this->account = $account;
        return $this;
    }
    /**
     * Get undepFunds value
     * @return bool|null
     */
    public function getUndepFunds()
    {
        return $this->undepFunds;
    }
    /**
     * Set undepFunds value
     * @param bool $undepFunds
     * @return \StructType\CustomerDeposit
     */
    public function setUndepFunds($undepFunds = null)
    {
        // validation for constraint: boolean
        if (!is_null($undepFunds) && !is_bool($undepFunds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($undepFunds, true), gettype($undepFunds)), __LINE__);
        }
        $this->undepFunds = $undepFunds;
        return $this;
    }
    /**
     * Get tranId value
     * @return string|null
     */
    public function getTranId()
    {
        return $this->tranId;
    }
    /**
     * Set tranId value
     * @param string $tranId
     * @return \StructType\CustomerDeposit
     */
    public function setTranId($tranId = null)
    {
        // validation for constraint: string
        if (!is_null($tranId) && !is_string($tranId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranId, true), gettype($tranId)), __LINE__);
        }
        $this->tranId = $tranId;
        return $this;
    }
    /**
     * Get applyList value
     * @return \StructType\CustomerDepositApplyList|null
     */
    public function getApplyList()
    {
        return $this->applyList;
    }
    /**
     * Set applyList value
     * @param \StructType\CustomerDepositApplyList $applyList
     * @return \StructType\CustomerDeposit
     */
    public function setApplyList(\StructType\CustomerDepositApplyList $applyList = null)
    {
        $this->applyList = $applyList;
        return $this;
    }
    /**
     * Get accountingBookDetailList value
     * @return \StructType\AccountingBookDetailList|null
     */
    public function getAccountingBookDetailList()
    {
        return $this->accountingBookDetailList;
    }
    /**
     * Set accountingBookDetailList value
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @return \StructType\CustomerDeposit
     */
    public function setAccountingBookDetailList(\StructType\AccountingBookDetailList $accountingBookDetailList = null)
    {
        $this->accountingBookDetailList = $accountingBookDetailList;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\CustomerDeposit
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\CustomerDeposit
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\CustomerDeposit
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
