<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerCurrency StructType
 * @subpackage Structs
 */
class CustomerCurrency extends AbstractStructBase
{
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $currency;
    /**
     * The balance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $balance;
    /**
     * The consolBalance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $consolBalance;
    /**
     * The depositBalance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $depositBalance;
    /**
     * The consolDepositBalance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $consolDepositBalance;
    /**
     * The overdueBalance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $overdueBalance;
    /**
     * The consolOverdueBalance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $consolOverdueBalance;
    /**
     * The unbilledOrders
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $unbilledOrders;
    /**
     * The consolUnbilledOrders
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $consolUnbilledOrders;
    /**
     * The overrideCurrencyFormat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $overrideCurrencyFormat;
    /**
     * The displaySymbol
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $displaySymbol;
    /**
     * The symbolPlacement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $symbolPlacement;
    /**
     * Constructor method for CustomerCurrency
     * @uses CustomerCurrency::setCurrency()
     * @uses CustomerCurrency::setBalance()
     * @uses CustomerCurrency::setConsolBalance()
     * @uses CustomerCurrency::setDepositBalance()
     * @uses CustomerCurrency::setConsolDepositBalance()
     * @uses CustomerCurrency::setOverdueBalance()
     * @uses CustomerCurrency::setConsolOverdueBalance()
     * @uses CustomerCurrency::setUnbilledOrders()
     * @uses CustomerCurrency::setConsolUnbilledOrders()
     * @uses CustomerCurrency::setOverrideCurrencyFormat()
     * @uses CustomerCurrency::setDisplaySymbol()
     * @uses CustomerCurrency::setSymbolPlacement()
     * @param \StructType\RecordRef $currency
     * @param float $balance
     * @param float $consolBalance
     * @param float $depositBalance
     * @param float $consolDepositBalance
     * @param float $overdueBalance
     * @param float $consolOverdueBalance
     * @param float $unbilledOrders
     * @param float $consolUnbilledOrders
     * @param bool $overrideCurrencyFormat
     * @param string $displaySymbol
     * @param string $symbolPlacement
     */
    public function __construct(\StructType\RecordRef $currency = null, $balance = null, $consolBalance = null, $depositBalance = null, $consolDepositBalance = null, $overdueBalance = null, $consolOverdueBalance = null, $unbilledOrders = null, $consolUnbilledOrders = null, $overrideCurrencyFormat = null, $displaySymbol = null, $symbolPlacement = null)
    {
        $this
            ->setCurrency($currency)
            ->setBalance($balance)
            ->setConsolBalance($consolBalance)
            ->setDepositBalance($depositBalance)
            ->setConsolDepositBalance($consolDepositBalance)
            ->setOverdueBalance($overdueBalance)
            ->setConsolOverdueBalance($consolOverdueBalance)
            ->setUnbilledOrders($unbilledOrders)
            ->setConsolUnbilledOrders($consolUnbilledOrders)
            ->setOverrideCurrencyFormat($overrideCurrencyFormat)
            ->setDisplaySymbol($displaySymbol)
            ->setSymbolPlacement($symbolPlacement);
    }
    /**
     * Get currency value
     * @return \StructType\RecordRef|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \StructType\RecordRef $currency
     * @return \StructType\CustomerCurrency
     */
    public function setCurrency(\StructType\RecordRef $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get balance value
     * @return float|null
     */
    public function getBalance()
    {
        return $this->balance;
    }
    /**
     * Set balance value
     * @param float $balance
     * @return \StructType\CustomerCurrency
     */
    public function setBalance($balance = null)
    {
        // validation for constraint: float
        if (!is_null($balance) && !(is_float($balance) || is_numeric($balance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($balance, true), gettype($balance)), __LINE__);
        }
        $this->balance = $balance;
        return $this;
    }
    /**
     * Get consolBalance value
     * @return float|null
     */
    public function getConsolBalance()
    {
        return $this->consolBalance;
    }
    /**
     * Set consolBalance value
     * @param float $consolBalance
     * @return \StructType\CustomerCurrency
     */
    public function setConsolBalance($consolBalance = null)
    {
        // validation for constraint: float
        if (!is_null($consolBalance) && !(is_float($consolBalance) || is_numeric($consolBalance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($consolBalance, true), gettype($consolBalance)), __LINE__);
        }
        $this->consolBalance = $consolBalance;
        return $this;
    }
    /**
     * Get depositBalance value
     * @return float|null
     */
    public function getDepositBalance()
    {
        return $this->depositBalance;
    }
    /**
     * Set depositBalance value
     * @param float $depositBalance
     * @return \StructType\CustomerCurrency
     */
    public function setDepositBalance($depositBalance = null)
    {
        // validation for constraint: float
        if (!is_null($depositBalance) && !(is_float($depositBalance) || is_numeric($depositBalance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($depositBalance, true), gettype($depositBalance)), __LINE__);
        }
        $this->depositBalance = $depositBalance;
        return $this;
    }
    /**
     * Get consolDepositBalance value
     * @return float|null
     */
    public function getConsolDepositBalance()
    {
        return $this->consolDepositBalance;
    }
    /**
     * Set consolDepositBalance value
     * @param float $consolDepositBalance
     * @return \StructType\CustomerCurrency
     */
    public function setConsolDepositBalance($consolDepositBalance = null)
    {
        // validation for constraint: float
        if (!is_null($consolDepositBalance) && !(is_float($consolDepositBalance) || is_numeric($consolDepositBalance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($consolDepositBalance, true), gettype($consolDepositBalance)), __LINE__);
        }
        $this->consolDepositBalance = $consolDepositBalance;
        return $this;
    }
    /**
     * Get overdueBalance value
     * @return float|null
     */
    public function getOverdueBalance()
    {
        return $this->overdueBalance;
    }
    /**
     * Set overdueBalance value
     * @param float $overdueBalance
     * @return \StructType\CustomerCurrency
     */
    public function setOverdueBalance($overdueBalance = null)
    {
        // validation for constraint: float
        if (!is_null($overdueBalance) && !(is_float($overdueBalance) || is_numeric($overdueBalance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($overdueBalance, true), gettype($overdueBalance)), __LINE__);
        }
        $this->overdueBalance = $overdueBalance;
        return $this;
    }
    /**
     * Get consolOverdueBalance value
     * @return float|null
     */
    public function getConsolOverdueBalance()
    {
        return $this->consolOverdueBalance;
    }
    /**
     * Set consolOverdueBalance value
     * @param float $consolOverdueBalance
     * @return \StructType\CustomerCurrency
     */
    public function setConsolOverdueBalance($consolOverdueBalance = null)
    {
        // validation for constraint: float
        if (!is_null($consolOverdueBalance) && !(is_float($consolOverdueBalance) || is_numeric($consolOverdueBalance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($consolOverdueBalance, true), gettype($consolOverdueBalance)), __LINE__);
        }
        $this->consolOverdueBalance = $consolOverdueBalance;
        return $this;
    }
    /**
     * Get unbilledOrders value
     * @return float|null
     */
    public function getUnbilledOrders()
    {
        return $this->unbilledOrders;
    }
    /**
     * Set unbilledOrders value
     * @param float $unbilledOrders
     * @return \StructType\CustomerCurrency
     */
    public function setUnbilledOrders($unbilledOrders = null)
    {
        // validation for constraint: float
        if (!is_null($unbilledOrders) && !(is_float($unbilledOrders) || is_numeric($unbilledOrders))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unbilledOrders, true), gettype($unbilledOrders)), __LINE__);
        }
        $this->unbilledOrders = $unbilledOrders;
        return $this;
    }
    /**
     * Get consolUnbilledOrders value
     * @return float|null
     */
    public function getConsolUnbilledOrders()
    {
        return $this->consolUnbilledOrders;
    }
    /**
     * Set consolUnbilledOrders value
     * @param float $consolUnbilledOrders
     * @return \StructType\CustomerCurrency
     */
    public function setConsolUnbilledOrders($consolUnbilledOrders = null)
    {
        // validation for constraint: float
        if (!is_null($consolUnbilledOrders) && !(is_float($consolUnbilledOrders) || is_numeric($consolUnbilledOrders))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($consolUnbilledOrders, true), gettype($consolUnbilledOrders)), __LINE__);
        }
        $this->consolUnbilledOrders = $consolUnbilledOrders;
        return $this;
    }
    /**
     * Get overrideCurrencyFormat value
     * @return bool|null
     */
    public function getOverrideCurrencyFormat()
    {
        return $this->overrideCurrencyFormat;
    }
    /**
     * Set overrideCurrencyFormat value
     * @param bool $overrideCurrencyFormat
     * @return \StructType\CustomerCurrency
     */
    public function setOverrideCurrencyFormat($overrideCurrencyFormat = null)
    {
        // validation for constraint: boolean
        if (!is_null($overrideCurrencyFormat) && !is_bool($overrideCurrencyFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($overrideCurrencyFormat, true), gettype($overrideCurrencyFormat)), __LINE__);
        }
        $this->overrideCurrencyFormat = $overrideCurrencyFormat;
        return $this;
    }
    /**
     * Get displaySymbol value
     * @return string|null
     */
    public function getDisplaySymbol()
    {
        return $this->displaySymbol;
    }
    /**
     * Set displaySymbol value
     * @param string $displaySymbol
     * @return \StructType\CustomerCurrency
     */
    public function setDisplaySymbol($displaySymbol = null)
    {
        // validation for constraint: string
        if (!is_null($displaySymbol) && !is_string($displaySymbol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displaySymbol, true), gettype($displaySymbol)), __LINE__);
        }
        $this->displaySymbol = $displaySymbol;
        return $this;
    }
    /**
     * Get symbolPlacement value
     * @return string|null
     */
    public function getSymbolPlacement()
    {
        return $this->symbolPlacement;
    }
    /**
     * Set symbolPlacement value
     * @uses \EnumType\CurrencySymbolPlacement::valueIsValid()
     * @uses \EnumType\CurrencySymbolPlacement::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $symbolPlacement
     * @return \StructType\CustomerCurrency
     */
    public function setSymbolPlacement($symbolPlacement = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CurrencySymbolPlacement::valueIsValid($symbolPlacement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CurrencySymbolPlacement', is_array($symbolPlacement) ? implode(', ', $symbolPlacement) : var_export($symbolPlacement, true), implode(', ', \EnumType\CurrencySymbolPlacement::getValidValues())), __LINE__);
        }
        $this->symbolPlacement = $symbolPlacement;
        return $this;
    }
}
