<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomSegment StructType
 * @subpackage Structs
 */
class CustomSegment extends Record
{
    /**
     * The label
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $label;
    /**
     * The scriptId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $scriptId;
    /**
     * The recordScriptId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $recordScriptId;
    /**
     * The recordType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $recordType;
    /**
     * The fieldType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fieldType;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The showInList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $showInList;
    /**
     * The filteredByList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRefList
     */
    public $filteredByList;
    /**
     * The hasGLImpact
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $hasGLImpact;
    /**
     * The help
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $help;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The isMandatory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isMandatory;
    /**
     * The defaultSelection
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $defaultSelection;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * Constructor method for CustomSegment
     * @uses CustomSegment::setLabel()
     * @uses CustomSegment::setScriptId()
     * @uses CustomSegment::setRecordScriptId()
     * @uses CustomSegment::setRecordType()
     * @uses CustomSegment::setFieldType()
     * @uses CustomSegment::setIsInactive()
     * @uses CustomSegment::setShowInList()
     * @uses CustomSegment::setFilteredByList()
     * @uses CustomSegment::setHasGLImpact()
     * @uses CustomSegment::setHelp()
     * @uses CustomSegment::setDescription()
     * @uses CustomSegment::setIsMandatory()
     * @uses CustomSegment::setDefaultSelection()
     * @uses CustomSegment::setInternalId()
     * @param string $label
     * @param string $scriptId
     * @param string $recordScriptId
     * @param \StructType\RecordRef $recordType
     * @param string $fieldType
     * @param bool $isInactive
     * @param bool $showInList
     * @param \StructType\RecordRefList $filteredByList
     * @param bool $hasGLImpact
     * @param string $help
     * @param string $description
     * @param bool $isMandatory
     * @param \StructType\RecordRef $defaultSelection
     * @param string $internalId
     */
    public function __construct($label = null, $scriptId = null, $recordScriptId = null, \StructType\RecordRef $recordType = null, $fieldType = null, $isInactive = null, $showInList = null, \StructType\RecordRefList $filteredByList = null, $hasGLImpact = null, $help = null, $description = null, $isMandatory = null, \StructType\RecordRef $defaultSelection = null, $internalId = null)
    {
        $this
            ->setLabel($label)
            ->setScriptId($scriptId)
            ->setRecordScriptId($recordScriptId)
            ->setRecordType($recordType)
            ->setFieldType($fieldType)
            ->setIsInactive($isInactive)
            ->setShowInList($showInList)
            ->setFilteredByList($filteredByList)
            ->setHasGLImpact($hasGLImpact)
            ->setHelp($help)
            ->setDescription($description)
            ->setIsMandatory($isMandatory)
            ->setDefaultSelection($defaultSelection)
            ->setInternalId($internalId);
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \StructType\CustomSegment
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
    /**
     * Get scriptId value
     * @return string|null
     */
    public function getScriptId()
    {
        return $this->scriptId;
    }
    /**
     * Set scriptId value
     * @param string $scriptId
     * @return \StructType\CustomSegment
     */
    public function setScriptId($scriptId = null)
    {
        // validation for constraint: string
        if (!is_null($scriptId) && !is_string($scriptId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scriptId, true), gettype($scriptId)), __LINE__);
        }
        $this->scriptId = $scriptId;
        return $this;
    }
    /**
     * Get recordScriptId value
     * @return string|null
     */
    public function getRecordScriptId()
    {
        return $this->recordScriptId;
    }
    /**
     * Set recordScriptId value
     * @param string $recordScriptId
     * @return \StructType\CustomSegment
     */
    public function setRecordScriptId($recordScriptId = null)
    {
        // validation for constraint: string
        if (!is_null($recordScriptId) && !is_string($recordScriptId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recordScriptId, true), gettype($recordScriptId)), __LINE__);
        }
        $this->recordScriptId = $recordScriptId;
        return $this;
    }
    /**
     * Get recordType value
     * @return \StructType\RecordRef|null
     */
    public function getRecordType()
    {
        return $this->recordType;
    }
    /**
     * Set recordType value
     * @param \StructType\RecordRef $recordType
     * @return \StructType\CustomSegment
     */
    public function setRecordType(\StructType\RecordRef $recordType = null)
    {
        $this->recordType = $recordType;
        return $this;
    }
    /**
     * Get fieldType value
     * @return string|null
     */
    public function getFieldType()
    {
        return $this->fieldType;
    }
    /**
     * Set fieldType value
     * @uses \EnumType\CustomizationFieldType::valueIsValid()
     * @uses \EnumType\CustomizationFieldType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fieldType
     * @return \StructType\CustomSegment
     */
    public function setFieldType($fieldType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CustomizationFieldType::valueIsValid($fieldType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CustomizationFieldType', is_array($fieldType) ? implode(', ', $fieldType) : var_export($fieldType, true), implode(', ', \EnumType\CustomizationFieldType::getValidValues())), __LINE__);
        }
        $this->fieldType = $fieldType;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\CustomSegment
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get showInList value
     * @return bool|null
     */
    public function getShowInList()
    {
        return $this->showInList;
    }
    /**
     * Set showInList value
     * @param bool $showInList
     * @return \StructType\CustomSegment
     */
    public function setShowInList($showInList = null)
    {
        // validation for constraint: boolean
        if (!is_null($showInList) && !is_bool($showInList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showInList, true), gettype($showInList)), __LINE__);
        }
        $this->showInList = $showInList;
        return $this;
    }
    /**
     * Get filteredByList value
     * @return \StructType\RecordRefList|null
     */
    public function getFilteredByList()
    {
        return $this->filteredByList;
    }
    /**
     * Set filteredByList value
     * @param \StructType\RecordRefList $filteredByList
     * @return \StructType\CustomSegment
     */
    public function setFilteredByList(\StructType\RecordRefList $filteredByList = null)
    {
        $this->filteredByList = $filteredByList;
        return $this;
    }
    /**
     * Get hasGLImpact value
     * @return bool|null
     */
    public function getHasGLImpact()
    {
        return $this->hasGLImpact;
    }
    /**
     * Set hasGLImpact value
     * @param bool $hasGLImpact
     * @return \StructType\CustomSegment
     */
    public function setHasGLImpact($hasGLImpact = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasGLImpact) && !is_bool($hasGLImpact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasGLImpact, true), gettype($hasGLImpact)), __LINE__);
        }
        $this->hasGLImpact = $hasGLImpact;
        return $this;
    }
    /**
     * Get help value
     * @return string|null
     */
    public function getHelp()
    {
        return $this->help;
    }
    /**
     * Set help value
     * @param string $help
     * @return \StructType\CustomSegment
     */
    public function setHelp($help = null)
    {
        // validation for constraint: string
        if (!is_null($help) && !is_string($help)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($help, true), gettype($help)), __LINE__);
        }
        $this->help = $help;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\CustomSegment
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get isMandatory value
     * @return bool|null
     */
    public function getIsMandatory()
    {
        return $this->isMandatory;
    }
    /**
     * Set isMandatory value
     * @param bool $isMandatory
     * @return \StructType\CustomSegment
     */
    public function setIsMandatory($isMandatory = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMandatory) && !is_bool($isMandatory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMandatory, true), gettype($isMandatory)), __LINE__);
        }
        $this->isMandatory = $isMandatory;
        return $this;
    }
    /**
     * Get defaultSelection value
     * @return \StructType\RecordRef|null
     */
    public function getDefaultSelection()
    {
        return $this->defaultSelection;
    }
    /**
     * Set defaultSelection value
     * @param \StructType\RecordRef $defaultSelection
     * @return \StructType\CustomSegment
     */
    public function setDefaultSelection(\StructType\RecordRef $defaultSelection = null)
    {
        $this->defaultSelection = $defaultSelection;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\CustomSegment
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
}
