<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomSale StructType
 * @subpackage Structs
 */
class CustomSale extends Record
{
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The tranType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $tranType;
    /**
     * The nexus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $nexus;
    /**
     * The subsidiaryTaxRegNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiaryTaxRegNum;
    /**
     * The taxRegOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $taxRegOverride;
    /**
     * The taxDetailsOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $taxDetailsOverride;
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The entity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entity;
    /**
     * The billingAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $billingAccount;
    /**
     * The tranDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranDate;
    /**
     * The tranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranId;
    /**
     * The entityTaxRegNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entityTaxRegNum;
    /**
     * The source
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $source;
    /**
     * The createdFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $createdFrom;
    /**
     * The postingPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $postingPeriod;
    /**
     * The opportunity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $opportunity;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The terms
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $terms;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiary;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $currency;
    /**
     * The dueDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dueDate;
    /**
     * The discountDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $discountDate;
    /**
     * The discountAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $discountAmount;
    /**
     * The salesRep
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $salesRep;
    /**
     * The partner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $partner;
    /**
     * The leadSource
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $leadSource;
    /**
     * The startDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * The otherRefNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $otherRefNum;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The tranStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $tranStatus;
    /**
     * The salesEffectiveDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $salesEffectiveDate;
    /**
     * The excludeCommission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $excludeCommission;
    /**
     * The totalCostEstimate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $totalCostEstimate;
    /**
     * The estGrossProfit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $estGrossProfit;
    /**
     * The estGrossProfitPercent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $estGrossProfitPercent;
    /**
     * The revRecSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $revRecSchedule;
    /**
     * The revRecStartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $revRecStartDate;
    /**
     * The revRecEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $revRecEndDate;
    /**
     * The account
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $account;
    /**
     * The exchangeRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $exchangeRate;
    /**
     * The currencyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currencyName;
    /**
     * The promoCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $promoCode;
    /**
     * The discountItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $discountItem;
    /**
     * The discountRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $discountRate;
    /**
     * The isMultiShipTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isMultiShipTo;
    /**
     * The isTaxable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isTaxable;
    /**
     * The toBePrinted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $toBePrinted;
    /**
     * The toBeEmailed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $toBeEmailed;
    /**
     * The toBeFaxed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $toBeFaxed;
    /**
     * The fax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fax;
    /**
     * The messageSel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $messageSel;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * The billingAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $billingAddress;
    /**
     * The billAddressList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $billAddressList;
    /**
     * The shippingAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $shippingAddress;
    /**
     * The shipIsResidential
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $shipIsResidential;
    /**
     * The shipAddressList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $shipAddressList;
    /**
     * The fob
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fob;
    /**
     * The shipDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shipDate;
    /**
     * The shipMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $shipMethod;
    /**
     * The shippingCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $shippingCost;
    /**
     * The handlingCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $handlingCost;
    /**
     * The trackingNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $trackingNumbers;
    /**
     * The linkedTrackingNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $linkedTrackingNumbers;
    /**
     * The salesGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $salesGroup;
    /**
     * The subTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $subTotal;
    /**
     * The revenueStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $revenueStatus;
    /**
     * The recognizedRevenue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $recognizedRevenue;
    /**
     * The deferredRevenue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $deferredRevenue;
    /**
     * The revRecOnRevCommitment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $revRecOnRevCommitment;
    /**
     * The syncSalesTeams
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $syncSalesTeams;
    /**
     * The discountTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $discountTotal;
    /**
     * The taxTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxTotal;
    /**
     * The altShippingCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $altShippingCost;
    /**
     * The altHandlingCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $altHandlingCost;
    /**
     * The total
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $total;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The job
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $job;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The giftCertApplied
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $giftCertApplied;
    /**
     * The tranIsVsoeBundle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $tranIsVsoeBundle;
    /**
     * The vsoeAutoCalc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $vsoeAutoCalc;
    /**
     * The syncPartnerTeams
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $syncPartnerTeams;
    /**
     * The shipGroupList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomSaleShipGroupList
     */
    public $shipGroupList;
    /**
     * The overrideInstallments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $overrideInstallments;
    /**
     * The installmentList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InstallmentList
     */
    public $installmentList;
    /**
     * The partnersList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomSalePartnersList
     */
    public $partnersList;
    /**
     * The promotionsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PromotionsList
     */
    public $promotionsList;
    /**
     * The itemList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomSaleItemList
     */
    public $itemList;
    /**
     * The giftCertRedemptionList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\GiftCertRedemptionList
     */
    public $giftCertRedemptionList;
    /**
     * The accountingBookDetailList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccountingBookDetailList
     */
    public $accountingBookDetailList;
    /**
     * The salesTeamList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomSaleSalesTeamList
     */
    public $salesTeamList;
    /**
     * The taxDetailsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TaxDetailsList
     */
    public $taxDetailsList;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for CustomSale
     * @uses CustomSale::setCreatedDate()
     * @uses CustomSale::setLastModifiedDate()
     * @uses CustomSale::setTranType()
     * @uses CustomSale::setNexus()
     * @uses CustomSale::setSubsidiaryTaxRegNum()
     * @uses CustomSale::setTaxRegOverride()
     * @uses CustomSale::setTaxDetailsOverride()
     * @uses CustomSale::setCustomForm()
     * @uses CustomSale::setEntity()
     * @uses CustomSale::setBillingAccount()
     * @uses CustomSale::setTranDate()
     * @uses CustomSale::setTranId()
     * @uses CustomSale::setEntityTaxRegNum()
     * @uses CustomSale::setSource()
     * @uses CustomSale::setCreatedFrom()
     * @uses CustomSale::setPostingPeriod()
     * @uses CustomSale::setOpportunity()
     * @uses CustomSale::setDepartment()
     * @uses CustomSale::setClass()
     * @uses CustomSale::setTerms()
     * @uses CustomSale::setLocation()
     * @uses CustomSale::setSubsidiary()
     * @uses CustomSale::setCurrency()
     * @uses CustomSale::setDueDate()
     * @uses CustomSale::setDiscountDate()
     * @uses CustomSale::setDiscountAmount()
     * @uses CustomSale::setSalesRep()
     * @uses CustomSale::setPartner()
     * @uses CustomSale::setLeadSource()
     * @uses CustomSale::setStartDate()
     * @uses CustomSale::setEndDate()
     * @uses CustomSale::setOtherRefNum()
     * @uses CustomSale::setMemo()
     * @uses CustomSale::setTranStatus()
     * @uses CustomSale::setSalesEffectiveDate()
     * @uses CustomSale::setExcludeCommission()
     * @uses CustomSale::setTotalCostEstimate()
     * @uses CustomSale::setEstGrossProfit()
     * @uses CustomSale::setEstGrossProfitPercent()
     * @uses CustomSale::setRevRecSchedule()
     * @uses CustomSale::setRevRecStartDate()
     * @uses CustomSale::setRevRecEndDate()
     * @uses CustomSale::setAccount()
     * @uses CustomSale::setExchangeRate()
     * @uses CustomSale::setCurrencyName()
     * @uses CustomSale::setPromoCode()
     * @uses CustomSale::setDiscountItem()
     * @uses CustomSale::setDiscountRate()
     * @uses CustomSale::setIsMultiShipTo()
     * @uses CustomSale::setIsTaxable()
     * @uses CustomSale::setToBePrinted()
     * @uses CustomSale::setToBeEmailed()
     * @uses CustomSale::setToBeFaxed()
     * @uses CustomSale::setFax()
     * @uses CustomSale::setMessageSel()
     * @uses CustomSale::setMessage()
     * @uses CustomSale::setBillingAddress()
     * @uses CustomSale::setBillAddressList()
     * @uses CustomSale::setShippingAddress()
     * @uses CustomSale::setShipIsResidential()
     * @uses CustomSale::setShipAddressList()
     * @uses CustomSale::setFob()
     * @uses CustomSale::setShipDate()
     * @uses CustomSale::setShipMethod()
     * @uses CustomSale::setShippingCost()
     * @uses CustomSale::setHandlingCost()
     * @uses CustomSale::setTrackingNumbers()
     * @uses CustomSale::setLinkedTrackingNumbers()
     * @uses CustomSale::setSalesGroup()
     * @uses CustomSale::setSubTotal()
     * @uses CustomSale::setRevenueStatus()
     * @uses CustomSale::setRecognizedRevenue()
     * @uses CustomSale::setDeferredRevenue()
     * @uses CustomSale::setRevRecOnRevCommitment()
     * @uses CustomSale::setSyncSalesTeams()
     * @uses CustomSale::setDiscountTotal()
     * @uses CustomSale::setTaxTotal()
     * @uses CustomSale::setAltShippingCost()
     * @uses CustomSale::setAltHandlingCost()
     * @uses CustomSale::setTotal()
     * @uses CustomSale::setStatus()
     * @uses CustomSale::setJob()
     * @uses CustomSale::setEmail()
     * @uses CustomSale::setGiftCertApplied()
     * @uses CustomSale::setTranIsVsoeBundle()
     * @uses CustomSale::setVsoeAutoCalc()
     * @uses CustomSale::setSyncPartnerTeams()
     * @uses CustomSale::setShipGroupList()
     * @uses CustomSale::setOverrideInstallments()
     * @uses CustomSale::setInstallmentList()
     * @uses CustomSale::setPartnersList()
     * @uses CustomSale::setPromotionsList()
     * @uses CustomSale::setItemList()
     * @uses CustomSale::setGiftCertRedemptionList()
     * @uses CustomSale::setAccountingBookDetailList()
     * @uses CustomSale::setSalesTeamList()
     * @uses CustomSale::setTaxDetailsList()
     * @uses CustomSale::setCustomFieldList()
     * @uses CustomSale::setInternalId()
     * @uses CustomSale::setExternalId()
     * @param string $createdDate
     * @param string $lastModifiedDate
     * @param \StructType\RecordRef $tranType
     * @param \StructType\RecordRef $nexus
     * @param \StructType\RecordRef $subsidiaryTaxRegNum
     * @param bool $taxRegOverride
     * @param bool $taxDetailsOverride
     * @param \StructType\RecordRef $customForm
     * @param \StructType\RecordRef $entity
     * @param \StructType\RecordRef $billingAccount
     * @param string $tranDate
     * @param string $tranId
     * @param \StructType\RecordRef $entityTaxRegNum
     * @param string $source
     * @param \StructType\RecordRef $createdFrom
     * @param \StructType\RecordRef $postingPeriod
     * @param \StructType\RecordRef $opportunity
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $terms
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRef $subsidiary
     * @param \StructType\RecordRef $currency
     * @param string $dueDate
     * @param string $discountDate
     * @param float $discountAmount
     * @param \StructType\RecordRef $salesRep
     * @param \StructType\RecordRef $partner
     * @param \StructType\RecordRef $leadSource
     * @param string $startDate
     * @param string $endDate
     * @param string $otherRefNum
     * @param string $memo
     * @param \StructType\RecordRef $tranStatus
     * @param string $salesEffectiveDate
     * @param bool $excludeCommission
     * @param float $totalCostEstimate
     * @param float $estGrossProfit
     * @param float $estGrossProfitPercent
     * @param \StructType\RecordRef $revRecSchedule
     * @param string $revRecStartDate
     * @param string $revRecEndDate
     * @param \StructType\RecordRef $account
     * @param float $exchangeRate
     * @param string $currencyName
     * @param \StructType\RecordRef $promoCode
     * @param \StructType\RecordRef $discountItem
     * @param string $discountRate
     * @param bool $isMultiShipTo
     * @param bool $isTaxable
     * @param bool $toBePrinted
     * @param bool $toBeEmailed
     * @param bool $toBeFaxed
     * @param string $fax
     * @param \StructType\RecordRef $messageSel
     * @param string $message
     * @param \StructType\Address $billingAddress
     * @param \StructType\RecordRef $billAddressList
     * @param \StructType\Address $shippingAddress
     * @param bool $shipIsResidential
     * @param \StructType\RecordRef $shipAddressList
     * @param string $fob
     * @param string $shipDate
     * @param \StructType\RecordRef $shipMethod
     * @param float $shippingCost
     * @param float $handlingCost
     * @param string $trackingNumbers
     * @param string $linkedTrackingNumbers
     * @param \StructType\RecordRef $salesGroup
     * @param float $subTotal
     * @param string $revenueStatus
     * @param float $recognizedRevenue
     * @param float $deferredRevenue
     * @param bool $revRecOnRevCommitment
     * @param bool $syncSalesTeams
     * @param float $discountTotal
     * @param float $taxTotal
     * @param float $altShippingCost
     * @param float $altHandlingCost
     * @param float $total
     * @param string $status
     * @param \StructType\RecordRef $job
     * @param string $email
     * @param float $giftCertApplied
     * @param bool $tranIsVsoeBundle
     * @param bool $vsoeAutoCalc
     * @param bool $syncPartnerTeams
     * @param \StructType\CustomSaleShipGroupList $shipGroupList
     * @param bool $overrideInstallments
     * @param \StructType\InstallmentList $installmentList
     * @param \StructType\CustomSalePartnersList $partnersList
     * @param \StructType\PromotionsList $promotionsList
     * @param \StructType\CustomSaleItemList $itemList
     * @param \StructType\GiftCertRedemptionList $giftCertRedemptionList
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @param \StructType\CustomSaleSalesTeamList $salesTeamList
     * @param \StructType\TaxDetailsList $taxDetailsList
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($createdDate = null, $lastModifiedDate = null, \StructType\RecordRef $tranType = null, \StructType\RecordRef $nexus = null, \StructType\RecordRef $subsidiaryTaxRegNum = null, $taxRegOverride = null, $taxDetailsOverride = null, \StructType\RecordRef $customForm = null, \StructType\RecordRef $entity = null, \StructType\RecordRef $billingAccount = null, $tranDate = null, $tranId = null, \StructType\RecordRef $entityTaxRegNum = null, $source = null, \StructType\RecordRef $createdFrom = null, \StructType\RecordRef $postingPeriod = null, \StructType\RecordRef $opportunity = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRef $terms = null, \StructType\RecordRef $location = null, \StructType\RecordRef $subsidiary = null, \StructType\RecordRef $currency = null, $dueDate = null, $discountDate = null, $discountAmount = null, \StructType\RecordRef $salesRep = null, \StructType\RecordRef $partner = null, \StructType\RecordRef $leadSource = null, $startDate = null, $endDate = null, $otherRefNum = null, $memo = null, \StructType\RecordRef $tranStatus = null, $salesEffectiveDate = null, $excludeCommission = null, $totalCostEstimate = null, $estGrossProfit = null, $estGrossProfitPercent = null, \StructType\RecordRef $revRecSchedule = null, $revRecStartDate = null, $revRecEndDate = null, \StructType\RecordRef $account = null, $exchangeRate = null, $currencyName = null, \StructType\RecordRef $promoCode = null, \StructType\RecordRef $discountItem = null, $discountRate = null, $isMultiShipTo = null, $isTaxable = null, $toBePrinted = null, $toBeEmailed = null, $toBeFaxed = null, $fax = null, \StructType\RecordRef $messageSel = null, $message = null, \StructType\Address $billingAddress = null, \StructType\RecordRef $billAddressList = null, \StructType\Address $shippingAddress = null, $shipIsResidential = null, \StructType\RecordRef $shipAddressList = null, $fob = null, $shipDate = null, \StructType\RecordRef $shipMethod = null, $shippingCost = null, $handlingCost = null, $trackingNumbers = null, $linkedTrackingNumbers = null, \StructType\RecordRef $salesGroup = null, $subTotal = null, $revenueStatus = null, $recognizedRevenue = null, $deferredRevenue = null, $revRecOnRevCommitment = null, $syncSalesTeams = null, $discountTotal = null, $taxTotal = null, $altShippingCost = null, $altHandlingCost = null, $total = null, $status = null, \StructType\RecordRef $job = null, $email = null, $giftCertApplied = null, $tranIsVsoeBundle = null, $vsoeAutoCalc = null, $syncPartnerTeams = null, \StructType\CustomSaleShipGroupList $shipGroupList = null, $overrideInstallments = null, \StructType\InstallmentList $installmentList = null, \StructType\CustomSalePartnersList $partnersList = null, \StructType\PromotionsList $promotionsList = null, \StructType\CustomSaleItemList $itemList = null, \StructType\GiftCertRedemptionList $giftCertRedemptionList = null, \StructType\AccountingBookDetailList $accountingBookDetailList = null, \StructType\CustomSaleSalesTeamList $salesTeamList = null, \StructType\TaxDetailsList $taxDetailsList = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCreatedDate($createdDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setTranType($tranType)
            ->setNexus($nexus)
            ->setSubsidiaryTaxRegNum($subsidiaryTaxRegNum)
            ->setTaxRegOverride($taxRegOverride)
            ->setTaxDetailsOverride($taxDetailsOverride)
            ->setCustomForm($customForm)
            ->setEntity($entity)
            ->setBillingAccount($billingAccount)
            ->setTranDate($tranDate)
            ->setTranId($tranId)
            ->setEntityTaxRegNum($entityTaxRegNum)
            ->setSource($source)
            ->setCreatedFrom($createdFrom)
            ->setPostingPeriod($postingPeriod)
            ->setOpportunity($opportunity)
            ->setDepartment($department)
            ->setClass($class)
            ->setTerms($terms)
            ->setLocation($location)
            ->setSubsidiary($subsidiary)
            ->setCurrency($currency)
            ->setDueDate($dueDate)
            ->setDiscountDate($discountDate)
            ->setDiscountAmount($discountAmount)
            ->setSalesRep($salesRep)
            ->setPartner($partner)
            ->setLeadSource($leadSource)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setOtherRefNum($otherRefNum)
            ->setMemo($memo)
            ->setTranStatus($tranStatus)
            ->setSalesEffectiveDate($salesEffectiveDate)
            ->setExcludeCommission($excludeCommission)
            ->setTotalCostEstimate($totalCostEstimate)
            ->setEstGrossProfit($estGrossProfit)
            ->setEstGrossProfitPercent($estGrossProfitPercent)
            ->setRevRecSchedule($revRecSchedule)
            ->setRevRecStartDate($revRecStartDate)
            ->setRevRecEndDate($revRecEndDate)
            ->setAccount($account)
            ->setExchangeRate($exchangeRate)
            ->setCurrencyName($currencyName)
            ->setPromoCode($promoCode)
            ->setDiscountItem($discountItem)
            ->setDiscountRate($discountRate)
            ->setIsMultiShipTo($isMultiShipTo)
            ->setIsTaxable($isTaxable)
            ->setToBePrinted($toBePrinted)
            ->setToBeEmailed($toBeEmailed)
            ->setToBeFaxed($toBeFaxed)
            ->setFax($fax)
            ->setMessageSel($messageSel)
            ->setMessage($message)
            ->setBillingAddress($billingAddress)
            ->setBillAddressList($billAddressList)
            ->setShippingAddress($shippingAddress)
            ->setShipIsResidential($shipIsResidential)
            ->setShipAddressList($shipAddressList)
            ->setFob($fob)
            ->setShipDate($shipDate)
            ->setShipMethod($shipMethod)
            ->setShippingCost($shippingCost)
            ->setHandlingCost($handlingCost)
            ->setTrackingNumbers($trackingNumbers)
            ->setLinkedTrackingNumbers($linkedTrackingNumbers)
            ->setSalesGroup($salesGroup)
            ->setSubTotal($subTotal)
            ->setRevenueStatus($revenueStatus)
            ->setRecognizedRevenue($recognizedRevenue)
            ->setDeferredRevenue($deferredRevenue)
            ->setRevRecOnRevCommitment($revRecOnRevCommitment)
            ->setSyncSalesTeams($syncSalesTeams)
            ->setDiscountTotal($discountTotal)
            ->setTaxTotal($taxTotal)
            ->setAltShippingCost($altShippingCost)
            ->setAltHandlingCost($altHandlingCost)
            ->setTotal($total)
            ->setStatus($status)
            ->setJob($job)
            ->setEmail($email)
            ->setGiftCertApplied($giftCertApplied)
            ->setTranIsVsoeBundle($tranIsVsoeBundle)
            ->setVsoeAutoCalc($vsoeAutoCalc)
            ->setSyncPartnerTeams($syncPartnerTeams)
            ->setShipGroupList($shipGroupList)
            ->setOverrideInstallments($overrideInstallments)
            ->setInstallmentList($installmentList)
            ->setPartnersList($partnersList)
            ->setPromotionsList($promotionsList)
            ->setItemList($itemList)
            ->setGiftCertRedemptionList($giftCertRedemptionList)
            ->setAccountingBookDetailList($accountingBookDetailList)
            ->setSalesTeamList($salesTeamList)
            ->setTaxDetailsList($taxDetailsList)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\CustomSale
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\CustomSale
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get tranType value
     * @return \StructType\RecordRef|null
     */
    public function getTranType()
    {
        return $this->tranType;
    }
    /**
     * Set tranType value
     * @param \StructType\RecordRef $tranType
     * @return \StructType\CustomSale
     */
    public function setTranType(\StructType\RecordRef $tranType = null)
    {
        $this->tranType = $tranType;
        return $this;
    }
    /**
     * Get nexus value
     * @return \StructType\RecordRef|null
     */
    public function getNexus()
    {
        return $this->nexus;
    }
    /**
     * Set nexus value
     * @param \StructType\RecordRef $nexus
     * @return \StructType\CustomSale
     */
    public function setNexus(\StructType\RecordRef $nexus = null)
    {
        $this->nexus = $nexus;
        return $this;
    }
    /**
     * Get subsidiaryTaxRegNum value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiaryTaxRegNum()
    {
        return $this->subsidiaryTaxRegNum;
    }
    /**
     * Set subsidiaryTaxRegNum value
     * @param \StructType\RecordRef $subsidiaryTaxRegNum
     * @return \StructType\CustomSale
     */
    public function setSubsidiaryTaxRegNum(\StructType\RecordRef $subsidiaryTaxRegNum = null)
    {
        $this->subsidiaryTaxRegNum = $subsidiaryTaxRegNum;
        return $this;
    }
    /**
     * Get taxRegOverride value
     * @return bool|null
     */
    public function getTaxRegOverride()
    {
        return $this->taxRegOverride;
    }
    /**
     * Set taxRegOverride value
     * @param bool $taxRegOverride
     * @return \StructType\CustomSale
     */
    public function setTaxRegOverride($taxRegOverride = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxRegOverride) && !is_bool($taxRegOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxRegOverride, true), gettype($taxRegOverride)), __LINE__);
        }
        $this->taxRegOverride = $taxRegOverride;
        return $this;
    }
    /**
     * Get taxDetailsOverride value
     * @return bool|null
     */
    public function getTaxDetailsOverride()
    {
        return $this->taxDetailsOverride;
    }
    /**
     * Set taxDetailsOverride value
     * @param bool $taxDetailsOverride
     * @return \StructType\CustomSale
     */
    public function setTaxDetailsOverride($taxDetailsOverride = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxDetailsOverride) && !is_bool($taxDetailsOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxDetailsOverride, true), gettype($taxDetailsOverride)), __LINE__);
        }
        $this->taxDetailsOverride = $taxDetailsOverride;
        return $this;
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\CustomSale
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get entity value
     * @return \StructType\RecordRef|null
     */
    public function getEntity()
    {
        return $this->entity;
    }
    /**
     * Set entity value
     * @param \StructType\RecordRef $entity
     * @return \StructType\CustomSale
     */
    public function setEntity(\StructType\RecordRef $entity = null)
    {
        $this->entity = $entity;
        return $this;
    }
    /**
     * Get billingAccount value
     * @return \StructType\RecordRef|null
     */
    public function getBillingAccount()
    {
        return $this->billingAccount;
    }
    /**
     * Set billingAccount value
     * @param \StructType\RecordRef $billingAccount
     * @return \StructType\CustomSale
     */
    public function setBillingAccount(\StructType\RecordRef $billingAccount = null)
    {
        $this->billingAccount = $billingAccount;
        return $this;
    }
    /**
     * Get tranDate value
     * @return string|null
     */
    public function getTranDate()
    {
        return $this->tranDate;
    }
    /**
     * Set tranDate value
     * @param string $tranDate
     * @return \StructType\CustomSale
     */
    public function setTranDate($tranDate = null)
    {
        // validation for constraint: string
        if (!is_null($tranDate) && !is_string($tranDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranDate, true), gettype($tranDate)), __LINE__);
        }
        $this->tranDate = $tranDate;
        return $this;
    }
    /**
     * Get tranId value
     * @return string|null
     */
    public function getTranId()
    {
        return $this->tranId;
    }
    /**
     * Set tranId value
     * @param string $tranId
     * @return \StructType\CustomSale
     */
    public function setTranId($tranId = null)
    {
        // validation for constraint: string
        if (!is_null($tranId) && !is_string($tranId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranId, true), gettype($tranId)), __LINE__);
        }
        $this->tranId = $tranId;
        return $this;
    }
    /**
     * Get entityTaxRegNum value
     * @return \StructType\RecordRef|null
     */
    public function getEntityTaxRegNum()
    {
        return $this->entityTaxRegNum;
    }
    /**
     * Set entityTaxRegNum value
     * @param \StructType\RecordRef $entityTaxRegNum
     * @return \StructType\CustomSale
     */
    public function setEntityTaxRegNum(\StructType\RecordRef $entityTaxRegNum = null)
    {
        $this->entityTaxRegNum = $entityTaxRegNum;
        return $this;
    }
    /**
     * Get source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->source;
    }
    /**
     * Set source value
     * @param string $source
     * @return \StructType\CustomSale
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($source, true), gettype($source)), __LINE__);
        }
        $this->source = $source;
        return $this;
    }
    /**
     * Get createdFrom value
     * @return \StructType\RecordRef|null
     */
    public function getCreatedFrom()
    {
        return $this->createdFrom;
    }
    /**
     * Set createdFrom value
     * @param \StructType\RecordRef $createdFrom
     * @return \StructType\CustomSale
     */
    public function setCreatedFrom(\StructType\RecordRef $createdFrom = null)
    {
        $this->createdFrom = $createdFrom;
        return $this;
    }
    /**
     * Get postingPeriod value
     * @return \StructType\RecordRef|null
     */
    public function getPostingPeriod()
    {
        return $this->postingPeriod;
    }
    /**
     * Set postingPeriod value
     * @param \StructType\RecordRef $postingPeriod
     * @return \StructType\CustomSale
     */
    public function setPostingPeriod(\StructType\RecordRef $postingPeriod = null)
    {
        $this->postingPeriod = $postingPeriod;
        return $this;
    }
    /**
     * Get opportunity value
     * @return \StructType\RecordRef|null
     */
    public function getOpportunity()
    {
        return $this->opportunity;
    }
    /**
     * Set opportunity value
     * @param \StructType\RecordRef $opportunity
     * @return \StructType\CustomSale
     */
    public function setOpportunity(\StructType\RecordRef $opportunity = null)
    {
        $this->opportunity = $opportunity;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\CustomSale
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\CustomSale
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get terms value
     * @return \StructType\RecordRef|null
     */
    public function getTerms()
    {
        return $this->terms;
    }
    /**
     * Set terms value
     * @param \StructType\RecordRef $terms
     * @return \StructType\CustomSale
     */
    public function setTerms(\StructType\RecordRef $terms = null)
    {
        $this->terms = $terms;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\CustomSale
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\RecordRef $subsidiary
     * @return \StructType\CustomSale
     */
    public function setSubsidiary(\StructType\RecordRef $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\RecordRef|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \StructType\RecordRef $currency
     * @return \StructType\CustomSale
     */
    public function setCurrency(\StructType\RecordRef $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get dueDate value
     * @return string|null
     */
    public function getDueDate()
    {
        return $this->dueDate;
    }
    /**
     * Set dueDate value
     * @param string $dueDate
     * @return \StructType\CustomSale
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dueDate, true), gettype($dueDate)), __LINE__);
        }
        $this->dueDate = $dueDate;
        return $this;
    }
    /**
     * Get discountDate value
     * @return string|null
     */
    public function getDiscountDate()
    {
        return $this->discountDate;
    }
    /**
     * Set discountDate value
     * @param string $discountDate
     * @return \StructType\CustomSale
     */
    public function setDiscountDate($discountDate = null)
    {
        // validation for constraint: string
        if (!is_null($discountDate) && !is_string($discountDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountDate, true), gettype($discountDate)), __LINE__);
        }
        $this->discountDate = $discountDate;
        return $this;
    }
    /**
     * Get discountAmount value
     * @return float|null
     */
    public function getDiscountAmount()
    {
        return $this->discountAmount;
    }
    /**
     * Set discountAmount value
     * @param float $discountAmount
     * @return \StructType\CustomSale
     */
    public function setDiscountAmount($discountAmount = null)
    {
        // validation for constraint: float
        if (!is_null($discountAmount) && !(is_float($discountAmount) || is_numeric($discountAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountAmount, true), gettype($discountAmount)), __LINE__);
        }
        $this->discountAmount = $discountAmount;
        return $this;
    }
    /**
     * Get salesRep value
     * @return \StructType\RecordRef|null
     */
    public function getSalesRep()
    {
        return $this->salesRep;
    }
    /**
     * Set salesRep value
     * @param \StructType\RecordRef $salesRep
     * @return \StructType\CustomSale
     */
    public function setSalesRep(\StructType\RecordRef $salesRep = null)
    {
        $this->salesRep = $salesRep;
        return $this;
    }
    /**
     * Get partner value
     * @return \StructType\RecordRef|null
     */
    public function getPartner()
    {
        return $this->partner;
    }
    /**
     * Set partner value
     * @param \StructType\RecordRef $partner
     * @return \StructType\CustomSale
     */
    public function setPartner(\StructType\RecordRef $partner = null)
    {
        $this->partner = $partner;
        return $this;
    }
    /**
     * Get leadSource value
     * @return \StructType\RecordRef|null
     */
    public function getLeadSource()
    {
        return $this->leadSource;
    }
    /**
     * Set leadSource value
     * @param \StructType\RecordRef $leadSource
     * @return \StructType\CustomSale
     */
    public function setLeadSource(\StructType\RecordRef $leadSource = null)
    {
        $this->leadSource = $leadSource;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\CustomSale
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\CustomSale
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get otherRefNum value
     * @return string|null
     */
    public function getOtherRefNum()
    {
        return $this->otherRefNum;
    }
    /**
     * Set otherRefNum value
     * @param string $otherRefNum
     * @return \StructType\CustomSale
     */
    public function setOtherRefNum($otherRefNum = null)
    {
        // validation for constraint: string
        if (!is_null($otherRefNum) && !is_string($otherRefNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otherRefNum, true), gettype($otherRefNum)), __LINE__);
        }
        $this->otherRefNum = $otherRefNum;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\CustomSale
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get tranStatus value
     * @return \StructType\RecordRef|null
     */
    public function getTranStatus()
    {
        return $this->tranStatus;
    }
    /**
     * Set tranStatus value
     * @param \StructType\RecordRef $tranStatus
     * @return \StructType\CustomSale
     */
    public function setTranStatus(\StructType\RecordRef $tranStatus = null)
    {
        $this->tranStatus = $tranStatus;
        return $this;
    }
    /**
     * Get salesEffectiveDate value
     * @return string|null
     */
    public function getSalesEffectiveDate()
    {
        return $this->salesEffectiveDate;
    }
    /**
     * Set salesEffectiveDate value
     * @param string $salesEffectiveDate
     * @return \StructType\CustomSale
     */
    public function setSalesEffectiveDate($salesEffectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($salesEffectiveDate) && !is_string($salesEffectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesEffectiveDate, true), gettype($salesEffectiveDate)), __LINE__);
        }
        $this->salesEffectiveDate = $salesEffectiveDate;
        return $this;
    }
    /**
     * Get excludeCommission value
     * @return bool|null
     */
    public function getExcludeCommission()
    {
        return $this->excludeCommission;
    }
    /**
     * Set excludeCommission value
     * @param bool $excludeCommission
     * @return \StructType\CustomSale
     */
    public function setExcludeCommission($excludeCommission = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludeCommission) && !is_bool($excludeCommission)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($excludeCommission, true), gettype($excludeCommission)), __LINE__);
        }
        $this->excludeCommission = $excludeCommission;
        return $this;
    }
    /**
     * Get totalCostEstimate value
     * @return float|null
     */
    public function getTotalCostEstimate()
    {
        return $this->totalCostEstimate;
    }
    /**
     * Set totalCostEstimate value
     * @param float $totalCostEstimate
     * @return \StructType\CustomSale
     */
    public function setTotalCostEstimate($totalCostEstimate = null)
    {
        // validation for constraint: float
        if (!is_null($totalCostEstimate) && !(is_float($totalCostEstimate) || is_numeric($totalCostEstimate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalCostEstimate, true), gettype($totalCostEstimate)), __LINE__);
        }
        $this->totalCostEstimate = $totalCostEstimate;
        return $this;
    }
    /**
     * Get estGrossProfit value
     * @return float|null
     */
    public function getEstGrossProfit()
    {
        return $this->estGrossProfit;
    }
    /**
     * Set estGrossProfit value
     * @param float $estGrossProfit
     * @return \StructType\CustomSale
     */
    public function setEstGrossProfit($estGrossProfit = null)
    {
        // validation for constraint: float
        if (!is_null($estGrossProfit) && !(is_float($estGrossProfit) || is_numeric($estGrossProfit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estGrossProfit, true), gettype($estGrossProfit)), __LINE__);
        }
        $this->estGrossProfit = $estGrossProfit;
        return $this;
    }
    /**
     * Get estGrossProfitPercent value
     * @return float|null
     */
    public function getEstGrossProfitPercent()
    {
        return $this->estGrossProfitPercent;
    }
    /**
     * Set estGrossProfitPercent value
     * @param float $estGrossProfitPercent
     * @return \StructType\CustomSale
     */
    public function setEstGrossProfitPercent($estGrossProfitPercent = null)
    {
        // validation for constraint: float
        if (!is_null($estGrossProfitPercent) && !(is_float($estGrossProfitPercent) || is_numeric($estGrossProfitPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estGrossProfitPercent, true), gettype($estGrossProfitPercent)), __LINE__);
        }
        $this->estGrossProfitPercent = $estGrossProfitPercent;
        return $this;
    }
    /**
     * Get revRecSchedule value
     * @return \StructType\RecordRef|null
     */
    public function getRevRecSchedule()
    {
        return $this->revRecSchedule;
    }
    /**
     * Set revRecSchedule value
     * @param \StructType\RecordRef $revRecSchedule
     * @return \StructType\CustomSale
     */
    public function setRevRecSchedule(\StructType\RecordRef $revRecSchedule = null)
    {
        $this->revRecSchedule = $revRecSchedule;
        return $this;
    }
    /**
     * Get revRecStartDate value
     * @return string|null
     */
    public function getRevRecStartDate()
    {
        return $this->revRecStartDate;
    }
    /**
     * Set revRecStartDate value
     * @param string $revRecStartDate
     * @return \StructType\CustomSale
     */
    public function setRevRecStartDate($revRecStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($revRecStartDate) && !is_string($revRecStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($revRecStartDate, true), gettype($revRecStartDate)), __LINE__);
        }
        $this->revRecStartDate = $revRecStartDate;
        return $this;
    }
    /**
     * Get revRecEndDate value
     * @return string|null
     */
    public function getRevRecEndDate()
    {
        return $this->revRecEndDate;
    }
    /**
     * Set revRecEndDate value
     * @param string $revRecEndDate
     * @return \StructType\CustomSale
     */
    public function setRevRecEndDate($revRecEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($revRecEndDate) && !is_string($revRecEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($revRecEndDate, true), gettype($revRecEndDate)), __LINE__);
        }
        $this->revRecEndDate = $revRecEndDate;
        return $this;
    }
    /**
     * Get account value
     * @return \StructType\RecordRef|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * Set account value
     * @param \StructType\RecordRef $account
     * @return \StructType\CustomSale
     */
    public function setAccount(\StructType\RecordRef $account = null)
    {
        $this->account = $account;
        return $this;
    }
    /**
     * Get exchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->exchangeRate;
    }
    /**
     * Set exchangeRate value
     * @param float $exchangeRate
     * @return \StructType\CustomSale
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->exchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get currencyName value
     * @return string|null
     */
    public function getCurrencyName()
    {
        return $this->currencyName;
    }
    /**
     * Set currencyName value
     * @param string $currencyName
     * @return \StructType\CustomSale
     */
    public function setCurrencyName($currencyName = null)
    {
        // validation for constraint: string
        if (!is_null($currencyName) && !is_string($currencyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyName, true), gettype($currencyName)), __LINE__);
        }
        $this->currencyName = $currencyName;
        return $this;
    }
    /**
     * Get promoCode value
     * @return \StructType\RecordRef|null
     */
    public function getPromoCode()
    {
        return $this->promoCode;
    }
    /**
     * Set promoCode value
     * @param \StructType\RecordRef $promoCode
     * @return \StructType\CustomSale
     */
    public function setPromoCode(\StructType\RecordRef $promoCode = null)
    {
        $this->promoCode = $promoCode;
        return $this;
    }
    /**
     * Get discountItem value
     * @return \StructType\RecordRef|null
     */
    public function getDiscountItem()
    {
        return $this->discountItem;
    }
    /**
     * Set discountItem value
     * @param \StructType\RecordRef $discountItem
     * @return \StructType\CustomSale
     */
    public function setDiscountItem(\StructType\RecordRef $discountItem = null)
    {
        $this->discountItem = $discountItem;
        return $this;
    }
    /**
     * Get discountRate value
     * @return string|null
     */
    public function getDiscountRate()
    {
        return $this->discountRate;
    }
    /**
     * Set discountRate value
     * @param string $discountRate
     * @return \StructType\CustomSale
     */
    public function setDiscountRate($discountRate = null)
    {
        // validation for constraint: string
        if (!is_null($discountRate) && !is_string($discountRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountRate, true), gettype($discountRate)), __LINE__);
        }
        $this->discountRate = $discountRate;
        return $this;
    }
    /**
     * Get isMultiShipTo value
     * @return bool|null
     */
    public function getIsMultiShipTo()
    {
        return $this->isMultiShipTo;
    }
    /**
     * Set isMultiShipTo value
     * @param bool $isMultiShipTo
     * @return \StructType\CustomSale
     */
    public function setIsMultiShipTo($isMultiShipTo = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMultiShipTo) && !is_bool($isMultiShipTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMultiShipTo, true), gettype($isMultiShipTo)), __LINE__);
        }
        $this->isMultiShipTo = $isMultiShipTo;
        return $this;
    }
    /**
     * Get isTaxable value
     * @return bool|null
     */
    public function getIsTaxable()
    {
        return $this->isTaxable;
    }
    /**
     * Set isTaxable value
     * @param bool $isTaxable
     * @return \StructType\CustomSale
     */
    public function setIsTaxable($isTaxable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTaxable) && !is_bool($isTaxable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTaxable, true), gettype($isTaxable)), __LINE__);
        }
        $this->isTaxable = $isTaxable;
        return $this;
    }
    /**
     * Get toBePrinted value
     * @return bool|null
     */
    public function getToBePrinted()
    {
        return $this->toBePrinted;
    }
    /**
     * Set toBePrinted value
     * @param bool $toBePrinted
     * @return \StructType\CustomSale
     */
    public function setToBePrinted($toBePrinted = null)
    {
        // validation for constraint: boolean
        if (!is_null($toBePrinted) && !is_bool($toBePrinted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($toBePrinted, true), gettype($toBePrinted)), __LINE__);
        }
        $this->toBePrinted = $toBePrinted;
        return $this;
    }
    /**
     * Get toBeEmailed value
     * @return bool|null
     */
    public function getToBeEmailed()
    {
        return $this->toBeEmailed;
    }
    /**
     * Set toBeEmailed value
     * @param bool $toBeEmailed
     * @return \StructType\CustomSale
     */
    public function setToBeEmailed($toBeEmailed = null)
    {
        // validation for constraint: boolean
        if (!is_null($toBeEmailed) && !is_bool($toBeEmailed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($toBeEmailed, true), gettype($toBeEmailed)), __LINE__);
        }
        $this->toBeEmailed = $toBeEmailed;
        return $this;
    }
    /**
     * Get toBeFaxed value
     * @return bool|null
     */
    public function getToBeFaxed()
    {
        return $this->toBeFaxed;
    }
    /**
     * Set toBeFaxed value
     * @param bool $toBeFaxed
     * @return \StructType\CustomSale
     */
    public function setToBeFaxed($toBeFaxed = null)
    {
        // validation for constraint: boolean
        if (!is_null($toBeFaxed) && !is_bool($toBeFaxed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($toBeFaxed, true), gettype($toBeFaxed)), __LINE__);
        }
        $this->toBeFaxed = $toBeFaxed;
        return $this;
    }
    /**
     * Get fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->fax;
    }
    /**
     * Set fax value
     * @param string $fax
     * @return \StructType\CustomSale
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        $this->fax = $fax;
        return $this;
    }
    /**
     * Get messageSel value
     * @return \StructType\RecordRef|null
     */
    public function getMessageSel()
    {
        return $this->messageSel;
    }
    /**
     * Set messageSel value
     * @param \StructType\RecordRef $messageSel
     * @return \StructType\CustomSale
     */
    public function setMessageSel(\StructType\RecordRef $messageSel = null)
    {
        $this->messageSel = $messageSel;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\CustomSale
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get billingAddress value
     * @return \StructType\Address|null
     */
    public function getBillingAddress()
    {
        return $this->billingAddress;
    }
    /**
     * Set billingAddress value
     * @param \StructType\Address $billingAddress
     * @return \StructType\CustomSale
     */
    public function setBillingAddress(\StructType\Address $billingAddress = null)
    {
        $this->billingAddress = $billingAddress;
        return $this;
    }
    /**
     * Get billAddressList value
     * @return \StructType\RecordRef|null
     */
    public function getBillAddressList()
    {
        return $this->billAddressList;
    }
    /**
     * Set billAddressList value
     * @param \StructType\RecordRef $billAddressList
     * @return \StructType\CustomSale
     */
    public function setBillAddressList(\StructType\RecordRef $billAddressList = null)
    {
        $this->billAddressList = $billAddressList;
        return $this;
    }
    /**
     * Get shippingAddress value
     * @return \StructType\Address|null
     */
    public function getShippingAddress()
    {
        return $this->shippingAddress;
    }
    /**
     * Set shippingAddress value
     * @param \StructType\Address $shippingAddress
     * @return \StructType\CustomSale
     */
    public function setShippingAddress(\StructType\Address $shippingAddress = null)
    {
        $this->shippingAddress = $shippingAddress;
        return $this;
    }
    /**
     * Get shipIsResidential value
     * @return bool|null
     */
    public function getShipIsResidential()
    {
        return $this->shipIsResidential;
    }
    /**
     * Set shipIsResidential value
     * @param bool $shipIsResidential
     * @return \StructType\CustomSale
     */
    public function setShipIsResidential($shipIsResidential = null)
    {
        // validation for constraint: boolean
        if (!is_null($shipIsResidential) && !is_bool($shipIsResidential)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shipIsResidential, true), gettype($shipIsResidential)), __LINE__);
        }
        $this->shipIsResidential = $shipIsResidential;
        return $this;
    }
    /**
     * Get shipAddressList value
     * @return \StructType\RecordRef|null
     */
    public function getShipAddressList()
    {
        return $this->shipAddressList;
    }
    /**
     * Set shipAddressList value
     * @param \StructType\RecordRef $shipAddressList
     * @return \StructType\CustomSale
     */
    public function setShipAddressList(\StructType\RecordRef $shipAddressList = null)
    {
        $this->shipAddressList = $shipAddressList;
        return $this;
    }
    /**
     * Get fob value
     * @return string|null
     */
    public function getFob()
    {
        return $this->fob;
    }
    /**
     * Set fob value
     * @param string $fob
     * @return \StructType\CustomSale
     */
    public function setFob($fob = null)
    {
        // validation for constraint: string
        if (!is_null($fob) && !is_string($fob)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fob, true), gettype($fob)), __LINE__);
        }
        $this->fob = $fob;
        return $this;
    }
    /**
     * Get shipDate value
     * @return string|null
     */
    public function getShipDate()
    {
        return $this->shipDate;
    }
    /**
     * Set shipDate value
     * @param string $shipDate
     * @return \StructType\CustomSale
     */
    public function setShipDate($shipDate = null)
    {
        // validation for constraint: string
        if (!is_null($shipDate) && !is_string($shipDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipDate, true), gettype($shipDate)), __LINE__);
        }
        $this->shipDate = $shipDate;
        return $this;
    }
    /**
     * Get shipMethod value
     * @return \StructType\RecordRef|null
     */
    public function getShipMethod()
    {
        return $this->shipMethod;
    }
    /**
     * Set shipMethod value
     * @param \StructType\RecordRef $shipMethod
     * @return \StructType\CustomSale
     */
    public function setShipMethod(\StructType\RecordRef $shipMethod = null)
    {
        $this->shipMethod = $shipMethod;
        return $this;
    }
    /**
     * Get shippingCost value
     * @return float|null
     */
    public function getShippingCost()
    {
        return $this->shippingCost;
    }
    /**
     * Set shippingCost value
     * @param float $shippingCost
     * @return \StructType\CustomSale
     */
    public function setShippingCost($shippingCost = null)
    {
        // validation for constraint: float
        if (!is_null($shippingCost) && !(is_float($shippingCost) || is_numeric($shippingCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shippingCost, true), gettype($shippingCost)), __LINE__);
        }
        $this->shippingCost = $shippingCost;
        return $this;
    }
    /**
     * Get handlingCost value
     * @return float|null
     */
    public function getHandlingCost()
    {
        return $this->handlingCost;
    }
    /**
     * Set handlingCost value
     * @param float $handlingCost
     * @return \StructType\CustomSale
     */
    public function setHandlingCost($handlingCost = null)
    {
        // validation for constraint: float
        if (!is_null($handlingCost) && !(is_float($handlingCost) || is_numeric($handlingCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($handlingCost, true), gettype($handlingCost)), __LINE__);
        }
        $this->handlingCost = $handlingCost;
        return $this;
    }
    /**
     * Get trackingNumbers value
     * @return string|null
     */
    public function getTrackingNumbers()
    {
        return $this->trackingNumbers;
    }
    /**
     * Set trackingNumbers value
     * @param string $trackingNumbers
     * @return \StructType\CustomSale
     */
    public function setTrackingNumbers($trackingNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumbers) && !is_string($trackingNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingNumbers, true), gettype($trackingNumbers)), __LINE__);
        }
        $this->trackingNumbers = $trackingNumbers;
        return $this;
    }
    /**
     * Get linkedTrackingNumbers value
     * @return string|null
     */
    public function getLinkedTrackingNumbers()
    {
        return $this->linkedTrackingNumbers;
    }
    /**
     * Set linkedTrackingNumbers value
     * @param string $linkedTrackingNumbers
     * @return \StructType\CustomSale
     */
    public function setLinkedTrackingNumbers($linkedTrackingNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($linkedTrackingNumbers) && !is_string($linkedTrackingNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkedTrackingNumbers, true), gettype($linkedTrackingNumbers)), __LINE__);
        }
        $this->linkedTrackingNumbers = $linkedTrackingNumbers;
        return $this;
    }
    /**
     * Get salesGroup value
     * @return \StructType\RecordRef|null
     */
    public function getSalesGroup()
    {
        return $this->salesGroup;
    }
    /**
     * Set salesGroup value
     * @param \StructType\RecordRef $salesGroup
     * @return \StructType\CustomSale
     */
    public function setSalesGroup(\StructType\RecordRef $salesGroup = null)
    {
        $this->salesGroup = $salesGroup;
        return $this;
    }
    /**
     * Get subTotal value
     * @return float|null
     */
    public function getSubTotal()
    {
        return $this->subTotal;
    }
    /**
     * Set subTotal value
     * @param float $subTotal
     * @return \StructType\CustomSale
     */
    public function setSubTotal($subTotal = null)
    {
        // validation for constraint: float
        if (!is_null($subTotal) && !(is_float($subTotal) || is_numeric($subTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($subTotal, true), gettype($subTotal)), __LINE__);
        }
        $this->subTotal = $subTotal;
        return $this;
    }
    /**
     * Get revenueStatus value
     * @return string|null
     */
    public function getRevenueStatus()
    {
        return $this->revenueStatus;
    }
    /**
     * Set revenueStatus value
     * @uses \EnumType\RevenueStatus::valueIsValid()
     * @uses \EnumType\RevenueStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $revenueStatus
     * @return \StructType\CustomSale
     */
    public function setRevenueStatus($revenueStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RevenueStatus::valueIsValid($revenueStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RevenueStatus', is_array($revenueStatus) ? implode(', ', $revenueStatus) : var_export($revenueStatus, true), implode(', ', \EnumType\RevenueStatus::getValidValues())), __LINE__);
        }
        $this->revenueStatus = $revenueStatus;
        return $this;
    }
    /**
     * Get recognizedRevenue value
     * @return float|null
     */
    public function getRecognizedRevenue()
    {
        return $this->recognizedRevenue;
    }
    /**
     * Set recognizedRevenue value
     * @param float $recognizedRevenue
     * @return \StructType\CustomSale
     */
    public function setRecognizedRevenue($recognizedRevenue = null)
    {
        // validation for constraint: float
        if (!is_null($recognizedRevenue) && !(is_float($recognizedRevenue) || is_numeric($recognizedRevenue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($recognizedRevenue, true), gettype($recognizedRevenue)), __LINE__);
        }
        $this->recognizedRevenue = $recognizedRevenue;
        return $this;
    }
    /**
     * Get deferredRevenue value
     * @return float|null
     */
    public function getDeferredRevenue()
    {
        return $this->deferredRevenue;
    }
    /**
     * Set deferredRevenue value
     * @param float $deferredRevenue
     * @return \StructType\CustomSale
     */
    public function setDeferredRevenue($deferredRevenue = null)
    {
        // validation for constraint: float
        if (!is_null($deferredRevenue) && !(is_float($deferredRevenue) || is_numeric($deferredRevenue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($deferredRevenue, true), gettype($deferredRevenue)), __LINE__);
        }
        $this->deferredRevenue = $deferredRevenue;
        return $this;
    }
    /**
     * Get revRecOnRevCommitment value
     * @return bool|null
     */
    public function getRevRecOnRevCommitment()
    {
        return $this->revRecOnRevCommitment;
    }
    /**
     * Set revRecOnRevCommitment value
     * @param bool $revRecOnRevCommitment
     * @return \StructType\CustomSale
     */
    public function setRevRecOnRevCommitment($revRecOnRevCommitment = null)
    {
        // validation for constraint: boolean
        if (!is_null($revRecOnRevCommitment) && !is_bool($revRecOnRevCommitment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($revRecOnRevCommitment, true), gettype($revRecOnRevCommitment)), __LINE__);
        }
        $this->revRecOnRevCommitment = $revRecOnRevCommitment;
        return $this;
    }
    /**
     * Get syncSalesTeams value
     * @return bool|null
     */
    public function getSyncSalesTeams()
    {
        return $this->syncSalesTeams;
    }
    /**
     * Set syncSalesTeams value
     * @param bool $syncSalesTeams
     * @return \StructType\CustomSale
     */
    public function setSyncSalesTeams($syncSalesTeams = null)
    {
        // validation for constraint: boolean
        if (!is_null($syncSalesTeams) && !is_bool($syncSalesTeams)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($syncSalesTeams, true), gettype($syncSalesTeams)), __LINE__);
        }
        $this->syncSalesTeams = $syncSalesTeams;
        return $this;
    }
    /**
     * Get discountTotal value
     * @return float|null
     */
    public function getDiscountTotal()
    {
        return $this->discountTotal;
    }
    /**
     * Set discountTotal value
     * @param float $discountTotal
     * @return \StructType\CustomSale
     */
    public function setDiscountTotal($discountTotal = null)
    {
        // validation for constraint: float
        if (!is_null($discountTotal) && !(is_float($discountTotal) || is_numeric($discountTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountTotal, true), gettype($discountTotal)), __LINE__);
        }
        $this->discountTotal = $discountTotal;
        return $this;
    }
    /**
     * Get taxTotal value
     * @return float|null
     */
    public function getTaxTotal()
    {
        return $this->taxTotal;
    }
    /**
     * Set taxTotal value
     * @param float $taxTotal
     * @return \StructType\CustomSale
     */
    public function setTaxTotal($taxTotal = null)
    {
        // validation for constraint: float
        if (!is_null($taxTotal) && !(is_float($taxTotal) || is_numeric($taxTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxTotal, true), gettype($taxTotal)), __LINE__);
        }
        $this->taxTotal = $taxTotal;
        return $this;
    }
    /**
     * Get altShippingCost value
     * @return float|null
     */
    public function getAltShippingCost()
    {
        return $this->altShippingCost;
    }
    /**
     * Set altShippingCost value
     * @param float $altShippingCost
     * @return \StructType\CustomSale
     */
    public function setAltShippingCost($altShippingCost = null)
    {
        // validation for constraint: float
        if (!is_null($altShippingCost) && !(is_float($altShippingCost) || is_numeric($altShippingCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($altShippingCost, true), gettype($altShippingCost)), __LINE__);
        }
        $this->altShippingCost = $altShippingCost;
        return $this;
    }
    /**
     * Get altHandlingCost value
     * @return float|null
     */
    public function getAltHandlingCost()
    {
        return $this->altHandlingCost;
    }
    /**
     * Set altHandlingCost value
     * @param float $altHandlingCost
     * @return \StructType\CustomSale
     */
    public function setAltHandlingCost($altHandlingCost = null)
    {
        // validation for constraint: float
        if (!is_null($altHandlingCost) && !(is_float($altHandlingCost) || is_numeric($altHandlingCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($altHandlingCost, true), gettype($altHandlingCost)), __LINE__);
        }
        $this->altHandlingCost = $altHandlingCost;
        return $this;
    }
    /**
     * Get total value
     * @return float|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param float $total
     * @return \StructType\CustomSale
     */
    public function setTotal($total = null)
    {
        // validation for constraint: float
        if (!is_null($total) && !(is_float($total) || is_numeric($total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\CustomSale
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get job value
     * @return \StructType\RecordRef|null
     */
    public function getJob()
    {
        return $this->job;
    }
    /**
     * Set job value
     * @param \StructType\RecordRef $job
     * @return \StructType\CustomSale
     */
    public function setJob(\StructType\RecordRef $job = null)
    {
        $this->job = $job;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\CustomSale
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get giftCertApplied value
     * @return float|null
     */
    public function getGiftCertApplied()
    {
        return $this->giftCertApplied;
    }
    /**
     * Set giftCertApplied value
     * @param float $giftCertApplied
     * @return \StructType\CustomSale
     */
    public function setGiftCertApplied($giftCertApplied = null)
    {
        // validation for constraint: float
        if (!is_null($giftCertApplied) && !(is_float($giftCertApplied) || is_numeric($giftCertApplied))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($giftCertApplied, true), gettype($giftCertApplied)), __LINE__);
        }
        $this->giftCertApplied = $giftCertApplied;
        return $this;
    }
    /**
     * Get tranIsVsoeBundle value
     * @return bool|null
     */
    public function getTranIsVsoeBundle()
    {
        return $this->tranIsVsoeBundle;
    }
    /**
     * Set tranIsVsoeBundle value
     * @param bool $tranIsVsoeBundle
     * @return \StructType\CustomSale
     */
    public function setTranIsVsoeBundle($tranIsVsoeBundle = null)
    {
        // validation for constraint: boolean
        if (!is_null($tranIsVsoeBundle) && !is_bool($tranIsVsoeBundle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tranIsVsoeBundle, true), gettype($tranIsVsoeBundle)), __LINE__);
        }
        $this->tranIsVsoeBundle = $tranIsVsoeBundle;
        return $this;
    }
    /**
     * Get vsoeAutoCalc value
     * @return bool|null
     */
    public function getVsoeAutoCalc()
    {
        return $this->vsoeAutoCalc;
    }
    /**
     * Set vsoeAutoCalc value
     * @param bool $vsoeAutoCalc
     * @return \StructType\CustomSale
     */
    public function setVsoeAutoCalc($vsoeAutoCalc = null)
    {
        // validation for constraint: boolean
        if (!is_null($vsoeAutoCalc) && !is_bool($vsoeAutoCalc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vsoeAutoCalc, true), gettype($vsoeAutoCalc)), __LINE__);
        }
        $this->vsoeAutoCalc = $vsoeAutoCalc;
        return $this;
    }
    /**
     * Get syncPartnerTeams value
     * @return bool|null
     */
    public function getSyncPartnerTeams()
    {
        return $this->syncPartnerTeams;
    }
    /**
     * Set syncPartnerTeams value
     * @param bool $syncPartnerTeams
     * @return \StructType\CustomSale
     */
    public function setSyncPartnerTeams($syncPartnerTeams = null)
    {
        // validation for constraint: boolean
        if (!is_null($syncPartnerTeams) && !is_bool($syncPartnerTeams)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($syncPartnerTeams, true), gettype($syncPartnerTeams)), __LINE__);
        }
        $this->syncPartnerTeams = $syncPartnerTeams;
        return $this;
    }
    /**
     * Get shipGroupList value
     * @return \StructType\CustomSaleShipGroupList|null
     */
    public function getShipGroupList()
    {
        return $this->shipGroupList;
    }
    /**
     * Set shipGroupList value
     * @param \StructType\CustomSaleShipGroupList $shipGroupList
     * @return \StructType\CustomSale
     */
    public function setShipGroupList(\StructType\CustomSaleShipGroupList $shipGroupList = null)
    {
        $this->shipGroupList = $shipGroupList;
        return $this;
    }
    /**
     * Get overrideInstallments value
     * @return bool|null
     */
    public function getOverrideInstallments()
    {
        return $this->overrideInstallments;
    }
    /**
     * Set overrideInstallments value
     * @param bool $overrideInstallments
     * @return \StructType\CustomSale
     */
    public function setOverrideInstallments($overrideInstallments = null)
    {
        // validation for constraint: boolean
        if (!is_null($overrideInstallments) && !is_bool($overrideInstallments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($overrideInstallments, true), gettype($overrideInstallments)), __LINE__);
        }
        $this->overrideInstallments = $overrideInstallments;
        return $this;
    }
    /**
     * Get installmentList value
     * @return \StructType\InstallmentList|null
     */
    public function getInstallmentList()
    {
        return $this->installmentList;
    }
    /**
     * Set installmentList value
     * @param \StructType\InstallmentList $installmentList
     * @return \StructType\CustomSale
     */
    public function setInstallmentList(\StructType\InstallmentList $installmentList = null)
    {
        $this->installmentList = $installmentList;
        return $this;
    }
    /**
     * Get partnersList value
     * @return \StructType\CustomSalePartnersList|null
     */
    public function getPartnersList()
    {
        return $this->partnersList;
    }
    /**
     * Set partnersList value
     * @param \StructType\CustomSalePartnersList $partnersList
     * @return \StructType\CustomSale
     */
    public function setPartnersList(\StructType\CustomSalePartnersList $partnersList = null)
    {
        $this->partnersList = $partnersList;
        return $this;
    }
    /**
     * Get promotionsList value
     * @return \StructType\PromotionsList|null
     */
    public function getPromotionsList()
    {
        return $this->promotionsList;
    }
    /**
     * Set promotionsList value
     * @param \StructType\PromotionsList $promotionsList
     * @return \StructType\CustomSale
     */
    public function setPromotionsList(\StructType\PromotionsList $promotionsList = null)
    {
        $this->promotionsList = $promotionsList;
        return $this;
    }
    /**
     * Get itemList value
     * @return \StructType\CustomSaleItemList|null
     */
    public function getItemList()
    {
        return $this->itemList;
    }
    /**
     * Set itemList value
     * @param \StructType\CustomSaleItemList $itemList
     * @return \StructType\CustomSale
     */
    public function setItemList(\StructType\CustomSaleItemList $itemList = null)
    {
        $this->itemList = $itemList;
        return $this;
    }
    /**
     * Get giftCertRedemptionList value
     * @return \StructType\GiftCertRedemptionList|null
     */
    public function getGiftCertRedemptionList()
    {
        return $this->giftCertRedemptionList;
    }
    /**
     * Set giftCertRedemptionList value
     * @param \StructType\GiftCertRedemptionList $giftCertRedemptionList
     * @return \StructType\CustomSale
     */
    public function setGiftCertRedemptionList(\StructType\GiftCertRedemptionList $giftCertRedemptionList = null)
    {
        $this->giftCertRedemptionList = $giftCertRedemptionList;
        return $this;
    }
    /**
     * Get accountingBookDetailList value
     * @return \StructType\AccountingBookDetailList|null
     */
    public function getAccountingBookDetailList()
    {
        return $this->accountingBookDetailList;
    }
    /**
     * Set accountingBookDetailList value
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @return \StructType\CustomSale
     */
    public function setAccountingBookDetailList(\StructType\AccountingBookDetailList $accountingBookDetailList = null)
    {
        $this->accountingBookDetailList = $accountingBookDetailList;
        return $this;
    }
    /**
     * Get salesTeamList value
     * @return \StructType\CustomSaleSalesTeamList|null
     */
    public function getSalesTeamList()
    {
        return $this->salesTeamList;
    }
    /**
     * Set salesTeamList value
     * @param \StructType\CustomSaleSalesTeamList $salesTeamList
     * @return \StructType\CustomSale
     */
    public function setSalesTeamList(\StructType\CustomSaleSalesTeamList $salesTeamList = null)
    {
        $this->salesTeamList = $salesTeamList;
        return $this;
    }
    /**
     * Get taxDetailsList value
     * @return \StructType\TaxDetailsList|null
     */
    public function getTaxDetailsList()
    {
        return $this->taxDetailsList;
    }
    /**
     * Set taxDetailsList value
     * @param \StructType\TaxDetailsList $taxDetailsList
     * @return \StructType\CustomSale
     */
    public function setTaxDetailsList(\StructType\TaxDetailsList $taxDetailsList = null)
    {
        $this->taxDetailsList = $taxDetailsList;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\CustomSale
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\CustomSale
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\CustomSale
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
