<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomRecordTypeTranslationsList StructType
 * @subpackage Structs
 */
class CustomRecordTypeTranslationsList extends AbstractStructBase
{
    /**
     * The translations
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomRecordTypeTranslations[]
     */
    public $translations;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for CustomRecordTypeTranslationsList
     * @uses CustomRecordTypeTranslationsList::setTranslations()
     * @uses CustomRecordTypeTranslationsList::setReplaceAll()
     * @param \StructType\CustomRecordTypeTranslations[] $translations
     * @param bool $replaceAll
     */
    public function __construct(array $translations = array(), $replaceAll = true)
    {
        $this
            ->setTranslations($translations)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get translations value
     * @return \StructType\CustomRecordTypeTranslations[]|null
     */
    public function getTranslations()
    {
        return $this->translations;
    }
    /**
     * This method is responsible for validating the values passed to the setTranslations method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTranslations method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTranslationsForArrayConstraintsFromSetTranslations(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customRecordTypeTranslationsListTranslationsItem) {
            // validation for constraint: itemType
            if (!$customRecordTypeTranslationsListTranslationsItem instanceof \StructType\CustomRecordTypeTranslations) {
                $invalidValues[] = is_object($customRecordTypeTranslationsListTranslationsItem) ? get_class($customRecordTypeTranslationsListTranslationsItem) : sprintf('%s(%s)', gettype($customRecordTypeTranslationsListTranslationsItem), var_export($customRecordTypeTranslationsListTranslationsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The translations property can only contain items of type \StructType\CustomRecordTypeTranslations, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set translations value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomRecordTypeTranslations[] $translations
     * @return \StructType\CustomRecordTypeTranslationsList
     */
    public function setTranslations(array $translations = array())
    {
        // validation for constraint: array
        if ('' !== ($translationsArrayErrorMessage = self::validateTranslationsForArrayConstraintsFromSetTranslations($translations))) {
            throw new \InvalidArgumentException($translationsArrayErrorMessage, __LINE__);
        }
        $this->translations = $translations;
        return $this;
    }
    /**
     * Add item to translations value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomRecordTypeTranslations $item
     * @return \StructType\CustomRecordTypeTranslationsList
     */
    public function addToTranslations(\StructType\CustomRecordTypeTranslations $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomRecordTypeTranslations) {
            throw new \InvalidArgumentException(sprintf('The translations property can only contain items of type \StructType\CustomRecordTypeTranslations, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->translations[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\CustomRecordTypeTranslationsList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
