<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomRecordTypeManagersList StructType
 * @subpackage Structs
 */
class CustomRecordTypeManagersList extends AbstractStructBase
{
    /**
     * The managers
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomRecordTypeManagers[]
     */
    public $managers;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for CustomRecordTypeManagersList
     * @uses CustomRecordTypeManagersList::setManagers()
     * @uses CustomRecordTypeManagersList::setReplaceAll()
     * @param \StructType\CustomRecordTypeManagers[] $managers
     * @param bool $replaceAll
     */
    public function __construct(array $managers = array(), $replaceAll = true)
    {
        $this
            ->setManagers($managers)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get managers value
     * @return \StructType\CustomRecordTypeManagers[]|null
     */
    public function getManagers()
    {
        return $this->managers;
    }
    /**
     * This method is responsible for validating the values passed to the setManagers method
     * This method is willingly generated in order to preserve the one-line inline validation within the setManagers method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateManagersForArrayConstraintsFromSetManagers(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customRecordTypeManagersListManagersItem) {
            // validation for constraint: itemType
            if (!$customRecordTypeManagersListManagersItem instanceof \StructType\CustomRecordTypeManagers) {
                $invalidValues[] = is_object($customRecordTypeManagersListManagersItem) ? get_class($customRecordTypeManagersListManagersItem) : sprintf('%s(%s)', gettype($customRecordTypeManagersListManagersItem), var_export($customRecordTypeManagersListManagersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The managers property can only contain items of type \StructType\CustomRecordTypeManagers, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set managers value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomRecordTypeManagers[] $managers
     * @return \StructType\CustomRecordTypeManagersList
     */
    public function setManagers(array $managers = array())
    {
        // validation for constraint: array
        if ('' !== ($managersArrayErrorMessage = self::validateManagersForArrayConstraintsFromSetManagers($managers))) {
            throw new \InvalidArgumentException($managersArrayErrorMessage, __LINE__);
        }
        $this->managers = $managers;
        return $this;
    }
    /**
     * Add item to managers value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomRecordTypeManagers $item
     * @return \StructType\CustomRecordTypeManagersList
     */
    public function addToManagers(\StructType\CustomRecordTypeManagers $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomRecordTypeManagers) {
            throw new \InvalidArgumentException(sprintf('The managers property can only contain items of type \StructType\CustomRecordTypeManagers, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->managers[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\CustomRecordTypeManagersList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
