<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomRecordTypeFieldList StructType
 * @subpackage Structs
 */
class CustomRecordTypeFieldList extends AbstractStructBase
{
    /**
     * The customField
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomRecordCustomField[]
     */
    public $customField;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for CustomRecordTypeFieldList
     * @uses CustomRecordTypeFieldList::setCustomField()
     * @uses CustomRecordTypeFieldList::setReplaceAll()
     * @param \StructType\CustomRecordCustomField[] $customField
     * @param bool $replaceAll
     */
    public function __construct(array $customField = array(), $replaceAll = true)
    {
        $this
            ->setCustomField($customField)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get customField value
     * @return \StructType\CustomRecordCustomField[]|null
     */
    public function getCustomField()
    {
        return $this->customField;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomField method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomField method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomFieldForArrayConstraintsFromSetCustomField(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customRecordTypeFieldListCustomFieldItem) {
            // validation for constraint: itemType
            if (!$customRecordTypeFieldListCustomFieldItem instanceof \StructType\CustomRecordCustomField) {
                $invalidValues[] = is_object($customRecordTypeFieldListCustomFieldItem) ? get_class($customRecordTypeFieldListCustomFieldItem) : sprintf('%s(%s)', gettype($customRecordTypeFieldListCustomFieldItem), var_export($customRecordTypeFieldListCustomFieldItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customField property can only contain items of type \StructType\CustomRecordCustomField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customField value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomRecordCustomField[] $customField
     * @return \StructType\CustomRecordTypeFieldList
     */
    public function setCustomField(array $customField = array())
    {
        // validation for constraint: array
        if ('' !== ($customFieldArrayErrorMessage = self::validateCustomFieldForArrayConstraintsFromSetCustomField($customField))) {
            throw new \InvalidArgumentException($customFieldArrayErrorMessage, __LINE__);
        }
        $this->customField = $customField;
        return $this;
    }
    /**
     * Add item to customField value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomRecordCustomField $item
     * @return \StructType\CustomRecordTypeFieldList
     */
    public function addToCustomField(\StructType\CustomRecordCustomField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomRecordCustomField) {
            throw new \InvalidArgumentException(sprintf('The customField property can only contain items of type \StructType\CustomRecordCustomField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customField[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\CustomRecordTypeFieldList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
