<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomPurchaseItem StructType
 * @subpackage Structs
 */
class CustomPurchaseItem extends AbstractStructBase
{
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The vendorName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vendorName;
    /**
     * The line
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $line;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantity;
    /**
     * The units
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $units;
    /**
     * The inventoryDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InventoryDetail
     */
    public $inventoryDetail;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The serialNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serialNumbers;
    /**
     * The binNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $binNumbers;
    /**
     * The grossAmt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $grossAmt;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $rate;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * The options
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $options;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The landedCostCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $landedCostCategory;
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customer;
    /**
     * The isBillable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isBillable;
    /**
     * The billVarianceStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $billVarianceStatus;
    /**
     * The amortizationSched
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $amortizationSched;
    /**
     * The amortizStartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $amortizStartDate;
    /**
     * The amortizationEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $amortizationEndDate;
    /**
     * The amortizationResidual
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $amortizationResidual;
    /**
     * The taxAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxAmount;
    /**
     * The taxDetailsReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxDetailsReference;
    /**
     * The landedCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\LandedCost
     */
    public $landedCost;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for CustomPurchaseItem
     * @uses CustomPurchaseItem::setItem()
     * @uses CustomPurchaseItem::setVendorName()
     * @uses CustomPurchaseItem::setLine()
     * @uses CustomPurchaseItem::setQuantity()
     * @uses CustomPurchaseItem::setUnits()
     * @uses CustomPurchaseItem::setInventoryDetail()
     * @uses CustomPurchaseItem::setDescription()
     * @uses CustomPurchaseItem::setSerialNumbers()
     * @uses CustomPurchaseItem::setBinNumbers()
     * @uses CustomPurchaseItem::setGrossAmt()
     * @uses CustomPurchaseItem::setRate()
     * @uses CustomPurchaseItem::setAmount()
     * @uses CustomPurchaseItem::setOptions()
     * @uses CustomPurchaseItem::setDepartment()
     * @uses CustomPurchaseItem::setClass()
     * @uses CustomPurchaseItem::setLocation()
     * @uses CustomPurchaseItem::setLandedCostCategory()
     * @uses CustomPurchaseItem::setCustomer()
     * @uses CustomPurchaseItem::setIsBillable()
     * @uses CustomPurchaseItem::setBillVarianceStatus()
     * @uses CustomPurchaseItem::setAmortizationSched()
     * @uses CustomPurchaseItem::setAmortizStartDate()
     * @uses CustomPurchaseItem::setAmortizationEndDate()
     * @uses CustomPurchaseItem::setAmortizationResidual()
     * @uses CustomPurchaseItem::setTaxAmount()
     * @uses CustomPurchaseItem::setTaxDetailsReference()
     * @uses CustomPurchaseItem::setLandedCost()
     * @uses CustomPurchaseItem::setCustomFieldList()
     * @param \StructType\RecordRef $item
     * @param string $vendorName
     * @param int $line
     * @param float $quantity
     * @param \StructType\RecordRef $units
     * @param \StructType\InventoryDetail $inventoryDetail
     * @param string $description
     * @param string $serialNumbers
     * @param string $binNumbers
     * @param float $grossAmt
     * @param string $rate
     * @param float $amount
     * @param \StructType\CustomFieldList $options
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRef $landedCostCategory
     * @param \StructType\RecordRef $customer
     * @param bool $isBillable
     * @param string $billVarianceStatus
     * @param \StructType\RecordRef $amortizationSched
     * @param string $amortizStartDate
     * @param string $amortizationEndDate
     * @param string $amortizationResidual
     * @param float $taxAmount
     * @param string $taxDetailsReference
     * @param \StructType\LandedCost $landedCost
     * @param \StructType\CustomFieldList $customFieldList
     */
    public function __construct(\StructType\RecordRef $item = null, $vendorName = null, $line = null, $quantity = null, \StructType\RecordRef $units = null, \StructType\InventoryDetail $inventoryDetail = null, $description = null, $serialNumbers = null, $binNumbers = null, $grossAmt = null, $rate = null, $amount = null, \StructType\CustomFieldList $options = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRef $location = null, \StructType\RecordRef $landedCostCategory = null, \StructType\RecordRef $customer = null, $isBillable = null, $billVarianceStatus = null, \StructType\RecordRef $amortizationSched = null, $amortizStartDate = null, $amortizationEndDate = null, $amortizationResidual = null, $taxAmount = null, $taxDetailsReference = null, \StructType\LandedCost $landedCost = null, \StructType\CustomFieldList $customFieldList = null)
    {
        $this
            ->setItem($item)
            ->setVendorName($vendorName)
            ->setLine($line)
            ->setQuantity($quantity)
            ->setUnits($units)
            ->setInventoryDetail($inventoryDetail)
            ->setDescription($description)
            ->setSerialNumbers($serialNumbers)
            ->setBinNumbers($binNumbers)
            ->setGrossAmt($grossAmt)
            ->setRate($rate)
            ->setAmount($amount)
            ->setOptions($options)
            ->setDepartment($department)
            ->setClass($class)
            ->setLocation($location)
            ->setLandedCostCategory($landedCostCategory)
            ->setCustomer($customer)
            ->setIsBillable($isBillable)
            ->setBillVarianceStatus($billVarianceStatus)
            ->setAmortizationSched($amortizationSched)
            ->setAmortizStartDate($amortizStartDate)
            ->setAmortizationEndDate($amortizationEndDate)
            ->setAmortizationResidual($amortizationResidual)
            ->setTaxAmount($taxAmount)
            ->setTaxDetailsReference($taxDetailsReference)
            ->setLandedCost($landedCost)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get item value
     * @return \StructType\RecordRef|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\CustomPurchaseItem
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get vendorName value
     * @return string|null
     */
    public function getVendorName()
    {
        return $this->vendorName;
    }
    /**
     * Set vendorName value
     * @param string $vendorName
     * @return \StructType\CustomPurchaseItem
     */
    public function setVendorName($vendorName = null)
    {
        // validation for constraint: string
        if (!is_null($vendorName) && !is_string($vendorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorName, true), gettype($vendorName)), __LINE__);
        }
        $this->vendorName = $vendorName;
        return $this;
    }
    /**
     * Get line value
     * @return int|null
     */
    public function getLine()
    {
        return $this->line;
    }
    /**
     * Set line value
     * @param int $line
     * @return \StructType\CustomPurchaseItem
     */
    public function setLine($line = null)
    {
        // validation for constraint: int
        if (!is_null($line) && !(is_int($line) || ctype_digit($line))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($line, true), gettype($line)), __LINE__);
        }
        $this->line = $line;
        return $this;
    }
    /**
     * Get quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param float $quantity
     * @return \StructType\CustomPurchaseItem
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get units value
     * @return \StructType\RecordRef|null
     */
    public function getUnits()
    {
        return $this->units;
    }
    /**
     * Set units value
     * @param \StructType\RecordRef $units
     * @return \StructType\CustomPurchaseItem
     */
    public function setUnits(\StructType\RecordRef $units = null)
    {
        $this->units = $units;
        return $this;
    }
    /**
     * Get inventoryDetail value
     * @return \StructType\InventoryDetail|null
     */
    public function getInventoryDetail()
    {
        return $this->inventoryDetail;
    }
    /**
     * Set inventoryDetail value
     * @param \StructType\InventoryDetail $inventoryDetail
     * @return \StructType\CustomPurchaseItem
     */
    public function setInventoryDetail(\StructType\InventoryDetail $inventoryDetail = null)
    {
        $this->inventoryDetail = $inventoryDetail;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\CustomPurchaseItem
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get serialNumbers value
     * @return string|null
     */
    public function getSerialNumbers()
    {
        return $this->serialNumbers;
    }
    /**
     * Set serialNumbers value
     * @param string $serialNumbers
     * @return \StructType\CustomPurchaseItem
     */
    public function setSerialNumbers($serialNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumbers) && !is_string($serialNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serialNumbers, true), gettype($serialNumbers)), __LINE__);
        }
        $this->serialNumbers = $serialNumbers;
        return $this;
    }
    /**
     * Get binNumbers value
     * @return string|null
     */
    public function getBinNumbers()
    {
        return $this->binNumbers;
    }
    /**
     * Set binNumbers value
     * @param string $binNumbers
     * @return \StructType\CustomPurchaseItem
     */
    public function setBinNumbers($binNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($binNumbers) && !is_string($binNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($binNumbers, true), gettype($binNumbers)), __LINE__);
        }
        $this->binNumbers = $binNumbers;
        return $this;
    }
    /**
     * Get grossAmt value
     * @return float|null
     */
    public function getGrossAmt()
    {
        return $this->grossAmt;
    }
    /**
     * Set grossAmt value
     * @param float $grossAmt
     * @return \StructType\CustomPurchaseItem
     */
    public function setGrossAmt($grossAmt = null)
    {
        // validation for constraint: float
        if (!is_null($grossAmt) && !(is_float($grossAmt) || is_numeric($grossAmt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($grossAmt, true), gettype($grossAmt)), __LINE__);
        }
        $this->grossAmt = $grossAmt;
        return $this;
    }
    /**
     * Get rate value
     * @return string|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param string $rate
     * @return \StructType\CustomPurchaseItem
     */
    public function setRate($rate = null)
    {
        // validation for constraint: string
        if (!is_null($rate) && !is_string($rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\CustomPurchaseItem
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get options value
     * @return \StructType\CustomFieldList|null
     */
    public function getOptions()
    {
        return $this->options;
    }
    /**
     * Set options value
     * @param \StructType\CustomFieldList $options
     * @return \StructType\CustomPurchaseItem
     */
    public function setOptions(\StructType\CustomFieldList $options = null)
    {
        $this->options = $options;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\CustomPurchaseItem
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\CustomPurchaseItem
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\CustomPurchaseItem
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get landedCostCategory value
     * @return \StructType\RecordRef|null
     */
    public function getLandedCostCategory()
    {
        return $this->landedCostCategory;
    }
    /**
     * Set landedCostCategory value
     * @param \StructType\RecordRef $landedCostCategory
     * @return \StructType\CustomPurchaseItem
     */
    public function setLandedCostCategory(\StructType\RecordRef $landedCostCategory = null)
    {
        $this->landedCostCategory = $landedCostCategory;
        return $this;
    }
    /**
     * Get customer value
     * @return \StructType\RecordRef|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param \StructType\RecordRef $customer
     * @return \StructType\CustomPurchaseItem
     */
    public function setCustomer(\StructType\RecordRef $customer = null)
    {
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get isBillable value
     * @return bool|null
     */
    public function getIsBillable()
    {
        return $this->isBillable;
    }
    /**
     * Set isBillable value
     * @param bool $isBillable
     * @return \StructType\CustomPurchaseItem
     */
    public function setIsBillable($isBillable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBillable) && !is_bool($isBillable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBillable, true), gettype($isBillable)), __LINE__);
        }
        $this->isBillable = $isBillable;
        return $this;
    }
    /**
     * Get billVarianceStatus value
     * @return string|null
     */
    public function getBillVarianceStatus()
    {
        return $this->billVarianceStatus;
    }
    /**
     * Set billVarianceStatus value
     * @uses \EnumType\TransactionBillVarianceStatus::valueIsValid()
     * @uses \EnumType\TransactionBillVarianceStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $billVarianceStatus
     * @return \StructType\CustomPurchaseItem
     */
    public function setBillVarianceStatus($billVarianceStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransactionBillVarianceStatus::valueIsValid($billVarianceStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TransactionBillVarianceStatus', is_array($billVarianceStatus) ? implode(', ', $billVarianceStatus) : var_export($billVarianceStatus, true), implode(', ', \EnumType\TransactionBillVarianceStatus::getValidValues())), __LINE__);
        }
        $this->billVarianceStatus = $billVarianceStatus;
        return $this;
    }
    /**
     * Get amortizationSched value
     * @return \StructType\RecordRef|null
     */
    public function getAmortizationSched()
    {
        return $this->amortizationSched;
    }
    /**
     * Set amortizationSched value
     * @param \StructType\RecordRef $amortizationSched
     * @return \StructType\CustomPurchaseItem
     */
    public function setAmortizationSched(\StructType\RecordRef $amortizationSched = null)
    {
        $this->amortizationSched = $amortizationSched;
        return $this;
    }
    /**
     * Get amortizStartDate value
     * @return string|null
     */
    public function getAmortizStartDate()
    {
        return $this->amortizStartDate;
    }
    /**
     * Set amortizStartDate value
     * @param string $amortizStartDate
     * @return \StructType\CustomPurchaseItem
     */
    public function setAmortizStartDate($amortizStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($amortizStartDate) && !is_string($amortizStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amortizStartDate, true), gettype($amortizStartDate)), __LINE__);
        }
        $this->amortizStartDate = $amortizStartDate;
        return $this;
    }
    /**
     * Get amortizationEndDate value
     * @return string|null
     */
    public function getAmortizationEndDate()
    {
        return $this->amortizationEndDate;
    }
    /**
     * Set amortizationEndDate value
     * @param string $amortizationEndDate
     * @return \StructType\CustomPurchaseItem
     */
    public function setAmortizationEndDate($amortizationEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($amortizationEndDate) && !is_string($amortizationEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amortizationEndDate, true), gettype($amortizationEndDate)), __LINE__);
        }
        $this->amortizationEndDate = $amortizationEndDate;
        return $this;
    }
    /**
     * Get amortizationResidual value
     * @return string|null
     */
    public function getAmortizationResidual()
    {
        return $this->amortizationResidual;
    }
    /**
     * Set amortizationResidual value
     * @param string $amortizationResidual
     * @return \StructType\CustomPurchaseItem
     */
    public function setAmortizationResidual($amortizationResidual = null)
    {
        // validation for constraint: string
        if (!is_null($amortizationResidual) && !is_string($amortizationResidual)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amortizationResidual, true), gettype($amortizationResidual)), __LINE__);
        }
        $this->amortizationResidual = $amortizationResidual;
        return $this;
    }
    /**
     * Get taxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->taxAmount;
    }
    /**
     * Set taxAmount value
     * @param float $taxAmount
     * @return \StructType\CustomPurchaseItem
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxAmount) && !(is_float($taxAmount) || is_numeric($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->taxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get taxDetailsReference value
     * @return string|null
     */
    public function getTaxDetailsReference()
    {
        return $this->taxDetailsReference;
    }
    /**
     * Set taxDetailsReference value
     * @param string $taxDetailsReference
     * @return \StructType\CustomPurchaseItem
     */
    public function setTaxDetailsReference($taxDetailsReference = null)
    {
        // validation for constraint: string
        if (!is_null($taxDetailsReference) && !is_string($taxDetailsReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxDetailsReference, true), gettype($taxDetailsReference)), __LINE__);
        }
        $this->taxDetailsReference = $taxDetailsReference;
        return $this;
    }
    /**
     * Get landedCost value
     * @return \StructType\LandedCost|null
     */
    public function getLandedCost()
    {
        return $this->landedCost;
    }
    /**
     * Set landedCost value
     * @param \StructType\LandedCost $landedCost
     * @return \StructType\CustomPurchaseItem
     */
    public function setLandedCost(\StructType\LandedCost $landedCost = null)
    {
        $this->landedCost = $landedCost;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\CustomPurchaseItem
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
