<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomListTranslationsList StructType
 * @subpackage Structs
 */
class CustomListTranslationsList extends AbstractStructBase
{
    /**
     * The translations
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomListTranslations[]
     */
    public $translations;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for CustomListTranslationsList
     * @uses CustomListTranslationsList::setTranslations()
     * @uses CustomListTranslationsList::setReplaceAll()
     * @param \StructType\CustomListTranslations[] $translations
     * @param bool $replaceAll
     */
    public function __construct(array $translations = array(), $replaceAll = true)
    {
        $this
            ->setTranslations($translations)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get translations value
     * @return \StructType\CustomListTranslations[]|null
     */
    public function getTranslations()
    {
        return $this->translations;
    }
    /**
     * This method is responsible for validating the values passed to the setTranslations method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTranslations method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTranslationsForArrayConstraintsFromSetTranslations(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customListTranslationsListTranslationsItem) {
            // validation for constraint: itemType
            if (!$customListTranslationsListTranslationsItem instanceof \StructType\CustomListTranslations) {
                $invalidValues[] = is_object($customListTranslationsListTranslationsItem) ? get_class($customListTranslationsListTranslationsItem) : sprintf('%s(%s)', gettype($customListTranslationsListTranslationsItem), var_export($customListTranslationsListTranslationsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The translations property can only contain items of type \StructType\CustomListTranslations, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set translations value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomListTranslations[] $translations
     * @return \StructType\CustomListTranslationsList
     */
    public function setTranslations(array $translations = array())
    {
        // validation for constraint: array
        if ('' !== ($translationsArrayErrorMessage = self::validateTranslationsForArrayConstraintsFromSetTranslations($translations))) {
            throw new \InvalidArgumentException($translationsArrayErrorMessage, __LINE__);
        }
        $this->translations = $translations;
        return $this;
    }
    /**
     * Add item to translations value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomListTranslations $item
     * @return \StructType\CustomListTranslationsList
     */
    public function addToTranslations(\StructType\CustomListTranslations $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomListTranslations) {
            throw new \InvalidArgumentException(sprintf('The translations property can only contain items of type \StructType\CustomListTranslations, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->translations[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\CustomListTranslationsList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
