<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomFieldTranslationsList StructType
 * @subpackage Structs
 */
class CustomFieldTranslationsList extends AbstractStructBase
{
    /**
     * The translations
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomFieldTranslations[]
     */
    public $translations;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for CustomFieldTranslationsList
     * @uses CustomFieldTranslationsList::setTranslations()
     * @uses CustomFieldTranslationsList::setReplaceAll()
     * @param \StructType\CustomFieldTranslations[] $translations
     * @param bool $replaceAll
     */
    public function __construct(array $translations = array(), $replaceAll = true)
    {
        $this
            ->setTranslations($translations)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get translations value
     * @return \StructType\CustomFieldTranslations[]|null
     */
    public function getTranslations()
    {
        return $this->translations;
    }
    /**
     * This method is responsible for validating the values passed to the setTranslations method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTranslations method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTranslationsForArrayConstraintsFromSetTranslations(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customFieldTranslationsListTranslationsItem) {
            // validation for constraint: itemType
            if (!$customFieldTranslationsListTranslationsItem instanceof \StructType\CustomFieldTranslations) {
                $invalidValues[] = is_object($customFieldTranslationsListTranslationsItem) ? get_class($customFieldTranslationsListTranslationsItem) : sprintf('%s(%s)', gettype($customFieldTranslationsListTranslationsItem), var_export($customFieldTranslationsListTranslationsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The translations property can only contain items of type \StructType\CustomFieldTranslations, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set translations value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldTranslations[] $translations
     * @return \StructType\CustomFieldTranslationsList
     */
    public function setTranslations(array $translations = array())
    {
        // validation for constraint: array
        if ('' !== ($translationsArrayErrorMessage = self::validateTranslationsForArrayConstraintsFromSetTranslations($translations))) {
            throw new \InvalidArgumentException($translationsArrayErrorMessage, __LINE__);
        }
        $this->translations = $translations;
        return $this;
    }
    /**
     * Add item to translations value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldTranslations $item
     * @return \StructType\CustomFieldTranslationsList
     */
    public function addToTranslations(\StructType\CustomFieldTranslations $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomFieldTranslations) {
            throw new \InvalidArgumentException(sprintf('The translations property can only contain items of type \StructType\CustomFieldTranslations, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->translations[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\CustomFieldTranslationsList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
