<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomFieldList StructType
 * @subpackage Structs
 */
class CustomFieldList extends AbstractStructBase
{
    /**
     * The customField
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomFieldRef[]
     */
    public $customField;
    /**
     * Constructor method for CustomFieldList
     * @uses CustomFieldList::setCustomField()
     * @param \StructType\CustomFieldRef[] $customField
     */
    public function __construct(array $customField = array())
    {
        $this
            ->setCustomField($customField);
    }
    /**
     * Get customField value
     * @return \StructType\CustomFieldRef[]|null
     */
    public function getCustomField()
    {
        return $this->customField;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomField method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomField method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomFieldForArrayConstraintsFromSetCustomField(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customFieldListCustomFieldItem) {
            // validation for constraint: itemType
            if (!$customFieldListCustomFieldItem instanceof \StructType\CustomFieldRef) {
                $invalidValues[] = is_object($customFieldListCustomFieldItem) ? get_class($customFieldListCustomFieldItem) : sprintf('%s(%s)', gettype($customFieldListCustomFieldItem), var_export($customFieldListCustomFieldItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customField property can only contain items of type \StructType\CustomFieldRef, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customField value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldRef[] $customField
     * @return \StructType\CustomFieldList
     */
    public function setCustomField(array $customField = array())
    {
        // validation for constraint: array
        if ('' !== ($customFieldArrayErrorMessage = self::validateCustomFieldForArrayConstraintsFromSetCustomField($customField))) {
            throw new \InvalidArgumentException($customFieldArrayErrorMessage, __LINE__);
        }
        $this->customField = $customField;
        return $this;
    }
    /**
     * Add item to customField value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldRef $item
     * @return \StructType\CustomFieldList
     */
    public function addToCustomField(\StructType\CustomFieldRef $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomFieldRef) {
            throw new \InvalidArgumentException(sprintf('The customField property can only contain items of type \StructType\CustomFieldRef, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customField[] = $item;
        return $this;
    }
}
