<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomFieldDepartmentAccessList StructType
 * @subpackage Structs
 */
class CustomFieldDepartmentAccessList extends AbstractStructBase
{
    /**
     * The deptAccess
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomFieldDepartmentAccess[]
     */
    public $deptAccess;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for CustomFieldDepartmentAccessList
     * @uses CustomFieldDepartmentAccessList::setDeptAccess()
     * @uses CustomFieldDepartmentAccessList::setReplaceAll()
     * @param \StructType\CustomFieldDepartmentAccess[] $deptAccess
     * @param bool $replaceAll
     */
    public function __construct(array $deptAccess = array(), $replaceAll = true)
    {
        $this
            ->setDeptAccess($deptAccess)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get deptAccess value
     * @return \StructType\CustomFieldDepartmentAccess[]|null
     */
    public function getDeptAccess()
    {
        return $this->deptAccess;
    }
    /**
     * This method is responsible for validating the values passed to the setDeptAccess method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeptAccess method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeptAccessForArrayConstraintsFromSetDeptAccess(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customFieldDepartmentAccessListDeptAccessItem) {
            // validation for constraint: itemType
            if (!$customFieldDepartmentAccessListDeptAccessItem instanceof \StructType\CustomFieldDepartmentAccess) {
                $invalidValues[] = is_object($customFieldDepartmentAccessListDeptAccessItem) ? get_class($customFieldDepartmentAccessListDeptAccessItem) : sprintf('%s(%s)', gettype($customFieldDepartmentAccessListDeptAccessItem), var_export($customFieldDepartmentAccessListDeptAccessItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The deptAccess property can only contain items of type \StructType\CustomFieldDepartmentAccess, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set deptAccess value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldDepartmentAccess[] $deptAccess
     * @return \StructType\CustomFieldDepartmentAccessList
     */
    public function setDeptAccess(array $deptAccess = array())
    {
        // validation for constraint: array
        if ('' !== ($deptAccessArrayErrorMessage = self::validateDeptAccessForArrayConstraintsFromSetDeptAccess($deptAccess))) {
            throw new \InvalidArgumentException($deptAccessArrayErrorMessage, __LINE__);
        }
        $this->deptAccess = $deptAccess;
        return $this;
    }
    /**
     * Add item to deptAccess value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldDepartmentAccess $item
     * @return \StructType\CustomFieldDepartmentAccessList
     */
    public function addToDeptAccess(\StructType\CustomFieldDepartmentAccess $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomFieldDepartmentAccess) {
            throw new \InvalidArgumentException(sprintf('The deptAccess property can only contain items of type \StructType\CustomFieldDepartmentAccess, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->deptAccess[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\CustomFieldDepartmentAccessList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
