<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CurrencyRateSearchRowBasic StructType
 * @subpackage Structs
 */
class CurrencyRateSearchRowBasic extends SearchRowBasic
{
    /**
     * The baseCurrency
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $baseCurrency;
    /**
     * The effectiveDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $effectiveDate;
    /**
     * The exchangeRate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $exchangeRate;
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $internalId;
    /**
     * The transactionCurrency
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $transactionCurrency;
    /**
     * Constructor method for CurrencyRateSearchRowBasic
     * @uses CurrencyRateSearchRowBasic::setBaseCurrency()
     * @uses CurrencyRateSearchRowBasic::setEffectiveDate()
     * @uses CurrencyRateSearchRowBasic::setExchangeRate()
     * @uses CurrencyRateSearchRowBasic::setInternalId()
     * @uses CurrencyRateSearchRowBasic::setTransactionCurrency()
     * @param \StructType\SearchColumnSelectField[] $baseCurrency
     * @param \StructType\SearchColumnDateField[] $effectiveDate
     * @param \StructType\SearchColumnDoubleField[] $exchangeRate
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @param \StructType\SearchColumnSelectField[] $transactionCurrency
     */
    public function __construct(array $baseCurrency = array(), array $effectiveDate = array(), array $exchangeRate = array(), array $internalId = array(), array $transactionCurrency = array())
    {
        $this
            ->setBaseCurrency($baseCurrency)
            ->setEffectiveDate($effectiveDate)
            ->setExchangeRate($exchangeRate)
            ->setInternalId($internalId)
            ->setTransactionCurrency($transactionCurrency);
    }
    /**
     * Get baseCurrency value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getBaseCurrency()
    {
        return $this->baseCurrency;
    }
    /**
     * This method is responsible for validating the values passed to the setBaseCurrency method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBaseCurrency method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBaseCurrencyForArrayConstraintsFromSetBaseCurrency(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $currencyRateSearchRowBasicBaseCurrencyItem) {
            // validation for constraint: itemType
            if (!$currencyRateSearchRowBasicBaseCurrencyItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($currencyRateSearchRowBasicBaseCurrencyItem) ? get_class($currencyRateSearchRowBasicBaseCurrencyItem) : sprintf('%s(%s)', gettype($currencyRateSearchRowBasicBaseCurrencyItem), var_export($currencyRateSearchRowBasicBaseCurrencyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The baseCurrency property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set baseCurrency value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $baseCurrency
     * @return \StructType\CurrencyRateSearchRowBasic
     */
    public function setBaseCurrency(array $baseCurrency = array())
    {
        // validation for constraint: array
        if ('' !== ($baseCurrencyArrayErrorMessage = self::validateBaseCurrencyForArrayConstraintsFromSetBaseCurrency($baseCurrency))) {
            throw new \InvalidArgumentException($baseCurrencyArrayErrorMessage, __LINE__);
        }
        $this->baseCurrency = $baseCurrency;
        return $this;
    }
    /**
     * Add item to baseCurrency value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\CurrencyRateSearchRowBasic
     */
    public function addToBaseCurrency(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The baseCurrency property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->baseCurrency[] = $item;
        return $this;
    }
    /**
     * Get effectiveDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getEffectiveDate()
    {
        return $this->effectiveDate;
    }
    /**
     * This method is responsible for validating the values passed to the setEffectiveDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEffectiveDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEffectiveDateForArrayConstraintsFromSetEffectiveDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $currencyRateSearchRowBasicEffectiveDateItem) {
            // validation for constraint: itemType
            if (!$currencyRateSearchRowBasicEffectiveDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($currencyRateSearchRowBasicEffectiveDateItem) ? get_class($currencyRateSearchRowBasicEffectiveDateItem) : sprintf('%s(%s)', gettype($currencyRateSearchRowBasicEffectiveDateItem), var_export($currencyRateSearchRowBasicEffectiveDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The effectiveDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set effectiveDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $effectiveDate
     * @return \StructType\CurrencyRateSearchRowBasic
     */
    public function setEffectiveDate(array $effectiveDate = array())
    {
        // validation for constraint: array
        if ('' !== ($effectiveDateArrayErrorMessage = self::validateEffectiveDateForArrayConstraintsFromSetEffectiveDate($effectiveDate))) {
            throw new \InvalidArgumentException($effectiveDateArrayErrorMessage, __LINE__);
        }
        $this->effectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Add item to effectiveDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\CurrencyRateSearchRowBasic
     */
    public function addToEffectiveDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The effectiveDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->effectiveDate[] = $item;
        return $this;
    }
    /**
     * Get exchangeRate value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getExchangeRate()
    {
        return $this->exchangeRate;
    }
    /**
     * This method is responsible for validating the values passed to the setExchangeRate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExchangeRate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExchangeRateForArrayConstraintsFromSetExchangeRate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $currencyRateSearchRowBasicExchangeRateItem) {
            // validation for constraint: itemType
            if (!$currencyRateSearchRowBasicExchangeRateItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($currencyRateSearchRowBasicExchangeRateItem) ? get_class($currencyRateSearchRowBasicExchangeRateItem) : sprintf('%s(%s)', gettype($currencyRateSearchRowBasicExchangeRateItem), var_export($currencyRateSearchRowBasicExchangeRateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The exchangeRate property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set exchangeRate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $exchangeRate
     * @return \StructType\CurrencyRateSearchRowBasic
     */
    public function setExchangeRate(array $exchangeRate = array())
    {
        // validation for constraint: array
        if ('' !== ($exchangeRateArrayErrorMessage = self::validateExchangeRateForArrayConstraintsFromSetExchangeRate($exchangeRate))) {
            throw new \InvalidArgumentException($exchangeRateArrayErrorMessage, __LINE__);
        }
        $this->exchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Add item to exchangeRate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\CurrencyRateSearchRowBasic
     */
    public function addToExchangeRate(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The exchangeRate property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->exchangeRate[] = $item;
        return $this;
    }
    /**
     * Get internalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * This method is responsible for validating the values passed to the setInternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternalIdForArrayConstraintsFromSetInternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $currencyRateSearchRowBasicInternalIdItem) {
            // validation for constraint: itemType
            if (!$currencyRateSearchRowBasicInternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($currencyRateSearchRowBasicInternalIdItem) ? get_class($currencyRateSearchRowBasicInternalIdItem) : sprintf('%s(%s)', gettype($currencyRateSearchRowBasicInternalIdItem), var_export($currencyRateSearchRowBasicInternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @return \StructType\CurrencyRateSearchRowBasic
     */
    public function setInternalId(array $internalId = array())
    {
        // validation for constraint: array
        if ('' !== ($internalIdArrayErrorMessage = self::validateInternalIdForArrayConstraintsFromSetInternalId($internalId))) {
            throw new \InvalidArgumentException($internalIdArrayErrorMessage, __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Add item to internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\CurrencyRateSearchRowBasic
     */
    public function addToInternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->internalId[] = $item;
        return $this;
    }
    /**
     * Get transactionCurrency value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getTransactionCurrency()
    {
        return $this->transactionCurrency;
    }
    /**
     * This method is responsible for validating the values passed to the setTransactionCurrency method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransactionCurrency method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransactionCurrencyForArrayConstraintsFromSetTransactionCurrency(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $currencyRateSearchRowBasicTransactionCurrencyItem) {
            // validation for constraint: itemType
            if (!$currencyRateSearchRowBasicTransactionCurrencyItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($currencyRateSearchRowBasicTransactionCurrencyItem) ? get_class($currencyRateSearchRowBasicTransactionCurrencyItem) : sprintf('%s(%s)', gettype($currencyRateSearchRowBasicTransactionCurrencyItem), var_export($currencyRateSearchRowBasicTransactionCurrencyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The transactionCurrency property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set transactionCurrency value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $transactionCurrency
     * @return \StructType\CurrencyRateSearchRowBasic
     */
    public function setTransactionCurrency(array $transactionCurrency = array())
    {
        // validation for constraint: array
        if ('' !== ($transactionCurrencyArrayErrorMessage = self::validateTransactionCurrencyForArrayConstraintsFromSetTransactionCurrency($transactionCurrency))) {
            throw new \InvalidArgumentException($transactionCurrencyArrayErrorMessage, __LINE__);
        }
        $this->transactionCurrency = $transactionCurrency;
        return $this;
    }
    /**
     * Add item to transactionCurrency value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\CurrencyRateSearchRowBasic
     */
    public function addToTransactionCurrency(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The transactionCurrency property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->transactionCurrency[] = $item;
        return $this;
    }
}
