<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CrmCustomFieldFilterList StructType
 * @subpackage Structs
 */
class CrmCustomFieldFilterList extends AbstractStructBase
{
    /**
     * The filter
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CrmCustomFieldFilter[]
     */
    public $filter;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for CrmCustomFieldFilterList
     * @uses CrmCustomFieldFilterList::setFilter()
     * @uses CrmCustomFieldFilterList::setReplaceAll()
     * @param \StructType\CrmCustomFieldFilter[] $filter
     * @param bool $replaceAll
     */
    public function __construct(array $filter = array(), $replaceAll = true)
    {
        $this
            ->setFilter($filter)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get filter value
     * @return \StructType\CrmCustomFieldFilter[]|null
     */
    public function getFilter()
    {
        return $this->filter;
    }
    /**
     * This method is responsible for validating the values passed to the setFilter method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFilter method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFilterForArrayConstraintsFromSetFilter(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $crmCustomFieldFilterListFilterItem) {
            // validation for constraint: itemType
            if (!$crmCustomFieldFilterListFilterItem instanceof \StructType\CrmCustomFieldFilter) {
                $invalidValues[] = is_object($crmCustomFieldFilterListFilterItem) ? get_class($crmCustomFieldFilterListFilterItem) : sprintf('%s(%s)', gettype($crmCustomFieldFilterListFilterItem), var_export($crmCustomFieldFilterListFilterItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The filter property can only contain items of type \StructType\CrmCustomFieldFilter, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set filter value
     * @throws \InvalidArgumentException
     * @param \StructType\CrmCustomFieldFilter[] $filter
     * @return \StructType\CrmCustomFieldFilterList
     */
    public function setFilter(array $filter = array())
    {
        // validation for constraint: array
        if ('' !== ($filterArrayErrorMessage = self::validateFilterForArrayConstraintsFromSetFilter($filter))) {
            throw new \InvalidArgumentException($filterArrayErrorMessage, __LINE__);
        }
        $this->filter = $filter;
        return $this;
    }
    /**
     * Add item to filter value
     * @throws \InvalidArgumentException
     * @param \StructType\CrmCustomFieldFilter $item
     * @return \StructType\CrmCustomFieldFilterList
     */
    public function addToFilter(\StructType\CrmCustomFieldFilter $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CrmCustomFieldFilter) {
            throw new \InvalidArgumentException(sprintf('The filter property can only contain items of type \StructType\CrmCustomFieldFilter, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->filter[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\CrmCustomFieldFilterList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
