<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CouponCodeSearchRowBasic StructType
 * @subpackage Structs
 */
class CouponCodeSearchRowBasic extends SearchRowBasic
{
    /**
     * The code
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $code;
    /**
     * The dateSent
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $dateSent;
    /**
     * The externalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $externalId;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnLongField[]
     */
    public $id;
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $internalId;
    /**
     * The promotion
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $promotion;
    /**
     * The recipient
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $recipient;
    /**
     * The useCount
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnLongField[]
     */
    public $useCount;
    /**
     * The used
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $used;
    /**
     * Constructor method for CouponCodeSearchRowBasic
     * @uses CouponCodeSearchRowBasic::setCode()
     * @uses CouponCodeSearchRowBasic::setDateSent()
     * @uses CouponCodeSearchRowBasic::setExternalId()
     * @uses CouponCodeSearchRowBasic::setId()
     * @uses CouponCodeSearchRowBasic::setInternalId()
     * @uses CouponCodeSearchRowBasic::setPromotion()
     * @uses CouponCodeSearchRowBasic::setRecipient()
     * @uses CouponCodeSearchRowBasic::setUseCount()
     * @uses CouponCodeSearchRowBasic::setUsed()
     * @param \StructType\SearchColumnStringField[] $code
     * @param \StructType\SearchColumnDateField[] $dateSent
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @param \StructType\SearchColumnLongField[] $id
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @param \StructType\SearchColumnStringField[] $promotion
     * @param \StructType\SearchColumnStringField[] $recipient
     * @param \StructType\SearchColumnLongField[] $useCount
     * @param \StructType\SearchColumnBooleanField[] $used
     */
    public function __construct(array $code = array(), array $dateSent = array(), array $externalId = array(), array $id = array(), array $internalId = array(), array $promotion = array(), array $recipient = array(), array $useCount = array(), array $used = array())
    {
        $this
            ->setCode($code)
            ->setDateSent($dateSent)
            ->setExternalId($externalId)
            ->setId($id)
            ->setInternalId($internalId)
            ->setPromotion($promotion)
            ->setRecipient($recipient)
            ->setUseCount($useCount)
            ->setUsed($used);
    }
    /**
     * Get code value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * This method is responsible for validating the values passed to the setCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCodeForArrayConstraintsFromSetCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $couponCodeSearchRowBasicCodeItem) {
            // validation for constraint: itemType
            if (!$couponCodeSearchRowBasicCodeItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($couponCodeSearchRowBasicCodeItem) ? get_class($couponCodeSearchRowBasicCodeItem) : sprintf('%s(%s)', gettype($couponCodeSearchRowBasicCodeItem), var_export($couponCodeSearchRowBasicCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The code property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set code value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $code
     * @return \StructType\CouponCodeSearchRowBasic
     */
    public function setCode(array $code = array())
    {
        // validation for constraint: array
        if ('' !== ($codeArrayErrorMessage = self::validateCodeForArrayConstraintsFromSetCode($code))) {
            throw new \InvalidArgumentException($codeArrayErrorMessage, __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Add item to code value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\CouponCodeSearchRowBasic
     */
    public function addToCode(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The code property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->code[] = $item;
        return $this;
    }
    /**
     * Get dateSent value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getDateSent()
    {
        return $this->dateSent;
    }
    /**
     * This method is responsible for validating the values passed to the setDateSent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDateSent method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDateSentForArrayConstraintsFromSetDateSent(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $couponCodeSearchRowBasicDateSentItem) {
            // validation for constraint: itemType
            if (!$couponCodeSearchRowBasicDateSentItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($couponCodeSearchRowBasicDateSentItem) ? get_class($couponCodeSearchRowBasicDateSentItem) : sprintf('%s(%s)', gettype($couponCodeSearchRowBasicDateSentItem), var_export($couponCodeSearchRowBasicDateSentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The dateSent property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set dateSent value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $dateSent
     * @return \StructType\CouponCodeSearchRowBasic
     */
    public function setDateSent(array $dateSent = array())
    {
        // validation for constraint: array
        if ('' !== ($dateSentArrayErrorMessage = self::validateDateSentForArrayConstraintsFromSetDateSent($dateSent))) {
            throw new \InvalidArgumentException($dateSentArrayErrorMessage, __LINE__);
        }
        $this->dateSent = $dateSent;
        return $this;
    }
    /**
     * Add item to dateSent value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\CouponCodeSearchRowBasic
     */
    public function addToDateSent(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The dateSent property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->dateSent[] = $item;
        return $this;
    }
    /**
     * Get externalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * This method is responsible for validating the values passed to the setExternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExternalIdForArrayConstraintsFromSetExternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $couponCodeSearchRowBasicExternalIdItem) {
            // validation for constraint: itemType
            if (!$couponCodeSearchRowBasicExternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($couponCodeSearchRowBasicExternalIdItem) ? get_class($couponCodeSearchRowBasicExternalIdItem) : sprintf('%s(%s)', gettype($couponCodeSearchRowBasicExternalIdItem), var_export($couponCodeSearchRowBasicExternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @return \StructType\CouponCodeSearchRowBasic
     */
    public function setExternalId(array $externalId = array())
    {
        // validation for constraint: array
        if ('' !== ($externalIdArrayErrorMessage = self::validateExternalIdForArrayConstraintsFromSetExternalId($externalId))) {
            throw new \InvalidArgumentException($externalIdArrayErrorMessage, __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
    /**
     * Add item to externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\CouponCodeSearchRowBasic
     */
    public function addToExternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->externalId[] = $item;
        return $this;
    }
    /**
     * Get id value
     * @return \StructType\SearchColumnLongField[]|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * This method is responsible for validating the values passed to the setId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdForArrayConstraintsFromSetId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $couponCodeSearchRowBasicIdItem) {
            // validation for constraint: itemType
            if (!$couponCodeSearchRowBasicIdItem instanceof \StructType\SearchColumnLongField) {
                $invalidValues[] = is_object($couponCodeSearchRowBasicIdItem) ? get_class($couponCodeSearchRowBasicIdItem) : sprintf('%s(%s)', gettype($couponCodeSearchRowBasicIdItem), var_export($couponCodeSearchRowBasicIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The id property can only contain items of type \StructType\SearchColumnLongField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set id value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnLongField[] $id
     * @return \StructType\CouponCodeSearchRowBasic
     */
    public function setId(array $id = array())
    {
        // validation for constraint: array
        if ('' !== ($idArrayErrorMessage = self::validateIdForArrayConstraintsFromSetId($id))) {
            throw new \InvalidArgumentException($idArrayErrorMessage, __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Add item to id value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnLongField $item
     * @return \StructType\CouponCodeSearchRowBasic
     */
    public function addToId(\StructType\SearchColumnLongField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnLongField) {
            throw new \InvalidArgumentException(sprintf('The id property can only contain items of type \StructType\SearchColumnLongField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->id[] = $item;
        return $this;
    }
    /**
     * Get internalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * This method is responsible for validating the values passed to the setInternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternalIdForArrayConstraintsFromSetInternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $couponCodeSearchRowBasicInternalIdItem) {
            // validation for constraint: itemType
            if (!$couponCodeSearchRowBasicInternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($couponCodeSearchRowBasicInternalIdItem) ? get_class($couponCodeSearchRowBasicInternalIdItem) : sprintf('%s(%s)', gettype($couponCodeSearchRowBasicInternalIdItem), var_export($couponCodeSearchRowBasicInternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @return \StructType\CouponCodeSearchRowBasic
     */
    public function setInternalId(array $internalId = array())
    {
        // validation for constraint: array
        if ('' !== ($internalIdArrayErrorMessage = self::validateInternalIdForArrayConstraintsFromSetInternalId($internalId))) {
            throw new \InvalidArgumentException($internalIdArrayErrorMessage, __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Add item to internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\CouponCodeSearchRowBasic
     */
    public function addToInternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->internalId[] = $item;
        return $this;
    }
    /**
     * Get promotion value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getPromotion()
    {
        return $this->promotion;
    }
    /**
     * This method is responsible for validating the values passed to the setPromotion method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPromotion method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePromotionForArrayConstraintsFromSetPromotion(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $couponCodeSearchRowBasicPromotionItem) {
            // validation for constraint: itemType
            if (!$couponCodeSearchRowBasicPromotionItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($couponCodeSearchRowBasicPromotionItem) ? get_class($couponCodeSearchRowBasicPromotionItem) : sprintf('%s(%s)', gettype($couponCodeSearchRowBasicPromotionItem), var_export($couponCodeSearchRowBasicPromotionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The promotion property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set promotion value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $promotion
     * @return \StructType\CouponCodeSearchRowBasic
     */
    public function setPromotion(array $promotion = array())
    {
        // validation for constraint: array
        if ('' !== ($promotionArrayErrorMessage = self::validatePromotionForArrayConstraintsFromSetPromotion($promotion))) {
            throw new \InvalidArgumentException($promotionArrayErrorMessage, __LINE__);
        }
        $this->promotion = $promotion;
        return $this;
    }
    /**
     * Add item to promotion value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\CouponCodeSearchRowBasic
     */
    public function addToPromotion(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The promotion property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->promotion[] = $item;
        return $this;
    }
    /**
     * Get recipient value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getRecipient()
    {
        return $this->recipient;
    }
    /**
     * This method is responsible for validating the values passed to the setRecipient method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecipient method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecipientForArrayConstraintsFromSetRecipient(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $couponCodeSearchRowBasicRecipientItem) {
            // validation for constraint: itemType
            if (!$couponCodeSearchRowBasicRecipientItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($couponCodeSearchRowBasicRecipientItem) ? get_class($couponCodeSearchRowBasicRecipientItem) : sprintf('%s(%s)', gettype($couponCodeSearchRowBasicRecipientItem), var_export($couponCodeSearchRowBasicRecipientItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The recipient property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set recipient value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $recipient
     * @return \StructType\CouponCodeSearchRowBasic
     */
    public function setRecipient(array $recipient = array())
    {
        // validation for constraint: array
        if ('' !== ($recipientArrayErrorMessage = self::validateRecipientForArrayConstraintsFromSetRecipient($recipient))) {
            throw new \InvalidArgumentException($recipientArrayErrorMessage, __LINE__);
        }
        $this->recipient = $recipient;
        return $this;
    }
    /**
     * Add item to recipient value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\CouponCodeSearchRowBasic
     */
    public function addToRecipient(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The recipient property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->recipient[] = $item;
        return $this;
    }
    /**
     * Get useCount value
     * @return \StructType\SearchColumnLongField[]|null
     */
    public function getUseCount()
    {
        return $this->useCount;
    }
    /**
     * This method is responsible for validating the values passed to the setUseCount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUseCount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUseCountForArrayConstraintsFromSetUseCount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $couponCodeSearchRowBasicUseCountItem) {
            // validation for constraint: itemType
            if (!$couponCodeSearchRowBasicUseCountItem instanceof \StructType\SearchColumnLongField) {
                $invalidValues[] = is_object($couponCodeSearchRowBasicUseCountItem) ? get_class($couponCodeSearchRowBasicUseCountItem) : sprintf('%s(%s)', gettype($couponCodeSearchRowBasicUseCountItem), var_export($couponCodeSearchRowBasicUseCountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The useCount property can only contain items of type \StructType\SearchColumnLongField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set useCount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnLongField[] $useCount
     * @return \StructType\CouponCodeSearchRowBasic
     */
    public function setUseCount(array $useCount = array())
    {
        // validation for constraint: array
        if ('' !== ($useCountArrayErrorMessage = self::validateUseCountForArrayConstraintsFromSetUseCount($useCount))) {
            throw new \InvalidArgumentException($useCountArrayErrorMessage, __LINE__);
        }
        $this->useCount = $useCount;
        return $this;
    }
    /**
     * Add item to useCount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnLongField $item
     * @return \StructType\CouponCodeSearchRowBasic
     */
    public function addToUseCount(\StructType\SearchColumnLongField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnLongField) {
            throw new \InvalidArgumentException(sprintf('The useCount property can only contain items of type \StructType\SearchColumnLongField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->useCount[] = $item;
        return $this;
    }
    /**
     * Get used value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getUsed()
    {
        return $this->used;
    }
    /**
     * This method is responsible for validating the values passed to the setUsed method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUsed method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUsedForArrayConstraintsFromSetUsed(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $couponCodeSearchRowBasicUsedItem) {
            // validation for constraint: itemType
            if (!$couponCodeSearchRowBasicUsedItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($couponCodeSearchRowBasicUsedItem) ? get_class($couponCodeSearchRowBasicUsedItem) : sprintf('%s(%s)', gettype($couponCodeSearchRowBasicUsedItem), var_export($couponCodeSearchRowBasicUsedItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The used property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set used value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $used
     * @return \StructType\CouponCodeSearchRowBasic
     */
    public function setUsed(array $used = array())
    {
        // validation for constraint: array
        if ('' !== ($usedArrayErrorMessage = self::validateUsedForArrayConstraintsFromSetUsed($used))) {
            throw new \InvalidArgumentException($usedArrayErrorMessage, __LINE__);
        }
        $this->used = $used;
        return $this;
    }
    /**
     * Add item to used value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\CouponCodeSearchRowBasic
     */
    public function addToUsed(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The used property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->used[] = $item;
        return $this;
    }
}
