<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChargeSearchRowBasic StructType
 * @subpackage Structs
 */
class ChargeSearchRowBasic extends SearchRowBasic
{
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $amount;
    /**
     * The billingAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $billingAccount;
    /**
     * The billingItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $billingItem;
    /**
     * The billTo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $billTo;
    /**
     * The chargeDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $chargeDate;
    /**
     * The chargeType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $chargeType;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $class;
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $createdDate;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $currency;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $department;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $description;
    /**
     * The externalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $externalId;
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $internalId;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $location;
    /**
     * The modifiedDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $modifiedDate;
    /**
     * The postingPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $postingPeriod;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $quantity;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $rate;
    /**
     * The rule
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $rule;
    /**
     * The runId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $runId;
    /**
     * The salesOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $salesOrder;
    /**
     * The stage
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnEnumSelectField[]
     */
    public $stage;
    /**
     * The subscriptionLine
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $subscriptionLine;
    /**
     * The use
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnEnumSelectField[]
     */
    public $use;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchColumnCustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for ChargeSearchRowBasic
     * @uses ChargeSearchRowBasic::setAmount()
     * @uses ChargeSearchRowBasic::setBillingAccount()
     * @uses ChargeSearchRowBasic::setBillingItem()
     * @uses ChargeSearchRowBasic::setBillTo()
     * @uses ChargeSearchRowBasic::setChargeDate()
     * @uses ChargeSearchRowBasic::setChargeType()
     * @uses ChargeSearchRowBasic::setClass()
     * @uses ChargeSearchRowBasic::setCreatedDate()
     * @uses ChargeSearchRowBasic::setCurrency()
     * @uses ChargeSearchRowBasic::setDepartment()
     * @uses ChargeSearchRowBasic::setDescription()
     * @uses ChargeSearchRowBasic::setExternalId()
     * @uses ChargeSearchRowBasic::setInternalId()
     * @uses ChargeSearchRowBasic::setLocation()
     * @uses ChargeSearchRowBasic::setModifiedDate()
     * @uses ChargeSearchRowBasic::setPostingPeriod()
     * @uses ChargeSearchRowBasic::setQuantity()
     * @uses ChargeSearchRowBasic::setRate()
     * @uses ChargeSearchRowBasic::setRule()
     * @uses ChargeSearchRowBasic::setRunId()
     * @uses ChargeSearchRowBasic::setSalesOrder()
     * @uses ChargeSearchRowBasic::setStage()
     * @uses ChargeSearchRowBasic::setSubscriptionLine()
     * @uses ChargeSearchRowBasic::setUse()
     * @uses ChargeSearchRowBasic::setCustomFieldList()
     * @param \StructType\SearchColumnDoubleField[] $amount
     * @param \StructType\SearchColumnSelectField[] $billingAccount
     * @param \StructType\SearchColumnSelectField[] $billingItem
     * @param \StructType\SearchColumnSelectField[] $billTo
     * @param \StructType\SearchColumnDateField[] $chargeDate
     * @param \StructType\SearchColumnSelectField[] $chargeType
     * @param \StructType\SearchColumnSelectField[] $class
     * @param \StructType\SearchColumnDateField[] $createdDate
     * @param \StructType\SearchColumnSelectField[] $currency
     * @param \StructType\SearchColumnSelectField[] $department
     * @param \StructType\SearchColumnStringField[] $description
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @param \StructType\SearchColumnSelectField[] $location
     * @param \StructType\SearchColumnDateField[] $modifiedDate
     * @param \StructType\SearchColumnStringField[] $postingPeriod
     * @param \StructType\SearchColumnStringField[] $quantity
     * @param \StructType\SearchColumnStringField[] $rate
     * @param \StructType\SearchColumnSelectField[] $rule
     * @param \StructType\SearchColumnStringField[] $runId
     * @param \StructType\SearchColumnStringField[] $salesOrder
     * @param \StructType\SearchColumnEnumSelectField[] $stage
     * @param \StructType\SearchColumnSelectField[] $subscriptionLine
     * @param \StructType\SearchColumnEnumSelectField[] $use
     * @param \StructType\SearchColumnCustomFieldList $customFieldList
     */
    public function __construct(array $amount = array(), array $billingAccount = array(), array $billingItem = array(), array $billTo = array(), array $chargeDate = array(), array $chargeType = array(), array $class = array(), array $createdDate = array(), array $currency = array(), array $department = array(), array $description = array(), array $externalId = array(), array $internalId = array(), array $location = array(), array $modifiedDate = array(), array $postingPeriod = array(), array $quantity = array(), array $rate = array(), array $rule = array(), array $runId = array(), array $salesOrder = array(), array $stage = array(), array $subscriptionLine = array(), array $use = array(), \StructType\SearchColumnCustomFieldList $customFieldList = null)
    {
        $this
            ->setAmount($amount)
            ->setBillingAccount($billingAccount)
            ->setBillingItem($billingItem)
            ->setBillTo($billTo)
            ->setChargeDate($chargeDate)
            ->setChargeType($chargeType)
            ->setClass($class)
            ->setCreatedDate($createdDate)
            ->setCurrency($currency)
            ->setDepartment($department)
            ->setDescription($description)
            ->setExternalId($externalId)
            ->setInternalId($internalId)
            ->setLocation($location)
            ->setModifiedDate($modifiedDate)
            ->setPostingPeriod($postingPeriod)
            ->setQuantity($quantity)
            ->setRate($rate)
            ->setRule($rule)
            ->setRunId($runId)
            ->setSalesOrder($salesOrder)
            ->setStage($stage)
            ->setSubscriptionLine($subscriptionLine)
            ->setUse($use)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get amount value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * This method is responsible for validating the values passed to the setAmount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAmount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAmountForArrayConstraintsFromSetAmount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $chargeSearchRowBasicAmountItem) {
            // validation for constraint: itemType
            if (!$chargeSearchRowBasicAmountItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($chargeSearchRowBasicAmountItem) ? get_class($chargeSearchRowBasicAmountItem) : sprintf('%s(%s)', gettype($chargeSearchRowBasicAmountItem), var_export($chargeSearchRowBasicAmountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The amount property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set amount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $amount
     * @return \StructType\ChargeSearchRowBasic
     */
    public function setAmount(array $amount = array())
    {
        // validation for constraint: array
        if ('' !== ($amountArrayErrorMessage = self::validateAmountForArrayConstraintsFromSetAmount($amount))) {
            throw new \InvalidArgumentException($amountArrayErrorMessage, __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Add item to amount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ChargeSearchRowBasic
     */
    public function addToAmount(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The amount property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->amount[] = $item;
        return $this;
    }
    /**
     * Get billingAccount value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getBillingAccount()
    {
        return $this->billingAccount;
    }
    /**
     * This method is responsible for validating the values passed to the setBillingAccount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBillingAccount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBillingAccountForArrayConstraintsFromSetBillingAccount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $chargeSearchRowBasicBillingAccountItem) {
            // validation for constraint: itemType
            if (!$chargeSearchRowBasicBillingAccountItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($chargeSearchRowBasicBillingAccountItem) ? get_class($chargeSearchRowBasicBillingAccountItem) : sprintf('%s(%s)', gettype($chargeSearchRowBasicBillingAccountItem), var_export($chargeSearchRowBasicBillingAccountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The billingAccount property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set billingAccount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $billingAccount
     * @return \StructType\ChargeSearchRowBasic
     */
    public function setBillingAccount(array $billingAccount = array())
    {
        // validation for constraint: array
        if ('' !== ($billingAccountArrayErrorMessage = self::validateBillingAccountForArrayConstraintsFromSetBillingAccount($billingAccount))) {
            throw new \InvalidArgumentException($billingAccountArrayErrorMessage, __LINE__);
        }
        $this->billingAccount = $billingAccount;
        return $this;
    }
    /**
     * Add item to billingAccount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ChargeSearchRowBasic
     */
    public function addToBillingAccount(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The billingAccount property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->billingAccount[] = $item;
        return $this;
    }
    /**
     * Get billingItem value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getBillingItem()
    {
        return $this->billingItem;
    }
    /**
     * This method is responsible for validating the values passed to the setBillingItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBillingItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBillingItemForArrayConstraintsFromSetBillingItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $chargeSearchRowBasicBillingItemItem) {
            // validation for constraint: itemType
            if (!$chargeSearchRowBasicBillingItemItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($chargeSearchRowBasicBillingItemItem) ? get_class($chargeSearchRowBasicBillingItemItem) : sprintf('%s(%s)', gettype($chargeSearchRowBasicBillingItemItem), var_export($chargeSearchRowBasicBillingItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The billingItem property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set billingItem value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $billingItem
     * @return \StructType\ChargeSearchRowBasic
     */
    public function setBillingItem(array $billingItem = array())
    {
        // validation for constraint: array
        if ('' !== ($billingItemArrayErrorMessage = self::validateBillingItemForArrayConstraintsFromSetBillingItem($billingItem))) {
            throw new \InvalidArgumentException($billingItemArrayErrorMessage, __LINE__);
        }
        $this->billingItem = $billingItem;
        return $this;
    }
    /**
     * Add item to billingItem value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ChargeSearchRowBasic
     */
    public function addToBillingItem(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The billingItem property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->billingItem[] = $item;
        return $this;
    }
    /**
     * Get billTo value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getBillTo()
    {
        return $this->billTo;
    }
    /**
     * This method is responsible for validating the values passed to the setBillTo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBillTo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBillToForArrayConstraintsFromSetBillTo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $chargeSearchRowBasicBillToItem) {
            // validation for constraint: itemType
            if (!$chargeSearchRowBasicBillToItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($chargeSearchRowBasicBillToItem) ? get_class($chargeSearchRowBasicBillToItem) : sprintf('%s(%s)', gettype($chargeSearchRowBasicBillToItem), var_export($chargeSearchRowBasicBillToItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The billTo property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set billTo value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $billTo
     * @return \StructType\ChargeSearchRowBasic
     */
    public function setBillTo(array $billTo = array())
    {
        // validation for constraint: array
        if ('' !== ($billToArrayErrorMessage = self::validateBillToForArrayConstraintsFromSetBillTo($billTo))) {
            throw new \InvalidArgumentException($billToArrayErrorMessage, __LINE__);
        }
        $this->billTo = $billTo;
        return $this;
    }
    /**
     * Add item to billTo value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ChargeSearchRowBasic
     */
    public function addToBillTo(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The billTo property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->billTo[] = $item;
        return $this;
    }
    /**
     * Get chargeDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getChargeDate()
    {
        return $this->chargeDate;
    }
    /**
     * This method is responsible for validating the values passed to the setChargeDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setChargeDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateChargeDateForArrayConstraintsFromSetChargeDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $chargeSearchRowBasicChargeDateItem) {
            // validation for constraint: itemType
            if (!$chargeSearchRowBasicChargeDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($chargeSearchRowBasicChargeDateItem) ? get_class($chargeSearchRowBasicChargeDateItem) : sprintf('%s(%s)', gettype($chargeSearchRowBasicChargeDateItem), var_export($chargeSearchRowBasicChargeDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The chargeDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set chargeDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $chargeDate
     * @return \StructType\ChargeSearchRowBasic
     */
    public function setChargeDate(array $chargeDate = array())
    {
        // validation for constraint: array
        if ('' !== ($chargeDateArrayErrorMessage = self::validateChargeDateForArrayConstraintsFromSetChargeDate($chargeDate))) {
            throw new \InvalidArgumentException($chargeDateArrayErrorMessage, __LINE__);
        }
        $this->chargeDate = $chargeDate;
        return $this;
    }
    /**
     * Add item to chargeDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\ChargeSearchRowBasic
     */
    public function addToChargeDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The chargeDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->chargeDate[] = $item;
        return $this;
    }
    /**
     * Get chargeType value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getChargeType()
    {
        return $this->chargeType;
    }
    /**
     * This method is responsible for validating the values passed to the setChargeType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setChargeType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateChargeTypeForArrayConstraintsFromSetChargeType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $chargeSearchRowBasicChargeTypeItem) {
            // validation for constraint: itemType
            if (!$chargeSearchRowBasicChargeTypeItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($chargeSearchRowBasicChargeTypeItem) ? get_class($chargeSearchRowBasicChargeTypeItem) : sprintf('%s(%s)', gettype($chargeSearchRowBasicChargeTypeItem), var_export($chargeSearchRowBasicChargeTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The chargeType property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set chargeType value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $chargeType
     * @return \StructType\ChargeSearchRowBasic
     */
    public function setChargeType(array $chargeType = array())
    {
        // validation for constraint: array
        if ('' !== ($chargeTypeArrayErrorMessage = self::validateChargeTypeForArrayConstraintsFromSetChargeType($chargeType))) {
            throw new \InvalidArgumentException($chargeTypeArrayErrorMessage, __LINE__);
        }
        $this->chargeType = $chargeType;
        return $this;
    }
    /**
     * Add item to chargeType value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ChargeSearchRowBasic
     */
    public function addToChargeType(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The chargeType property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->chargeType[] = $item;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * This method is responsible for validating the values passed to the setClass method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClass method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateClassForArrayConstraintsFromSetClass(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $chargeSearchRowBasicClassItem) {
            // validation for constraint: itemType
            if (!$chargeSearchRowBasicClassItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($chargeSearchRowBasicClassItem) ? get_class($chargeSearchRowBasicClassItem) : sprintf('%s(%s)', gettype($chargeSearchRowBasicClassItem), var_export($chargeSearchRowBasicClassItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The class property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set class value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $class
     * @return \StructType\ChargeSearchRowBasic
     */
    public function setClass(array $class = array())
    {
        // validation for constraint: array
        if ('' !== ($classArrayErrorMessage = self::validateClassForArrayConstraintsFromSetClass($class))) {
            throw new \InvalidArgumentException($classArrayErrorMessage, __LINE__);
        }
        $this->class = $class;
        return $this;
    }
    /**
     * Add item to class value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ChargeSearchRowBasic
     */
    public function addToClass(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The class property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->class[] = $item;
        return $this;
    }
    /**
     * Get createdDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * This method is responsible for validating the values passed to the setCreatedDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCreatedDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCreatedDateForArrayConstraintsFromSetCreatedDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $chargeSearchRowBasicCreatedDateItem) {
            // validation for constraint: itemType
            if (!$chargeSearchRowBasicCreatedDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($chargeSearchRowBasicCreatedDateItem) ? get_class($chargeSearchRowBasicCreatedDateItem) : sprintf('%s(%s)', gettype($chargeSearchRowBasicCreatedDateItem), var_export($chargeSearchRowBasicCreatedDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The createdDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set createdDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $createdDate
     * @return \StructType\ChargeSearchRowBasic
     */
    public function setCreatedDate(array $createdDate = array())
    {
        // validation for constraint: array
        if ('' !== ($createdDateArrayErrorMessage = self::validateCreatedDateForArrayConstraintsFromSetCreatedDate($createdDate))) {
            throw new \InvalidArgumentException($createdDateArrayErrorMessage, __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Add item to createdDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\ChargeSearchRowBasic
     */
    public function addToCreatedDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The createdDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->createdDate[] = $item;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * This method is responsible for validating the values passed to the setCurrency method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCurrency method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCurrencyForArrayConstraintsFromSetCurrency(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $chargeSearchRowBasicCurrencyItem) {
            // validation for constraint: itemType
            if (!$chargeSearchRowBasicCurrencyItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($chargeSearchRowBasicCurrencyItem) ? get_class($chargeSearchRowBasicCurrencyItem) : sprintf('%s(%s)', gettype($chargeSearchRowBasicCurrencyItem), var_export($chargeSearchRowBasicCurrencyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The currency property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set currency value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $currency
     * @return \StructType\ChargeSearchRowBasic
     */
    public function setCurrency(array $currency = array())
    {
        // validation for constraint: array
        if ('' !== ($currencyArrayErrorMessage = self::validateCurrencyForArrayConstraintsFromSetCurrency($currency))) {
            throw new \InvalidArgumentException($currencyArrayErrorMessage, __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Add item to currency value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ChargeSearchRowBasic
     */
    public function addToCurrency(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The currency property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->currency[] = $item;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * This method is responsible for validating the values passed to the setDepartment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDepartment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDepartmentForArrayConstraintsFromSetDepartment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $chargeSearchRowBasicDepartmentItem) {
            // validation for constraint: itemType
            if (!$chargeSearchRowBasicDepartmentItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($chargeSearchRowBasicDepartmentItem) ? get_class($chargeSearchRowBasicDepartmentItem) : sprintf('%s(%s)', gettype($chargeSearchRowBasicDepartmentItem), var_export($chargeSearchRowBasicDepartmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The department property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set department value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $department
     * @return \StructType\ChargeSearchRowBasic
     */
    public function setDepartment(array $department = array())
    {
        // validation for constraint: array
        if ('' !== ($departmentArrayErrorMessage = self::validateDepartmentForArrayConstraintsFromSetDepartment($department))) {
            throw new \InvalidArgumentException($departmentArrayErrorMessage, __LINE__);
        }
        $this->department = $department;
        return $this;
    }
    /**
     * Add item to department value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ChargeSearchRowBasic
     */
    public function addToDepartment(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The department property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->department[] = $item;
        return $this;
    }
    /**
     * Get description value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $chargeSearchRowBasicDescriptionItem) {
            // validation for constraint: itemType
            if (!$chargeSearchRowBasicDescriptionItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($chargeSearchRowBasicDescriptionItem) ? get_class($chargeSearchRowBasicDescriptionItem) : sprintf('%s(%s)', gettype($chargeSearchRowBasicDescriptionItem), var_export($chargeSearchRowBasicDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The description property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set description value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $description
     * @return \StructType\ChargeSearchRowBasic
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Add item to description value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\ChargeSearchRowBasic
     */
    public function addToDescription(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The description property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->description[] = $item;
        return $this;
    }
    /**
     * Get externalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * This method is responsible for validating the values passed to the setExternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExternalIdForArrayConstraintsFromSetExternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $chargeSearchRowBasicExternalIdItem) {
            // validation for constraint: itemType
            if (!$chargeSearchRowBasicExternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($chargeSearchRowBasicExternalIdItem) ? get_class($chargeSearchRowBasicExternalIdItem) : sprintf('%s(%s)', gettype($chargeSearchRowBasicExternalIdItem), var_export($chargeSearchRowBasicExternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @return \StructType\ChargeSearchRowBasic
     */
    public function setExternalId(array $externalId = array())
    {
        // validation for constraint: array
        if ('' !== ($externalIdArrayErrorMessage = self::validateExternalIdForArrayConstraintsFromSetExternalId($externalId))) {
            throw new \InvalidArgumentException($externalIdArrayErrorMessage, __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
    /**
     * Add item to externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ChargeSearchRowBasic
     */
    public function addToExternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->externalId[] = $item;
        return $this;
    }
    /**
     * Get internalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * This method is responsible for validating the values passed to the setInternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternalIdForArrayConstraintsFromSetInternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $chargeSearchRowBasicInternalIdItem) {
            // validation for constraint: itemType
            if (!$chargeSearchRowBasicInternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($chargeSearchRowBasicInternalIdItem) ? get_class($chargeSearchRowBasicInternalIdItem) : sprintf('%s(%s)', gettype($chargeSearchRowBasicInternalIdItem), var_export($chargeSearchRowBasicInternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @return \StructType\ChargeSearchRowBasic
     */
    public function setInternalId(array $internalId = array())
    {
        // validation for constraint: array
        if ('' !== ($internalIdArrayErrorMessage = self::validateInternalIdForArrayConstraintsFromSetInternalId($internalId))) {
            throw new \InvalidArgumentException($internalIdArrayErrorMessage, __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Add item to internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ChargeSearchRowBasic
     */
    public function addToInternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->internalId[] = $item;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * This method is responsible for validating the values passed to the setLocation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocationForArrayConstraintsFromSetLocation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $chargeSearchRowBasicLocationItem) {
            // validation for constraint: itemType
            if (!$chargeSearchRowBasicLocationItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($chargeSearchRowBasicLocationItem) ? get_class($chargeSearchRowBasicLocationItem) : sprintf('%s(%s)', gettype($chargeSearchRowBasicLocationItem), var_export($chargeSearchRowBasicLocationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The location property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set location value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $location
     * @return \StructType\ChargeSearchRowBasic
     */
    public function setLocation(array $location = array())
    {
        // validation for constraint: array
        if ('' !== ($locationArrayErrorMessage = self::validateLocationForArrayConstraintsFromSetLocation($location))) {
            throw new \InvalidArgumentException($locationArrayErrorMessage, __LINE__);
        }
        $this->location = $location;
        return $this;
    }
    /**
     * Add item to location value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ChargeSearchRowBasic
     */
    public function addToLocation(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The location property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->location[] = $item;
        return $this;
    }
    /**
     * Get modifiedDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getModifiedDate()
    {
        return $this->modifiedDate;
    }
    /**
     * This method is responsible for validating the values passed to the setModifiedDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setModifiedDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateModifiedDateForArrayConstraintsFromSetModifiedDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $chargeSearchRowBasicModifiedDateItem) {
            // validation for constraint: itemType
            if (!$chargeSearchRowBasicModifiedDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($chargeSearchRowBasicModifiedDateItem) ? get_class($chargeSearchRowBasicModifiedDateItem) : sprintf('%s(%s)', gettype($chargeSearchRowBasicModifiedDateItem), var_export($chargeSearchRowBasicModifiedDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The modifiedDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set modifiedDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $modifiedDate
     * @return \StructType\ChargeSearchRowBasic
     */
    public function setModifiedDate(array $modifiedDate = array())
    {
        // validation for constraint: array
        if ('' !== ($modifiedDateArrayErrorMessage = self::validateModifiedDateForArrayConstraintsFromSetModifiedDate($modifiedDate))) {
            throw new \InvalidArgumentException($modifiedDateArrayErrorMessage, __LINE__);
        }
        $this->modifiedDate = $modifiedDate;
        return $this;
    }
    /**
     * Add item to modifiedDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\ChargeSearchRowBasic
     */
    public function addToModifiedDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The modifiedDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->modifiedDate[] = $item;
        return $this;
    }
    /**
     * Get postingPeriod value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getPostingPeriod()
    {
        return $this->postingPeriod;
    }
    /**
     * This method is responsible for validating the values passed to the setPostingPeriod method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPostingPeriod method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePostingPeriodForArrayConstraintsFromSetPostingPeriod(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $chargeSearchRowBasicPostingPeriodItem) {
            // validation for constraint: itemType
            if (!$chargeSearchRowBasicPostingPeriodItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($chargeSearchRowBasicPostingPeriodItem) ? get_class($chargeSearchRowBasicPostingPeriodItem) : sprintf('%s(%s)', gettype($chargeSearchRowBasicPostingPeriodItem), var_export($chargeSearchRowBasicPostingPeriodItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The postingPeriod property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set postingPeriod value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $postingPeriod
     * @return \StructType\ChargeSearchRowBasic
     */
    public function setPostingPeriod(array $postingPeriod = array())
    {
        // validation for constraint: array
        if ('' !== ($postingPeriodArrayErrorMessage = self::validatePostingPeriodForArrayConstraintsFromSetPostingPeriod($postingPeriod))) {
            throw new \InvalidArgumentException($postingPeriodArrayErrorMessage, __LINE__);
        }
        $this->postingPeriod = $postingPeriod;
        return $this;
    }
    /**
     * Add item to postingPeriod value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\ChargeSearchRowBasic
     */
    public function addToPostingPeriod(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The postingPeriod property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->postingPeriod[] = $item;
        return $this;
    }
    /**
     * Get quantity value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * This method is responsible for validating the values passed to the setQuantity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQuantity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateQuantityForArrayConstraintsFromSetQuantity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $chargeSearchRowBasicQuantityItem) {
            // validation for constraint: itemType
            if (!$chargeSearchRowBasicQuantityItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($chargeSearchRowBasicQuantityItem) ? get_class($chargeSearchRowBasicQuantityItem) : sprintf('%s(%s)', gettype($chargeSearchRowBasicQuantityItem), var_export($chargeSearchRowBasicQuantityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The quantity property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set quantity value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $quantity
     * @return \StructType\ChargeSearchRowBasic
     */
    public function setQuantity(array $quantity = array())
    {
        // validation for constraint: array
        if ('' !== ($quantityArrayErrorMessage = self::validateQuantityForArrayConstraintsFromSetQuantity($quantity))) {
            throw new \InvalidArgumentException($quantityArrayErrorMessage, __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Add item to quantity value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\ChargeSearchRowBasic
     */
    public function addToQuantity(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The quantity property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->quantity[] = $item;
        return $this;
    }
    /**
     * Get rate value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * This method is responsible for validating the values passed to the setRate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRateForArrayConstraintsFromSetRate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $chargeSearchRowBasicRateItem) {
            // validation for constraint: itemType
            if (!$chargeSearchRowBasicRateItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($chargeSearchRowBasicRateItem) ? get_class($chargeSearchRowBasicRateItem) : sprintf('%s(%s)', gettype($chargeSearchRowBasicRateItem), var_export($chargeSearchRowBasicRateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The rate property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set rate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $rate
     * @return \StructType\ChargeSearchRowBasic
     */
    public function setRate(array $rate = array())
    {
        // validation for constraint: array
        if ('' !== ($rateArrayErrorMessage = self::validateRateForArrayConstraintsFromSetRate($rate))) {
            throw new \InvalidArgumentException($rateArrayErrorMessage, __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Add item to rate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\ChargeSearchRowBasic
     */
    public function addToRate(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The rate property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->rate[] = $item;
        return $this;
    }
    /**
     * Get rule value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getRule()
    {
        return $this->rule;
    }
    /**
     * This method is responsible for validating the values passed to the setRule method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRule method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRuleForArrayConstraintsFromSetRule(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $chargeSearchRowBasicRuleItem) {
            // validation for constraint: itemType
            if (!$chargeSearchRowBasicRuleItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($chargeSearchRowBasicRuleItem) ? get_class($chargeSearchRowBasicRuleItem) : sprintf('%s(%s)', gettype($chargeSearchRowBasicRuleItem), var_export($chargeSearchRowBasicRuleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The rule property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set rule value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $rule
     * @return \StructType\ChargeSearchRowBasic
     */
    public function setRule(array $rule = array())
    {
        // validation for constraint: array
        if ('' !== ($ruleArrayErrorMessage = self::validateRuleForArrayConstraintsFromSetRule($rule))) {
            throw new \InvalidArgumentException($ruleArrayErrorMessage, __LINE__);
        }
        $this->rule = $rule;
        return $this;
    }
    /**
     * Add item to rule value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ChargeSearchRowBasic
     */
    public function addToRule(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The rule property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->rule[] = $item;
        return $this;
    }
    /**
     * Get runId value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getRunId()
    {
        return $this->runId;
    }
    /**
     * This method is responsible for validating the values passed to the setRunId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRunId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRunIdForArrayConstraintsFromSetRunId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $chargeSearchRowBasicRunIdItem) {
            // validation for constraint: itemType
            if (!$chargeSearchRowBasicRunIdItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($chargeSearchRowBasicRunIdItem) ? get_class($chargeSearchRowBasicRunIdItem) : sprintf('%s(%s)', gettype($chargeSearchRowBasicRunIdItem), var_export($chargeSearchRowBasicRunIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The runId property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set runId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $runId
     * @return \StructType\ChargeSearchRowBasic
     */
    public function setRunId(array $runId = array())
    {
        // validation for constraint: array
        if ('' !== ($runIdArrayErrorMessage = self::validateRunIdForArrayConstraintsFromSetRunId($runId))) {
            throw new \InvalidArgumentException($runIdArrayErrorMessage, __LINE__);
        }
        $this->runId = $runId;
        return $this;
    }
    /**
     * Add item to runId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\ChargeSearchRowBasic
     */
    public function addToRunId(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The runId property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->runId[] = $item;
        return $this;
    }
    /**
     * Get salesOrder value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getSalesOrder()
    {
        return $this->salesOrder;
    }
    /**
     * This method is responsible for validating the values passed to the setSalesOrder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSalesOrder method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSalesOrderForArrayConstraintsFromSetSalesOrder(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $chargeSearchRowBasicSalesOrderItem) {
            // validation for constraint: itemType
            if (!$chargeSearchRowBasicSalesOrderItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($chargeSearchRowBasicSalesOrderItem) ? get_class($chargeSearchRowBasicSalesOrderItem) : sprintf('%s(%s)', gettype($chargeSearchRowBasicSalesOrderItem), var_export($chargeSearchRowBasicSalesOrderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The salesOrder property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set salesOrder value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $salesOrder
     * @return \StructType\ChargeSearchRowBasic
     */
    public function setSalesOrder(array $salesOrder = array())
    {
        // validation for constraint: array
        if ('' !== ($salesOrderArrayErrorMessage = self::validateSalesOrderForArrayConstraintsFromSetSalesOrder($salesOrder))) {
            throw new \InvalidArgumentException($salesOrderArrayErrorMessage, __LINE__);
        }
        $this->salesOrder = $salesOrder;
        return $this;
    }
    /**
     * Add item to salesOrder value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\ChargeSearchRowBasic
     */
    public function addToSalesOrder(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The salesOrder property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->salesOrder[] = $item;
        return $this;
    }
    /**
     * Get stage value
     * @return \StructType\SearchColumnEnumSelectField[]|null
     */
    public function getStage()
    {
        return $this->stage;
    }
    /**
     * This method is responsible for validating the values passed to the setStage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStageForArrayConstraintsFromSetStage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $chargeSearchRowBasicStageItem) {
            // validation for constraint: itemType
            if (!$chargeSearchRowBasicStageItem instanceof \StructType\SearchColumnEnumSelectField) {
                $invalidValues[] = is_object($chargeSearchRowBasicStageItem) ? get_class($chargeSearchRowBasicStageItem) : sprintf('%s(%s)', gettype($chargeSearchRowBasicStageItem), var_export($chargeSearchRowBasicStageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The stage property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set stage value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField[] $stage
     * @return \StructType\ChargeSearchRowBasic
     */
    public function setStage(array $stage = array())
    {
        // validation for constraint: array
        if ('' !== ($stageArrayErrorMessage = self::validateStageForArrayConstraintsFromSetStage($stage))) {
            throw new \InvalidArgumentException($stageArrayErrorMessage, __LINE__);
        }
        $this->stage = $stage;
        return $this;
    }
    /**
     * Add item to stage value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField $item
     * @return \StructType\ChargeSearchRowBasic
     */
    public function addToStage(\StructType\SearchColumnEnumSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnEnumSelectField) {
            throw new \InvalidArgumentException(sprintf('The stage property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->stage[] = $item;
        return $this;
    }
    /**
     * Get subscriptionLine value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getSubscriptionLine()
    {
        return $this->subscriptionLine;
    }
    /**
     * This method is responsible for validating the values passed to the setSubscriptionLine method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubscriptionLine method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubscriptionLineForArrayConstraintsFromSetSubscriptionLine(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $chargeSearchRowBasicSubscriptionLineItem) {
            // validation for constraint: itemType
            if (!$chargeSearchRowBasicSubscriptionLineItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($chargeSearchRowBasicSubscriptionLineItem) ? get_class($chargeSearchRowBasicSubscriptionLineItem) : sprintf('%s(%s)', gettype($chargeSearchRowBasicSubscriptionLineItem), var_export($chargeSearchRowBasicSubscriptionLineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The subscriptionLine property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set subscriptionLine value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $subscriptionLine
     * @return \StructType\ChargeSearchRowBasic
     */
    public function setSubscriptionLine(array $subscriptionLine = array())
    {
        // validation for constraint: array
        if ('' !== ($subscriptionLineArrayErrorMessage = self::validateSubscriptionLineForArrayConstraintsFromSetSubscriptionLine($subscriptionLine))) {
            throw new \InvalidArgumentException($subscriptionLineArrayErrorMessage, __LINE__);
        }
        $this->subscriptionLine = $subscriptionLine;
        return $this;
    }
    /**
     * Add item to subscriptionLine value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ChargeSearchRowBasic
     */
    public function addToSubscriptionLine(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The subscriptionLine property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->subscriptionLine[] = $item;
        return $this;
    }
    /**
     * Get use value
     * @return \StructType\SearchColumnEnumSelectField[]|null
     */
    public function getUse()
    {
        return $this->use;
    }
    /**
     * This method is responsible for validating the values passed to the setUse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUse method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUseForArrayConstraintsFromSetUse(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $chargeSearchRowBasicUseItem) {
            // validation for constraint: itemType
            if (!$chargeSearchRowBasicUseItem instanceof \StructType\SearchColumnEnumSelectField) {
                $invalidValues[] = is_object($chargeSearchRowBasicUseItem) ? get_class($chargeSearchRowBasicUseItem) : sprintf('%s(%s)', gettype($chargeSearchRowBasicUseItem), var_export($chargeSearchRowBasicUseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The use property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set use value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField[] $use
     * @return \StructType\ChargeSearchRowBasic
     */
    public function setUse(array $use = array())
    {
        // validation for constraint: array
        if ('' !== ($useArrayErrorMessage = self::validateUseForArrayConstraintsFromSetUse($use))) {
            throw new \InvalidArgumentException($useArrayErrorMessage, __LINE__);
        }
        $this->use = $use;
        return $this;
    }
    /**
     * Add item to use value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField $item
     * @return \StructType\ChargeSearchRowBasic
     */
    public function addToUse(\StructType\SearchColumnEnumSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnEnumSelectField) {
            throw new \InvalidArgumentException(sprintf('The use property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->use[] = $item;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\SearchColumnCustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\SearchColumnCustomFieldList $customFieldList
     * @return \StructType\ChargeSearchRowBasic
     */
    public function setCustomFieldList(\StructType\SearchColumnCustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
