<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Charge StructType
 * @subpackage Structs
 */
class Charge extends Record
{
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The salesOrder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $salesOrder;
    /**
     * The billTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $billTo;
    /**
     * The billingAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $billingAccount;
    /**
     * The stage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $stage;
    /**
     * The chargeDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $chargeDate;
    /**
     * The use
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $use;
    /**
     * The chargeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $chargeType;
    /**
     * The projectTask
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $projectTask;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The timeRecord
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $timeRecord;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $rate;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantity;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * The billingItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $billingItem;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $currency;
    /**
     * The transaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $transaction;
    /**
     * The transactionLine
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $transactionLine;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The salesOrderLine
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $salesOrderLine;
    /**
     * The subscriptionLine
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subscriptionLine;
    /**
     * The invoice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $invoice;
    /**
     * The invoiceLine
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $invoiceLine;
    /**
     * The rule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $rule;
    /**
     * The runId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $runId;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for Charge
     * @uses Charge::setCustomForm()
     * @uses Charge::setSalesOrder()
     * @uses Charge::setBillTo()
     * @uses Charge::setBillingAccount()
     * @uses Charge::setStage()
     * @uses Charge::setChargeDate()
     * @uses Charge::setUse()
     * @uses Charge::setChargeType()
     * @uses Charge::setProjectTask()
     * @uses Charge::setDescription()
     * @uses Charge::setCreatedDate()
     * @uses Charge::setTimeRecord()
     * @uses Charge::setRate()
     * @uses Charge::setQuantity()
     * @uses Charge::setAmount()
     * @uses Charge::setBillingItem()
     * @uses Charge::setCurrency()
     * @uses Charge::setTransaction()
     * @uses Charge::setTransactionLine()
     * @uses Charge::setClass()
     * @uses Charge::setDepartment()
     * @uses Charge::setLocation()
     * @uses Charge::setSalesOrderLine()
     * @uses Charge::setSubscriptionLine()
     * @uses Charge::setInvoice()
     * @uses Charge::setInvoiceLine()
     * @uses Charge::setRule()
     * @uses Charge::setRunId()
     * @uses Charge::setInternalId()
     * @uses Charge::setExternalId()
     * @param \StructType\RecordRef $customForm
     * @param \StructType\RecordRef $salesOrder
     * @param \StructType\RecordRef $billTo
     * @param \StructType\RecordRef $billingAccount
     * @param string $stage
     * @param string $chargeDate
     * @param string $use
     * @param \StructType\RecordRef $chargeType
     * @param \StructType\RecordRef $projectTask
     * @param string $description
     * @param string $createdDate
     * @param \StructType\RecordRef $timeRecord
     * @param string $rate
     * @param float $quantity
     * @param float $amount
     * @param \StructType\RecordRef $billingItem
     * @param \StructType\RecordRef $currency
     * @param \StructType\RecordRef $transaction
     * @param \StructType\RecordRef $transactionLine
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRef $salesOrderLine
     * @param \StructType\RecordRef $subscriptionLine
     * @param \StructType\RecordRef $invoice
     * @param \StructType\RecordRef $invoiceLine
     * @param \StructType\RecordRef $rule
     * @param string $runId
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct(\StructType\RecordRef $customForm = null, \StructType\RecordRef $salesOrder = null, \StructType\RecordRef $billTo = null, \StructType\RecordRef $billingAccount = null, $stage = null, $chargeDate = null, $use = null, \StructType\RecordRef $chargeType = null, \StructType\RecordRef $projectTask = null, $description = null, $createdDate = null, \StructType\RecordRef $timeRecord = null, $rate = null, $quantity = null, $amount = null, \StructType\RecordRef $billingItem = null, \StructType\RecordRef $currency = null, \StructType\RecordRef $transaction = null, \StructType\RecordRef $transactionLine = null, \StructType\RecordRef $class = null, \StructType\RecordRef $department = null, \StructType\RecordRef $location = null, \StructType\RecordRef $salesOrderLine = null, \StructType\RecordRef $subscriptionLine = null, \StructType\RecordRef $invoice = null, \StructType\RecordRef $invoiceLine = null, \StructType\RecordRef $rule = null, $runId = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCustomForm($customForm)
            ->setSalesOrder($salesOrder)
            ->setBillTo($billTo)
            ->setBillingAccount($billingAccount)
            ->setStage($stage)
            ->setChargeDate($chargeDate)
            ->setUse($use)
            ->setChargeType($chargeType)
            ->setProjectTask($projectTask)
            ->setDescription($description)
            ->setCreatedDate($createdDate)
            ->setTimeRecord($timeRecord)
            ->setRate($rate)
            ->setQuantity($quantity)
            ->setAmount($amount)
            ->setBillingItem($billingItem)
            ->setCurrency($currency)
            ->setTransaction($transaction)
            ->setTransactionLine($transactionLine)
            ->setClass($class)
            ->setDepartment($department)
            ->setLocation($location)
            ->setSalesOrderLine($salesOrderLine)
            ->setSubscriptionLine($subscriptionLine)
            ->setInvoice($invoice)
            ->setInvoiceLine($invoiceLine)
            ->setRule($rule)
            ->setRunId($runId)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\Charge
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get salesOrder value
     * @return \StructType\RecordRef|null
     */
    public function getSalesOrder()
    {
        return $this->salesOrder;
    }
    /**
     * Set salesOrder value
     * @param \StructType\RecordRef $salesOrder
     * @return \StructType\Charge
     */
    public function setSalesOrder(\StructType\RecordRef $salesOrder = null)
    {
        $this->salesOrder = $salesOrder;
        return $this;
    }
    /**
     * Get billTo value
     * @return \StructType\RecordRef|null
     */
    public function getBillTo()
    {
        return $this->billTo;
    }
    /**
     * Set billTo value
     * @param \StructType\RecordRef $billTo
     * @return \StructType\Charge
     */
    public function setBillTo(\StructType\RecordRef $billTo = null)
    {
        $this->billTo = $billTo;
        return $this;
    }
    /**
     * Get billingAccount value
     * @return \StructType\RecordRef|null
     */
    public function getBillingAccount()
    {
        return $this->billingAccount;
    }
    /**
     * Set billingAccount value
     * @param \StructType\RecordRef $billingAccount
     * @return \StructType\Charge
     */
    public function setBillingAccount(\StructType\RecordRef $billingAccount = null)
    {
        $this->billingAccount = $billingAccount;
        return $this;
    }
    /**
     * Get stage value
     * @return string|null
     */
    public function getStage()
    {
        return $this->stage;
    }
    /**
     * Set stage value
     * @uses \EnumType\ChargeStage::valueIsValid()
     * @uses \EnumType\ChargeStage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $stage
     * @return \StructType\Charge
     */
    public function setStage($stage = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ChargeStage::valueIsValid($stage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ChargeStage', is_array($stage) ? implode(', ', $stage) : var_export($stage, true), implode(', ', \EnumType\ChargeStage::getValidValues())), __LINE__);
        }
        $this->stage = $stage;
        return $this;
    }
    /**
     * Get chargeDate value
     * @return string|null
     */
    public function getChargeDate()
    {
        return $this->chargeDate;
    }
    /**
     * Set chargeDate value
     * @param string $chargeDate
     * @return \StructType\Charge
     */
    public function setChargeDate($chargeDate = null)
    {
        // validation for constraint: string
        if (!is_null($chargeDate) && !is_string($chargeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeDate, true), gettype($chargeDate)), __LINE__);
        }
        $this->chargeDate = $chargeDate;
        return $this;
    }
    /**
     * Get use value
     * @return string|null
     */
    public function getUse()
    {
        return $this->use;
    }
    /**
     * Set use value
     * @uses \EnumType\ChargeUse::valueIsValid()
     * @uses \EnumType\ChargeUse::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $use
     * @return \StructType\Charge
     */
    public function setUse($use = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ChargeUse::valueIsValid($use)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ChargeUse', is_array($use) ? implode(', ', $use) : var_export($use, true), implode(', ', \EnumType\ChargeUse::getValidValues())), __LINE__);
        }
        $this->use = $use;
        return $this;
    }
    /**
     * Get chargeType value
     * @return \StructType\RecordRef|null
     */
    public function getChargeType()
    {
        return $this->chargeType;
    }
    /**
     * Set chargeType value
     * @param \StructType\RecordRef $chargeType
     * @return \StructType\Charge
     */
    public function setChargeType(\StructType\RecordRef $chargeType = null)
    {
        $this->chargeType = $chargeType;
        return $this;
    }
    /**
     * Get projectTask value
     * @return \StructType\RecordRef|null
     */
    public function getProjectTask()
    {
        return $this->projectTask;
    }
    /**
     * Set projectTask value
     * @param \StructType\RecordRef $projectTask
     * @return \StructType\Charge
     */
    public function setProjectTask(\StructType\RecordRef $projectTask = null)
    {
        $this->projectTask = $projectTask;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\Charge
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\Charge
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get timeRecord value
     * @return \StructType\RecordRef|null
     */
    public function getTimeRecord()
    {
        return $this->timeRecord;
    }
    /**
     * Set timeRecord value
     * @param \StructType\RecordRef $timeRecord
     * @return \StructType\Charge
     */
    public function setTimeRecord(\StructType\RecordRef $timeRecord = null)
    {
        $this->timeRecord = $timeRecord;
        return $this;
    }
    /**
     * Get rate value
     * @return string|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param string $rate
     * @return \StructType\Charge
     */
    public function setRate($rate = null)
    {
        // validation for constraint: string
        if (!is_null($rate) && !is_string($rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param float $quantity
     * @return \StructType\Charge
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\Charge
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get billingItem value
     * @return \StructType\RecordRef|null
     */
    public function getBillingItem()
    {
        return $this->billingItem;
    }
    /**
     * Set billingItem value
     * @param \StructType\RecordRef $billingItem
     * @return \StructType\Charge
     */
    public function setBillingItem(\StructType\RecordRef $billingItem = null)
    {
        $this->billingItem = $billingItem;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\RecordRef|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \StructType\RecordRef $currency
     * @return \StructType\Charge
     */
    public function setCurrency(\StructType\RecordRef $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get transaction value
     * @return \StructType\RecordRef|null
     */
    public function getTransaction()
    {
        return $this->transaction;
    }
    /**
     * Set transaction value
     * @param \StructType\RecordRef $transaction
     * @return \StructType\Charge
     */
    public function setTransaction(\StructType\RecordRef $transaction = null)
    {
        $this->transaction = $transaction;
        return $this;
    }
    /**
     * Get transactionLine value
     * @return \StructType\RecordRef|null
     */
    public function getTransactionLine()
    {
        return $this->transactionLine;
    }
    /**
     * Set transactionLine value
     * @param \StructType\RecordRef $transactionLine
     * @return \StructType\Charge
     */
    public function setTransactionLine(\StructType\RecordRef $transactionLine = null)
    {
        $this->transactionLine = $transactionLine;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\Charge
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\Charge
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\Charge
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get salesOrderLine value
     * @return \StructType\RecordRef|null
     */
    public function getSalesOrderLine()
    {
        return $this->salesOrderLine;
    }
    /**
     * Set salesOrderLine value
     * @param \StructType\RecordRef $salesOrderLine
     * @return \StructType\Charge
     */
    public function setSalesOrderLine(\StructType\RecordRef $salesOrderLine = null)
    {
        $this->salesOrderLine = $salesOrderLine;
        return $this;
    }
    /**
     * Get subscriptionLine value
     * @return \StructType\RecordRef|null
     */
    public function getSubscriptionLine()
    {
        return $this->subscriptionLine;
    }
    /**
     * Set subscriptionLine value
     * @param \StructType\RecordRef $subscriptionLine
     * @return \StructType\Charge
     */
    public function setSubscriptionLine(\StructType\RecordRef $subscriptionLine = null)
    {
        $this->subscriptionLine = $subscriptionLine;
        return $this;
    }
    /**
     * Get invoice value
     * @return \StructType\RecordRef|null
     */
    public function getInvoice()
    {
        return $this->invoice;
    }
    /**
     * Set invoice value
     * @param \StructType\RecordRef $invoice
     * @return \StructType\Charge
     */
    public function setInvoice(\StructType\RecordRef $invoice = null)
    {
        $this->invoice = $invoice;
        return $this;
    }
    /**
     * Get invoiceLine value
     * @return \StructType\RecordRef|null
     */
    public function getInvoiceLine()
    {
        return $this->invoiceLine;
    }
    /**
     * Set invoiceLine value
     * @param \StructType\RecordRef $invoiceLine
     * @return \StructType\Charge
     */
    public function setInvoiceLine(\StructType\RecordRef $invoiceLine = null)
    {
        $this->invoiceLine = $invoiceLine;
        return $this;
    }
    /**
     * Get rule value
     * @return \StructType\RecordRef|null
     */
    public function getRule()
    {
        return $this->rule;
    }
    /**
     * Set rule value
     * @param \StructType\RecordRef $rule
     * @return \StructType\Charge
     */
    public function setRule(\StructType\RecordRef $rule = null)
    {
        $this->rule = $rule;
        return $this;
    }
    /**
     * Get runId value
     * @return string|null
     */
    public function getRunId()
    {
        return $this->runId;
    }
    /**
     * Set runId value
     * @param string $runId
     * @return \StructType\Charge
     */
    public function setRunId($runId = null)
    {
        // validation for constraint: string
        if (!is_null($runId) && !is_string($runId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($runId, true), gettype($runId)), __LINE__);
        }
        $this->runId = $runId;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\Charge
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\Charge
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
