<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CashSaleShipGroupList StructType
 * @subpackage Structs
 */
class CashSaleShipGroupList extends AbstractStructBase
{
    /**
     * The shipGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TransactionShipGroup[]
     */
    public $shipGroup;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for CashSaleShipGroupList
     * @uses CashSaleShipGroupList::setShipGroup()
     * @uses CashSaleShipGroupList::setReplaceAll()
     * @param \StructType\TransactionShipGroup[] $shipGroup
     * @param bool $replaceAll
     */
    public function __construct(array $shipGroup = array(), $replaceAll = true)
    {
        $this
            ->setShipGroup($shipGroup)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get shipGroup value
     * @return \StructType\TransactionShipGroup[]|null
     */
    public function getShipGroup()
    {
        return $this->shipGroup;
    }
    /**
     * This method is responsible for validating the values passed to the setShipGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipGroupForArrayConstraintsFromSetShipGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cashSaleShipGroupListShipGroupItem) {
            // validation for constraint: itemType
            if (!$cashSaleShipGroupListShipGroupItem instanceof \StructType\TransactionShipGroup) {
                $invalidValues[] = is_object($cashSaleShipGroupListShipGroupItem) ? get_class($cashSaleShipGroupListShipGroupItem) : sprintf('%s(%s)', gettype($cashSaleShipGroupListShipGroupItem), var_export($cashSaleShipGroupListShipGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The shipGroup property can only contain items of type \StructType\TransactionShipGroup, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set shipGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\TransactionShipGroup[] $shipGroup
     * @return \StructType\CashSaleShipGroupList
     */
    public function setShipGroup(array $shipGroup = array())
    {
        // validation for constraint: array
        if ('' !== ($shipGroupArrayErrorMessage = self::validateShipGroupForArrayConstraintsFromSetShipGroup($shipGroup))) {
            throw new \InvalidArgumentException($shipGroupArrayErrorMessage, __LINE__);
        }
        $this->shipGroup = $shipGroup;
        return $this;
    }
    /**
     * Add item to shipGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\TransactionShipGroup $item
     * @return \StructType\CashSaleShipGroupList
     */
    public function addToShipGroup(\StructType\TransactionShipGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TransactionShipGroup) {
            throw new \InvalidArgumentException(sprintf('The shipGroup property can only contain items of type \StructType\TransactionShipGroup, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->shipGroup[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\CashSaleShipGroupList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
