<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CashSaleItemCostList StructType
 * @subpackage Structs
 */
class CashSaleItemCostList extends AbstractStructBase
{
    /**
     * The itemCost
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CashSaleItemCost[]
     */
    public $itemCost;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for CashSaleItemCostList
     * @uses CashSaleItemCostList::setItemCost()
     * @uses CashSaleItemCostList::setReplaceAll()
     * @param \StructType\CashSaleItemCost[] $itemCost
     * @param bool $replaceAll
     */
    public function __construct(array $itemCost = array(), $replaceAll = true)
    {
        $this
            ->setItemCost($itemCost)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get itemCost value
     * @return \StructType\CashSaleItemCost[]|null
     */
    public function getItemCost()
    {
        return $this->itemCost;
    }
    /**
     * This method is responsible for validating the values passed to the setItemCost method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemCost method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemCostForArrayConstraintsFromSetItemCost(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cashSaleItemCostListItemCostItem) {
            // validation for constraint: itemType
            if (!$cashSaleItemCostListItemCostItem instanceof \StructType\CashSaleItemCost) {
                $invalidValues[] = is_object($cashSaleItemCostListItemCostItem) ? get_class($cashSaleItemCostListItemCostItem) : sprintf('%s(%s)', gettype($cashSaleItemCostListItemCostItem), var_export($cashSaleItemCostListItemCostItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The itemCost property can only contain items of type \StructType\CashSaleItemCost, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set itemCost value
     * @throws \InvalidArgumentException
     * @param \StructType\CashSaleItemCost[] $itemCost
     * @return \StructType\CashSaleItemCostList
     */
    public function setItemCost(array $itemCost = array())
    {
        // validation for constraint: array
        if ('' !== ($itemCostArrayErrorMessage = self::validateItemCostForArrayConstraintsFromSetItemCost($itemCost))) {
            throw new \InvalidArgumentException($itemCostArrayErrorMessage, __LINE__);
        }
        $this->itemCost = $itemCost;
        return $this;
    }
    /**
     * Add item to itemCost value
     * @throws \InvalidArgumentException
     * @param \StructType\CashSaleItemCost $item
     * @return \StructType\CashSaleItemCostList
     */
    public function addToItemCost(\StructType\CashSaleItemCost $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CashSaleItemCost) {
            throw new \InvalidArgumentException(sprintf('The itemCost property can only contain items of type \StructType\CashSaleItemCost, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->itemCost[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\CashSaleItemCostList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
