<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CampaignResponseResponsesList StructType
 * @subpackage Structs
 */
class CampaignResponseResponsesList extends AbstractStructBase
{
    /**
     * The responses
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CampaignResponseResponses[]
     */
    public $responses;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for CampaignResponseResponsesList
     * @uses CampaignResponseResponsesList::setResponses()
     * @uses CampaignResponseResponsesList::setReplaceAll()
     * @param \StructType\CampaignResponseResponses[] $responses
     * @param bool $replaceAll
     */
    public function __construct(array $responses = array(), $replaceAll = true)
    {
        $this
            ->setResponses($responses)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get responses value
     * @return \StructType\CampaignResponseResponses[]|null
     */
    public function getResponses()
    {
        return $this->responses;
    }
    /**
     * This method is responsible for validating the values passed to the setResponses method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResponses method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResponsesForArrayConstraintsFromSetResponses(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $campaignResponseResponsesListResponsesItem) {
            // validation for constraint: itemType
            if (!$campaignResponseResponsesListResponsesItem instanceof \StructType\CampaignResponseResponses) {
                $invalidValues[] = is_object($campaignResponseResponsesListResponsesItem) ? get_class($campaignResponseResponsesListResponsesItem) : sprintf('%s(%s)', gettype($campaignResponseResponsesListResponsesItem), var_export($campaignResponseResponsesListResponsesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The responses property can only contain items of type \StructType\CampaignResponseResponses, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set responses value
     * @throws \InvalidArgumentException
     * @param \StructType\CampaignResponseResponses[] $responses
     * @return \StructType\CampaignResponseResponsesList
     */
    public function setResponses(array $responses = array())
    {
        // validation for constraint: array
        if ('' !== ($responsesArrayErrorMessage = self::validateResponsesForArrayConstraintsFromSetResponses($responses))) {
            throw new \InvalidArgumentException($responsesArrayErrorMessage, __LINE__);
        }
        $this->responses = $responses;
        return $this;
    }
    /**
     * Add item to responses value
     * @throws \InvalidArgumentException
     * @param \StructType\CampaignResponseResponses $item
     * @return \StructType\CampaignResponseResponsesList
     */
    public function addToResponses(\StructType\CampaignResponseResponses $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CampaignResponseResponses) {
            throw new \InvalidArgumentException(sprintf('The responses property can only contain items of type \StructType\CampaignResponseResponses, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->responses[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\CampaignResponseResponsesList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
