<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalendarEventAttendee StructType
 * @subpackage Structs
 */
class CalendarEventAttendee extends AbstractStructBase
{
    /**
     * The sendEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $sendEmail;
    /**
     * The attendee
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $attendee;
    /**
     * The response
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $response;
    /**
     * The attendance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $attendance;
    /**
     * Constructor method for CalendarEventAttendee
     * @uses CalendarEventAttendee::setSendEmail()
     * @uses CalendarEventAttendee::setAttendee()
     * @uses CalendarEventAttendee::setResponse()
     * @uses CalendarEventAttendee::setAttendance()
     * @param bool $sendEmail
     * @param \StructType\RecordRef $attendee
     * @param string $response
     * @param string $attendance
     */
    public function __construct($sendEmail = null, \StructType\RecordRef $attendee = null, $response = null, $attendance = null)
    {
        $this
            ->setSendEmail($sendEmail)
            ->setAttendee($attendee)
            ->setResponse($response)
            ->setAttendance($attendance);
    }
    /**
     * Get sendEmail value
     * @return bool|null
     */
    public function getSendEmail()
    {
        return $this->sendEmail;
    }
    /**
     * Set sendEmail value
     * @param bool $sendEmail
     * @return \StructType\CalendarEventAttendee
     */
    public function setSendEmail($sendEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendEmail) && !is_bool($sendEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendEmail, true), gettype($sendEmail)), __LINE__);
        }
        $this->sendEmail = $sendEmail;
        return $this;
    }
    /**
     * Get attendee value
     * @return \StructType\RecordRef|null
     */
    public function getAttendee()
    {
        return $this->attendee;
    }
    /**
     * Set attendee value
     * @param \StructType\RecordRef $attendee
     * @return \StructType\CalendarEventAttendee
     */
    public function setAttendee(\StructType\RecordRef $attendee = null)
    {
        $this->attendee = $attendee;
        return $this;
    }
    /**
     * Get response value
     * @return string|null
     */
    public function getResponse()
    {
        return $this->response;
    }
    /**
     * Set response value
     * @uses \EnumType\CalendarEventAttendeeResponse::valueIsValid()
     * @uses \EnumType\CalendarEventAttendeeResponse::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $response
     * @return \StructType\CalendarEventAttendee
     */
    public function setResponse($response = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CalendarEventAttendeeResponse::valueIsValid($response)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CalendarEventAttendeeResponse', is_array($response) ? implode(', ', $response) : var_export($response, true), implode(', ', \EnumType\CalendarEventAttendeeResponse::getValidValues())), __LINE__);
        }
        $this->response = $response;
        return $this;
    }
    /**
     * Get attendance value
     * @return string|null
     */
    public function getAttendance()
    {
        return $this->attendance;
    }
    /**
     * Set attendance value
     * @uses \EnumType\CalendarEventAttendeeAttendance::valueIsValid()
     * @uses \EnumType\CalendarEventAttendeeAttendance::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $attendance
     * @return \StructType\CalendarEventAttendee
     */
    public function setAttendance($attendance = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CalendarEventAttendeeAttendance::valueIsValid($attendance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CalendarEventAttendeeAttendance', is_array($attendance) ? implode(', ', $attendance) : var_export($attendance, true), implode(', ', \EnumType\CalendarEventAttendeeAttendance::getValidValues())), __LINE__);
        }
        $this->attendance = $attendance;
        return $this;
    }
}
