<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BudgetSearchBasic StructType
 * @subpackage Structs
 */
class BudgetSearchBasic extends SearchRecordBasic
{
    /**
     * The account
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $account;
    /**
     * The accountingBook
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $accountingBook;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDoubleField
     */
    public $amount;
    /**
     * The category
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $category;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $class;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $currency;
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $customer;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $department;
    /**
     * The global
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchBooleanField
     */
    public $global;
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $internalId;
    /**
     * The internalIdNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchLongField
     */
    public $internalIdNumber;
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $item;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $location;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $subsidiary;
    /**
     * The year
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $year;
    /**
     * The year2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $year2;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchCustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for BudgetSearchBasic
     * @uses BudgetSearchBasic::setAccount()
     * @uses BudgetSearchBasic::setAccountingBook()
     * @uses BudgetSearchBasic::setAmount()
     * @uses BudgetSearchBasic::setCategory()
     * @uses BudgetSearchBasic::setClass()
     * @uses BudgetSearchBasic::setCurrency()
     * @uses BudgetSearchBasic::setCustomer()
     * @uses BudgetSearchBasic::setDepartment()
     * @uses BudgetSearchBasic::setGlobal()
     * @uses BudgetSearchBasic::setInternalId()
     * @uses BudgetSearchBasic::setInternalIdNumber()
     * @uses BudgetSearchBasic::setItem()
     * @uses BudgetSearchBasic::setLocation()
     * @uses BudgetSearchBasic::setSubsidiary()
     * @uses BudgetSearchBasic::setYear()
     * @uses BudgetSearchBasic::setYear2()
     * @uses BudgetSearchBasic::setCustomFieldList()
     * @param \StructType\SearchMultiSelectField $account
     * @param \StructType\SearchMultiSelectField $accountingBook
     * @param \StructType\SearchDoubleField $amount
     * @param \StructType\SearchMultiSelectField $category
     * @param \StructType\SearchMultiSelectField $class
     * @param \StructType\SearchMultiSelectField $currency
     * @param \StructType\SearchMultiSelectField $customer
     * @param \StructType\SearchMultiSelectField $department
     * @param \StructType\SearchBooleanField $global
     * @param \StructType\SearchMultiSelectField $internalId
     * @param \StructType\SearchLongField $internalIdNumber
     * @param \StructType\SearchMultiSelectField $item
     * @param \StructType\SearchMultiSelectField $location
     * @param \StructType\SearchMultiSelectField $subsidiary
     * @param \StructType\SearchMultiSelectField $year
     * @param \StructType\SearchMultiSelectField $year2
     * @param \StructType\SearchCustomFieldList $customFieldList
     */
    public function __construct(\StructType\SearchMultiSelectField $account = null, \StructType\SearchMultiSelectField $accountingBook = null, \StructType\SearchDoubleField $amount = null, \StructType\SearchMultiSelectField $category = null, \StructType\SearchMultiSelectField $class = null, \StructType\SearchMultiSelectField $currency = null, \StructType\SearchMultiSelectField $customer = null, \StructType\SearchMultiSelectField $department = null, \StructType\SearchBooleanField $global = null, \StructType\SearchMultiSelectField $internalId = null, \StructType\SearchLongField $internalIdNumber = null, \StructType\SearchMultiSelectField $item = null, \StructType\SearchMultiSelectField $location = null, \StructType\SearchMultiSelectField $subsidiary = null, \StructType\SearchMultiSelectField $year = null, \StructType\SearchMultiSelectField $year2 = null, \StructType\SearchCustomFieldList $customFieldList = null)
    {
        $this
            ->setAccount($account)
            ->setAccountingBook($accountingBook)
            ->setAmount($amount)
            ->setCategory($category)
            ->setClass($class)
            ->setCurrency($currency)
            ->setCustomer($customer)
            ->setDepartment($department)
            ->setGlobal($global)
            ->setInternalId($internalId)
            ->setInternalIdNumber($internalIdNumber)
            ->setItem($item)
            ->setLocation($location)
            ->setSubsidiary($subsidiary)
            ->setYear($year)
            ->setYear2($year2)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get account value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * Set account value
     * @param \StructType\SearchMultiSelectField $account
     * @return \StructType\BudgetSearchBasic
     */
    public function setAccount(\StructType\SearchMultiSelectField $account = null)
    {
        $this->account = $account;
        return $this;
    }
    /**
     * Get accountingBook value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getAccountingBook()
    {
        return $this->accountingBook;
    }
    /**
     * Set accountingBook value
     * @param \StructType\SearchMultiSelectField $accountingBook
     * @return \StructType\BudgetSearchBasic
     */
    public function setAccountingBook(\StructType\SearchMultiSelectField $accountingBook = null)
    {
        $this->accountingBook = $accountingBook;
        return $this;
    }
    /**
     * Get amount value
     * @return \StructType\SearchDoubleField|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param \StructType\SearchDoubleField $amount
     * @return \StructType\BudgetSearchBasic
     */
    public function setAmount(\StructType\SearchDoubleField $amount = null)
    {
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get category value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param \StructType\SearchMultiSelectField $category
     * @return \StructType\BudgetSearchBasic
     */
    public function setCategory(\StructType\SearchMultiSelectField $category = null)
    {
        $this->category = $category;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\SearchMultiSelectField $class
     * @return \StructType\BudgetSearchBasic
     */
    public function setClass(\StructType\SearchMultiSelectField $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \StructType\SearchMultiSelectField $currency
     * @return \StructType\BudgetSearchBasic
     */
    public function setCurrency(\StructType\SearchMultiSelectField $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get customer value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param \StructType\SearchMultiSelectField $customer
     * @return \StructType\BudgetSearchBasic
     */
    public function setCustomer(\StructType\SearchMultiSelectField $customer = null)
    {
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\SearchMultiSelectField $department
     * @return \StructType\BudgetSearchBasic
     */
    public function setDepartment(\StructType\SearchMultiSelectField $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get global value
     * @return \StructType\SearchBooleanField|null
     */
    public function getGlobal()
    {
        return $this->global;
    }
    /**
     * Set global value
     * @param \StructType\SearchBooleanField $global
     * @return \StructType\BudgetSearchBasic
     */
    public function setGlobal(\StructType\SearchBooleanField $global = null)
    {
        $this->global = $global;
        return $this;
    }
    /**
     * Get internalId value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param \StructType\SearchMultiSelectField $internalId
     * @return \StructType\BudgetSearchBasic
     */
    public function setInternalId(\StructType\SearchMultiSelectField $internalId = null)
    {
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get internalIdNumber value
     * @return \StructType\SearchLongField|null
     */
    public function getInternalIdNumber()
    {
        return $this->internalIdNumber;
    }
    /**
     * Set internalIdNumber value
     * @param \StructType\SearchLongField $internalIdNumber
     * @return \StructType\BudgetSearchBasic
     */
    public function setInternalIdNumber(\StructType\SearchLongField $internalIdNumber = null)
    {
        $this->internalIdNumber = $internalIdNumber;
        return $this;
    }
    /**
     * Get item value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\SearchMultiSelectField $item
     * @return \StructType\BudgetSearchBasic
     */
    public function setItem(\StructType\SearchMultiSelectField $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\SearchMultiSelectField $location
     * @return \StructType\BudgetSearchBasic
     */
    public function setLocation(\StructType\SearchMultiSelectField $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\SearchMultiSelectField $subsidiary
     * @return \StructType\BudgetSearchBasic
     */
    public function setSubsidiary(\StructType\SearchMultiSelectField $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get year value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getYear()
    {
        return $this->year;
    }
    /**
     * Set year value
     * @param \StructType\SearchMultiSelectField $year
     * @return \StructType\BudgetSearchBasic
     */
    public function setYear(\StructType\SearchMultiSelectField $year = null)
    {
        $this->year = $year;
        return $this;
    }
    /**
     * Get year2 value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getYear2()
    {
        return $this->year2;
    }
    /**
     * Set year2 value
     * @param \StructType\SearchMultiSelectField $year2
     * @return \StructType\BudgetSearchBasic
     */
    public function setYear2(\StructType\SearchMultiSelectField $year2 = null)
    {
        $this->year2 = $year2;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\SearchCustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\SearchCustomFieldList $customFieldList
     * @return \StructType\BudgetSearchBasic
     */
    public function setCustomFieldList(\StructType\SearchCustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
